/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb;

import com.hundsun.lightdb.FileImportStat;
import com.hundsun.lightdb.IndexCreateStat;
import com.hundsun.lightdb.IndexInfo;
import com.hundsun.lightdb.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@SuppressFBWarnings(value={"PATH_TRAVERSAL_OUT", "PATH_TRAVERSAL_IN", "SQL_INJECTION_JDBC", "EXTERNAL_CONFIG_CONTROL", "DMI_HARDCODED_EXEC_COMMAND", "COMMAND_INJECTION"})
public class Import2Lightdb {
    private static final Logger log = LoggerFactory.getLogger(Import2Lightdb.class);
    public static final int FIVE_HUNDRED_THOUSAND = 500000;
    static Map<String, Integer> tableInfo = new HashMap();
    static Map<String, String[]> tableDef = new HashMap();
    static Map<String, List<IndexInfo>> indexes = new HashMap();
    static ConcurrentHashMap<String, AtomicInteger> finishedNotPartTable = new ConcurrentHashMap();
    static ConcurrentHashMap<String, String> importing = new ConcurrentHashMap();
    static ConcurrentHashMap<String, String> notFinishedIndex = new ConcurrentHashMap();
    static int totalFile = 0;
    static int totalIndex = 0;
    static final AtomicInteger SUCCESS = new AtomicInteger(0);
    static final AtomicInteger FAILED = new AtomicInteger(0);
    static final AtomicInteger SUCCESS_INDEX = new AtomicInteger(0);
    static final AtomicInteger FAILED_INDEX = new AtomicInteger(0);
    static final CopyOnWriteArrayList<FileImportStat> STATS = new CopyOnWriteArrayList();
    static final CopyOnWriteArrayList<IndexCreateStat> STATS_INDEX = new CopyOnWriteArrayList();
    static String connectionString;
    static ExecutorService indexExecutor;
    static String username;
    static String password;

    public static void printTime(long currentTimeMillis, String msg) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formattedTime = dateFormat.format(new Date(currentTimeMillis));
        log.info(formattedTime + ":" + msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, InterruptedException {
        Statement stmt;
        String line;
        BufferedReader br;
        boolean truncateTable;
        long currentTimeMillis = System.currentTimeMillis();
        Import2Lightdb.printTime((long)currentTimeMillis, (String)"\u5f00\u59cb\u65f6\u95f4");
        String userInfo = System.getProperty("userInfo");
        String charset = System.getProperty("charset");
        String dataDir = System.getProperty("data.dir");
        if (userInfo == null && password == null && username == null && dataDir == null) {
            log.info("usage: java -Ddata.dir=xxx -DthreadCount=xxx -DjustIndex -Dusername=xxx -Dpassword=xxx -DuserInfo=ip:port/dbname -jar import2lightdb.jar\n\u4e09\u9009\u4e00\u6a21\u5f0f\uff1a\u5bfc\u6570\u636e(\u65e0justIndex\u548cforAllIndex\u9009\u9879)\uff0c\u81ea\u52a8\u5efa\u5bfc\u5165\u6570\u636e\u7684\u7d22\u5f15(\u4f20justIndex\uff0c\u4f1a\u521b\u5efa\u6839\u8868\u7d22\u5f15\uff0c\u9700\u8981\u6b63\u5e38\u9000\u51fa)\uff0c\u521b\u5efa\u6307\u5b9a\u5206\u533a\u8868\u7684\u7d22\u5f15(\u4f20forAllIndex\uff0c\u4e0d\u4f1a\u521b\u5efa\u6839\u8868\u7d22\u5f15)\n\ndata.dir \u6587\u4ef6\u5b58\u653e\u8def\u5f84\nuserInfo \u76ee\u6807\u6570\u636e\u5e93\nusername \u7528\u6237\u540d\npassword \u5bc6\u7801\njustIndex \u6709\u8fd9\u4e2a\u6807\u5fd7\u4e3a\u521b\u5efa\u7d22\u5f15\u800c\u4e0d\u662f\u5bfc\u5165\u6570\u636e(\u4ec5\u652f\u6301\u4e8c\u9009\u4e00)\nforAllIndex \u4ec5\u8dd1\u6279\u91cf\u5206\u533a\u7d22\u5f15\nsep \u5206\u9694\u7b26\uff0c\u9ed8\u8ba4i_mpig\nshardCount \u975e\u5206\u533a\u8868\u7684\u5206\u7247\u6570\uff0c\u9ed8\u8ba420\uff0c\u540c\u5bfc\u51fa\u7a0b\u5e8f\u7684\u9ed8\u8ba4\u503c\nthreadCount \u7ebf\u7a0b\u6570,min(\u9ed8\u8ba4cpu\u6570\u91cf\u768450%,32)\n\u6d89\u53ca\u7684\u914d\u7f6e\u6587\u4ef6\uff1aindexInfo.txt\uff08\u8981\u521b\u5efa\u7684\u7d22\u5f15\u5b9a\u4e49\uff09\uff0ctableInfo.txt\uff08\u8981\u5bfc\u5165\u7684\u8868\u5217\u8868\uff0c\u67e5\u8be2\u5b57\u6bb5\u5b9a\u4e49\uff09\uff0cfull_indexInfo.txt\uff08\u8981\u521b\u5efa\u7684\u5206\u533a\u8868\u7684\u7d22\u5f15\uff09");
            System.exit(-1);
        }
        boolean justIndex = System.getProperty("justIndex") != null;
        boolean forAllIndex = System.getProperty("forAllIndex") != null;
        String confDir = System.getProperty("conf.dir");
        String indexConf = System.getProperty("index.dir");
        if (indexConf == null) {
            indexConf = "indexInfo.txt";
        }
        if (confDir == null) {
            confDir = "tableInfo.txt";
        }
        if (charset == null) {
            charset = "GBK";
        }
        int notPartTableShardCount = 20;
        String t = System.getProperty("shardCount");
        if (t != null) {
            notPartTableShardCount = Integer.parseInt(t);
        }
        boolean hasQuote = System.getProperty("hasQuote") != null;
        connectionString = "jdbc:postgresql://" + userInfo + "?characterEncoding=UTF-8";
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(connectionString, username, password);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        int threadCount = Math.min(Runtime.getRuntime().availableProcessors() / 2, 32);
        String s = System.getProperty("threadCount");
        if (s != null) {
            threadCount = Integer.parseInt(s);
        }
        ExecutorService executor = Executors.newFixedThreadPool(threadCount);
        indexExecutor = Executors.newFixedThreadPool(Math.min(threadCount, 32));
        log.info("\u672c\u7a0b\u5e8f\u4e3a\u4e86\u786e\u4fdd\u6700\u5927\u5316\u6027\u80fd\uff0c\u5fc5\u987b\u8fd0\u884c\u5728lightdb\u670d\u52a1\u7aef\u6240\u5728\u7684\u670d\u52a1\u5668, \u6240\u4ee5\u4e0d\u4f20\u9012ip");
        log.info("\u72b6\u6001\u4ecedone->importing->finished->indexed");
        String sep = System.getProperty("sep");
        boolean bl = truncateTable = System.getProperty("truncate") != null;
        if (username == null) {
            log.error("-Dusername\u5fc5\u987b\u4f20\u9012\uff0c\u6307\u5b9a\u7528\u6237\u540d");
            System.exit(-1);
        }
        if (sep == null) {
            sep = "i_mpig";
        }
        if (password == null) {
            log.error("-Dpassword\u5fc5\u987b\u4f20\u9012\uff0c\u6307\u5b9a\u5bc6\u7801");
            System.exit(-1);
        }
        if (dataDir == null) {
            dataDir = "/home/lightdb";
        }
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (forAllIndex) {
            Import2Lightdb.createForALlPartIndex();
        }
        log.info("\u52a0\u8f7d\u8981\u5bfc\u5165\u7684\u8868\u6e05\u5355: " + confDir);
        try {
            br = new BufferedReader(new FileReader(confDir));
            try {
                while ((line = br.readLine()) != null) {
                    if (line.trim().startsWith("#") || "".equals(line.trim())) continue;
                    String fqn = line.trim().toUpperCase();
                    stmt = connection.createStatement();
                    String getDef = String.format("SELECT\n\ttypname,\n\tatttypid,\n\tattnum\nFROM\n\tpg_attribute x,\n\tpg_type t\nWHERE\n\tt.oid = x.atttypid\n\tAND attrelid IN (\n\tSELECT\n\t\toid\n\tFROM\n\t\tpg_class\n\tWHERE\n\t\trelname = '%s'\n\t\tAND relnamespace IN (\n\t\tSELECT\n\t\t\toid\n\t\tFROM\n\t\t\tpg_namespace\n\t\tWHERE\n\t\t\tnspname = '%s'))\n\tAND attnum>0", StringUtils.split((String)fqn, (String)".")[1].toLowerCase(), StringUtils.split((String)fqn, (String)".")[0].toLowerCase());
                    ResultSet resultSet = stmt.executeQuery(getDef);
                    File[] cols = new ArrayList();
                    while (resultSet.next()) {
                        if (resultSet.getString(1).equals("varchar2")) {
                            cols.add("v");
                            continue;
                        }
                        if (resultSet.getString(1).equals("numeric")) {
                            cols.add("n");
                            continue;
                        }
                        cols.add(resultSet.getString(1));
                    }
                    tableDef.put(fqn, cols.toArray(new String[0]));
                    if (cols.size() == 0) {
                        log.error(fqn + "\u6ca1\u6709\u67e5\u8be2\u5230\u5b9a\u4e49\uff0c\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5");
                        System.exit(-1);
                    }
                    tableInfo.put(fqn, cols.size());
                }
            }
            finally {
                br.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        try {
            br = new BufferedReader(new FileReader(indexConf));
            try {
                while ((line = br.readLine()) != null) {
                    if (line.trim().startsWith("#") || "".equals(line.trim())) continue;
                    IndexInfo indexInfo = new IndexInfo();
                    String[] ind = line.split(" ");
                    indexInfo.fields = ind[4];
                    indexInfo.unique = ind[3];
                    indexInfo.schenaName = ind[0].toLowerCase();
                    indexInfo.tableName = ind[1].toLowerCase();
                    indexInfo.indexName = ind[2].toLowerCase();
                    if (indexes.containsKey(indexInfo.schenaName + "." + indexInfo.tableName)) {
                        ((List)indexes.get(indexInfo.schenaName + "." + indexInfo.tableName)).add(indexInfo);
                        continue;
                    }
                    indexes.put(indexInfo.schenaName + "." + indexInfo.tableName, new ArrayList());
                    ((List)indexes.get(indexInfo.schenaName + "." + indexInfo.tableName)).add(indexInfo);
                }
            }
            finally {
                br.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if ("".equals(dataDir.trim())) {
            log.error("-Ddata.dir\u5982\u679c\u6307\u5b9a\uff0c\u4e0d\u80fd\u4e3a\u7a7a");
            System.exit(-1);
        }
        int needImportCount = -1;
        String filePath = dataDir + "/count";
        try (BufferedReader br2 = new BufferedReader(new FileReader(filePath));){
            String line2 = br2.readLine();
            if (line2 != null) {
                needImportCount = Integer.parseInt(line2);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (needImportCount == -1) {
            log.error("\u6587\u4ef6" + dataDir + "/count\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u542f\u52a8\u5bfc\u51fa\u7a0b\u5e8f\uff0c\u518d\u542f\u52a8\u672c\u7a0b\u5e8f");
            System.exit(-1);
        }
        File doneFile = new File(dataDir + "/finished.done");
        while (!doneFile.exists() && !(justIndex ? totalIndex == needImportCount : totalFile == needImportCount)) {
            File directory = new File(dataDir);
            File[] files = directory.listFiles();
            int i = 0;
            if (files != null) {
                for (File file : files) {
                    if (file.isFile()) {
                        String fileName = file.getName();
                        if (fileName.endsWith(".done") && !justIndex) {
                            File newFile = new File(file.getAbsolutePath().replace(".done", ".importing"));
                            boolean renamed = file.renameTo(newFile);
                            fileName = newFile.getName();
                            if (fileName.indexOf("___") < 0) {
                                log.error(fileName + "\u6587\u4ef6\u540d\u4e2d\u4e0d\u5305\u542b\u8868\u540d\u5206\u9694\u7b26___\uff0c\u4e0d\u5408\u6cd5\uff0c\u8bf7\u68c0\u67e5\u5bfc\u51fa\u7a0b\u5e8f");
                                continue;
                            }
                            if (newFile.length() == 0L) {
                                ++totalFile;
                                SUCCESS.addAndGet(1);
                                log.info(fileName + "\u6587\u4ef6\u5927\u5c0f\u4e3a0, \u8df3\u8fc7\u5bfc\u5165");
                                File importDoneFile = new File(newFile.getAbsolutePath().replace(".importing", ".finished"));
                                renamed = newFile.renameTo(importDoneFile);
                                String tableName = fileName.split("___")[0].toLowerCase();
                                continue;
                            }
                            String tableName = fileName.split("___")[0];
                            String appendix = fileName.split("___")[1];
                            appendix = appendix.substring(0, appendix.indexOf(46));
                            String finalFileName = newFile.getName();
                            String finalDataDir1 = dataDir;
                            ++totalFile;
                            String finalSep = sep;
                            String finalCharset = charset;
                            if (importing.contains(finalFileName)) {
                                Import2Lightdb.printTime((long)System.currentTimeMillis(), (String)("\u6587\u4ef6" + finalFileName + "\uff0c\u5df2\u7ecf\u63d0\u4ea4\u8fc7\uff0c\u4e0d\u80fd\u91cd\u590d\u63d0\u4ea4\u5bfc\u5165\uff0c\u7a0b\u5e8f\u5b58\u5728bug\uff0c\u8bf7\u68c0\u67e5"));
                                continue;
                            }
                            executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                            ++i;
                            continue;
                        }
                        if (!fileName.endsWith(".finished") && (file.length() != 0L || !fileName.endsWith(".importing")) || !justIndex) continue;
                        String tableName = fileName.split("___")[0].toLowerCase();
                        String partName = fileName.split("___")[1].toLowerCase();
                        if ((partName = partName.substring(0, partName.indexOf(46))).length() <= 2) {
                            finishedNotPartTable.putIfAbsent(tableName, new AtomicInteger(0));
                            ((AtomicInteger)finishedNotPartTable.get(tableName)).addAndGet(1);
                            if (finishedNotPartTable.contains(tableName) && ((AtomicInteger)finishedNotPartTable.get(tableName)).get() == notPartTableShardCount) {
                                Import2Lightdb.renameFileWithPrefix((String)dataDir, (String)tableName);
                                notFinishedIndex.put(tableName, "");
                                indexExecutor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                                Import2Lightdb.printTime((long)System.currentTimeMillis(), (String)(tableName + "\u6240\u6709\u5206\u7247\u5df2\u5bfc\u5165\uff0c\u5df2\u63d0\u4ea4\u521b\u5efa\u7d22\u5f15"));
                                finishedNotPartTable.remove(tableName);
                                continue;
                            }
                            Import2Lightdb.printTime((long)System.currentTimeMillis(), (String)(tableName + "\u5df2\u5bfc\u5165\u5206\u7247\u6570\uff1a" + ((AtomicInteger)finishedNotPartTable.get(tableName)).get() + ",\u5171\u9700" + notPartTableShardCount + "\u4e2a\u624d\u80fd\u521b\u5efa\u7d22\u5f15"));
                            continue;
                        }
                        String finalFileName1 = file.getName();
                        File indexingName = new File(file.getAbsolutePath().replace(".finished", ".indexed"));
                        boolean renamed = file.renameTo(indexingName);
                        String finalPartName = partName;
                        ++totalIndex;
                        notFinishedIndex.put(indexingName.getName(), "");
                        indexExecutor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                        continue;
                    }
                    if (!file.isDirectory()) continue;
                    log.error("\u4e0d\u5e94\u8be5\u51fa\u73b0\u76ee\u5f55\uff08\u5982\u679c\u662f\u81ea\u5df1\u5efa\u7684\uff0c\u5ffd\u7565\u5373\u53ef\uff09: " + file.getName());
                }
                if (i == 0 && !justIndex) {
                    Import2Lightdb.printTime((long)System.currentTimeMillis(), (String)"\u76ee\u5f55\u4e3a\u7a7a\uff0c\u7b49\u5f8510\u79d2\u540e\u91cd\u65b0\u626b\u63cf(\u8981\u9000\u51fa\u672c\u7a0b\u5e8f,\u5728-Ddata.dir\u6307\u5b9a\u76ee\u5f55\u4e0b\u521b\u5efa\u7a7a\u7684finished.done\u6587\u4ef6\u5373\u53ef)");
                    Thread.sleep(10000L);
                } else if (justIndex) {
                    Import2Lightdb.printTime((long)System.currentTimeMillis(), (String)"\u5df2\u5904\u7406\u4e00\u6279\u7d22\u5f15\uff0c\u7b49\u5f8510\u79d2\u540e\u91cd\u65b0\u626b\u63cf(\u8981\u9000\u51fa\u672c\u7a0b\u5e8f,\u5728-Ddata.dir\u6307\u5b9a\u76ee\u5f55\u4e0b\u521b\u5efa\u7a7a\u7684finished.done\u6587\u4ef6\u5373\u53ef\uff0c\u6b64\u65f6\u4f1a\u5f00\u59cb\u521b\u5efa\u5206\u533a\u4e3b\u8868\u548c\u975e\u5206\u533a\u8868\u4e0a\u7684\u7d22\u5f15)");
                    Thread.sleep(10000L);
                }
                if (!justIndex) {
                    Import2Lightdb.printTime((long)System.currentTimeMillis(), (String)("\u5bfc\u5165\u8fdb\u5ea6,\u5171\u9700:" + needImportCount + ",\u63d0\u4ea4:" + totalFile + ",\u6210\u529f:" + SUCCESS.get() + ",\u5931\u8d25:" + FAILED.get()));
                    continue;
                }
                Import2Lightdb.printTime((long)System.currentTimeMillis(), (String)("\u7d22\u5f15\u521b\u5efa\u8fdb\u5ea6,\u5171\u9700:" + needImportCount + ",\u63d0\u4ea4:" + totalIndex + ",\u6210\u529f:" + SUCCESS_INDEX.get() + ",\u5931\u8d25:" + FAILED_INDEX.get() + ", \u5c1a\u672a\u5b8c\u6210\u521b\u5efa(\u672a\u6210\u529f\u3001\u4e5f\u672a\u5931\u8d25)\u7684\u8868\u6216\u5206\u533a\u6e05\u5355:" + String.join((CharSequence)",", notFinishedIndex.keySet())));
                continue;
            }
            Import2Lightdb.printTime((long)System.currentTimeMillis(), (String)"\u76ee\u5f55\u4e3a\u7a7a\uff0c\u7b49\u5f8510\u79d2\u540e\u91cd\u65b0\u626b\u63cf(\u8981\u9000\u51fa\u672c\u7a0b\u5e8f,\u5728-Ddata.dir\u6307\u5b9a\u76ee\u5f55\u4e0b\u521b\u5efa\u7a7a\u7684finished.done\u6587\u4ef6\u5373\u53ef)");
            Thread.sleep(10000L);
        }
        executor.shutdown();
        executor.awaitTermination(1L, TimeUnit.DAYS);
        if (justIndex) {
            Import2Lightdb.printTime((long)System.currentTimeMillis(), (String)"\u5f00\u59cb\u521b\u5efa\u5206\u533a\u4e3b\u8868\u548c\u975e\u5206\u533a\u8868\u4e0a\u7684\u7d22\u5f15");
            try {
                connection = DriverManager.getConnection(connectionString, username, password);
                stmt = connection.createStatement();
                int rebIndexNum = 5;
                for (Map.Entry entry : indexes.entrySet()) {
                    String tableName = (String)entry.getKey();
                    for (IndexInfo indexInfo : (List)indexes.get(tableName)) {
                        String unique = "Y".equals(indexInfo.unique) ? "unique" : "";
                        String createIndex = "";
                        boolean success = false;
                        int retries = 1;
                        while (!success && retries <= rebIndexNum) {
                            try {
                                long curr = System.currentTimeMillis();
                                Import2Lightdb.printTime((long)curr, (String)("\u5f00\u59cb\u521b\u5efa\u5206\u533a\u4e3b\u8868(\u6216\u975e\u5206\u533a\u8868)\u7d22\u5f15" + indexInfo.indexName));
                                createIndex = "create " + unique + " index IF NOT EXISTS " + indexInfo.indexName + " on " + tableName + "(" + indexInfo.fields + ")";
                                stmt.execute(createIndex);
                                long elapsed = System.currentTimeMillis() - curr;
                                Import2Lightdb.printTime((long)System.currentTimeMillis(), (String)("\u5b8c\u6210\u521b\u5efa\u5206\u533a\u4e3b\u8868(\u6216\u975e\u5206\u533a\u8868)\u7d22\u5f15:" + createIndex + "\uff0c\u8017\u65f6\uff1a" + elapsed + "ms"));
                                success = true;
                            }
                            catch (Exception e) {
                                log.error("\u521b\u5efa\u5206\u533a\u4e3b\u8868(\u6216\u975e\u5206\u533a\u8868)" + tableName + "\u4e0a\u7684\u7d22\u5f15\u5931\u8d25:" + createIndex);
                                log.error("\u5c1d\u8bd5\u7b2c" + ++retries + "\u6b21\u521b\u5efa\u7d22\u5f15\uff0c\u6700\u591a\u91cd\u8bd55\u6b21");
                                try {
                                    Thread.sleep(10000L);
                                }
                                catch (InterruptedException ex) {
                                    throw new RuntimeException(ex);
                                }
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error("\u8fd9\u91cc\u4e0d\u5e94\u8be5\u53d1\u751f\u5f02\u5e38");
                e.printStackTrace();
            }
            finally {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            Import2Lightdb.generateReportForIndex();
        } else {
            Import2Lightdb.generateReport();
        }
        indexExecutor.shutdown();
        indexExecutor.awaitTermination(1L, TimeUnit.DAYS);
        currentTimeMillis = System.currentTimeMillis();
        Import2Lightdb.printTime((long)currentTimeMillis, (String)"\u7ed3\u675f\u65f6\u95f4");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createForALlPartIndex() {
        String[] ind;
        Object line;
        BufferedReader br;
        HashMap indexesSkip = new HashMap(16);
        try {
            br = new BufferedReader(new FileReader("indexInfo.txt"));
            try {
                while ((line = br.readLine()) != null) {
                    if (((String)line).trim().startsWith("#") || "".equals(((String)line).trim())) continue;
                    IndexInfo indexInfo = new IndexInfo();
                    ind = ((String)line).split(" ");
                    indexInfo.fields = ind[4];
                    indexInfo.unique = ind[3];
                    indexInfo.schenaName = ind[0].toLowerCase();
                    indexInfo.tableName = ind[1].toLowerCase();
                    indexInfo.indexName = ind[2].toLowerCase();
                    if (indexesSkip.containsKey(indexInfo.schenaName + "." + indexInfo.tableName)) {
                        ((List)indexesSkip.get(indexInfo.schenaName + "." + indexInfo.tableName)).add(indexInfo);
                        continue;
                    }
                    indexesSkip.put(indexInfo.schenaName + "." + indexInfo.tableName, new ArrayList());
                    ((List)indexesSkip.get(indexInfo.schenaName + "." + indexInfo.tableName)).add(indexInfo);
                }
            }
            finally {
                br.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            br = new BufferedReader(new FileReader("full_indexInfo.txt"));
            try {
                while ((line = br.readLine()) != null) {
                    if (((String)line).trim().startsWith("#") || "".equals(((String)line).trim())) continue;
                    IndexInfo indexInfo = new IndexInfo();
                    ind = ((String)line).split(" ");
                    indexInfo.fields = ind[4];
                    indexInfo.unique = ind[3];
                    indexInfo.schenaName = ind[0].toLowerCase();
                    indexInfo.tableName = ind[1].toLowerCase();
                    if (indexesSkip.containsKey(indexInfo.schenaName + "." + indexInfo.tableName)) continue;
                    indexInfo.indexName = ind[2].toLowerCase();
                    if (indexes.containsKey(indexInfo.schenaName + "." + indexInfo.tableName)) {
                        ((List)indexes.get(indexInfo.schenaName + "." + indexInfo.tableName)).add(indexInfo);
                        continue;
                    }
                    indexes.put(indexInfo.schenaName + "." + indexInfo.tableName, new ArrayList());
                    ((List)indexes.get(indexInfo.schenaName + "." + indexInfo.tableName)).add(indexInfo);
                }
            }
            finally {
                br.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int i = 0;
        log.info("\u5f85\u5904\u7406\u7684\u8868\u6570\u91cf: " + indexes.size() + "," + indexes.keySet());
        for (Map.Entry entry : indexes.entrySet()) {
            String fqn = (String)entry.getKey();
            String schemaName = fqn.split("\\.")[0];
            String tableName = fqn.split("\\.")[1];
            Connection connection = null;
            try {
                connection = DriverManager.getConnection(connectionString, username, password);
                String getPart = "select c.relname\nfrom pg_class c\n\tjoin pg_inherits i on i.inhrelid = c.oid\n\tjoin pg_class d on d.oid = i.inhparent\nwhere d.relname = ? and d.relnamespace in (select oid from pg_namespace where nspname = ?)";
                log.info("\u83b7\u53d6\u7684" + fqn + "\u7684\u5206\u533a\u6e05\u5355\uff1a" + getPart);
                PreparedStatement pstmt = connection.prepareStatement(getPart);
                pstmt.setString(1, tableName);
                pstmt.setString(2, schemaName);
                ResultSet resultSet = pstmt.executeQuery();
                while (resultSet.next()) {
                    ++i;
                    String partName = resultSet.getString(1);
                    String finalPartName = partName = partName.substring(partName.indexOf(36) + 1);
                    indexExecutor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                }
                resultSet.close();
                pstmt.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (connection == null) continue;
                    connection.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        indexExecutor.shutdown();
        try {
            indexExecutor.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        log.info("\u4ec5\u521b\u5efa\u5206\u533a\u7d22\u5f15\uff0c\u6240\u6709\u5206\u533a\u7d22\u5f15\uff0c\u5171" + i + "\u4e2a\u5206\u533a\u5df2\u521b\u5efa\u5b8c\u6210\uff08\u7236\u8868\u7d22\u5f15\u9700\u81ea\u5df1\u521b\u5efa\uff09\uff0c\u7a0b\u5e8f\u9000\u51fa");
        System.exit(-1);
    }

    private static void generateReportForIndex() {
        String html = "<html>\n\n<head>\n\t<title>\u7d22\u5f15\u521b\u5efa\u6027\u80fd</title>\n</head>\n<body>\n\t<h1>\u7d22\u5f15\u521b\u5efa\u6027\u80fd</h1>\n\t<table border=\"1\" cellspacing=\"0\" cellpadding=\"10\"><thead><tr>   <th>\u8868</th><th>\u7d22\u5f15\u540d</th><th>\u662f\u5426\u5206\u533a\u7d22\u5f15</th><th>\u8017\u65f6(ms)</th></tr></thead><tbody>\n";
        String foot = "</tbody></table></body>\n\n</html>";
        String body = "";
        STATS_INDEX.sort(new /* Unavailable Anonymous Inner Class!! */);
        for (IndexCreateStat stat : STATS_INDEX) {
            try {
                body = body + "<tr><td>" + stat.tableName + "</td><td>" + stat.indexName + "</td><td>" + stat.isPart + "</td><td>" + stat.importElapsedMs + "</td></tr>\n";
            }
            catch (Exception e) {
                log.info("\u751f\u6210\u62a5\u544a\u62a5\u9519:" + stat);
                e.printStackTrace();
            }
        }
        try {
            FileWriter writer = new FileWriter("create_index_perf.html");
            writer.write(html);
            writer.write(body);
            writer.write(foot);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void generateReport() {
        String html = "<html>\n\n<head>\n\t<title>\u6570\u636e\u5bfc\u5165\u6027\u80fd\u7edf\u8ba1</title>\n</head>\n<body>\n\t<h1>\u6570\u636e\u5bfc\u5165\u6027\u80fd\u7edf\u8ba1</h1>\n\t<table border=\"1\" cellspacing=\"0\" cellpadding=\"10\"><thead><tr>   <th>\u6587\u4ef6\u540d</th><th>\u6587\u4ef6\u5927\u5c0f</th><th>\u884c\u6570</th><th>\u5b57\u6bb5\u6570</th><th>\u8017\u65f6(ms)</th></tr></thead><tbody>\n";
        String foot = "</tbody></table></body>\n\n</html>";
        String body = "";
        STATS.sort(new /* Unavailable Anonymous Inner Class!! */);
        for (FileImportStat stat : STATS) {
            try {
                body = body + "<tr><td>" + stat.fileName + "</td><td>" + stat.size + "</td><td>" + stat.rows + "</td><td>" + stat.cols + "</td><td>" + stat.importElapsedMs + "</td></tr>\n";
            }
            catch (Exception e) {
                log.info("\u751f\u6210\u62a5\u544a\u62a5\u9519:" + stat);
                e.printStackTrace();
            }
        }
        try {
            FileWriter writer = new FileWriter("import_perf.html");
            writer.write(html);
            writer.write(body);
            writer.write(foot);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void renameFileWithPrefix(String dataDir, String prefix) {
        File[] files;
        File folder = new File(dataDir);
        if (folder.isDirectory() && (files = folder.listFiles()) != null) {
            for (File file : files) {
                if (!file.getName().toLowerCase().startsWith(prefix)) continue;
                File indexingName = new File(file.getAbsolutePath().replace(".finished", ".indexed"));
                boolean bl = file.renameTo(indexingName);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean copyFailedWithError(String copyLogFile) {
        try (BufferedReader br = new BufferedReader(new FileReader(copyLogFile));){
            String line;
            do {
                if ((line = br.readLine()) == null) return false;
            } while (!line.contains("ERROR: "));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return true;
        }
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    static {
        username = System.getProperty("username");
        password = System.getProperty("password");
    }
}

