/*
 * Decompiled with CFR 0.152.
 */
package com.goldendb.jdbc;

import com.goldendb.jdbc.MySQLConnection;
import com.goldendb.jdbc.StreamingNotifiable;
import com.goldendb.jdbc.internal.util.Messages;
import com.goldendb.jdbc.internal.util.SQLError;
import java.sql.SQLException;

public class CommunicationsException
extends SQLException
implements StreamingNotifiable {
    static final long serialVersionUID = 3193864990663398317L;
    private String exceptionMessage = null;

    public CommunicationsException(MySQLConnection conn, long lastPacketSentTimeMs, long lastPacketReceivedTimeMs, Exception underlyingException) {
        this.exceptionMessage = SQLError.createLinkFailureMessageBasedOnHeuristics(conn, lastPacketSentTimeMs, lastPacketReceivedTimeMs, underlyingException);
        if (underlyingException != null) {
            this.initCause(underlyingException);
        }
    }

    public String getMessage() {
        return this.exceptionMessage;
    }

    public String getSQLState() {
        return "08S01";
    }

    public void setWasStreamingResults() {
        this.exceptionMessage = Messages.getString("CommunicationsException.ClientWasStreaming");
    }
}

