/*
 * Decompiled with CFR 0.152.
 */
package com.goldendb.jdbc;

import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.Map;

public class HashCalculation {
    private static final long HASH_BUCKETID = 262144L;
    private static final long UT_HASH_RANDOM_MASK = 1463735687L;
    private static final long UT_HASH_RANDOM_MASK2 = 1653893711L;

    public BigInteger utHashUlint(BigInteger key, long tableSize) {
        key = key.xor(BigInteger.valueOf(1653893711L));
        return key.remainder(BigInteger.valueOf(tableSize));
    }

    public BigInteger utFoldUlintPair(long n1, long n2) {
        BigInteger b1 = BigInteger.valueOf(n1);
        BigInteger b2 = BigInteger.valueOf(n2);
        return b1.xor(b2).xor(BigInteger.valueOf(1653893711L)).shiftLeft(8).add(b1).xor(BigInteger.valueOf(1463735687L)).add(b2);
    }

    public long hashFuncBKDR(String str, int len) {
        long seed = 131L;
        long hash = 0L;
        for (int i = 0; i < len; ++i) {
            char item = str.charAt(i);
            hash = hash * seed + Long.valueOf(item);
        }
        return hash & Long.MAX_VALUE;
    }

    public BigInteger getHashValue(String str, int len) {
        long totalCount = 0L;
        long totalTmp = 0L;
        totalTmp = this.hashFuncBKDR(str, len);
        BigInteger rs = this.utFoldUlintPair(totalCount, totalTmp);
        return this.utHashUlint(rs, 262144L);
    }

    public int getGroupNo(String value, int valueLength, int groupCount) {
        int groupNo = 0;
        long interval = 262144L / (long)groupCount;
        LinkedHashMap<Long, Integer> nodes = new LinkedHashMap<Long, Integer>();
        for (int i = 1; i <= groupCount; ++i) {
            if (groupCount == i) {
                nodes.put(262144L, i);
                continue;
            }
            nodes.put((long)i * interval, i);
        }
        BigInteger val = this.getHashValue(value, valueLength);
        for (Map.Entry entry : nodes.entrySet()) {
            if ((long)val.intValue() >= (Long)entry.getKey()) continue;
            groupNo = (Integer)entry.getValue();
            break;
        }
        return groupNo;
    }

    public static void main(String[] args) {
        HashCalculation hash = new HashCalculation();
        System.out.println(hash.getGroupNo("123456789", "123456789".length(), 9));
    }
}

