/*
 * Decompiled with CFR 0.152.
 */
package com.goldendb.jdbc;

import com.goldendb.jdbc.BalanceStrategy;
import com.goldendb.jdbc.Connection;
import com.goldendb.jdbc.internal.core.io.ConnectionImpl;
import com.goldendb.jdbc.internal.core.loadbalance.LoadBalancedConnectionProxy;
import com.goldendb.jdbc.internal.util.SQLError;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomBalanceStrategy
implements BalanceStrategy {
    @Override
    public void destroy() {
    }

    @Override
    public void init(Connection conn, Properties props) throws SQLException {
    }

    @Override
    public ConnectionImpl pickConnection(LoadBalancedConnectionProxy proxy, List<String> configuredHosts, Map<String, ConnectionImpl> liveConnections, long[] responseTimes, int numRetries) throws SQLException {
        ConnectionImpl conn;
        int numHosts = configuredHosts.size();
        SQLException ex = null;
        ArrayList<String> whiteList = new ArrayList<String>(numHosts);
        whiteList.addAll(configuredHosts);
        Map<String, Long> blackList = proxy.getGlobalBlacklist();
        whiteList.removeAll(blackList.keySet());
        Map<String, Integer> whiteListMap = this.getArrayIndexMap(whiteList);
        int attempts = 0;
        while (true) {
            if (attempts >= numRetries) {
                if (ex != null) {
                    throw ex;
                }
                return null;
            }
            int random = (int)Math.floor(Math.random() * (double)whiteList.size());
            if (whiteList.size() == 0) {
                throw SQLError.createSQLException("No hosts configured", null);
            }
            String hostPortSpec = (String)whiteList.get(random);
            conn = liveConnections.get(hostPortSpec);
            if (conn != null) break;
            try {
                conn = proxy.createConnectionForHost(hostPortSpec);
            }
            catch (SQLException var19) {
                ex = var19;
                if (!proxy.shouldExceptionTriggerConnectionSwitch(var19)) {
                    throw var19;
                }
                Integer whiteListIndex = whiteListMap.get(hostPortSpec);
                if (whiteListIndex != null) {
                    whiteList.remove(whiteListIndex);
                    whiteListMap = this.getArrayIndexMap(whiteList);
                }
                proxy.addToGlobalBlacklist(hostPortSpec);
                if (whiteList.size() != 0) continue;
                ++attempts;
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException var18) {
                    // empty catch block
                }
                whiteListMap = new HashMap<String, Integer>(numHosts);
                whiteList.addAll(configuredHosts);
                blackList = proxy.getGlobalBlacklist();
                whiteList.removeAll(blackList.keySet());
                whiteListMap = this.getArrayIndexMap(whiteList);
                continue;
            }
            break;
        }
        return conn;
    }

    private Map<String, Integer> getArrayIndexMap(List<String> l) {
        HashMap<String, Integer> m = new HashMap<String, Integer>(l.size());
        for (int i = 0; i < l.size(); ++i) {
            m.put(l.get(i), i);
        }
        return m;
    }
}

