/*
 * Decompiled with CFR 0.152.
 */
package com.goldendb.jdbc.internal.authentication;

import com.goldendb.jdbc.AuthenticationPlugin;
import com.goldendb.jdbc.Connection;
import com.goldendb.jdbc.ExportControlled;
import com.goldendb.jdbc.MySQLConnection;
import com.goldendb.jdbc.internal.core.io.Buffer;
import com.goldendb.jdbc.internal.core.io.Security;
import com.goldendb.jdbc.internal.util.Messages;
import com.goldendb.jdbc.internal.util.SQLError;
import com.goldendb.jdbc.internal.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sha256PasswordPlugin
implements AuthenticationPlugin {
    public static String PLUGIN_NAME = "sha256_password";
    protected Connection connection;
    protected String password = null;
    protected String seed = null;
    protected boolean publicKeyRequested = false;
    protected String publicKeyString = null;

    @Override
    public void init(Connection conn, Properties props) throws SQLException {
        this.connection = conn;
        String pkURL = this.connection.getServerRSAPublicKeyFile();
        if (pkURL != null) {
            this.publicKeyString = Sha256PasswordPlugin.readRSAKey(this.connection, pkURL);
        }
    }

    @Override
    public void destroy() {
        this.password = null;
        this.seed = null;
        this.publicKeyRequested = false;
    }

    @Override
    public String getProtocolPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    public boolean requiresConfidentiality() {
        return false;
    }

    @Override
    public boolean isReusable() {
        return true;
    }

    @Override
    public void setAuthenticationParameters(String user, String password) {
        this.password = password;
    }

    @Override
    public boolean nextAuthenticationStep(Buffer fromServer, List<Buffer> toServer) throws SQLException {
        toServer.clear();
        if (this.password != null && this.password.length() != 0 && fromServer != null) {
            if (((MySQLConnection)this.connection).getIO().isSSLEstablished()) {
                Buffer bresp;
                try {
                    bresp = new Buffer(StringUtils.getBytes(this.password, this.connection.getPasswordCharacterEncoding()));
                }
                catch (UnsupportedEncodingException var5) {
                    throw SQLError.createSQLException(Messages.getString("Sha256PasswordPlugin.3", new Object[]{this.connection.getPasswordCharacterEncoding()}), "S1000", null);
                }
                bresp.setPosition(bresp.getBufLength());
                int oldBufLength = bresp.getBufLength();
                bresp.writeByte((byte)0);
                bresp.setBufLength(oldBufLength + 1);
                bresp.setPosition(0);
                toServer.add(bresp);
            } else if (this.connection.getServerRSAPublicKeyFile() != null) {
                this.seed = fromServer.readString();
                Buffer bresp = new Buffer(this.encryptPassword());
                toServer.add(bresp);
            } else {
                if (!this.connection.getAllowPublicKeyRetrieval()) {
                    throw SQLError.createSQLException(Messages.getString("Sha256PasswordPlugin.2"), "08001", this.connection.getExceptionInterceptor());
                }
                if (this.publicKeyRequested && fromServer.getBufLength() > 20) {
                    this.publicKeyString = fromServer.readString();
                    Buffer bresp = new Buffer(this.encryptPassword());
                    toServer.add(bresp);
                    this.publicKeyRequested = false;
                } else {
                    this.seed = fromServer.readString();
                    Buffer bresp = new Buffer(new byte[]{1});
                    toServer.add(bresp);
                    this.publicKeyRequested = true;
                }
            }
        } else {
            Buffer bresp = new Buffer(new byte[]{0});
            toServer.add(bresp);
        }
        return true;
    }

    protected byte[] encryptPassword() throws SQLException {
        return this.encryptPassword("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
    }

    protected byte[] encryptPassword(String transformation) throws SQLException {
        byte[] input;
        Object var2 = null;
        try {
            byte[] byArray;
            if (this.password != null) {
                byArray = StringUtils.getBytesNullTerminated(this.password, this.connection.getPasswordCharacterEncoding());
            } else {
                byte[] byArray2 = new byte[1];
                byArray = byArray2;
                byArray2[0] = 0;
            }
            input = byArray;
        }
        catch (UnsupportedEncodingException var5) {
            throw SQLError.createSQLException(Messages.getString("Sha256PasswordPlugin.3", new Object[]{this.connection.getPasswordCharacterEncoding()}), "S1000", null);
        }
        byte[] mysqlScrambleBuff = new byte[input.length];
        Security.xorString(input, mysqlScrambleBuff, this.seed.getBytes(), input.length);
        return ExportControlled.encryptWithRSAPublicKey(mysqlScrambleBuff, ExportControlled.decodeRSAPublicKey(this.publicKeyString, this.connection.getExceptionInterceptor()), transformation, this.connection.getExceptionInterceptor());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readRSAKey(Connection connection, String pkPath) throws SQLException {
        String string;
        String res = null;
        byte[] fileBuf = new byte[2048];
        BufferedInputStream fileIn = null;
        try {
            try {
                String var9;
                File f = new File(pkPath);
                String canonicalPath = f.getCanonicalPath();
                fileIn = new BufferedInputStream(new FileInputStream(canonicalPath));
                int bytesRead = 0;
                StringBuilder sb = new StringBuilder();
                while ((bytesRead = fileIn.read(fileBuf)) != -1) {
                    sb.append(StringUtils.toAsciiString(fileBuf, 0, bytesRead));
                }
                string = var9 = (res = sb.toString());
                Object var12_12 = null;
                if (fileIn == null) return string;
            }
            catch (IOException var19) {
                if (connection.getParanoid()) {
                    throw SQLError.createSQLException(Messages.getString("Sha256PasswordPlugin.0", new Object[]{""}), "S1009", connection.getExceptionInterceptor());
                }
                throw SQLError.createSQLException(Messages.getString("Sha256PasswordPlugin.0", new Object[]{"'" + pkPath + "'"}), "S1009", var19, connection.getExceptionInterceptor());
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (fileIn == null) throw throwable;
            try {
                fileIn.close();
                throw throwable;
            }
            catch (Exception var18) {
                SQLException sqlEx = SQLError.createSQLException(Messages.getString("Sha256PasswordPlugin.1"), "S1000", var18, connection.getExceptionInterceptor());
                throw sqlEx;
            }
        }
        try {}
        catch (Exception var18) {
            SQLException sqlEx = SQLError.createSQLException(Messages.getString("Sha256PasswordPlugin.1"), "S1000", var18, connection.getExceptionInterceptor());
            throw sqlEx;
        }
        fileIn.close();
        return string;
    }

    @Override
    public void reset() {
    }
}

