/*
 * Decompiled with CFR 0.152.
 */
package com.goldendb.jdbc.internal.core;

import com.goldendb.jdbc.Blob;
import com.goldendb.jdbc.Clob;
import com.goldendb.jdbc.Util;
import com.goldendb.jdbc.internal.core.JDBC4ClientInfoProvider;
import com.goldendb.jdbc.internal.core.JDBC4MySQLConnection;
import com.goldendb.jdbc.internal.core.JDBC4MysqlSQLXML;
import com.goldendb.jdbc.internal.core.JDBC4NClob;
import com.goldendb.jdbc.internal.core.io.ConnectionImpl;
import com.goldendb.jdbc.internal.util.Messages;
import com.goldendb.jdbc.internal.util.SQLError;
import java.sql.Array;
import java.sql.NClob;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.util.Properties;

public class JDBC4Connection
extends ConnectionImpl
implements JDBC4MySQLConnection {
    private static final long serialVersionUID = 2877471301981509475L;
    private JDBC4ClientInfoProvider infoProvider;

    public JDBC4Connection(String hostToConnectTo, int portToConnectTo, Properties info, String databaseToConnectTo, String url) throws SQLException {
        super(hostToConnectTo, portToConnectTo, info, databaseToConnectTo, url);
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return new JDBC4MysqlSQLXML(this.getExceptionInterceptor());
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw SQLError.createSQLFeatureNotSupportedException();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.getClientInfoProviderImpl().getClientInfo(this);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.getClientInfoProviderImpl().getClientInfo(this, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int timeout) throws SQLException {
        Object object = this.getConnectionMutex();
        synchronized (object) {
            if (this.isClosed()) {
                return false;
            }
            try {
                this.pingInternal(false, timeout * 1000);
                boolean var10000 = true;
                return var10000;
            }
            catch (Throwable var8) {
                boolean var10000;
                try {
                    try {
                        this.abortInternal();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    var10000 = false;
                }
                catch (Throwable var9) {
                    return false;
                }
                return var10000;
            }
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.getClientInfoProviderImpl().setClientInfo(this, properties);
        }
        catch (SQLClientInfoException var4) {
            throw var4;
        }
        catch (SQLException var5) {
            SQLClientInfoException clientInfoEx = new SQLClientInfoException();
            clientInfoEx.initCause(var5);
            throw clientInfoEx;
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.getClientInfoProviderImpl().setClientInfo(this, name, value);
        }
        catch (SQLClientInfoException var5) {
            throw var5;
        }
        catch (SQLException var6) {
            SQLClientInfoException clientInfoEx = new SQLClientInfoException();
            clientInfoEx.initCause(var6);
            throw clientInfoEx;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.checkClosed();
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this);
        }
        catch (ClassCastException var3) {
            throw SQLError.createSQLException("Unable to unwrap to " + iface.toString(), "S1009", this.getExceptionInterceptor());
        }
    }

    @Override
    public java.sql.Blob createBlob() {
        return new Blob(this.getExceptionInterceptor());
    }

    @Override
    public java.sql.Clob createClob() {
        return new Clob(this.getExceptionInterceptor());
    }

    @Override
    public NClob createNClob() {
        return new JDBC4NClob(this.getExceptionInterceptor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JDBC4ClientInfoProvider getClientInfoProviderImpl() throws SQLException {
        Object object = this.getConnectionMutex();
        synchronized (object) {
            if (this.infoProvider == null) {
                try {
                    try {
                        this.infoProvider = (JDBC4ClientInfoProvider)Util.getInstance(this.getClientInfoProvider(), new Class[0], new Object[0], this.getExceptionInterceptor());
                    }
                    catch (SQLException var4) {
                        if (var4.getCause() instanceof ClassCastException) {
                            this.infoProvider = (JDBC4ClientInfoProvider)Util.getInstance("com.goldendb.jdbc." + this.getClientInfoProvider(), new Class[0], new Object[0], this.getExceptionInterceptor());
                        }
                    }
                }
                catch (ClassCastException var5) {
                    throw SQLError.createSQLException(Messages.getString("JDBC4Connection.ClientInfoNotImplemented", new Object[]{this.getClientInfoProvider()}), "S1009", this.getExceptionInterceptor());
                }
                this.infoProvider.initialize(this, this.props);
            }
            return this.infoProvider;
        }
    }
}

