/*
 * Decompiled with CFR 0.152.
 */
package com.goldendb.jdbc.internal.core.io;

import com.goldendb.jdbc.AuthenticationPlugin;
import com.goldendb.jdbc.CompressedInputStream;
import com.goldendb.jdbc.ConnectionFeatureNotAvailableException;
import com.goldendb.jdbc.Constants;
import com.goldendb.jdbc.DriverVersion;
import com.goldendb.jdbc.ExceptionInterceptor;
import com.goldendb.jdbc.ExportControlled;
import com.goldendb.jdbc.Extension;
import com.goldendb.jdbc.MySQLConnection;
import com.goldendb.jdbc.MysqlDataTruncation;
import com.goldendb.jdbc.PacketTooBigException;
import com.goldendb.jdbc.PreparedStatement;
import com.goldendb.jdbc.ProfilerEventHandlerFactory;
import com.goldendb.jdbc.ServerPreparedStatement;
import com.goldendb.jdbc.StatementImpl;
import com.goldendb.jdbc.Util;
import com.goldendb.jdbc.internal.authentication.GoldendbClearPasswordPlugin;
import com.goldendb.jdbc.internal.authentication.GoldendbNativePasswordPlugin;
import com.goldendb.jdbc.internal.authentication.GoldendbOldPasswordPlugin;
import com.goldendb.jdbc.internal.authentication.Sha256PasswordPlugin;
import com.goldendb.jdbc.internal.core.io.Buffer;
import com.goldendb.jdbc.internal.core.io.BufferRow;
import com.goldendb.jdbc.internal.core.io.ByteArrayRow;
import com.goldendb.jdbc.internal.core.io.Field;
import com.goldendb.jdbc.internal.core.io.NetworkResources;
import com.goldendb.jdbc.internal.core.io.NonRegisteringDriver;
import com.goldendb.jdbc.internal.core.io.ResultSetImpl;
import com.goldendb.jdbc.internal.core.io.ResultSetInternalMethods;
import com.goldendb.jdbc.internal.core.io.ResultSetRow;
import com.goldendb.jdbc.internal.core.io.RowData;
import com.goldendb.jdbc.internal.core.io.RowDataCursor;
import com.goldendb.jdbc.internal.core.io.RowDataDynamic;
import com.goldendb.jdbc.internal.core.io.RowDataStatic;
import com.goldendb.jdbc.internal.core.io.Security;
import com.goldendb.jdbc.internal.core.io.SocketFactory;
import com.goldendb.jdbc.internal.core.io.Statement;
import com.goldendb.jdbc.internal.core.io.StatementInterceptorV2;
import com.goldendb.jdbc.internal.custom.LoadBalanceExceptionChecker;
import com.goldendb.jdbc.internal.exceptions.GoldenDBStatementCancelledException;
import com.goldendb.jdbc.internal.exceptions.GoldenDBTimeoutException;
import com.goldendb.jdbc.internal.log.LogUtils;
import com.goldendb.jdbc.internal.util.CharsetMapping;
import com.goldendb.jdbc.internal.util.Messages;
import com.goldendb.jdbc.internal.util.ReadAheadInputStream;
import com.goldendb.jdbc.internal.util.ResultSetUtil;
import com.goldendb.jdbc.internal.util.SQLError;
import com.goldendb.jdbc.internal.util.SingleByteCharsetConverter;
import com.goldendb.jdbc.internal.util.StringUtils;
import com.goldendb.jdbc.internal.util.TimeUtil;
import com.goldendb.jdbc.profiler.ProfilerEvent;
import com.goldendb.jdbc.profiler.ProfilerEventHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.ref.SoftReference;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.Deflater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MysqlIO {
    private static final String CODE_PAGE_1252 = "Cp1252";
    protected static final int NULL_LENGTH = -1;
    protected static final int COMP_HEADER_LENGTH = 3;
    protected static final int MIN_COMPRESS_LEN = 50;
    protected static final int HEADER_LENGTH = 4;
    protected static final int AUTH_411_OVERHEAD = 33;
    public static final int SEED_LENGTH = 20;
    private static int maxBufferSize = 65535;
    private static final String NONE = "none";
    private static final int CLIENT_LONG_PASSWORD = 1;
    private static final int CLIENT_FOUND_ROWS = 2;
    private static final int CLIENT_LONG_FLAG = 4;
    protected static final int CLIENT_CONNECT_WITH_DB = 8;
    private static final int CLIENT_COMPRESS = 32;
    private static final int CLIENT_LOCAL_FILES = 128;
    private static final int CLIENT_PROTOCOL_41 = 512;
    private static final int CLIENT_INTERACTIVE = 1024;
    protected static final int CLIENT_SSL = 2048;
    private static final int CLIENT_TRANSACTIONS = 8192;
    protected static final int CLIENT_RESERVED = 16384;
    protected static final int CLIENT_SECURE_CONNECTION = 32768;
    private static final int CLIENT_MULTI_STATEMENTS = 65536;
    private static final int CLIENT_MULTI_RESULTS = 131072;
    private static final int CLIENT_PLUGIN_AUTH = 524288;
    private static final int CLIENT_CONNECT_ATTRS = 0x100000;
    private static final int CLIENT_PLUGIN_AUTH_LENENC_CLIENT_DATA = 0x200000;
    private static final int CLIENT_CAN_HANDLE_EXPIRED_PASSWORD = 0x400000;
    private static final int CLIENT_SESSION_TRACK = 0x800000;
    private static final int CLIENT_DEPRECATE_EOF = 0x1000000;
    private static final int SERVER_STATUS_IN_TRANS = 1;
    private static final int SERVER_STATUS_AUTOCOMMIT = 2;
    static final int SERVER_MORE_RESULTS_EXISTS = 8;
    private static final int SERVER_QUERY_NO_GOOD_INDEX_USED = 16;
    private static final int SERVER_QUERY_NO_INDEX_USED = 32;
    private static final int SERVER_QUERY_WAS_SLOW = 2048;
    private static final int SERVER_STATUS_CURSOR_EXISTS = 64;
    private static final String FALSE_SCRAMBLE = "xxxxxxxx";
    protected static final int MAX_QUERY_SIZE_TO_LOG = 1024;
    protected static final int MAX_QUERY_SIZE_TO_EXPLAIN = 0x100000;
    protected static final int INITIAL_PACKET_SIZE = 51200;
    private static String jvmPlatformCharset = null;
    protected static final String ZERO_DATE_VALUE_MARKER = "0000-00-00";
    protected static final String ZERO_DATETIME_VALUE_MARKER = "0000-00-00 00:00:00";
    private static final String EXPLAINABLE_STATEMENT = "SELECT";
    private static final String[] EXPLAINABLE_STATEMENT_EXTENSION = new String[]{"INSERT", "UPDATE", "REPLACE", "DELETE"};
    private static final int MAX_PACKET_DUMP_LENGTH = 1024;
    private boolean packetSequenceReset = false;
    protected int serverCharsetIndex;
    private Buffer reusablePacket = null;
    private Buffer sendPacket = null;
    private Buffer sharedSendPacket = null;
    private MyDumpInfo myDumpInfo = null;
    public BufferedOutputStream mysqlOutput = null;
    public MySQLConnection connection;
    private Deflater deflater = null;
    public InputStream mysqlInput = null;
    private LinkedList<StringBuilder> packetDebugRingBuffer = null;
    private RowData streamingData = null;
    public Socket mysqlConnection = null;
    public SocketFactory socketFactory = null;
    private SoftReference<Buffer> loadFileBufRef;
    private SoftReference<Buffer> splitBufRef;
    private SoftReference<Buffer> compressBufRef;
    public String host = null;
    protected String seed;
    private String serverVersion = null;
    private String socketFactoryClassName = null;
    private byte[] packetHeaderBuf = new byte[4];
    private boolean colDecimalNeedsBump = false;
    private boolean hadWarnings = false;
    private boolean has41NewNewProt = false;
    private boolean hasLongColumnInfo = false;
    private boolean isInteractiveClient = false;
    private boolean logSlowQueries = false;
    private boolean platformDbCharsetMatches = true;
    private boolean profileSql = false;
    private boolean queryBadIndexUsed = false;
    private boolean queryNoIndexUsed = false;
    private boolean serverQueryWasSlow = false;
    private boolean use41Extensions = false;
    private boolean useCompression = false;
    private boolean useNewLargePackets = false;
    private boolean useNewUpdateCounts = false;
    private byte packetSequence = 0;
    private byte compressedPacketSequence = 0;
    private byte readPacketSequence = (byte)-1;
    private boolean checkPacketSequence = false;
    private byte protocolVersion = 0;
    private int maxAllowedPacket = 0x100000;
    protected int maxThreeBytes = 16581375;
    public int port = 3306;
    protected int serverCapabilities;
    private int serverMajorVersion = 0;
    private int serverMinorVersion = 0;
    private int oldServerStatus = 0;
    private int serverStatus = 0;
    private int serverSubMinorVersion = 0;
    private int warningCount = 0;
    protected long clientParam = 0L;
    protected long lastPacketSentTimeMs = 0L;
    protected long lastPacketReceivedTimeMs = 0L;
    private boolean traceProtocol = false;
    private boolean enablePacketDebug = false;
    private boolean useConnectWithDb;
    private boolean needToGrabQueryFromPacket;
    private boolean autoGenerateTestcaseScript;
    private long threadId;
    private boolean useNanosForElapsedTime;
    private long slowQueryThreshold;
    private String queryTimingUnits;
    private boolean useDirectRowUnpack = true;
    private int useBufferRowSizeThreshold;
    private int commandCount = 0;
    private List<StatementInterceptorV2> statementInterceptors;
    private ExceptionInterceptor exceptionInterceptor;
    private int authPluginDataLength = 0;
    protected int orgPort = 0;
    protected String orgIP;
    protected SocketInfo socketInfo;
    private Map<String, AuthenticationPlugin> authenticationPlugins = null;
    private List<String> disabledAuthenticationPlugins = null;
    private String clientDefaultAuthenticationPlugin = null;
    private String clientDefaultAuthenticationPluginName = null;
    private String serverDefaultAuthenticationPluginName = null;
    private int statementExecutionDepth = 0;
    private boolean useAutoSlowLog;
    private boolean batchExecuteWithErrorNumber;

    public MysqlIO(String host, int port, Properties props, String socketFactoryClassName, MySQLConnection conn, int socketTimeout, int useBufferRowSizeThreshold) throws IOException, SQLException {
        this.connection = conn;
        int sysDumpListSize = this.connection.getDumpListSize();
        int infoLength = this.connection.getDumpInfoLength();
        this.batchExecuteWithErrorNumber = this.connection.getBatchExecuteWithErrorNumber();
        this.myDumpInfo = new MyDumpInfo(sysDumpListSize, infoLength);
        if (this.connection.getEnablePacketDebug()) {
            this.packetDebugRingBuffer = new LinkedList();
        }
        this.traceProtocol = this.connection.getTraceProtocol();
        this.useAutoSlowLog = this.connection.getAutoSlowLog();
        this.useBufferRowSizeThreshold = useBufferRowSizeThreshold;
        this.useDirectRowUnpack = this.connection.getUseDirectRowUnpack();
        this.logSlowQueries = this.connection.getLogSlowQueries();
        this.reusablePacket = new Buffer(51200);
        this.sendPacket = new Buffer(51200);
        this.port = port;
        this.host = host;
        this.socketFactoryClassName = socketFactoryClassName;
        this.socketFactory = this.createSocketFactory();
        this.exceptionInterceptor = this.connection.getExceptionInterceptor();
        try {
            this.mysqlConnection = this.socketFactory.connect(this.host, this.port, props);
            if (socketTimeout != 0) {
                try {
                    this.mysqlConnection.setSoTimeout(socketTimeout);
                }
                catch (Exception var11) {
                    // empty catch block
                }
            }
            this.mysqlConnection = this.socketFactory.beforeHandshake();
            this.socketInfo = new SocketInfo(this.mysqlConnection);
            String linkInfo = this.socketInfo.getLinkInfo() + "\n";
            this.connection.setLinkInfo(linkInfo);
            this.mysqlInput = this.connection.getUseReadAheadInput() ? new ReadAheadInputStream(this.mysqlConnection.getInputStream(), 16384, this.connection.getTraceProtocol(), this.connection.getLog()) : (this.connection.useUnbufferedInput() ? this.mysqlConnection.getInputStream() : new BufferedInputStream(this.mysqlConnection.getInputStream(), 16384));
            this.mysqlOutput = new BufferedOutputStream(this.mysqlConnection.getOutputStream(), 16384);
            this.isInteractiveClient = this.connection.getInteractiveClient();
            this.profileSql = this.connection.getProfileSql();
            this.autoGenerateTestcaseScript = this.connection.getAutoGenerateTestcaseScript();
            boolean bl = this.needToGrabQueryFromPacket = this.profileSql || this.logSlowQueries || this.autoGenerateTestcaseScript;
            if (this.connection.getUseNanosForElapsedTime() && TimeUtil.nanoTimeAvailable()) {
                this.useNanosForElapsedTime = true;
                this.queryTimingUnits = Messages.getString("Nanoseconds");
            } else {
                this.queryTimingUnits = Messages.getString("Milliseconds");
            }
            if (this.connection.getLogSlowQueries()) {
                this.calculateSlowQueryThreshold();
            }
        }
        catch (IOException var12) {
            this.printDumpStack();
            throw SQLError.createCommunicationsException(this.connection, 0L, 0L, var12, this.getExceptionInterceptor());
        }
        catch (SQLException var13) {
            this.printDumpStack();
            this.exceptionChecker(var13);
            throw var13;
        }
    }

    public boolean hasLongColumnInfo() {
        return this.hasLongColumnInfo;
    }

    protected boolean isDataAvailable() throws SQLException {
        try {
            return this.mysqlInput.available() > 0;
        }
        catch (IOException var2) {
            throw SQLError.createCommunicationsException(this.connection, this.lastPacketSentTimeMs, this.lastPacketReceivedTimeMs, var2, this.getExceptionInterceptor());
        }
    }

    public long getLastPacketSentTimeMs() {
        return this.lastPacketSentTimeMs;
    }

    public long getLastPacketReceivedTimeMs() {
        return this.lastPacketReceivedTimeMs;
    }

    protected ResultSetImpl getResultSet(StatementImpl callingStatement, long columnCount, int maxRows, int resultSetType, int resultSetConcurrency, boolean streamResults, String catalog, boolean isBinaryEncoded, Field[] metadataFromCache) throws SQLException {
        Field[] fields = null;
        try {
            RowData rowData;
            ServerPreparedStatement prepStmt;
            if (metadataFromCache == null) {
                fields = new Field[(int)columnCount];
                int i = 0;
                while ((long)i < columnCount) {
                    Buffer fieldPacket = null;
                    fieldPacket = this.readPacket();
                    fields[i] = this.unpackField(fieldPacket, false);
                    ++i;
                }
            } else {
                int i = 0;
                while ((long)i < columnCount) {
                    this.skipPacket();
                    ++i;
                }
            }
            if (!this.isEOFDeprecated() || this.connection.versionMeetsMinimum(5, 0, 2) && callingStatement != null && isBinaryEncoded && callingStatement.isCursorRequired()) {
                Buffer packet = this.reuseAndReadPacket(this.reusablePacket);
                this.readServerStatusForResultSets(packet);
            }
            if (this.connection.versionMeetsMinimum(5, 0, 2) && this.connection.getUseCursorFetch() && isBinaryEncoded && callingStatement != null && callingStatement.getFetchSize() != 0 && callingStatement.getResultSetType() == 1003) {
                prepStmt = (ServerPreparedStatement)callingStatement;
                boolean usingCursor = true;
                if (this.connection.versionMeetsMinimum(5, 0, 5)) {
                    boolean bl = usingCursor = (this.serverStatus & 0x40) != 0;
                }
                if (usingCursor) {
                    RowDataCursor rows = new RowDataCursor(this, prepStmt, fields);
                    ResultSetImpl rs = this.buildResultSetWithRows(callingStatement, catalog, fields, rows, resultSetType, resultSetConcurrency, isBinaryEncoded);
                    if (usingCursor) {
                        rs.setFetchSize(callingStatement.getFetchSize());
                    }
                    return rs;
                }
            }
            prepStmt = null;
            if (!streamResults) {
                rowData = this.readSingleRowSet(columnCount, maxRows, resultSetConcurrency, isBinaryEncoded, metadataFromCache == null ? fields : metadataFromCache);
            } else {
                this.streamingData = rowData = new RowDataDynamic(this, (int)columnCount, metadataFromCache == null ? fields : metadataFromCache, isBinaryEncoded);
            }
            ResultSetImpl rs = this.buildResultSetWithRows(callingStatement, catalog, metadataFromCache == null ? fields : metadataFromCache, rowData, resultSetType, resultSetConcurrency, isBinaryEncoded);
            return rs;
        }
        catch (SQLException var17) {
            this.printDumpStack();
            throw var17;
        }
    }

    protected NetworkResources getNetworkResources() {
        return new NetworkResources(this.mysqlConnection, this.mysqlInput, this.mysqlOutput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void forceClose() {
        try {
            this.getNetworkResources().forceClose();
            Object var2_1 = null;
            this.mysqlConnection = null;
            this.mysqlInput = null;
            this.mysqlOutput = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.mysqlConnection = null;
            this.mysqlInput = null;
            this.mysqlOutput = null;
            throw throwable;
        }
    }

    protected final void skipPacket() throws SQLException {
        try {
            int lengthRead = this.readFully(this.mysqlInput, this.packetHeaderBuf, 0, 4);
            if (lengthRead < 4) {
                this.forceClose();
                throw new IOException(Messages.getString("MysqlIO.1"));
            }
            int packetLength = (this.packetHeaderBuf[0] & 0xFF) + ((this.packetHeaderBuf[1] & 0xFF) << 8) + ((this.packetHeaderBuf[2] & 0xFF) << 16);
            if (this.traceProtocol) {
                StringBuilder traceMessageBuf = new StringBuilder();
                traceMessageBuf.append(Messages.getString("MysqlIO.2"));
                traceMessageBuf.append(packetLength);
                traceMessageBuf.append(Messages.getString("MysqlIO.3"));
                traceMessageBuf.append(StringUtils.dumpAsHex(this.packetHeaderBuf, 4));
                this.connection.getLog().logTrace(traceMessageBuf.toString());
            }
            byte multiPacketSeq = this.packetHeaderBuf[3];
            if (!this.packetSequenceReset) {
                if (this.enablePacketDebug && this.checkPacketSequence) {
                    this.checkPacketSequencing(multiPacketSeq);
                }
            } else {
                this.packetSequenceReset = false;
            }
            this.readPacketSequence = multiPacketSeq;
            this.skipFully(this.mysqlInput, packetLength);
        }
        catch (IOException var5) {
            throw SQLError.createCommunicationsException(this.connection, this.lastPacketSentTimeMs, this.lastPacketReceivedTimeMs, var5, this.getExceptionInterceptor());
        }
        catch (OutOfMemoryError var6) {
            OutOfMemoryError oom = var6;
            try {
                this.connection.realClose(false, false, true, oom);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw var6;
        }
    }

    public final Buffer readPacket() throws SQLException {
        try {
            int lengthRead = this.readFully(this.mysqlInput, this.packetHeaderBuf, 0, 4);
            if (lengthRead < 4) {
                this.forceClose();
                throw new IOException(Messages.getString("MysqlIO.1"));
            }
            int packetLength = (this.packetHeaderBuf[0] & 0xFF) + ((this.packetHeaderBuf[1] & 0xFF) << 8) + ((this.packetHeaderBuf[2] & 0xFF) << 16);
            if (packetLength > this.maxAllowedPacket) {
                throw new PacketTooBigException(packetLength, this.maxAllowedPacket);
            }
            if (this.traceProtocol) {
                StringBuilder traceMessageBuf = new StringBuilder();
                traceMessageBuf.append(Messages.getString("MysqlIO.2"));
                traceMessageBuf.append(packetLength);
                traceMessageBuf.append(Messages.getString("MysqlIO.3"));
                traceMessageBuf.append(StringUtils.dumpAsHex(this.packetHeaderBuf, 4));
                this.connection.getLog().logTrace(traceMessageBuf.toString());
            }
            byte multiPacketSeq = this.packetHeaderBuf[3];
            if (!this.packetSequenceReset) {
                if (this.enablePacketDebug && this.checkPacketSequence) {
                    this.checkPacketSequencing(multiPacketSeq);
                }
            } else {
                this.packetSequenceReset = false;
            }
            this.readPacketSequence = multiPacketSeq;
            byte[] buffer = new byte[packetLength];
            int numBytesRead = this.readFully(this.mysqlInput, buffer, 0, packetLength);
            if (numBytesRead != packetLength) {
                throw new IOException("Short read, expected " + packetLength + " bytes, only read " + numBytesRead);
            }
            Buffer packet = new Buffer(buffer);
            if (this.traceProtocol) {
                StringBuilder traceMessageBuf = new StringBuilder();
                traceMessageBuf.append(Messages.getString("MysqlIO.4"));
                traceMessageBuf.append(MysqlIO.getPacketDumpToLog(packet, packetLength));
                this.connection.getLog().logTrace(traceMessageBuf.toString());
            }
            if (this.enablePacketDebug) {
                this.enqueuePacketForDebugging(false, false, 0, this.packetHeaderBuf, packet);
            }
            if (this.connection.getMaintainTimeStats()) {
                this.lastPacketReceivedTimeMs = System.currentTimeMillis();
            }
            return packet;
        }
        catch (IOException var9) {
            this.printDumpStack();
            throw SQLError.createCommunicationsException(this.connection, this.lastPacketSentTimeMs, this.lastPacketReceivedTimeMs, var9, this.getExceptionInterceptor());
        }
        catch (SQLException var10) {
            this.printDumpStack();
            this.exceptionChecker(var10);
            throw var10;
        }
        catch (OutOfMemoryError var11) {
            OutOfMemoryError oom = var11;
            this.printDumpStack();
            try {
                this.connection.realClose(false, false, true, oom);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw var11;
        }
    }

    public final Field unpackField(Buffer packet, boolean extractDefaultValues) throws SQLException {
        try {
            if (this.use41Extensions) {
                int databaseNameLength;
                int databaseNameStart;
                if (this.has41NewNewProt) {
                    databaseNameStart = packet.getPosition() + 1;
                    databaseNameLength = packet.fastSkipLenString();
                    this.adjustStartForFieldLength(databaseNameStart, databaseNameLength);
                }
                databaseNameStart = packet.getPosition() + 1;
                databaseNameLength = packet.fastSkipLenString();
                databaseNameStart = this.adjustStartForFieldLength(databaseNameStart, databaseNameLength);
                int tableNameStart = packet.getPosition() + 1;
                int tableNameLength = packet.fastSkipLenString();
                tableNameStart = this.adjustStartForFieldLength(tableNameStart, tableNameLength);
                int originalTableNameStart = packet.getPosition() + 1;
                int originalTableNameLength = packet.fastSkipLenString();
                originalTableNameStart = this.adjustStartForFieldLength(originalTableNameStart, originalTableNameLength);
                int nameStart = packet.getPosition() + 1;
                int nameLength = packet.fastSkipLenString();
                nameStart = this.adjustStartForFieldLength(nameStart, nameLength);
                int originalColumnNameStart = packet.getPosition() + 1;
                int originalColumnNameLength = packet.fastSkipLenString();
                originalColumnNameStart = this.adjustStartForFieldLength(originalColumnNameStart, originalColumnNameLength);
                packet.readByte();
                short charSetNumber = (short)packet.readInt();
                long colLength = 0L;
                colLength = this.has41NewNewProt ? packet.readLong() : (long)packet.readLongInt();
                int colType = packet.readByte() & 0xFF;
                short colFlag = 0;
                colFlag = this.hasLongColumnInfo ? (short)packet.readInt() : (short)(packet.readByte() & 0xFF);
                int colDecimals = packet.readByte() & 0xFF;
                int defaultValueStart = -1;
                int defaultValueLength = -1;
                if (extractDefaultValues) {
                    defaultValueStart = packet.getPosition() + 1;
                    defaultValueLength = packet.fastSkipLenString();
                }
                Field field = new Field(this.connection, packet.getByteBuffer(), databaseNameStart, databaseNameLength, tableNameStart, tableNameLength, originalTableNameStart, originalTableNameLength, nameStart, nameLength, originalColumnNameStart, originalColumnNameLength, colLength, colType, colFlag, colDecimals, defaultValueStart, defaultValueLength, charSetNumber);
                return field;
            }
            int databaseNameStart = packet.getPosition() + 1;
            int databaseNameLength = packet.fastSkipLenString();
            databaseNameStart = this.adjustStartForFieldLength(databaseNameStart, databaseNameLength);
            int tableNameStart = packet.getPosition() + 1;
            int tableNameLength = packet.fastSkipLenString();
            tableNameStart = this.adjustStartForFieldLength(tableNameStart, tableNameLength);
            int originalTableNameStart = packet.readnBytes();
            int originalTableNameLength = packet.readnBytes();
            packet.readByte();
            short colFlag = 0;
            colFlag = this.hasLongColumnInfo ? (short)packet.readInt() : (short)(packet.readByte() & 0xFF);
            int nameLength = packet.readByte() & 0xFF;
            if (this.colDecimalNeedsBump) {
                ++nameLength;
            }
            Field field = new Field(this.connection, packet.getByteBuffer(), tableNameStart, tableNameLength, databaseNameStart, databaseNameLength, originalTableNameStart, originalTableNameLength, colFlag, nameLength);
            return field;
        }
        catch (SQLException var22) {
            this.printDumpStack();
            throw var22;
        }
    }

    private int adjustStartForFieldLength(int nameStart, int nameLength) {
        if (nameLength < 251) {
            return nameStart;
        }
        if (nameLength >= 251 && nameLength < 65536) {
            return nameStart + 2;
        }
        return nameLength >= 65536 && nameLength < 0x1000000 ? nameStart + 3 : nameStart + 8;
    }

    protected boolean isSetNeededForAutoCommitMode(boolean autoCommitFlag) {
        if (this.use41Extensions && this.connection.getElideSetAutoCommits()) {
            boolean autoCommitModeOnServer;
            boolean bl = autoCommitModeOnServer = (this.serverStatus & 2) != 0;
            if (!autoCommitFlag && this.versionMeetsMinimum(5, 0, 0)) {
                return !this.inTransactionOnServer();
            }
            return autoCommitModeOnServer != autoCommitFlag;
        }
        return true;
    }

    protected boolean inTransactionOnServer() {
        return (this.serverStatus & 1) != 0;
    }

    protected void changeUser(String userName, String password, String database) throws SQLException {
        try {
            this.packetSequence = (byte)-1;
            this.compressedPacketSequence = (byte)-1;
            int passwordLength = 16;
            int userLength = userName != null ? userName.length() : 0;
            int databaseLength = database != null ? database.length() : 0;
            int packLength = (userLength + passwordLength + databaseLength) * 3 + 7 + 4 + 33;
            if ((this.serverCapabilities & 0x80000) != 0) {
                this.proceedHandshakeWithPluggableAuthentication(userName, password, database, null);
            } else if ((this.serverCapabilities & 0x8000) != 0) {
                Buffer packet = new Buffer(packLength + 1);
                packet.writeByte((byte)17);
                if (this.versionMeetsMinimum(4, 1, 1)) {
                    this.secureAuth411(packet, packLength, userName, password, database, false, true);
                } else {
                    this.secureAuth(packet, packLength, userName, password, database, false);
                }
            } else {
                boolean localUseConnectWithDb;
                Buffer packet = new Buffer(packLength);
                packet.writeByte((byte)17);
                packet.writeString(userName);
                if (this.protocolVersion > 9) {
                    packet.writeString(Util.newCrypt(password, this.seed, this.connection.getPasswordCharacterEncoding()));
                } else {
                    packet.writeString(Util.oldCrypt(password, this.seed));
                }
                boolean bl = localUseConnectWithDb = this.useConnectWithDb && database != null && database.length() > 0;
                if (localUseConnectWithDb) {
                    packet.writeString(database);
                }
                this.send(packet, packet.getPosition());
                this.checkErrorPacket();
                if (!localUseConnectWithDb) {
                    this.changeDatabaseTo(database);
                }
            }
        }
        catch (SQLException var10) {
            this.printDumpStack();
            throw var10;
        }
    }

    protected Buffer checkErrorPacket() throws SQLException {
        return this.checkErrorPacket(-1);
    }

    protected void checkForCharsetMismatch() {
        if (this.connection.getUseUnicode() && this.connection.getEncoding() != null) {
            String encodingToCheck = jvmPlatformCharset;
            if (encodingToCheck == null) {
                encodingToCheck = System.getProperty("file.encoding");
            }
            this.platformDbCharsetMatches = encodingToCheck == null ? false : encodingToCheck.equals(this.connection.getEncoding());
        }
    }

    public void clearInputStream() throws SQLException {
        try {
            int len;
            while ((len = this.mysqlInput.available()) > 0 && this.mysqlInput.skip(len) > 0L) {
            }
        }
        catch (IOException var2) {
            this.printDumpStack();
            throw SQLError.createCommunicationsException(this.connection, this.lastPacketSentTimeMs, this.lastPacketReceivedTimeMs, var2, this.getExceptionInterceptor());
        }
    }

    protected void resetReadPacketSequence() {
        this.readPacketSequence = 0;
    }

    public void dumpPacketRingBuffer() throws SQLException {
        try {
            if (this.packetDebugRingBuffer != null && this.connection.getEnablePacketDebug()) {
                StringBuilder dumpBuffer = new StringBuilder();
                dumpBuffer.append("Last " + this.packetDebugRingBuffer.size() + " packets received from server, from oldest->newest:\n");
                dumpBuffer.append("\n");
                Iterator ringBufIter = this.packetDebugRingBuffer.iterator();
                while (ringBufIter.hasNext()) {
                    dumpBuffer.append((CharSequence)ringBufIter.next());
                    dumpBuffer.append("\n");
                }
                this.connection.getLog().logTrace(dumpBuffer.toString());
            }
        }
        catch (SQLException var3) {
            this.printDumpStack();
            throw var3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void explainSlowQuery(byte[] querySQL, String truncatedQuery) throws SQLException {
        PreparedStatement stmt;
        block8: {
            if (!StringUtils.startsWithIgnoreCaseAndWs(truncatedQuery, EXPLAINABLE_STATEMENT)) {
                if (!this.versionMeetsMinimum(5, 6, 3)) return;
                if (StringUtils.startsWithIgnoreCaseAndWs(truncatedQuery, EXPLAINABLE_STATEMENT_EXTENSION) == -1) return;
            }
            stmt = null;
            ResultSet rs = null;
            try {
                try {
                    stmt = (PreparedStatement)this.connection.clientPrepareStatement("EXPLAIN ?");
                    stmt.setBytesNoEscapeNoQuotes(1, querySQL);
                    rs = stmt.executeQuery();
                    StringBuilder explainResults = new StringBuilder(Messages.getString("MysqlIO.8") + truncatedQuery + Messages.getString("MysqlIO.9"));
                    ResultSetUtil.appendResultSetSlashGStyle(explainResults, rs);
                    this.connection.getLog().logWarn(explainResults.toString());
                }
                catch (SQLException var10) {
                    this.printDumpStack();
                    Object var7_8 = null;
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt == null) return;
                    stmt.close();
                    return;
                }
                Object var7_7 = null;
                if (rs == null) break block8;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (rs != null) {
                    rs.close();
                }
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            rs.close();
        }
        if (stmt == null) return;
        stmt.close();
    }

    public static int getMaxBuf() {
        return maxBufferSize;
    }

    final int getServerMajorVersion() {
        return this.serverMajorVersion;
    }

    final int getServerMinorVersion() {
        return this.serverMinorVersion;
    }

    final int getServerSubMinorVersion() {
        return this.serverSubMinorVersion;
    }

    String getServerVersion() {
        return this.serverVersion;
    }

    void doHandshake(String user, String password, String database) throws SQLException {
        block67: {
            try {
                int databaseLength;
                int userLength;
                this.checkPacketSequence = false;
                this.readPacketSequence = 0;
                Buffer buf = this.readPacket();
                this.protocolVersion = buf.readByte();
                if (this.protocolVersion == -1) {
                    try {
                        this.mysqlConnection.close();
                    }
                    catch (Exception var12) {
                        // empty catch block
                    }
                    int errno = 2000;
                    int point = buf.readInt();
                    String remaining = buf.readString("ASCII", this.getExceptionInterceptor());
                    StringBuilder errorBuf = new StringBuilder(Messages.getString("MysqlIO.10"));
                    errorBuf.append(remaining);
                    errorBuf.append("\"");
                    String xOpen = SQLError.mysqlToSqlState(point, this.connection.getUseSqlStateCodes());
                    throw SQLError.createSQLException(SQLError.get(xOpen) + ", " + errorBuf.toString(), xOpen, point, this.getExceptionInterceptor());
                }
                this.serverVersion = buf.readString("ASCII", this.getExceptionInterceptor());
                int point = this.serverVersion.indexOf(46);
                if (point != -1) {
                    try {
                        int n;
                        this.serverMajorVersion = n = Integer.parseInt(this.serverVersion.substring(0, point));
                    }
                    catch (NumberFormatException var16) {
                        // empty catch block
                    }
                    String remaining = this.serverVersion.substring(point + 1, this.serverVersion.length());
                    point = remaining.indexOf(46);
                    if (point != -1) {
                        try {
                            this.serverMinorVersion = userLength = Integer.parseInt(remaining.substring(0, point));
                        }
                        catch (NumberFormatException var15) {
                            // empty catch block
                        }
                        remaining = remaining.substring(point + 1, remaining.length());
                        for (userLength = 0; userLength < remaining.length() && remaining.charAt(userLength) >= '0' && remaining.charAt(userLength) <= '9'; ++userLength) {
                        }
                        try {
                            this.serverSubMinorVersion = databaseLength = Integer.parseInt(remaining.substring(0, userLength));
                        }
                        catch (NumberFormatException var14) {
                            // empty catch block
                        }
                    }
                }
                if (this.versionMeetsMinimum(4, 0, 8)) {
                    this.maxThreeBytes = 0xFFFFFF;
                    this.useNewLargePackets = true;
                } else {
                    this.maxThreeBytes = 16581375;
                    this.useNewLargePackets = false;
                }
                this.colDecimalNeedsBump = this.versionMeetsMinimum(3, 23, 0);
                this.colDecimalNeedsBump = !this.versionMeetsMinimum(3, 23, 15);
                this.useNewUpdateCounts = this.versionMeetsMinimum(3, 22, 5);
                this.threadId = buf.readLong();
                if (this.protocolVersion > 9) {
                    this.seed = buf.readString("ASCII", this.getExceptionInterceptor(), 8);
                    buf.readByte();
                } else {
                    this.seed = buf.readString("ASCII", this.getExceptionInterceptor());
                }
                this.serverCapabilities = 0;
                if (buf.getPosition() < buf.getBufLength()) {
                    this.serverCapabilities = buf.readInt();
                }
                if (this.versionMeetsMinimum(4, 1, 1) || this.protocolVersion > 9 && (this.serverCapabilities & 0x200) != 0) {
                    this.serverCharsetIndex = buf.readByte() & 0xFF;
                    this.serverStatus = buf.readInt();
                    this.checkTransactionState(0);
                    this.serverCapabilities |= buf.readInt() << 16;
                    if ((this.serverCapabilities & 0x80000) != 0) {
                        this.authPluginDataLength = buf.readByte() & 0xFF;
                    } else {
                        buf.readByte();
                    }
                    byte[] bs = buf.getBytes(4);
                    this.orgIP = (bs[0] & 0xFF) + "." + (bs[1] & 0xFF) + "." + (bs[2] & 0xFF) + "." + (bs[3] & 0xFF);
                    this.orgPort = buf.readInt();
                    buf.setPosition(buf.getPosition() + 4);
                    String linkInfo = this.socketInfo.getLinkInfo() + " ,[orgIP:" + this.orgIP + ",orgPort:" + this.orgPort + "]" + " \n";
                    this.connection.setLinkInfo(linkInfo);
                    if ((this.serverCapabilities & 0x8000) != 0) {
                        StringBuilder newSeed;
                        String seedPart2;
                        if (this.authPluginDataLength > 0) {
                            seedPart2 = buf.readString("ASCII", this.getExceptionInterceptor(), this.authPluginDataLength - 8);
                            newSeed = new StringBuilder(this.authPluginDataLength);
                        } else {
                            seedPart2 = buf.readString("ASCII", this.getExceptionInterceptor());
                            newSeed = new StringBuilder(20);
                        }
                        newSeed.append(this.seed);
                        newSeed.append(seedPart2);
                        this.seed = newSeed.toString();
                    }
                }
                if ((this.serverCapabilities & 0x20) != 0 && this.connection.getUseCompression()) {
                    this.clientParam |= 0x20L;
                }
                boolean bl = this.useConnectWithDb = database != null && database.length() > 0 && !this.connection.getCreateDatabaseIfNotExist();
                if (this.useConnectWithDb) {
                    this.clientParam |= 8L;
                }
                if (this.versionMeetsMinimum(5, 7, 0) && !this.connection.getUseSSL() && !this.connection.isUseSSLExplicit()) {
                    this.connection.setUseSSL(false);
                    this.connection.setVerifyServerCertificate(false);
                }
                if ((this.serverCapabilities & 0x800) == 0 && this.connection.getUseSSL()) {
                    if (this.connection.getRequireSSL()) {
                        this.connection.close();
                        this.forceClose();
                        throw SQLError.createSQLException(Messages.getString("MysqlIO.15"), "08001", this.getExceptionInterceptor());
                    }
                    this.connection.setUseSSL(false);
                }
                if ((this.serverCapabilities & 4) != 0) {
                    this.clientParam |= 4L;
                    this.hasLongColumnInfo = true;
                }
                if (!this.connection.getUseAffectedRows()) {
                    this.clientParam |= 2L;
                }
                if (this.connection.getAllowLoadLocalInfile()) {
                    this.clientParam |= 0x80L;
                }
                if (this.isInteractiveClient) {
                    this.clientParam |= 0x400L;
                }
                if ((this.serverCapabilities & 0x1000000) != 0) {
                    this.clientParam |= 0x1000000L;
                }
                if ((this.serverCapabilities & 0x80000) != 0) {
                    this.proceedHandshakeWithPluggableAuthentication(user, password, database, buf);
                    break block67;
                }
                this.clientParam = this.protocolVersion > 9 ? (this.clientParam |= 1L) : (this.clientParam &= 0xFFFFFFFFFFFFFFFEL);
                if (this.versionMeetsMinimum(4, 1, 0) || this.protocolVersion > 9 && (this.serverCapabilities & 0x4000) != 0) {
                    if (!(this.versionMeetsMinimum(4, 1, 1) || this.protocolVersion > 9 && (this.serverCapabilities & 0x200) != 0)) {
                        this.clientParam |= 0x4000L;
                        this.has41NewNewProt = false;
                    } else {
                        this.clientParam |= 0x200L;
                        this.has41NewNewProt = true;
                        this.clientParam |= 0x2000L;
                        this.clientParam |= 0x20000L;
                        if (this.connection.getAllowMultiQueries()) {
                            this.clientParam |= 0x10000L;
                        }
                    }
                    this.use41Extensions = true;
                }
                int passwordLength = 16;
                userLength = user != null ? user.length() : 0;
                databaseLength = database != null ? database.length() : 0;
                int packLength = (userLength + passwordLength + databaseLength) * 3 + 7 + 4 + 33;
                Buffer packet = null;
                if (!this.connection.getUseSSL()) {
                    if ((this.serverCapabilities & 0x8000) != 0) {
                        this.clientParam |= 0x8000L;
                        if (!(this.versionMeetsMinimum(4, 1, 1) || this.protocolVersion > 9 && (this.serverCapabilities & 0x200) != 0)) {
                            this.secureAuth(null, packLength, user, password, database, true);
                        } else {
                            this.secureAuth411(null, packLength, user, password, database, true, false);
                        }
                    } else {
                        packet = new Buffer(packLength);
                        if ((this.clientParam & 0x4000L) == 0L) {
                            packet.writeInt((int)this.clientParam);
                            packet.writeLongInt(this.maxThreeBytes);
                        } else if (!(this.versionMeetsMinimum(4, 1, 1) || this.protocolVersion > 9 && (this.serverCapabilities & 0x200) != 0)) {
                            packet.writeLong(this.clientParam);
                            packet.writeLong(this.maxThreeBytes);
                        } else {
                            packet.writeLong(this.clientParam);
                            packet.writeLong(this.maxThreeBytes);
                            packet.writeByte((byte)8);
                            packet.writeBytesNoNull(new byte[23]);
                        }
                        packet.writeString(user, CODE_PAGE_1252, this.connection);
                        if (this.protocolVersion > 9) {
                            packet.writeString(Util.newCrypt(password, this.seed, this.connection.getPasswordCharacterEncoding()), CODE_PAGE_1252, this.connection);
                        } else {
                            packet.writeString(Util.oldCrypt(password, this.seed), CODE_PAGE_1252, this.connection);
                        }
                        if (this.useConnectWithDb) {
                            packet.writeString(database, CODE_PAGE_1252, this.connection);
                        }
                        this.send(packet, packet.getPosition());
                    }
                } else {
                    this.negotiateSSLConnection(user, password, database, packLength);
                    if ((this.serverCapabilities & 0x8000) != 0) {
                        if (this.versionMeetsMinimum(4, 1, 1)) {
                            this.secureAuth411(null, packLength, user, password, database, true, false);
                        } else {
                            this.secureAuth411(null, packLength, user, password, database, true, false);
                        }
                    } else {
                        packet = new Buffer(packLength);
                        if (this.use41Extensions) {
                            packet.writeLong(this.clientParam);
                            packet.writeLong(this.maxThreeBytes);
                        } else {
                            packet.writeInt((int)this.clientParam);
                            packet.writeLongInt(this.maxThreeBytes);
                        }
                        packet.writeString(user);
                        if (this.protocolVersion > 9) {
                            packet.writeString(Util.newCrypt(password, this.seed, this.connection.getPasswordCharacterEncoding()));
                        } else {
                            packet.writeString(Util.oldCrypt(password, this.seed));
                        }
                        if ((this.serverCapabilities & 8) != 0 && database != null && database.length() > 0) {
                            packet.writeString(database);
                        }
                        this.send(packet, packet.getPosition());
                    }
                }
                if (!this.versionMeetsMinimum(4, 1, 1) || this.protocolVersion <= 9 || (this.serverCapabilities & 0x200) == 0) {
                    this.checkErrorPacket();
                }
                if ((this.serverCapabilities & 0x20) != 0 && this.connection.getUseCompression() && !(this.mysqlInput instanceof CompressedInputStream)) {
                    this.deflater = new Deflater();
                    this.useCompression = true;
                    this.mysqlInput = new CompressedInputStream(this.connection, this.mysqlInput);
                }
                if (!this.useConnectWithDb) {
                    this.changeDatabaseTo(database);
                }
                try {
                    this.mysqlConnection = this.socketFactory.afterHandshake();
                }
                catch (IOException var13) {
                    throw SQLError.createCommunicationsException(this.connection, this.lastPacketSentTimeMs, this.lastPacketReceivedTimeMs, var13, this.getExceptionInterceptor());
                }
            }
            catch (SQLException var17) {
                this.printDumpStack();
                this.exceptionChecker(var17);
                throw var17;
            }
        }
    }

    private void loadAuthenticationPlugins() throws SQLException {
        block11: {
            try {
                this.clientDefaultAuthenticationPlugin = this.connection.getDefaultAuthenticationPlugin();
                if (this.clientDefaultAuthenticationPlugin != null && !"".equals(this.clientDefaultAuthenticationPlugin.trim())) {
                    String authenticationPluginClasses;
                    String disabledPlugins = this.connection.getDisabledAuthenticationPlugins();
                    if (disabledPlugins != null && !"".equals(disabledPlugins)) {
                        this.disabledAuthenticationPlugins = new ArrayList<String>();
                        List<String> pluginsToDisable = StringUtils.split(disabledPlugins, ",", true);
                        Iterator<String> iter = pluginsToDisable.iterator();
                        while (iter.hasNext()) {
                            this.disabledAuthenticationPlugins.add(iter.next());
                        }
                    }
                    this.authenticationPlugins = new HashMap<String, AuthenticationPlugin>();
                    AuthenticationPlugin plugin = new GoldendbOldPasswordPlugin();
                    plugin.init(this.connection, this.connection.getProperties());
                    boolean defaultIsFound = this.addAuthenticationPlugin(plugin);
                    plugin = new GoldendbNativePasswordPlugin();
                    plugin.init(this.connection, this.connection.getProperties());
                    if (this.addAuthenticationPlugin(plugin)) {
                        defaultIsFound = true;
                    }
                    plugin = new GoldendbClearPasswordPlugin();
                    plugin.init(this.connection, this.connection.getProperties());
                    if (this.addAuthenticationPlugin(plugin)) {
                        defaultIsFound = true;
                    }
                    plugin = new Sha256PasswordPlugin();
                    plugin.init(this.connection, this.connection.getProperties());
                    if (this.addAuthenticationPlugin(plugin)) {
                        defaultIsFound = true;
                    }
                    if ((authenticationPluginClasses = this.connection.getAuthenticationPlugins()) != null && !"".equals(authenticationPluginClasses)) {
                        List<Extension> plugins = Util.loadExtensions(this.connection, this.connection.getProperties(), authenticationPluginClasses, "Connection.BadAuthenticationPlugin", this.getExceptionInterceptor());
                        for (Extension object : plugins) {
                            plugin = (AuthenticationPlugin)object;
                            if (!this.addAuthenticationPlugin(plugin)) continue;
                            defaultIsFound = true;
                        }
                    }
                    if (!defaultIsFound) {
                        throw SQLError.createSQLException(Messages.getString("Connection.DefaultAuthenticationPluginIsNotListed", new Object[]{this.clientDefaultAuthenticationPlugin}), this.getExceptionInterceptor());
                    }
                    break block11;
                }
                throw SQLError.createSQLException(Messages.getString("Connection.BadDefaultAuthenticationPlugin", new Object[]{this.clientDefaultAuthenticationPlugin}), this.getExceptionInterceptor());
            }
            catch (SQLException var8) {
                this.printDumpStack();
                throw var8;
            }
        }
    }

    private boolean addAuthenticationPlugin(AuthenticationPlugin plugin) throws SQLException {
        boolean disabledByMechanism;
        boolean isDefault = false;
        String pluginClassName = plugin.getClass().getName();
        String pluginProtocolName = plugin.getProtocolPluginName();
        boolean disabledByClassName = this.disabledAuthenticationPlugins != null && this.disabledAuthenticationPlugins.contains(pluginClassName);
        boolean bl = disabledByMechanism = this.disabledAuthenticationPlugins != null && this.disabledAuthenticationPlugins.contains(pluginProtocolName);
        if (!disabledByClassName && !disabledByMechanism) {
            this.authenticationPlugins.put(pluginProtocolName, plugin);
            if (this.clientDefaultAuthenticationPlugin.equals(pluginClassName)) {
                this.clientDefaultAuthenticationPluginName = pluginProtocolName;
                isDefault = true;
            }
        } else if (this.clientDefaultAuthenticationPlugin.equals(pluginClassName)) {
            throw SQLError.createSQLException(Messages.getString("Connection.BadDisabledAuthenticationPlugin", new Object[]{disabledByClassName ? pluginClassName : pluginProtocolName}), this.getExceptionInterceptor());
        }
        return isDefault;
    }

    private AuthenticationPlugin getAuthenticationPlugin(String pluginName) throws SQLException {
        AuthenticationPlugin plugin = this.authenticationPlugins.get(pluginName);
        if (plugin != null && !plugin.isReusable()) {
            try {
                plugin = (AuthenticationPlugin)plugin.getClass().newInstance();
                plugin.init(this.connection, this.connection.getProperties());
            }
            catch (Throwable var5) {
                SQLException sqlEx = SQLError.createSQLException(Messages.getString("Connection.BadAuthenticationPlugin", new Object[]{plugin.getClass().getName()}), this.getExceptionInterceptor());
                sqlEx.initCause(var5);
                throw sqlEx;
            }
        }
        return plugin;
    }

    private void checkConfidentiality(AuthenticationPlugin plugin) throws SQLException {
        if (plugin.requiresConfidentiality() && !this.isSSLEstablished()) {
            throw SQLError.createSQLException(Messages.getString("Connection.AuthenticationPluginRequiresSSL", new Object[]{plugin.getProtocolPluginName()}), this.getExceptionInterceptor());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void proceedHandshakeWithPluggableAuthentication(String user, String password, String database, Buffer challenge) throws SQLException {
        if (this.authenticationPlugins == null) {
            this.loadAuthenticationPlugins();
        }
        boolean skipPassword = false;
        int passwordLength = 16;
        int userLength = user != null ? user.length() : 0;
        int databaseLength = database != null ? database.length() : 0;
        int packLength = (userLength + passwordLength + databaseLength) * 3 + 7 + 4 + 33;
        AuthenticationPlugin plugin = null;
        Buffer fromServer = null;
        ArrayList<Buffer> toServer = new ArrayList<Buffer>();
        boolean done = false;
        Buffer last_sent = null;
        boolean old_raw_challenge = false;
        int counter = 100;
        while (0 < counter--) {
            String enc;
            if (!done) {
                if (challenge != null) {
                    if (challenge.isOKPacket()) {
                        throw SQLError.createSQLException(Messages.getString("Connection.UnexpectedAuthenticationApproval", new Object[]{plugin.getProtocolPluginName()}), this.getExceptionInterceptor());
                    }
                    this.clientParam |= 0xAA201L;
                    if (this.connection.getAllowMultiQueries()) {
                        this.clientParam |= 0x10000L;
                    }
                    if ((this.serverCapabilities & 0x400000) != 0 && !this.connection.getDisconnectOnExpiredPasswords()) {
                        this.clientParam |= 0x400000L;
                    }
                    if ((this.serverCapabilities & 0x100000) != 0 && !NONE.equals(this.connection.getConnectionAttributes())) {
                        this.clientParam |= 0x100000L;
                    }
                    if ((this.serverCapabilities & 0x200000) != 0) {
                        this.clientParam |= 0x200000L;
                    }
                    this.has41NewNewProt = true;
                    this.use41Extensions = true;
                    if (this.connection.getUseSSL()) {
                        this.negotiateSSLConnection(user, password, database, packLength);
                    }
                    enc = null;
                    if ((this.serverCapabilities & 0x80000) != 0) {
                        enc = !this.versionMeetsMinimum(5, 5, 10) || this.versionMeetsMinimum(5, 6, 0) && !this.versionMeetsMinimum(5, 6, 2) ? challenge.readString("ASCII", this.getExceptionInterceptor(), this.authPluginDataLength) : challenge.readString("ASCII", this.getExceptionInterceptor());
                    }
                    if ((plugin = this.getAuthenticationPlugin(enc)) == null) {
                        plugin = this.getAuthenticationPlugin(this.clientDefaultAuthenticationPluginName);
                    } else if (enc.equals(Sha256PasswordPlugin.PLUGIN_NAME) && !this.isSSLEstablished() && this.connection.getServerRSAPublicKeyFile() == null && !this.connection.getAllowPublicKeyRetrieval()) {
                        plugin = this.getAuthenticationPlugin(this.clientDefaultAuthenticationPluginName);
                        skipPassword = !this.clientDefaultAuthenticationPluginName.equals(enc);
                    }
                    this.serverDefaultAuthenticationPluginName = plugin.getProtocolPluginName();
                    this.checkConfidentiality(plugin);
                    fromServer = new Buffer(StringUtils.getBytes(this.seed));
                } else {
                    plugin = this.getAuthenticationPlugin(this.serverDefaultAuthenticationPluginName == null ? this.clientDefaultAuthenticationPluginName : this.serverDefaultAuthenticationPluginName);
                    this.checkConfidentiality(plugin);
                    fromServer = new Buffer(StringUtils.getBytes(this.seed));
                }
            } else {
                challenge = this.checkErrorPacket();
                old_raw_challenge = false;
                this.packetSequence = (byte)(this.packetSequence + 1);
                this.compressedPacketSequence = (byte)(this.compressedPacketSequence + 1);
                if (plugin == null) {
                    plugin = this.getAuthenticationPlugin(this.serverDefaultAuthenticationPluginName != null ? this.serverDefaultAuthenticationPluginName : this.clientDefaultAuthenticationPluginName);
                }
                if (challenge.isOKPacket()) {
                    challenge.newReadLength();
                    challenge.newReadLength();
                    this.oldServerStatus = this.serverStatus;
                    this.serverStatus = challenge.readInt();
                    plugin.destroy();
                    break;
                }
                if (challenge.isAuthMethodSwitchRequestPacket()) {
                    skipPassword = false;
                    enc = challenge.readString("ASCII", this.getExceptionInterceptor());
                    if (!plugin.getProtocolPluginName().equals(enc)) {
                        plugin.destroy();
                        plugin = this.getAuthenticationPlugin(enc);
                        if (plugin == null) {
                            throw SQLError.createSQLException(Messages.getString("Connection.BadAuthenticationPlugin", new Object[]{enc}), this.getExceptionInterceptor());
                        }
                    } else {
                        plugin.reset();
                    }
                    this.checkConfidentiality(plugin);
                    fromServer = new Buffer(StringUtils.getBytes(challenge.readString("ASCII", this.getExceptionInterceptor())));
                } else if (this.versionMeetsMinimum(5, 5, 16)) {
                    fromServer = new Buffer(challenge.getBytes(challenge.getPosition(), challenge.getBufLength() - challenge.getPosition()));
                } else {
                    old_raw_challenge = true;
                    fromServer = new Buffer(challenge.getBytes(challenge.getPosition() - 1, challenge.getBufLength() - challenge.getPosition() + 1));
                }
            }
            try {
                plugin.setAuthenticationParameters(user, skipPassword ? null : password);
                done = plugin.nextAuthenticationStep(fromServer, toServer);
            }
            catch (SQLException var20) {
                throw SQLError.createSQLException(var20.getMessage(), var20.getSQLState(), var20, this.getExceptionInterceptor());
            }
            if (toServer.size() <= 0) continue;
            if (challenge == null) {
                enc = this.getEncodingForHandshake();
                last_sent = new Buffer(packLength + 1);
                last_sent.writeByte((byte)17);
                last_sent.writeString(user, enc, this.connection);
                if (toServer.get(0).getBufLength() < 256) {
                    last_sent.writeByte((byte)toServer.get(0).getBufLength());
                    last_sent.writeBytesNoNull(toServer.get(0).getByteBuffer(), 0, toServer.get(0).getBufLength());
                } else {
                    last_sent.writeByte((byte)0);
                }
                if (this.useConnectWithDb) {
                    last_sent.writeString(database, enc, this.connection);
                } else {
                    last_sent.writeByte((byte)0);
                }
                this.appendCharsetByteForHandshake(last_sent, enc);
                last_sent.writeByte((byte)0);
                if ((this.serverCapabilities & 0x80000) != 0) {
                    last_sent.writeString(plugin.getProtocolPluginName(), enc, this.connection);
                }
                if ((this.clientParam & 0x100000L) != 0L) {
                    this.sendConnectionAttributes(last_sent, enc, this.connection);
                    last_sent.writeByte((byte)0);
                }
                this.send(last_sent, last_sent.getPosition());
                continue;
            }
            if (challenge.isAuthMethodSwitchRequestPacket()) {
                last_sent = new Buffer(toServer.get(0).getBufLength() + 4);
                last_sent.writeBytesNoNull(toServer.get(0).getByteBuffer(), 0, toServer.get(0).getBufLength());
                this.send(last_sent, last_sent.getPosition());
                continue;
            }
            if (!challenge.isRawPacket() && !old_raw_challenge) {
                enc = this.getEncodingForHandshake();
                last_sent = new Buffer(packLength);
                last_sent.writeLong(this.clientParam);
                last_sent.writeLong(this.maxThreeBytes);
                this.appendCharsetByteForHandshake(last_sent, enc);
                last_sent.writeBytesNoNull(new byte[23]);
                last_sent.writeString(user, enc, this.connection);
                if ((this.serverCapabilities & 0x200000) != 0) {
                    last_sent.writeLenBytes(toServer.get(0).getBytes(toServer.get(0).getBufLength()));
                } else {
                    last_sent.writeByte((byte)toServer.get(0).getBufLength());
                    last_sent.writeBytesNoNull(toServer.get(0).getByteBuffer(), 0, toServer.get(0).getBufLength());
                }
                if (this.useConnectWithDb) {
                    last_sent.writeString(database, enc, this.connection);
                }
                if ((this.serverCapabilities & 0x80000) != 0) {
                    last_sent.writeString(plugin.getProtocolPluginName(), enc, this.connection);
                }
                if ((this.clientParam & 0x100000L) != 0L) {
                    this.sendConnectionAttributes(last_sent, enc, this.connection);
                }
                this.send(last_sent, last_sent.getPosition());
                continue;
            }
            for (Buffer buffer : toServer) {
                last_sent = new Buffer(buffer.getBufLength() + 4);
                last_sent.writeBytesNoNull(buffer.getByteBuffer(), 0, toServer.get(0).getBufLength());
                this.send(last_sent, last_sent.getPosition());
            }
        }
        if (counter == 0) {
            throw SQLError.createSQLException(Messages.getString("CommunicationsException.TooManyAuthenticationPluginNegotiations"), this.getExceptionInterceptor());
        }
        if ((this.serverCapabilities & 0x20) != 0 && this.connection.getUseCompression() && !(this.mysqlInput instanceof CompressedInputStream)) {
            this.deflater = new Deflater();
            this.useCompression = true;
            this.mysqlInput = new CompressedInputStream(this.connection, this.mysqlInput);
        }
        if (!this.useConnectWithDb) {
            this.changeDatabaseTo(database);
        }
        try {
            this.mysqlConnection = this.socketFactory.afterHandshake();
            return;
        }
        catch (IOException var19) {
            throw SQLError.createCommunicationsException(this.connection, this.lastPacketSentTimeMs, this.lastPacketReceivedTimeMs, var19, this.getExceptionInterceptor());
        }
    }

    private Properties getConnectionAttributesAsProperties(String atts) throws SQLException {
        Properties props = new Properties();
        if (atts != null) {
            String[] pairs;
            String[] arr$ = pairs = atts.split(",");
            int len$ = pairs.length;
            for (int itor = 0; itor < len$; ++itor) {
                String pair = arr$[itor];
                int keyEnd = pair.indexOf(":");
                if (keyEnd <= 0 || keyEnd + 1 >= pair.length()) continue;
                props.setProperty(pair.substring(0, keyEnd), pair.substring(keyEnd + 1));
            }
        }
        props.setProperty("_os", NonRegisteringDriver.OS);
        props.setProperty("_platform", NonRegisteringDriver.PLATFORM);
        props.setProperty("_client_name", "GoldenDB Connector Java");
        String _client_version = "gdb_mysql-connector-java-5.1.46.57";
        _client_version = _client_version + DriverVersion.readVersoinInfo();
        props.setProperty("_client_version", _client_version);
        if (null != this.socketInfo) {
            String clientIP = this.socketInfo.getLocalAddr();
            String clientPort = String.valueOf(this.socketInfo.getLocalPort());
            String orgclient = clientIP + ":" + clientPort;
            props.setProperty("_orgclient", orgclient);
        }
        return props;
    }

    private void sendConnectionAttributes(Buffer buf, String enc, MySQLConnection conn) throws SQLException {
        String atts = conn.getConnectionAttributes();
        Buffer lb = new Buffer(100);
        try {
            Properties props = this.getConnectionAttributesAsProperties(atts);
            for (Object key : props.keySet()) {
                lb.writeLenString((String)key, enc, conn.getServerCharset(), null, conn.parserKnowsUnicode(), conn);
                lb.writeLenString(props.getProperty((String)key), enc, conn.getServerCharset(), null, conn.parserKnowsUnicode(), conn);
            }
        }
        catch (UnsupportedEncodingException var9) {
            // empty catch block
        }
        buf.writeByte((byte)(lb.getPosition() - 4));
        buf.writeBytesNoNull(lb.getByteBuffer(), 4, lb.getBufLength() - 4);
    }

    private void changeDatabaseTo(String database) throws SQLException {
        if (database != null && database.length() != 0) {
            try {
                this.sendCommand(2, database, null, false, null, 0);
            }
            catch (Exception var3) {
                if (!this.connection.getCreateDatabaseIfNotExist()) {
                    throw SQLError.createCommunicationsException(this.connection, this.lastPacketSentTimeMs, this.lastPacketReceivedTimeMs, var3, this.getExceptionInterceptor());
                }
                this.sendCommand(3, "CREATE DATABASE IF NOT EXISTS " + database, null, false, null, 0);
                this.sendCommand(2, database, null, false, null, 0);
            }
        }
    }

    final ResultSetRow nextRow(Field[] fields, int columnCount, boolean isBinaryEncoded, int resultSetConcurrency, boolean useBufferRowIfPossible, boolean useBufferRowExplicit, boolean canReuseRowPacketForBufferRow, Buffer existingRowPacket) throws SQLException {
        try {
            if (this.useDirectRowUnpack && existingRowPacket == null && !isBinaryEncoded && !useBufferRowIfPossible && !useBufferRowExplicit) {
                return this.nextRowFast(fields, columnCount, isBinaryEncoded, resultSetConcurrency, useBufferRowIfPossible, useBufferRowExplicit, canReuseRowPacketForBufferRow);
            }
            Buffer rowPacket = null;
            if (existingRowPacket == null) {
                rowPacket = this.checkErrorPacket();
                if (!useBufferRowExplicit && useBufferRowIfPossible && rowPacket.getBufLength() > this.useBufferRowSizeThreshold) {
                    useBufferRowExplicit = true;
                }
            } else {
                rowPacket = existingRowPacket;
                this.checkErrorPacket(existingRowPacket);
            }
            if (!isBinaryEncoded) {
                rowPacket.setPosition(rowPacket.getPosition() - 1);
                if (!this.isEOFDeprecated() && rowPacket.isEOFPacket() || this.isEOFDeprecated() && rowPacket.isResultSetOKPacket()) {
                    this.readServerStatusForResultSets(rowPacket);
                    return null;
                }
                if (resultSetConcurrency == 1008 || !useBufferRowIfPossible && !useBufferRowExplicit) {
                    byte[][] rowData = new byte[columnCount][];
                    for (int i = 0; i < columnCount; ++i) {
                        rowData[i] = rowPacket.readLenByteArray(0);
                    }
                    return new ByteArrayRow(rowData, this.getExceptionInterceptor());
                }
                if (!canReuseRowPacketForBufferRow) {
                    this.reusablePacket = new Buffer(rowPacket.getBufLength());
                }
                return new BufferRow(rowPacket, fields, false, this.getExceptionInterceptor());
            }
            if (!this.isEOFDeprecated() && rowPacket.isEOFPacket() || this.isEOFDeprecated() && rowPacket.isResultSetOKPacket()) {
                rowPacket.setPosition(rowPacket.getPosition() - 1);
                this.readServerStatusForResultSets(rowPacket);
                return null;
            }
            if (resultSetConcurrency != 1008 && (useBufferRowIfPossible || useBufferRowExplicit)) {
                if (!canReuseRowPacketForBufferRow) {
                    this.reusablePacket = new Buffer(rowPacket.getBufLength());
                }
                return new BufferRow(rowPacket, fields, true, this.getExceptionInterceptor());
            }
            return this.unpackBinaryResultSetRow(fields, rowPacket, resultSetConcurrency);
        }
        catch (SQLException var12) {
            this.printDumpStack();
            throw var12;
        }
    }

    final ResultSetRow nextRowFast(Field[] fields, int columnCount, boolean isBinaryEncoded, int resultSetConcurrency, boolean useBufferRowIfPossible, boolean useBufferRowExplicit, boolean canReuseRowPacket) throws SQLException {
        try {
            int lengthRead = this.readFully(this.mysqlInput, this.packetHeaderBuf, 0, 4);
            if (lengthRead < 4) {
                this.forceClose();
                throw new RuntimeException(Messages.getString("MysqlIO.43"));
            }
            int packetLength = (this.packetHeaderBuf[0] & 0xFF) + ((this.packetHeaderBuf[1] & 0xFF) << 8) + ((this.packetHeaderBuf[2] & 0xFF) << 16);
            if (packetLength == this.maxThreeBytes) {
                this.reuseAndReadPacket(this.reusablePacket, packetLength);
                return this.nextRow(fields, columnCount, isBinaryEncoded, resultSetConcurrency, useBufferRowIfPossible, useBufferRowExplicit, canReuseRowPacket, this.reusablePacket);
            }
            if (packetLength > this.useBufferRowSizeThreshold) {
                this.reuseAndReadPacket(this.reusablePacket, packetLength);
                return this.nextRow(fields, columnCount, isBinaryEncoded, resultSetConcurrency, true, true, false, this.reusablePacket);
            }
            int remaining = packetLength;
            boolean firstTime = true;
            Object rowData = null;
            for (int i = 0; i < columnCount; ++i) {
                int sw = this.mysqlInput.read() & 0xFF;
                --remaining;
                if (firstTime) {
                    if (sw == 255) {
                        Buffer errorPacket = new Buffer(packetLength + 4);
                        errorPacket.setPosition(0);
                        errorPacket.writeByte(this.packetHeaderBuf[0]);
                        errorPacket.writeByte(this.packetHeaderBuf[1]);
                        errorPacket.writeByte(this.packetHeaderBuf[2]);
                        errorPacket.writeByte((byte)1);
                        errorPacket.writeByte((byte)sw);
                        this.readFully(this.mysqlInput, errorPacket.getByteBuffer(), 5, packetLength - 1);
                        errorPacket.setPosition(4);
                        this.checkErrorPacket(errorPacket);
                    }
                    if (sw == 254 && packetLength < 0xFFFFFF) {
                        if (this.use41Extensions) {
                            if (this.isEOFDeprecated()) {
                                remaining -= this.skipLengthEncodedInteger(this.mysqlInput);
                                remaining -= this.skipLengthEncodedInteger(this.mysqlInput);
                                this.oldServerStatus = this.serverStatus;
                                this.serverStatus = this.mysqlInput.read() & 0xFF | (this.mysqlInput.read() & 0xFF) << 8;
                                this.checkTransactionState(this.oldServerStatus);
                                remaining -= 2;
                                this.warningCount = this.mysqlInput.read() & 0xFF | (this.mysqlInput.read() & 0xFF) << 8;
                                remaining -= 2;
                                if (this.warningCount > 0) {
                                    this.hadWarnings = true;
                                }
                            } else {
                                this.warningCount = this.mysqlInput.read() & 0xFF | (this.mysqlInput.read() & 0xFF) << 8;
                                remaining -= 2;
                                if (this.warningCount > 0) {
                                    this.hadWarnings = true;
                                }
                                this.oldServerStatus = this.serverStatus;
                                this.serverStatus = this.mysqlInput.read() & 0xFF | (this.mysqlInput.read() & 0xFF) << 8;
                                this.checkTransactionState(this.oldServerStatus);
                                remaining -= 2;
                            }
                            this.setServerSlowQueryFlags();
                            if (remaining > 0) {
                                this.skipFully(this.mysqlInput, remaining);
                            }
                        }
                        return null;
                    }
                    rowData = new byte[columnCount][];
                    firstTime = false;
                }
                int len = 0;
                switch (sw) {
                    case 251: {
                        len = -1;
                        break;
                    }
                    case 252: {
                        len = this.mysqlInput.read() & 0xFF | (this.mysqlInput.read() & 0xFF) << 8;
                        remaining -= 2;
                        break;
                    }
                    case 253: {
                        len = this.mysqlInput.read() & 0xFF | (this.mysqlInput.read() & 0xFF) << 8 | (this.mysqlInput.read() & 0xFF) << 16;
                        remaining -= 3;
                        break;
                    }
                    case 254: {
                        len = (int)((long)(this.mysqlInput.read() & 0xFF) | (long)(this.mysqlInput.read() & 0xFF) << 8 | (long)(this.mysqlInput.read() & 0xFF) << 16 | (long)(this.mysqlInput.read() & 0xFF) << 24 | (long)(this.mysqlInput.read() & 0xFF) << 32 | (long)(this.mysqlInput.read() & 0xFF) << 40 | (long)(this.mysqlInput.read() & 0xFF) << 48 | (long)(this.mysqlInput.read() & 0xFF) << 56);
                        remaining -= 8;
                        break;
                    }
                    default: {
                        len = sw;
                    }
                }
                if (len == -1) {
                    rowData[i] = null;
                    continue;
                }
                if (len == 0) {
                    rowData[i] = Constants.EMPTY_BYTE_ARRAY;
                    continue;
                }
                rowData[i] = new byte[len];
                int bytesRead = this.readFully(this.mysqlInput, rowData[i], 0, len);
                if (bytesRead != len) {
                    throw SQLError.createCommunicationsException(this.connection, this.lastPacketSentTimeMs, this.lastPacketReceivedTimeMs, new IOException(Messages.getString("MysqlIO.43")), this.getExceptionInterceptor());
                }
                remaining -= bytesRead;
            }
            if (remaining > 0) {
                this.skipFully(this.mysqlInput, remaining);
            }
            return new ByteArrayRow((byte[][])rowData, this.getExceptionInterceptor());
        }
        catch (IOException var17) {
            this.printDumpStack();
            throw SQLError.createCommunicationsException(this.connection, this.lastPacketSentTimeMs, this.lastPacketReceivedTimeMs, var17, this.getExceptionInterceptor());
        }
        catch (SQLException var18) {
            this.printDumpStack();
            this.exceptionChecker(var18);
            throw var18;
        }
    }

    final void quit() throws SQLException {
        try {
            try {
                try {
                    if (!this.mysqlConnection.isClosed()) {
                        try {
                            this.mysqlConnection.shutdownInput();
                        }
                        catch (UnsupportedOperationException var8) {}
                    }
                }
                catch (IOException var9) {
                    this.connection.getLog().logWarn("Caught while disconnecting...", var9);
                }
                Buffer packet = new Buffer(6);
                this.packetSequence = (byte)-1;
                this.compressedPacketSequence = (byte)-1;
                packet.writeByte((byte)1);
                this.send(packet, packet.getPosition());
            }
            catch (SQLException var10) {
                this.printDumpStack();
                throw var10;
            }
            Object var3_5 = null;
            this.forceClose();
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this.forceClose();
            throw throwable;
        }
    }

    public Buffer getSharedSendPacket() {
        if (this.sharedSendPacket == null) {
            this.sharedSendPacket = new Buffer(51200);
        }
        return this.sharedSendPacket;
    }

    void closeStreamer(RowData streamer) throws SQLException {
        try {
            if (this.streamingData == null) {
                throw SQLError.createSQLException(Messages.getString("MysqlIO.17") + streamer + Messages.getString("MysqlIO.18"), this.getExceptionInterceptor());
            }
            if (streamer != this.streamingData) {
                throw SQLError.createSQLException(Messages.getString("MysqlIO.19") + streamer + Messages.getString("MysqlIO.20") + Messages.getString("MysqlIO.21") + Messages.getString("MysqlIO.22"), this.getExceptionInterceptor());
            }
            this.streamingData = null;
        }
        catch (SQLException var3) {
            this.printDumpStack();
            throw var3;
        }
    }

    boolean tackOnMoreStreamingResults(ResultSetImpl addingTo) throws SQLException {
        try {
            if ((this.serverStatus & 8) == 0) {
                return false;
            }
            boolean moreRowSetsExist = true;
            ResultSetImpl currentResultSet = addingTo;
            boolean firstTime = true;
            while (moreRowSetsExist && (firstTime || !currentResultSet.reallyResult())) {
                firstTime = false;
                Buffer fieldPacket = this.checkErrorPacket();
                fieldPacket.setPosition(0);
                Statement owningStatement = addingTo.getStatement();
                int maxRows = owningStatement.getMaxRows();
                ResultSetImpl newResultSet = this.readResultsForQueryOrUpdate((StatementImpl)owningStatement, maxRows, owningStatement.getResultSetType(), owningStatement.getResultSetConcurrency(), true, owningStatement.getConnection().getCatalog(), fieldPacket, addingTo.isBinaryEncoded, -1L, null);
                currentResultSet.setNextResultSet(newResultSet);
                currentResultSet = newResultSet;
                boolean bl = moreRowSetsExist = (this.serverStatus & 8) != 0;
                if (newResultSet.reallyResult() || moreRowSetsExist) continue;
                return false;
            }
            return true;
        }
        catch (SQLException var9) {
            this.printDumpStack();
            throw var9;
        }
    }

    public ResultSetImpl readAllResults(StatementImpl callingStatement, int maxRows, int resultSetType, int resultSetConcurrency, boolean streamResults, String catalog, Buffer resultPacket, boolean isBinaryEncoded, long preSentColumnCount, Field[] metadataFromCache) throws SQLException {
        int lineNumber = 1;
        try {
            boolean moreRowSetsExist;
            boolean serverHasMoreResults;
            ResultSetImpl topLevelResultSet;
            resultPacket.setPosition(resultPacket.getPosition() - 1);
            ResultSetImpl currentResultSet = topLevelResultSet = this.readResultsForQueryOrUpdate(callingStatement, maxRows, resultSetType, resultSetConcurrency, streamResults, catalog, resultPacket, isBinaryEncoded, preSentColumnCount, metadataFromCache);
            boolean checkForMoreResults = (this.clientParam & 0x20000L) != 0L;
            boolean bl = serverHasMoreResults = (this.serverStatus & 8) != 0;
            if (serverHasMoreResults && streamResults) {
                if (topLevelResultSet.getUpdateCount() != -1L) {
                    this.tackOnMoreStreamingResults(topLevelResultSet);
                }
                this.reclaimLargeReusablePacket();
                return topLevelResultSet;
            }
            boolean bl2 = moreRowSetsExist = checkForMoreResults && serverHasMoreResults;
            while (moreRowSetsExist) {
                ++lineNumber;
                Buffer fieldPacket = this.checkErrorPacket();
                fieldPacket.setPosition(0);
                ResultSetImpl newResultSet = this.readResultsForQueryOrUpdate(callingStatement, maxRows, resultSetType, resultSetConcurrency, streamResults, catalog, fieldPacket, isBinaryEncoded, preSentColumnCount, metadataFromCache);
                currentResultSet.setNextResultSet(newResultSet);
                currentResultSet = newResultSet;
                moreRowSetsExist = (this.serverStatus & 8) != 0;
            }
            if (!streamResults) {
                this.clearInputStream();
            }
            this.reclaimLargeReusablePacket();
            return topLevelResultSet;
        }
        catch (SQLException var19) {
            try {
                if (this.batchExecuteWithErrorNumber && lineNumber > 1) {
                    callingStatement.batchUpdateErrorNumber = lineNumber;
                }
            }
            catch (Exception ex) {
                System.out.println("batch exception line number count exception:" + ex.toString());
            }
            this.printDumpStack();
            throw var19;
        }
    }

    void resetMaxBuf() {
        this.maxAllowedPacket = this.connection.getMaxAllowedPacket();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Buffer sendCommand(int command, String extraData, Buffer queryPacket, boolean skipCheck, String extraDataCharEncoding, int timeoutMillis) throws SQLException {
        try {
            Buffer var9;
            ++this.commandCount;
            this.enablePacketDebug = this.connection.getEnablePacketDebug();
            this.readPacketSequence = 0;
            int oldTimeout = 0;
            if (timeoutMillis != 0) {
                try {
                    oldTimeout = this.mysqlConnection.getSoTimeout();
                    this.mysqlConnection.setSoTimeout(timeoutMillis);
                }
                catch (SocketException var23) {
                    throw SQLError.createCommunicationsException(this.connection, this.lastPacketSentTimeMs, this.lastPacketReceivedTimeMs, var23, this.getExceptionInterceptor());
                }
            }
            try {
                try {
                    int packLength;
                    this.checkForOutstandingStreamingData();
                    this.oldServerStatus = this.serverStatus;
                    this.serverStatus = 0;
                    this.hadWarnings = false;
                    this.warningCount = 0;
                    this.queryNoIndexUsed = false;
                    this.queryBadIndexUsed = false;
                    this.serverQueryWasSlow = false;
                    if (this.useCompression && (packLength = this.mysqlInput.available()) > 0) {
                        this.mysqlInput.skip(packLength);
                    }
                    try {
                        this.clearInputStream();
                        if (queryPacket == null) {
                            packLength = 8 + (extraData != null ? extraData.length() : 0) + 2;
                            if (this.sendPacket == null) {
                                this.sendPacket = new Buffer(packLength);
                            }
                            this.packetSequence = (byte)-1;
                            this.compressedPacketSequence = (byte)-1;
                            this.readPacketSequence = 0;
                            this.checkPacketSequence = true;
                            this.sendPacket.clear();
                            this.sendPacket.writeByte((byte)command);
                            if (command == 2 || command == 3 || command == 22 || command == 34) {
                                if (extraDataCharEncoding == null) {
                                    this.sendPacket.writeStringNoNull(extraData);
                                } else {
                                    this.sendPacket.writeStringNoNull(extraData, extraDataCharEncoding, this.connection.getServerCharset(), this.connection.parserKnowsUnicode(), this.connection);
                                }
                            }
                            this.send(this.sendPacket, this.sendPacket.getPosition());
                        } else {
                            this.packetSequence = (byte)-1;
                            this.compressedPacketSequence = (byte)-1;
                            this.send(queryPacket, queryPacket.getPosition());
                        }
                    }
                    catch (SQLException var24) {
                        this.exceptionChecker(var24);
                        throw var24;
                    }
                    catch (Exception var25) {
                        throw SQLError.createCommunicationsException(this.connection, this.lastPacketSentTimeMs, this.lastPacketReceivedTimeMs, var25, this.getExceptionInterceptor());
                    }
                    Buffer returnPacket = null;
                    if (!skipCheck) {
                        if (command == 23 || command == 26) {
                            this.readPacketSequence = 0;
                            this.packetSequenceReset = true;
                        }
                        if (command == 33) {
                            this.readPacketSequence = 0;
                            this.packetSequenceReset = true;
                        }
                        returnPacket = this.checkErrorPacket(command);
                    }
                    var9 = returnPacket;
                }
                catch (IOException var26) {
                    this.preserveOldTransactionState();
                    throw SQLError.createCommunicationsException(this.connection, this.lastPacketSentTimeMs, this.lastPacketReceivedTimeMs, var26, this.getExceptionInterceptor());
                }
                catch (SQLException var27) {
                    this.preserveOldTransactionState();
                    this.exceptionChecker(var27);
                    throw var27;
                }
                Object var12_17 = null;
                if (timeoutMillis == 0) return var9;
            }
            catch (Throwable throwable) {
                Object var12_18 = null;
                if (timeoutMillis == 0) throw throwable;
                try {
                    this.mysqlConnection.setSoTimeout(oldTimeout);
                    throw throwable;
                }
                catch (SocketException var22) {
                    throw SQLError.createCommunicationsException(this.connection, this.lastPacketSentTimeMs, this.lastPacketReceivedTimeMs, var22, this.getExceptionInterceptor());
                }
            }
            try {}
            catch (SocketException var22) {
                throw SQLError.createCommunicationsException(this.connection, this.lastPacketSentTimeMs, this.lastPacketReceivedTimeMs, var22, this.getExceptionInterceptor());
            }
            this.mysqlConnection.setSoTimeout(oldTimeout);
            return var9;
        }
        catch (SQLException var29) {
            if (var29.getErrorCode() == 1295) throw var29;
            this.printDumpStack();
            this.exceptionChecker(var29);
            throw var29;
        }
    }

    public boolean shouldIntercept() {
        return this.statementInterceptors != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ResultSetInternalMethods sqlQueryDirect(StatementImpl callingStatement, String query, String characterEncoding, Buffer queryPacket, int maxRows, int resultSetType, int resultSetConcurrency, boolean streamResults, String catalog, Field[] cachedMetadata) throws Exception {
        ResultSetImpl var52;
        block47: {
            ResultSetInternalMethods var12;
            ResultSetInternalMethods interceptedResults;
            ++this.statementExecutionDepth;
            if (this.statementInterceptors == null || (interceptedResults = this.invokeStatementInterceptorsPre(query, callingStatement, false)) == null) break block47;
            ResultSetInternalMethods resultSetInternalMethods = var12 = interceptedResults;
            Object var32_20 = null;
            --this.statementExecutionDepth;
            return resultSetInternalMethods;
        }
        try {
            try {
                ResultSetInternalMethods interceptedResults;
                long queryStartTime = 0L;
                long queryEndTime = 0L;
                String statementComment = this.connection.getStatementComment();
                if (this.connection.getIncludeThreadNamesAsStatementComment()) {
                    statementComment = (statementComment != null ? statementComment + ", " : "") + "java thread: " + Thread.currentThread().getName();
                }
                if (query != null) {
                    int packLength = 5 + query.length() * 3 + 2;
                    byte[] commentAsBytes = null;
                    if (statementComment != null) {
                        commentAsBytes = StringUtils.getBytes(statementComment, (SingleByteCharsetConverter)null, characterEncoding, this.connection.getServerCharset(), this.connection.parserKnowsUnicode(), this.getExceptionInterceptor());
                        packLength += commentAsBytes.length;
                        packLength += 6;
                    }
                    if (this.sendPacket == null) {
                        this.sendPacket = new Buffer(packLength);
                    } else {
                        this.sendPacket.clear();
                    }
                    this.sendPacket.writeByte((byte)3);
                    if (commentAsBytes != null) {
                        this.sendPacket.writeBytesNoNull(Constants.SLASH_STAR_SPACE_AS_BYTES);
                        this.sendPacket.writeBytesNoNull(commentAsBytes);
                        this.sendPacket.writeBytesNoNull(Constants.SPACE_STAR_SLASH_SPACE_AS_BYTES);
                    }
                    if (characterEncoding != null) {
                        if (this.platformDbCharsetMatches) {
                            this.sendPacket.writeStringNoNull(query, characterEncoding, this.connection.getServerCharset(), this.connection.parserKnowsUnicode(), this.connection);
                        } else if (StringUtils.startsWithIgnoreCaseAndWs(query, "LOAD DATA")) {
                            this.sendPacket.writeBytesNoNull(StringUtils.getBytes(query));
                        } else {
                            this.sendPacket.writeStringNoNull(query, characterEncoding, this.connection.getServerCharset(), this.connection.parserKnowsUnicode(), this.connection);
                        }
                    } else {
                        this.sendPacket.writeStringNoNull(query);
                    }
                    queryPacket = this.sendPacket;
                }
                byte[] queryBuf = null;
                int oldPacketPosition = 0;
                if (this.needToGrabQueryFromPacket) {
                    queryBuf = queryPacket.getByteBuffer();
                    oldPacketPosition = queryPacket.getPosition();
                    queryStartTime = this.getCurrentTimeNanosOrMillis();
                }
                if (this.autoGenerateTestcaseScript) {
                    String testcaseQuery = null;
                    testcaseQuery = query != null ? (statementComment != null ? "/* " + statementComment + " */ " + query : query) : StringUtils.toString(queryBuf, 5, oldPacketPosition - 5);
                    StringBuilder debugBuf = new StringBuilder(testcaseQuery.length() + 32);
                    this.connection.generateConnectionCommentBlock(debugBuf);
                    debugBuf.append(testcaseQuery);
                    debugBuf.append(';');
                    this.connection.dumpTestcaseQuery(debugBuf.toString());
                }
                Buffer resultPacket = this.sendCommand(3, null, queryPacket, false, null, 0);
                long fetchBeginTime = 0L;
                long fetchEndTime = 0L;
                String profileQueryToLog = null;
                boolean queryWasSlow = false;
                if (this.profileSql || this.logSlowQueries) {
                    queryEndTime = this.getCurrentTimeNanosOrMillis();
                    boolean shouldExtractQuery = false;
                    if (this.profileSql) {
                        shouldExtractQuery = true;
                    } else if (this.logSlowQueries) {
                        long queryTime = queryEndTime - queryStartTime;
                        boolean logSlow = false;
                        if (!this.useAutoSlowLog) {
                            logSlow = queryTime > (long)this.connection.getSlowQueryThresholdMillis();
                        } else {
                            logSlow = this.connection.isAbonormallyLongQuery(queryTime);
                            this.connection.reportQueryTime(queryTime);
                        }
                        if (logSlow) {
                            shouldExtractQuery = true;
                            queryWasSlow = true;
                        }
                    }
                    if (shouldExtractQuery) {
                        boolean truncated = false;
                        int extractPosition = oldPacketPosition;
                        if (oldPacketPosition > this.connection.getMaxQuerySizeToLog()) {
                            extractPosition = this.connection.getMaxQuerySizeToLog() + 5;
                            truncated = true;
                        }
                        profileQueryToLog = StringUtils.toString(queryBuf, 5, extractPosition - 5);
                        if (truncated) {
                            profileQueryToLog = profileQueryToLog + Messages.getString("MysqlIO.25");
                        }
                    }
                    fetchBeginTime = queryEndTime;
                }
                ResultSetInternalMethods rs = this.readAllResults(callingStatement, maxRows, resultSetType, resultSetConcurrency, streamResults, catalog, resultPacket, false, -1L, cachedMetadata);
                if (queryWasSlow && !this.serverQueryWasSlow) {
                    StringBuilder mesgBuf = new StringBuilder(48 + profileQueryToLog.length());
                    mesgBuf.append(Messages.getString("MysqlIO.SlowQuery", new Object[]{String.valueOf(this.useAutoSlowLog ? " 95% of all queries " : Long.valueOf(this.slowQueryThreshold)), this.queryTimingUnits, queryEndTime - queryStartTime}));
                    mesgBuf.append(profileQueryToLog);
                    ProfilerEventHandler eventSink = ProfilerEventHandlerFactory.getInstance(this.connection);
                    eventSink.consumeEvent(new ProfilerEvent(6, "", catalog, this.connection.getId(), callingStatement != null ? callingStatement.getId() : 999, rs.resultId, System.currentTimeMillis(), (int)(queryEndTime - queryStartTime), this.queryTimingUnits, null, LogUtils.findCallingClassAndMethod(new Throwable()), mesgBuf.toString()));
                    if (this.connection.getExplainSlowQueries()) {
                        if (oldPacketPosition < 0x100000) {
                            this.explainSlowQuery(queryPacket.getBytes(5, oldPacketPosition - 5), profileQueryToLog);
                        } else {
                            this.connection.getLog().logWarn(Messages.getString("MysqlIO.28") + 0x100000 + Messages.getString("MysqlIO.29"));
                        }
                    }
                }
                if (this.logSlowQueries) {
                    ProfilerEventHandler eventSink = ProfilerEventHandlerFactory.getInstance(this.connection);
                    if (this.queryBadIndexUsed && this.profileSql) {
                        eventSink.consumeEvent(new ProfilerEvent(6, "", catalog, this.connection.getId(), callingStatement != null ? callingStatement.getId() : 999, rs.resultId, System.currentTimeMillis(), queryEndTime - queryStartTime, this.queryTimingUnits, null, LogUtils.findCallingClassAndMethod(new Throwable()), Messages.getString("MysqlIO.33") + profileQueryToLog));
                    }
                    if (this.queryNoIndexUsed && this.profileSql) {
                        eventSink.consumeEvent(new ProfilerEvent(6, "", catalog, this.connection.getId(), callingStatement != null ? callingStatement.getId() : 999, rs.resultId, System.currentTimeMillis(), queryEndTime - queryStartTime, this.queryTimingUnits, null, LogUtils.findCallingClassAndMethod(new Throwable()), Messages.getString("MysqlIO.35") + profileQueryToLog));
                    }
                    if (this.serverQueryWasSlow && this.profileSql) {
                        eventSink.consumeEvent(new ProfilerEvent(6, "", catalog, this.connection.getId(), callingStatement != null ? callingStatement.getId() : 999, rs.resultId, System.currentTimeMillis(), queryEndTime - queryStartTime, this.queryTimingUnits, null, LogUtils.findCallingClassAndMethod(new Throwable()), Messages.getString("MysqlIO.ServerSlowQuery") + profileQueryToLog));
                    }
                }
                if (this.profileSql) {
                    fetchEndTime = this.getCurrentTimeNanosOrMillis();
                    ProfilerEventHandler eventSink = ProfilerEventHandlerFactory.getInstance(this.connection);
                    eventSink.consumeEvent(new ProfilerEvent(3, "", catalog, this.connection.getId(), callingStatement != null ? callingStatement.getId() : 999, rs.resultId, System.currentTimeMillis(), queryEndTime - queryStartTime, this.queryTimingUnits, null, LogUtils.findCallingClassAndMethod(new Throwable()), profileQueryToLog));
                    eventSink.consumeEvent(new ProfilerEvent(5, "", catalog, this.connection.getId(), callingStatement != null ? callingStatement.getId() : 999, rs.resultId, System.currentTimeMillis(), fetchEndTime - fetchBeginTime, this.queryTimingUnits, null, LogUtils.findCallingClassAndMethod(new Throwable()), null));
                }
                if (this.hadWarnings) {
                    this.scanForAndThrowDataTruncation();
                }
                if (this.statementInterceptors != null && (interceptedResults = this.invokeStatementInterceptorsPost(query, callingStatement, rs, false, null)) != null) {
                    rs = interceptedResults;
                }
                this.parseUse(query);
                var52 = rs;
            }
            catch (SQLException var37) {
                this.printDumpStack();
                if (this.statementInterceptors != null) {
                    this.invokeStatementInterceptorsPost(query, callingStatement, null, false, var37);
                }
                if (callingStatement != null) {
                    Object object = callingStatement.cancelTimeoutMutex;
                    synchronized (object) {
                        if (callingStatement.wasCancelled) {
                            SQLException cause = null;
                            cause = callingStatement.wasCancelledByTimeout ? new GoldenDBTimeoutException() : new GoldenDBStatementCancelledException();
                            callingStatement.resetCancelledState();
                            throw cause;
                        }
                    }
                }
                throw var37;
            }
            catch (Exception var38) {
                this.printDumpStack();
                throw var38;
            }
            Object var32_21 = null;
            --this.statementExecutionDepth;
        }
        catch (Throwable throwable) {
            Object var32_22 = null;
            --this.statementExecutionDepth;
            throw throwable;
        }
        return var52;
    }

    public ResultSetInternalMethods invokeStatementInterceptorsPre(String sql, Statement interceptedStatement, boolean forceExecute) throws SQLException {
        ResultSetInternalMethods previousResultSet = null;
        try {
            int s = this.statementInterceptors.size();
            for (int i = 0; i < s; ++i) {
                ResultSetInternalMethods interceptedResultSet;
                boolean shouldExecute;
                StatementInterceptorV2 interceptor = this.statementInterceptors.get(i);
                boolean executeTopLevelOnly = interceptor.executeTopLevelOnly();
                boolean bl = shouldExecute = executeTopLevelOnly && (this.statementExecutionDepth == 1 || forceExecute) || !executeTopLevelOnly;
                if (!shouldExecute || (interceptedResultSet = interceptor.preProcess(sql, interceptedStatement, this.connection)) == null) continue;
                previousResultSet = interceptedResultSet;
            }
            return previousResultSet;
        }
        catch (SQLException var12) {
            this.printDumpStack();
            throw var12;
        }
    }

    public ResultSetInternalMethods invokeStatementInterceptorsPost(String sql, Statement interceptedStatement, ResultSetInternalMethods originalResultSet, boolean forceExecute, SQLException statementException) throws SQLException {
        try {
            int s = this.statementInterceptors.size();
            for (int i = 0; i < s; ++i) {
                ResultSetInternalMethods interceptedResultSet;
                boolean shouldExecute;
                StatementInterceptorV2 interceptor = this.statementInterceptors.get(i);
                boolean executeTopLevelOnly = interceptor.executeTopLevelOnly();
                boolean bl = shouldExecute = executeTopLevelOnly && (this.statementExecutionDepth == 1 || forceExecute) || !executeTopLevelOnly;
                if (!shouldExecute || (interceptedResultSet = interceptor.postProcess(sql, interceptedStatement, originalResultSet, this.connection, this.warningCount, this.queryNoIndexUsed, this.queryBadIndexUsed, statementException)) == null) continue;
                originalResultSet = interceptedResultSet;
            }
            return originalResultSet;
        }
        catch (SQLException var13) {
            this.printDumpStack();
            throw var13;
        }
    }

    private void calculateSlowQueryThreshold() {
        this.slowQueryThreshold = this.connection.getSlowQueryThresholdMillis();
        if (this.connection.getUseNanosForElapsedTime()) {
            long nanosThreshold = this.connection.getSlowQueryThresholdNanos();
            this.slowQueryThreshold = nanosThreshold != 0L ? nanosThreshold : (this.slowQueryThreshold *= 1000000L);
        }
    }

    public long getCurrentTimeNanosOrMillis() {
        return this.useNanosForElapsedTime ? TimeUtil.getCurrentTimeNanosOrMillis() : System.currentTimeMillis();
    }

    String getHost() {
        return this.host;
    }

    public boolean isVersion(int major, int minor, int subminor) {
        return major == this.getServerMajorVersion() && minor == this.getServerMinorVersion() && subminor == this.getServerSubMinorVersion();
    }

    public boolean versionMeetsMinimum(int major, int minor, int subminor) {
        if (this.getServerMajorVersion() >= major) {
            if (this.getServerMajorVersion() == major) {
                if (this.getServerMinorVersion() >= minor) {
                    if (this.getServerMinorVersion() == minor) {
                        return this.getServerSubMinorVersion() >= subminor;
                    }
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private static final String getPacketDumpToLog(Buffer packetToDump, int packetLength) {
        if (packetLength < 1024) {
            return packetToDump.dump(packetLength);
        }
        StringBuilder packetDumpBuf = new StringBuilder(4096);
        packetDumpBuf.append(packetToDump.dump(1024));
        packetDumpBuf.append(Messages.getString("MysqlIO.36"));
        packetDumpBuf.append(1024);
        packetDumpBuf.append(Messages.getString("MysqlIO.37"));
        return packetDumpBuf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int readFully(InputStream in, byte[] b, int off, int len) throws IOException {
        int count;
        try {
            int n;
            if (len < 0) {
                throw new IndexOutOfBoundsException();
            }
            for (n = 0; n < len; n += count) {
                count = in.read(b, off + n, len - n);
                if (count >= 0) continue;
                throw new EOFException(Messages.getString("MysqlIO.EOF", new Object[]{len, n}));
            }
            count = n;
            Object var8_7 = null;
            if (null == b) {
                b = "".getBytes();
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (null == b) {
                b = "".getBytes();
            }
            int infoLength = this.connection.getDumpInfoLength();
            String msg = "";
            msg = len > infoLength ? msg + "<readFully>,off:" + off + ",len:" + infoLength : msg + "<readFully>,off:" + off + ",len:" + len;
            this.recordDump(new Buffer(b), false, off, len, msg);
            throw throwable;
        }
        int infoLength = this.connection.getDumpInfoLength();
        String msg = "";
        msg = len > infoLength ? msg + "<readFully>,off:" + off + ",len:" + infoLength : msg + "<readFully>,off:" + off + ",len:" + len;
        this.recordDump(new Buffer(b), false, off, len, msg);
        return count;
    }

    private final long skipFully(InputStream in, long len) throws IOException {
        long n;
        long count;
        if (len < 0L) {
            throw new IOException("Negative skip length not allowed");
        }
        for (n = 0L; n < len; n += count) {
            count = in.skip(len - n);
            if (count >= 0L) continue;
            throw new EOFException(Messages.getString("MysqlIO.EOF", new Object[]{len, n}));
        }
        return n;
    }

    private final int skipLengthEncodedInteger(InputStream in) throws IOException {
        int sw = in.read() & 0xFF;
        switch (sw) {
            case 252: {
                return (int)this.skipFully(in, 2L) + 1;
            }
            case 253: {
                return (int)this.skipFully(in, 3L) + 1;
            }
            case 254: {
                return (int)this.skipFully(in, 8L) + 1;
            }
        }
        return 1;
    }

    protected final ResultSetImpl readResultsForQueryOrUpdate(StatementImpl callingStatement, int maxRows, int resultSetType, int resultSetConcurrency, boolean streamResults, String catalog, Buffer resultPacket, boolean isBinaryEncoded, long preSentColumnCount, Field[] metadataFromCache) throws SQLException {
        long columnCount = resultPacket.readFieldLength();
        if (columnCount == 0L) {
            return this.buildResultSetWithUpdates(callingStatement, resultPacket);
        }
        if (columnCount == -1L) {
            String charEncoding = null;
            if (this.connection.getUseUnicode()) {
                charEncoding = this.connection.getEncoding();
            }
            String fileName = null;
            fileName = this.platformDbCharsetMatches ? (charEncoding != null ? resultPacket.readString(charEncoding, this.getExceptionInterceptor()) : resultPacket.readString()) : resultPacket.readString();
            return this.sendFileToServer(callingStatement, fileName);
        }
        ResultSetImpl results = this.getResultSet(callingStatement, columnCount, maxRows, resultSetType, resultSetConcurrency, streamResults, catalog, isBinaryEncoded, metadataFromCache);
        return results;
    }

    private int alignPacketSize(int a, int l) {
        return a + l - 1 & ~(l - 1);
    }

    private ResultSetImpl buildResultSetWithRows(StatementImpl callingStatement, String catalog, Field[] fields, RowData rows, int resultSetType, int resultSetConcurrency, boolean isBinaryEncoded) throws SQLException {
        ResultSetImpl rs = null;
        switch (resultSetConcurrency) {
            case 1007: {
                rs = ResultSetImpl.getInstance(catalog, fields, rows, this.connection, callingStatement, false);
                if (!isBinaryEncoded) break;
                rs.setBinaryEncoded();
                break;
            }
            case 1008: {
                rs = ResultSetImpl.getInstance(catalog, fields, rows, this.connection, callingStatement, true);
                break;
            }
            default: {
                return ResultSetImpl.getInstance(catalog, fields, rows, this.connection, callingStatement, false);
            }
        }
        rs.setResultSetType(resultSetType);
        rs.setResultSetConcurrency(resultSetConcurrency);
        return rs;
    }

    private ResultSetImpl buildResultSetWithUpdates(StatementImpl callingStatement, Buffer resultPacket) throws SQLException {
        long updateCount = -1L;
        long updateID = -1L;
        String info = null;
        try {
            if (this.useNewUpdateCounts) {
                updateCount = resultPacket.newReadLength();
                updateID = resultPacket.newReadLength();
            } else {
                updateCount = resultPacket.readLength();
                updateID = resultPacket.readLength();
            }
            if (this.use41Extensions) {
                this.serverStatus = resultPacket.readInt();
                this.checkTransactionState(this.oldServerStatus);
                this.warningCount = resultPacket.readInt();
                if (this.warningCount > 0) {
                    this.hadWarnings = true;
                }
                resultPacket.readByte();
                this.setServerSlowQueryFlags();
            }
            if (this.connection.isReadInfoMsgEnabled()) {
                info = resultPacket.readString(this.connection.getErrorMessageEncoding(), this.getExceptionInterceptor());
            }
            if (this.batchExecuteWithErrorNumber) {
                if (info == null) {
                    info = resultPacket.readString(this.connection.getErrorMessageEncoding(), this.getExceptionInterceptor());
                }
                if (info != null && info.contains("Changed:") && info.contains("Warnings:")) {
                    try {
                        updateCount = Long.parseLong(info.substring(info.indexOf("Changed:"), info.indexOf("Warnings:")).replace("Changed:", "").trim());
                    }
                    catch (Exception e) {
                        System.out.println("parse updateCount message exception: " + e.toString());
                    }
                }
            }
        }
        catch (Exception var10) {
            SQLException sqlEx = SQLError.createSQLException(SQLError.get("S1000"), "S1000", -1, this.getExceptionInterceptor());
            sqlEx.initCause(var10);
            throw sqlEx;
        }
        ResultSetImpl updateRs = ResultSetImpl.getInstance(updateCount, updateID, this.connection, callingStatement);
        if (info != null) {
            updateRs.setServerInfo(info);
        }
        return updateRs;
    }

    private void setServerSlowQueryFlags() {
        this.queryBadIndexUsed = (this.serverStatus & 0x10) != 0;
        this.queryNoIndexUsed = (this.serverStatus & 0x20) != 0;
        this.serverQueryWasSlow = (this.serverStatus & 0x800) != 0;
    }

    private void checkForOutstandingStreamingData() throws SQLException {
        if (this.streamingData != null) {
            boolean shouldClobber = this.connection.getClobberStreamingResults();
            if (!shouldClobber) {
                throw SQLError.createSQLException(Messages.getString("MysqlIO.39") + this.streamingData + Messages.getString("MysqlIO.40") + Messages.getString("MysqlIO.41") + Messages.getString("MysqlIO.42"), this.getExceptionInterceptor());
            }
            this.streamingData.getOwner().realClose(false);
            this.clearInputStream();
        }
    }

    private Buffer compressPacket(Buffer packet, int offset, int packetLen) throws SQLException {
        int compressedLength = packetLen;
        int uncompressedLength = 0;
        byte[] compressedBytes = null;
        int offsetWrite = offset;
        if (packetLen < 50) {
            compressedBytes = packet.getByteBuffer();
        } else {
            byte[] bytesToCompress = packet.getByteBuffer();
            compressedBytes = new byte[bytesToCompress.length * 2];
            if (this.deflater == null) {
                this.deflater = new Deflater();
            }
            this.deflater.reset();
            this.deflater.setInput(bytesToCompress, offset, packetLen);
            this.deflater.finish();
            compressedLength = this.deflater.deflate(compressedBytes);
            if (compressedLength > packetLen) {
                compressedBytes = packet.getByteBuffer();
                compressedLength = packetLen;
            } else {
                uncompressedLength = packetLen;
                offsetWrite = 0;
            }
        }
        Buffer compressedPacket = new Buffer(7 + compressedLength);
        compressedPacket.setPosition(0);
        compressedPacket.writeLongInt(compressedLength);
        compressedPacket.writeByte(this.compressedPacketSequence);
        compressedPacket.writeLongInt(uncompressedLength);
        compressedPacket.writeBytesNoNull(compressedBytes, offsetWrite, compressedLength);
        return compressedPacket;
    }

    private final void readServerStatusForResultSets(Buffer rowPacket) throws SQLException {
        if (this.use41Extensions) {
            rowPacket.readByte();
            if (this.isEOFDeprecated()) {
                rowPacket.newReadLength();
                rowPacket.newReadLength();
                this.oldServerStatus = this.serverStatus;
                this.serverStatus = rowPacket.readInt();
                this.checkTransactionState(this.oldServerStatus);
                this.warningCount = rowPacket.readInt();
                if (this.warningCount > 0) {
                    this.hadWarnings = true;
                }
                rowPacket.readByte();
                if (this.connection.isReadInfoMsgEnabled()) {
                    rowPacket.readString(this.connection.getErrorMessageEncoding(), this.getExceptionInterceptor());
                }
            } else {
                this.warningCount = rowPacket.readInt();
                if (this.warningCount > 0) {
                    this.hadWarnings = true;
                }
                this.oldServerStatus = this.serverStatus;
                this.serverStatus = rowPacket.readInt();
                this.checkTransactionState(this.oldServerStatus);
            }
            this.setServerSlowQueryFlags();
        }
    }

    private SocketFactory createSocketFactory() throws SQLException {
        try {
            if (this.socketFactoryClassName == null) {
                throw SQLError.createSQLException(Messages.getString("MysqlIO.75"), "08001", this.getExceptionInterceptor());
            }
            return (SocketFactory)Class.forName(this.socketFactoryClassName).newInstance();
        }
        catch (Exception var3) {
            SQLException sqlEx = SQLError.createSQLException(Messages.getString("MysqlIO.76") + this.socketFactoryClassName + Messages.getString("MysqlIO.77"), "08001", this.getExceptionInterceptor());
            sqlEx.initCause(var3);
            throw sqlEx;
        }
    }

    private void enqueuePacketForDebugging(boolean isPacketBeingSent, boolean isPacketReused, int sendLength, byte[] header, Buffer packet) throws SQLException {
        if (this.packetDebugRingBuffer.size() + 1 > this.connection.getPacketDebugBufferSize()) {
            this.packetDebugRingBuffer.removeFirst();
        }
        StringBuilder packetDump = null;
        if (!isPacketBeingSent) {
            int bytesToDump = Math.min(1024, packet.getBufLength());
            Buffer packetToDump = new Buffer(4 + bytesToDump);
            packetToDump.setPosition(0);
            packetToDump.writeBytesNoNull(header);
            packetToDump.writeBytesNoNull(packet.getBytes(0, bytesToDump));
            String packetPayload = packetToDump.dump(bytesToDump);
            packetDump = new StringBuilder(96 + packetPayload.length());
            packetDump.append("Server ");
            packetDump.append(isPacketReused ? "(re-used) " : "(new) ");
            packetDump.append(packet.toSuperString());
            packetDump.append(" --------------------> Client\n");
            packetDump.append("\nPacket payload:\n\n");
            packetDump.append(packetPayload);
            if (bytesToDump == 1024) {
                packetDump.append("\nNote: Packet of " + packet.getBufLength() + " bytes truncated to " + 1024 + " bytes.\n");
            }
        } else {
            int bytesToDump = Math.min(1024, sendLength);
            String packetPayload = packet.dump(bytesToDump);
            packetDump = new StringBuilder(68 + packetPayload.length());
            packetDump.append("Client ");
            packetDump.append(packet.toSuperString());
            packetDump.append("--------------------> Server\n");
            packetDump.append("\nPacket payload:\n\n");
            packetDump.append(packetPayload);
            if (bytesToDump == 1024) {
                packetDump.append("\nNote: Packet of " + sendLength + " bytes truncated to " + 1024 + " bytes.\n");
            }
        }
        this.packetDebugRingBuffer.addLast(packetDump);
    }

    private RowData readSingleRowSet(long columnCount, int maxRows, int resultSetConcurrency, boolean isBinaryEncoded, Field[] fields) throws SQLException {
        ArrayList<ResultSetRow> rows = new ArrayList<ResultSetRow>();
        boolean useBufferRowExplicit = MysqlIO.useBufferRowExplicit(fields);
        ResultSetRow row = this.nextRow(fields, (int)columnCount, isBinaryEncoded, resultSetConcurrency, false, useBufferRowExplicit, false, null);
        int rowCount = 0;
        if (row != null) {
            rows.add(row);
            rowCount = 1;
        }
        while (true) {
            if (row == null) {
                RowDataStatic rowData = new RowDataStatic(rows);
                return rowData;
            }
            row = this.nextRow(fields, (int)columnCount, isBinaryEncoded, resultSetConcurrency, false, useBufferRowExplicit, false, null);
            if (row == null || maxRows != -1 && rowCount >= maxRows) continue;
            rows.add(row);
            ++rowCount;
        }
    }

    public static boolean useBufferRowExplicit(Field[] fields) {
        if (fields == null) {
            return false;
        }
        for (int i = 0; i < fields.length; ++i) {
            switch (fields[i].getSQLType()) {
                case -4: 
                case -1: 
                case 2004: 
                case 2005: {
                    return true;
                }
            }
        }
        return false;
    }

    private void reclaimLargeReusablePacket() {
        if (this.reusablePacket != null && this.reusablePacket.getCapacity() > this.connection.getReclaimBufferLength()) {
            this.reusablePacket = new Buffer(51200);
        }
    }

    private final Buffer reuseAndReadPacket(Buffer reuse) throws SQLException {
        return this.reuseAndReadPacket(reuse, -1);
    }

    private final Buffer reuseAndReadPacket(Buffer reuse, int existingPacketLength) throws SQLException {
        try {
            reuse.setWasMultiPacket(false);
            int packetLength = 0;
            if (existingPacketLength == -1) {
                int lengthRead = this.readFully(this.mysqlInput, this.packetHeaderBuf, 0, 4);
                if (lengthRead < 4) {
                    this.forceClose();
                    throw new IOException(Messages.getString("MysqlIO.43"));
                }
                packetLength = (this.packetHeaderBuf[0] & 0xFF) + ((this.packetHeaderBuf[1] & 0xFF) << 8) + ((this.packetHeaderBuf[2] & 0xFF) << 16);
            } else {
                packetLength = existingPacketLength;
            }
            if (this.traceProtocol) {
                StringBuilder traceMessageBuf = new StringBuilder();
                traceMessageBuf.append(Messages.getString("MysqlIO.44"));
                traceMessageBuf.append(packetLength);
                traceMessageBuf.append(Messages.getString("MysqlIO.45"));
                traceMessageBuf.append(StringUtils.dumpAsHex(this.packetHeaderBuf, 4));
                this.connection.getLog().logTrace(traceMessageBuf.toString());
            }
            byte multiPacketSeq = this.packetHeaderBuf[3];
            if (!this.packetSequenceReset) {
                if (this.enablePacketDebug && this.checkPacketSequence) {
                    this.checkPacketSequencing(multiPacketSeq);
                }
            } else {
                this.packetSequenceReset = false;
            }
            this.readPacketSequence = multiPacketSeq;
            reuse.setPosition(0);
            if (reuse.getByteBuffer().length <= packetLength) {
                reuse.setByteBuffer(new byte[packetLength + 1]);
            }
            reuse.setBufLength(packetLength);
            int numBytesRead = this.readFully(this.mysqlInput, reuse.getByteBuffer(), 0, packetLength);
            if (numBytesRead != packetLength) {
                throw new IOException("Short read, expected " + packetLength + " bytes, only read " + numBytesRead);
            }
            if (this.traceProtocol) {
                StringBuilder traceMessageBuf = new StringBuilder();
                traceMessageBuf.append(Messages.getString("MysqlIO.46"));
                traceMessageBuf.append(MysqlIO.getPacketDumpToLog(reuse, packetLength));
                this.connection.getLog().logTrace(traceMessageBuf.toString());
            }
            if (this.enablePacketDebug) {
                this.enqueuePacketForDebugging(false, true, 0, this.packetHeaderBuf, reuse);
            }
            boolean isMultiPacket = false;
            if (packetLength == this.maxThreeBytes) {
                reuse.setPosition(this.maxThreeBytes);
                isMultiPacket = true;
                packetLength = this.readRemainingMultiPackets(reuse, multiPacketSeq);
            }
            if (!isMultiPacket) {
                reuse.getByteBuffer()[packetLength] = 0;
            }
            if (this.connection.getMaintainTimeStats()) {
                this.lastPacketReceivedTimeMs = System.currentTimeMillis();
            }
            return reuse;
        }
        catch (SQLException var9) {
            this.printDumpStack();
            this.exceptionChecker(var9);
            throw var9;
        }
        catch (IOException var10) {
            this.printDumpStack();
            throw SQLError.createCommunicationsException(this.connection, this.lastPacketSentTimeMs, this.lastPacketReceivedTimeMs, var10, this.getExceptionInterceptor());
        }
        catch (OutOfMemoryError var11) {
            OutOfMemoryError oom = var11;
            try {
                this.clearInputStream();
            }
            catch (Exception var8) {
                // empty catch block
            }
            try {
                this.connection.realClose(false, false, true, oom);
            }
            catch (Exception var7) {
                // empty catch block
            }
            throw var11;
        }
    }

    private int readRemainingMultiPackets(Buffer reuse, byte multiPacketSeq) throws IOException, SQLException {
        int packetLength = -1;
        Buffer multiPacket = null;
        do {
            int lengthRead;
            if ((lengthRead = this.readFully(this.mysqlInput, this.packetHeaderBuf, 0, 4)) < 4) {
                this.forceClose();
                throw new IOException(Messages.getString("MysqlIO.47"));
            }
            packetLength = (this.packetHeaderBuf[0] & 0xFF) + ((this.packetHeaderBuf[1] & 0xFF) << 8) + ((this.packetHeaderBuf[2] & 0xFF) << 16);
            if (multiPacket == null) {
                multiPacket = new Buffer(packetLength);
            }
            if (!this.useNewLargePackets && packetLength == 1) {
                this.clearInputStream();
                break;
            }
            if ((multiPacketSeq = (byte)(multiPacketSeq + 1)) != this.packetHeaderBuf[3]) {
                throw new IOException(Messages.getString("MysqlIO.49"));
            }
            multiPacket.setPosition(0);
            multiPacket.setBufLength(packetLength);
            byte[] byteBuf = multiPacket.getByteBuffer();
            int bytesRead = this.readFully(this.mysqlInput, byteBuf, 0, packetLength);
            if (bytesRead != packetLength) {
                throw SQLError.createCommunicationsException(this.connection, this.lastPacketSentTimeMs, this.lastPacketReceivedTimeMs, SQLError.createSQLException(Messages.getString("MysqlIO.50") + packetLength + Messages.getString("MysqlIO.51") + bytesRead + ".", this.getExceptionInterceptor()), this.getExceptionInterceptor());
            }
            reuse.writeBytesNoNull(byteBuf, 0, packetLength);
        } while (packetLength == this.maxThreeBytes);
        reuse.setPosition(0);
        reuse.setWasMultiPacket(true);
        return packetLength;
    }

    private void checkPacketSequencing(byte multiPacketSeq) throws SQLException {
        if (multiPacketSeq == -128 && this.readPacketSequence != 127) {
            throw SQLError.createCommunicationsException(this.connection, this.lastPacketSentTimeMs, this.lastPacketReceivedTimeMs, new IOException("Packets out of order, expected packet # -128, but received packet # " + multiPacketSeq), this.getExceptionInterceptor());
        }
        if (this.readPacketSequence == -1 && multiPacketSeq != 0) {
            throw SQLError.createCommunicationsException(this.connection, this.lastPacketSentTimeMs, this.lastPacketReceivedTimeMs, new IOException("Packets out of order, expected packet # -1, but received packet # " + multiPacketSeq), this.getExceptionInterceptor());
        }
        if (multiPacketSeq != -128 && this.readPacketSequence != -1 && multiPacketSeq != this.readPacketSequence + 1) {
            throw SQLError.createCommunicationsException(this.connection, this.lastPacketSentTimeMs, this.lastPacketReceivedTimeMs, new IOException("Packets out of order, expected packet # " + (this.readPacketSequence + 1) + ", but received packet # " + multiPacketSeq), this.getExceptionInterceptor());
        }
    }

    public void enableMultiQueries() throws SQLException {
        try {
            Buffer buf = this.getSharedSendPacket();
            buf.clear();
            buf.writeByte((byte)27);
            buf.writeInt(0);
            this.sendCommand(27, null, buf, false, null, 0);
        }
        catch (SQLException var2) {
            this.printDumpStack();
            throw var2;
        }
    }

    public void disableMultiQueries() throws SQLException {
        try {
            Buffer buf = this.getSharedSendPacket();
            buf.clear();
            buf.writeByte((byte)27);
            buf.writeInt(1);
            this.sendCommand(27, null, buf, false, null, 0);
        }
        catch (SQLException var2) {
            this.printDumpStack();
            throw var2;
        }
    }

    private final void send(Buffer packet, int packetLen) throws SQLException {
        try {
            if (this.maxAllowedPacket > 0 && packetLen > this.maxAllowedPacket) {
                throw new PacketTooBigException(packetLen, this.maxAllowedPacket);
            }
            if (this.serverMajorVersion < 4 || packetLen - 4 < this.maxThreeBytes && (!this.useCompression || packetLen - 4 < this.maxThreeBytes - 3)) {
                StringBuilder traceMessageBuf;
                int infoLength;
                this.packetSequence = (byte)(this.packetSequence + 1);
                Buffer packetToSend = packet;
                packet.setPosition(0);
                packet.writeLongInt(packetLen - 4);
                packet.writeByte(this.packetSequence);
                if (this.useCompression) {
                    this.compressedPacketSequence = (byte)(this.compressedPacketSequence + 1);
                    infoLength = packetLen;
                    packetToSend = this.compressPacket(packet, 0, packetLen);
                    packetLen = packetToSend.getPosition();
                    if (this.traceProtocol) {
                        traceMessageBuf = new StringBuilder();
                        traceMessageBuf.append(Messages.getString("MysqlIO.57"));
                        traceMessageBuf.append(MysqlIO.getPacketDumpToLog(packetToSend, packetLen));
                        traceMessageBuf.append(Messages.getString("MysqlIO.58"));
                        traceMessageBuf.append(MysqlIO.getPacketDumpToLog(packet, infoLength));
                        this.connection.getLog().logTrace(traceMessageBuf.toString());
                    }
                } else if (this.traceProtocol) {
                    traceMessageBuf = new StringBuilder();
                    traceMessageBuf.append(Messages.getString("MysqlIO.59"));
                    traceMessageBuf.append("host: '");
                    traceMessageBuf.append(this.host);
                    traceMessageBuf.append("' threadId: '");
                    traceMessageBuf.append(this.threadId);
                    traceMessageBuf.append("'\n");
                    traceMessageBuf.append(packet.dump(packetLen));
                    this.connection.getLog().logTrace(traceMessageBuf.toString());
                }
                infoLength = this.connection.getDumpInfoLength();
                String msg = "";
                msg = packetLen > infoLength ? msg + "<code place 1>,len:" + infoLength : msg + "<code place 1>,len:" + packetLen;
                this.recordDump(packetToSend, true, 0, packetLen, msg);
                this.mysqlOutput.write(packetToSend.getByteBuffer(), 0, packetLen);
                this.mysqlOutput.flush();
            } else {
                this.sendSplitPackets(packet, packetLen);
            }
            if (this.enablePacketDebug) {
                this.enqueuePacketForDebugging(true, false, packetLen + 5, this.packetHeaderBuf, packet);
            }
            if (packet == this.sharedSendPacket) {
                this.reclaimLargeSharedSendPacket();
            }
            if (this.connection.getMaintainTimeStats()) {
                this.lastPacketSentTimeMs = System.currentTimeMillis();
            }
        }
        catch (IOException var6) {
            this.printDumpStack();
            throw SQLError.createCommunicationsException(this.connection, this.lastPacketSentTimeMs, this.lastPacketReceivedTimeMs, var6, this.getExceptionInterceptor());
        }
        catch (SQLException var7) {
            this.printDumpStack();
            this.exceptionChecker(var7);
            throw var7;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ResultSetImpl sendFileToServer(StatementImpl callingStatement, String fileName) throws SQLException {
        if (this.useCompression) {
            this.compressedPacketSequence = (byte)(this.compressedPacketSequence + 1);
        }
        try {
            Buffer filePacket;
            block29: {
                block26: {
                    filePacket = this.loadFileBufRef == null ? null : this.loadFileBufRef.get();
                    int bigPacketLength = Math.min(this.connection.getMaxAllowedPacket() - 12, this.alignPacketSize(this.connection.getMaxAllowedPacket() - 16, 4096) - 12);
                    int oneMeg = 0x100000;
                    int smallerPacketSizeAligned = Math.min(oneMeg - 12, this.alignPacketSize(oneMeg - 16, 4096) - 12);
                    int packetLength = Math.min(smallerPacketSizeAligned, bigPacketLength);
                    if (filePacket == null) {
                        try {
                            filePacket = new Buffer(packetLength + 4);
                            this.loadFileBufRef = new SoftReference<Buffer>(filePacket);
                        }
                        catch (OutOfMemoryError var25) {
                            throw SQLError.createSQLException("Could not allocate packet of " + packetLength + " bytes required for LOAD DATA LOCAL INFILE operation." + " Try increasing max heap allocation for JVM or decreasing server variable 'max_allowed_packet'", "S1001", this.getExceptionInterceptor());
                        }
                    }
                    filePacket.clear();
                    this.send(filePacket, 0);
                    byte[] fileBuf = new byte[packetLength];
                    BufferedInputStream fileIn = null;
                    try {
                        try {
                            int bytesRead;
                            if (!this.connection.getAllowLoadLocalInfile()) {
                                throw SQLError.createSQLException(Messages.getString("MysqlIO.LoadDataLocalNotAllowed"), "S1000", this.getExceptionInterceptor());
                            }
                            InputStream hookedStream = null;
                            if (callingStatement != null) {
                                hookedStream = callingStatement.getLocalInfileInputStream();
                            }
                            if (hookedStream != null) {
                                fileIn = new BufferedInputStream(hookedStream);
                            } else if (!this.connection.getAllowUrlInLocalInfile()) {
                                fileIn = new BufferedInputStream(new FileInputStream(fileName));
                            } else if (fileName.indexOf(58) != -1) {
                                try {
                                    URL urlFromFileName = new URL(fileName);
                                    fileIn = new BufferedInputStream(urlFromFileName.openStream());
                                }
                                catch (MalformedURLException var24) {
                                    fileIn = new BufferedInputStream(new FileInputStream(fileName));
                                }
                            } else {
                                fileIn = new BufferedInputStream(new FileInputStream(fileName));
                            }
                            boolean var31 = false;
                            while ((bytesRead = fileIn.read(fileBuf)) != -1) {
                                filePacket.clear();
                                filePacket.writeBytesNoNull(fileBuf, 0, bytesRead);
                                this.send(filePacket, filePacket.getPosition());
                            }
                            Object var14_19 = null;
                            if (fileIn == null) break block26;
                        }
                        catch (IOException var26) {
                            StringBuilder messageBuf = new StringBuilder(Messages.getString("MysqlIO.60"));
                            if (fileName != null && !this.connection.getParanoid()) {
                                messageBuf.append("'");
                                messageBuf.append(fileName);
                                messageBuf.append("'");
                            }
                            messageBuf.append(Messages.getString("MysqlIO.63"));
                            if (this.connection.getParanoid()) throw SQLError.createSQLException(messageBuf.toString(), "S1009", this.getExceptionInterceptor());
                            messageBuf.append(Messages.getString("MysqlIO.64"));
                            messageBuf.append(Util.stackTraceToString(var26));
                            throw SQLError.createSQLException(messageBuf.toString(), "S1009", this.getExceptionInterceptor());
                        }
                    }
                    catch (Throwable throwable) {
                        Object var14_20 = null;
                        if (fileIn == null) {
                            filePacket.clear();
                            this.send(filePacket, filePacket.getPosition());
                            this.checkErrorPacket();
                            throw throwable;
                        }
                        try {
                            fileIn.close();
                        }
                        catch (Exception var23) {
                            SQLException sqlEx = SQLError.createSQLException(Messages.getString("MysqlIO.65"), "S1000", var23, this.getExceptionInterceptor());
                            throw sqlEx;
                        }
                        fileIn = null;
                        throw throwable;
                    }
                    try {}
                    catch (Exception var23) {
                        SQLException sqlEx = SQLError.createSQLException(Messages.getString("MysqlIO.65"), "S1000", var23, this.getExceptionInterceptor());
                        throw sqlEx;
                    }
                    fileIn.close();
                    fileIn = null;
                    break block29;
                }
                filePacket.clear();
                this.send(filePacket, filePacket.getPosition());
                this.checkErrorPacket();
            }
            filePacket.clear();
            this.send(filePacket, filePacket.getPosition());
            Buffer resultPacket = this.checkErrorPacket();
            return this.buildResultSetWithUpdates(callingStatement, resultPacket);
        }
        catch (SQLException var28) {
            this.printDumpStack();
            throw var28;
        }
    }

    private Buffer checkErrorPacket(int command) throws SQLException {
        Buffer resultPacket = null;
        this.serverStatus = 0;
        try {
            resultPacket = this.reuseAndReadPacket(this.reusablePacket);
        }
        catch (SQLException var4) {
            this.exceptionChecker(var4);
            throw var4;
        }
        catch (Exception var5) {
            throw SQLError.createCommunicationsException(this.connection, this.lastPacketSentTimeMs, this.lastPacketReceivedTimeMs, var5, this.getExceptionInterceptor());
        }
        this.checkErrorPacket(resultPacket);
        return resultPacket;
    }

    private void checkErrorPacket(Buffer resultPacket) throws SQLException {
        byte statusCode = resultPacket.readByte();
        if (statusCode == -1) {
            int errno = 2000;
            StringBuilder errorBuf = new StringBuilder();
            if (this.protocolVersion > 9) {
                String xOpen;
                errno = resultPacket.readInt();
                String serverErrorMessage = resultPacket.readString(this.connection.getErrorMessageEncoding(), this.getExceptionInterceptor());
                if (serverErrorMessage.charAt(0) == '#') {
                    if (serverErrorMessage.length() > 6) {
                        xOpen = serverErrorMessage.substring(1, 6);
                        serverErrorMessage = serverErrorMessage.substring(6);
                        if (xOpen.equals("HY000")) {
                            xOpen = SQLError.mysqlToSqlState(errno, this.connection.getUseSqlStateCodes());
                        }
                    } else {
                        xOpen = SQLError.mysqlToSqlState(errno, this.connection.getUseSqlStateCodes());
                    }
                } else {
                    xOpen = SQLError.mysqlToSqlState(errno, this.connection.getUseSqlStateCodes());
                }
                this.clearInputStream();
                String xOpenErrorMessage = SQLError.get(xOpen);
                if (!this.connection.getUseOnlyServerErrorMessages() && xOpenErrorMessage != null) {
                    errorBuf.append(xOpenErrorMessage);
                    errorBuf.append(Messages.getString("MysqlIO.68"));
                }
                errorBuf.append(serverErrorMessage);
                if (!this.connection.getUseOnlyServerErrorMessages() && xOpenErrorMessage != null) {
                    errorBuf.append("\"");
                }
                this.appendDeadlockStatusInformation(xOpen, errorBuf);
                if (xOpen != null && xOpen.startsWith("22")) {
                    throw new MysqlDataTruncation(errorBuf.toString(), 0, true, false, 0, 0, errno);
                }
                throw SQLError.createSQLException(errorBuf.toString(), xOpen, errno, false, this.getExceptionInterceptor(), this.connection);
            }
            String serverErrorMessage = resultPacket.readString(this.connection.getErrorMessageEncoding(), this.getExceptionInterceptor());
            this.clearInputStream();
            if (serverErrorMessage.indexOf(Messages.getString("MysqlIO.70")) != -1) {
                throw SQLError.createSQLException(SQLError.get("S0022") + ", " + serverErrorMessage, "S0022", -1, false, this.getExceptionInterceptor(), this.connection);
            }
            errorBuf = new StringBuilder(Messages.getString("MysqlIO.72"));
            errorBuf.append(serverErrorMessage);
            errorBuf.append("\"");
            throw SQLError.createSQLException(SQLError.get("S1000") + ", " + errorBuf.toString(), "S1000", -1, false, this.getExceptionInterceptor(), this.connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void appendDeadlockStatusInformation(String xOpen, StringBuilder errorBuf) throws SQLException {
        block19: {
            if (this.connection.getIncludeInnodbStatusInDeadlockExceptions() && xOpen != null && (xOpen.startsWith("40") || xOpen.startsWith("41")) && this.streamingData == null) {
                ResultSet rs = null;
                try {
                    Object var6_4;
                    try {
                        rs = this.sqlQueryDirect(null, "SHOW ENGINE INNODB STATUS", this.connection.getEncoding(), null, -1, 1003, 1007, false, this.connection.getCatalog(), null);
                        if (rs.next()) {
                            errorBuf.append("\n\n");
                            errorBuf.append(rs.getString("Status"));
                        } else {
                            errorBuf.append("\n\n");
                            errorBuf.append(Messages.getString("MysqlIO.NoInnoDBStatusFound"));
                        }
                    }
                    catch (Exception var14) {
                        this.printDumpStack();
                        errorBuf.append("\n\n");
                        errorBuf.append(Messages.getString("MysqlIO.InnoDBStatusFailed"));
                        errorBuf.append("\n\n");
                        errorBuf.append(Util.stackTraceToString(var14));
                        var6_4 = null;
                        if (rs != null) {
                            rs.close();
                        }
                        break block19;
                    }
                    var6_4 = null;
                    if (rs == null) break block19;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    if (rs != null) {
                        rs.close();
                    }
                    throw throwable;
                }
                rs.close();
            }
        }
        if (this.connection.getIncludeThreadDumpInDeadlockExceptions()) {
            errorBuf.append("\n\n*** Java threads running at time of deadlock ***\n\n");
            ThreadMXBean threadMBean = ManagementFactory.getThreadMXBean();
            long[] threadIds = threadMBean.getAllThreadIds();
            ThreadInfo[] threads = threadMBean.getThreadInfo(threadIds, Integer.MAX_VALUE);
            ArrayList<ThreadInfo> activeThreads = new ArrayList<ThreadInfo>();
            ThreadInfo[] arr = threads;
            int len = threads.length;
            for (int i = 0; i < len; ++i) {
                ThreadInfo info = arr[i];
                if (info == null) continue;
                activeThreads.add(info);
            }
            for (ThreadInfo threadInfo : activeThreads) {
                StackTraceElement[] stackTrace;
                errorBuf.append('\"');
                errorBuf.append(threadInfo.getThreadName());
                errorBuf.append("\" tid=");
                errorBuf.append(threadInfo.getThreadId());
                errorBuf.append(" ");
                errorBuf.append((Object)threadInfo.getThreadState());
                if (threadInfo.getLockName() != null) {
                    errorBuf.append(" on lock=" + threadInfo.getLockName());
                }
                if (threadInfo.isSuspended()) {
                    errorBuf.append(" (suspended)");
                }
                if (threadInfo.isInNative()) {
                    errorBuf.append(" (running in native)");
                }
                if ((stackTrace = threadInfo.getStackTrace()).length > 0) {
                    errorBuf.append(" in ");
                    errorBuf.append(stackTrace[0].getClassName());
                    errorBuf.append(".");
                    errorBuf.append(stackTrace[0].getMethodName());
                    errorBuf.append("()");
                }
                errorBuf.append("\n");
                if (threadInfo.getLockOwnerName() != null) {
                    errorBuf.append("\t owned by " + threadInfo.getLockOwnerName() + " Id=" + threadInfo.getLockOwnerId());
                    errorBuf.append("\n");
                }
                for (int j = 0; j < stackTrace.length; ++j) {
                    StackTraceElement ste = stackTrace[j];
                    errorBuf.append("\tat " + ste.toString());
                    errorBuf.append("\n");
                }
            }
        }
    }

    private final void sendSplitPackets(Buffer packet, int packetLen) throws SQLException {
        try {
            int len;
            Buffer toCompress;
            Buffer packetToSend = this.splitBufRef == null ? null : this.splitBufRef.get();
            Buffer buffer = toCompress = this.useCompression && this.compressBufRef != null ? this.compressBufRef.get() : null;
            if (packetToSend == null) {
                packetToSend = new Buffer(this.maxThreeBytes + 4);
                this.splitBufRef = new SoftReference<Buffer>(packetToSend);
            }
            if (this.useCompression) {
                len = packetLen + (packetLen / this.maxThreeBytes + 1) * 4;
                if (toCompress == null) {
                    toCompress = new Buffer(len);
                    this.compressBufRef = new SoftReference<Buffer>(toCompress);
                } else if (toCompress.getBufLength() < len) {
                    toCompress.setPosition(toCompress.getBufLength());
                    toCompress.ensureCapacity(len - toCompress.getBufLength());
                }
            }
            int splitSize = this.maxThreeBytes;
            int originalPacketPos = 4;
            byte[] origPacketBytes = packet.getByteBuffer();
            int toCompressPosition = 0;
            for (len = packetLen - 4; len >= 0; len -= this.maxThreeBytes) {
                this.packetSequence = (byte)(this.packetSequence + 1);
                if (len < splitSize) {
                    splitSize = len;
                }
                packetToSend.setPosition(0);
                packetToSend.writeLongInt(splitSize);
                packetToSend.writeByte(this.packetSequence);
                if (len > 0) {
                    System.arraycopy(origPacketBytes, originalPacketPos, packetToSend.getByteBuffer(), 4, splitSize);
                }
                if (this.useCompression) {
                    System.arraycopy(packetToSend.getByteBuffer(), 0, toCompress.getByteBuffer(), toCompressPosition, 4 + splitSize);
                    toCompressPosition += 4 + splitSize;
                } else {
                    int infoLength = this.connection.getDumpInfoLength();
                    String msg = "";
                    msg = splitSize > infoLength ? msg + "<code place 2, while loop>,len:4" + infoLength : msg + "<code place 2, while loop>,len:4" + splitSize;
                    this.recordDump(packetToSend, true, 0, 4 + splitSize, msg);
                    this.mysqlOutput.write(packetToSend.getByteBuffer(), 0, 4 + splitSize);
                    this.mysqlOutput.flush();
                }
                originalPacketPos += splitSize;
            }
            if (this.useCompression) {
                len = toCompressPosition;
                toCompressPosition = 0;
                splitSize = this.maxThreeBytes - 3;
                while (len >= 0) {
                    this.compressedPacketSequence = (byte)(this.compressedPacketSequence + 1);
                    if (len < splitSize) {
                        splitSize = len;
                    }
                    Buffer compressedPacketToSend = this.compressPacket(toCompress, toCompressPosition, splitSize);
                    packetLen = compressedPacketToSend.getPosition();
                    int infoLength = this.connection.getDumpInfoLength();
                    String msg = "";
                    msg = splitSize > infoLength ? msg + "<code place 3, while loop>,len:" + infoLength : msg + "<code place 3, while loop>,len:" + splitSize;
                    this.recordDump(packetToSend, true, 0, packetLen, msg);
                    this.mysqlOutput.write(compressedPacketToSend.getByteBuffer(), 0, packetLen);
                    this.mysqlOutput.flush();
                    toCompressPosition += splitSize;
                    len -= this.maxThreeBytes - 3;
                }
            }
        }
        catch (IOException var13) {
            throw SQLError.createCommunicationsException(this.connection, this.lastPacketSentTimeMs, this.lastPacketReceivedTimeMs, var13, this.getExceptionInterceptor());
        }
    }

    private void reclaimLargeSharedSendPacket() {
        if (this.sharedSendPacket != null && this.sharedSendPacket.getCapacity() > this.connection.getReclaimBufferLength()) {
            this.sharedSendPacket = new Buffer(51200);
        }
    }

    public boolean hadWarnings() {
        return this.hadWarnings;
    }

    public void scanForAndThrowDataTruncation() throws SQLException {
        try {
            if (this.streamingData == null && this.versionMeetsMinimum(4, 1, 0) && this.connection.getJdbcCompliantTruncation() && this.warningCount > 0) {
                int warningCountOld = this.warningCount;
                SQLError.convertShowWarningsToSQLWarnings(this.connection, this.warningCount, true);
                this.warningCount = warningCountOld;
            }
        }
        catch (SQLException var2) {
            this.printDumpStack();
            throw var2;
        }
    }

    private void secureAuth(Buffer packet, int packLength, String user, String password, String database, boolean writeClientParams) throws SQLException {
        block16: {
            try {
                if (packet == null) {
                    packet = new Buffer(packLength);
                }
                if (writeClientParams) {
                    if (this.use41Extensions) {
                        if (this.versionMeetsMinimum(4, 1, 1)) {
                            packet.writeLong(this.clientParam);
                            packet.writeLong(this.maxThreeBytes);
                            packet.writeByte((byte)8);
                            packet.writeBytesNoNull(new byte[23]);
                        } else {
                            packet.writeLong(this.clientParam);
                            packet.writeLong(this.maxThreeBytes);
                        }
                    } else {
                        packet.writeInt((int)this.clientParam);
                        packet.writeLongInt(this.maxThreeBytes);
                    }
                }
                packet.writeString(user, CODE_PAGE_1252, this.connection);
                if (password.length() != 0) {
                    packet.writeString(FALSE_SCRAMBLE, CODE_PAGE_1252, this.connection);
                } else {
                    packet.writeString("", CODE_PAGE_1252, this.connection);
                }
                if (this.useConnectWithDb) {
                    packet.writeString(database, CODE_PAGE_1252, this.connection);
                }
                this.send(packet, packet.getPosition());
                if (password.length() <= 0) break block16;
                Buffer b = this.readPacket();
                b.setPosition(0);
                byte[] replyAsBytes = b.getByteBuffer();
                if (replyAsBytes.length != 24 || replyAsBytes[0] == 0) break block16;
                if (replyAsBytes[0] != 42) {
                    try {
                        byte[] buff = Security.passwordHashStage1(password);
                        byte[] passwordHash = new byte[buff.length];
                        System.arraycopy(buff, 0, passwordHash, 0, buff.length);
                        passwordHash = Security.passwordHashStage2(passwordHash, replyAsBytes);
                        byte[] packetDataAfterSalt = new byte[replyAsBytes.length - 4];
                        System.arraycopy(replyAsBytes, 4, packetDataAfterSalt, 0, replyAsBytes.length - 4);
                        byte[] mysqlScrambleBuff = new byte[20];
                        Security.xorString(packetDataAfterSalt, mysqlScrambleBuff, passwordHash, 20);
                        Security.xorString(mysqlScrambleBuff, buff, buff, 20);
                        Buffer packet2 = new Buffer(25);
                        packet2.writeBytesNoNull(buff);
                        this.packetSequence = (byte)(this.packetSequence + 1);
                        this.send(packet2, 24);
                        break block16;
                    }
                    catch (NoSuchAlgorithmException var15) {
                        throw SQLError.createSQLException(Messages.getString("MysqlIO.91") + Messages.getString("MysqlIO.92"), "S1000", this.getExceptionInterceptor());
                    }
                }
                try {
                    byte[] buff = Security.createKeyFromOldPassword(password);
                    byte[] passwordHash = new byte[replyAsBytes.length - 4];
                    System.arraycopy(replyAsBytes, 4, passwordHash, 0, replyAsBytes.length - 4);
                    byte[] packetDataAfterSalt = new byte[20];
                    Security.xorString(passwordHash, packetDataAfterSalt, buff, 20);
                    String scrambledPassword = Util.scramble(StringUtils.toString(packetDataAfterSalt), password);
                    Buffer packet2 = new Buffer(packLength);
                    packet2.writeString(scrambledPassword, CODE_PAGE_1252, this.connection);
                    this.packetSequence = (byte)(this.packetSequence + 1);
                    this.send(packet2, 24);
                }
                catch (NoSuchAlgorithmException var14) {
                    throw SQLError.createSQLException(Messages.getString("MysqlIO.91") + Messages.getString("MysqlIO.92"), "S1000", this.getExceptionInterceptor());
                }
            }
            catch (SQLException var16) {
                this.printDumpStack();
                throw var16;
            }
        }
    }

    void secureAuth411(Buffer packet, int packLength, String user, String password, String database, boolean writeClientParams, boolean forChangeUser) throws SQLException {
        try {
            String enc = this.getEncodingForHandshake();
            if (packet == null) {
                packet = new Buffer(packLength);
            }
            if (writeClientParams) {
                if (this.use41Extensions) {
                    if (this.versionMeetsMinimum(4, 1, 1)) {
                        packet.writeLong(this.clientParam);
                        packet.writeLong(this.maxThreeBytes);
                        this.appendCharsetByteForHandshake(packet, enc);
                        packet.writeBytesNoNull(new byte[23]);
                    } else {
                        packet.writeLong(this.clientParam);
                        packet.writeLong(this.maxThreeBytes);
                    }
                } else {
                    packet.writeInt((int)this.clientParam);
                    packet.writeLongInt(this.maxThreeBytes);
                }
            }
            if (user != null) {
                packet.writeString(user, enc, this.connection);
            }
            if (password.length() != 0) {
                packet.writeByte((byte)20);
                try {
                    packet.writeBytesNoNull(Security.scramble411(password, this.seed, this.connection.getPasswordCharacterEncoding()));
                }
                catch (NoSuchAlgorithmException var12) {
                    throw SQLError.createSQLException(Messages.getString("MysqlIO.91") + Messages.getString("MysqlIO.92"), "S1000", this.getExceptionInterceptor());
                }
                catch (UnsupportedEncodingException var13) {
                    throw SQLError.createSQLException(Messages.getString("MysqlIO.91") + Messages.getString("MysqlIO.92"), "S1000", this.getExceptionInterceptor());
                }
            } else {
                packet.writeByte((byte)0);
            }
            if (this.useConnectWithDb) {
                packet.writeString(database, enc, this.connection);
            } else if (forChangeUser) {
                packet.writeByte((byte)0);
            }
            if ((this.serverCapabilities & 0x100000) != 0) {
                this.sendConnectionAttributes(packet, enc, this.connection);
            }
            this.send(packet, packet.getPosition());
            byte var10002 = this.packetSequence;
            this.packetSequence = (byte)(var10002 + 1);
            byte savePacketSequence = var10002;
            Buffer reply = this.checkErrorPacket();
            if (reply.isAuthMethodSwitchRequestPacket()) {
                this.packetSequence = savePacketSequence = (byte)(savePacketSequence + 1);
                packet.clear();
                String seed323 = this.seed.substring(0, 8);
                packet.writeString(Util.newCrypt(password, seed323, this.connection.getPasswordCharacterEncoding()));
                this.send(packet, packet.getPosition());
                this.checkErrorPacket();
            }
            if (!this.useConnectWithDb) {
                this.changeDatabaseTo(database);
            }
        }
        catch (SQLException var14) {
            this.printDumpStack();
            throw var14;
        }
    }

    private final ResultSetRow unpackBinaryResultSetRow(Field[] fields, Buffer binaryData, int resultSetConcurrency) throws SQLException {
        int numFields = fields.length;
        byte[][] unpackedRowData = new byte[numFields][];
        int nullCount = (numFields + 9) / 8;
        int nullMaskPos = binaryData.getPosition();
        binaryData.setPosition(nullMaskPos + nullCount);
        int bit = 4;
        for (int i = 0; i < numFields; ++i) {
            if ((binaryData.readByte(nullMaskPos) & bit) != 0) {
                unpackedRowData[i] = null;
            } else if (resultSetConcurrency != 1008) {
                this.extractNativeEncodedColumn(binaryData, fields, i, unpackedRowData);
            } else {
                this.unpackNativeEncodedColumn(binaryData, fields, i, unpackedRowData);
            }
            if (((bit <<= 1) & 0xFF) != 0) continue;
            bit = 1;
            ++nullMaskPos;
        }
        return new ByteArrayRow(unpackedRowData, this.getExceptionInterceptor());
    }

    private final void extractNativeEncodedColumn(Buffer binaryData, Field[] fields, int columnIndex, byte[][] unpackedRowData) throws SQLException {
        Field curField = fields[columnIndex];
        switch (curField.getMysqlType()) {
            case 0: 
            case 15: 
            case 16: 
            case 245: 
            case 246: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                unpackedRowData[columnIndex] = binaryData.readLenByteArray(0);
                break;
            }
            case 1: {
                unpackedRowData[columnIndex] = new byte[]{binaryData.readByte()};
                break;
            }
            case 2: 
            case 13: {
                unpackedRowData[columnIndex] = binaryData.getBytes(2);
                break;
            }
            case 3: 
            case 9: {
                unpackedRowData[columnIndex] = binaryData.getBytes(4);
                break;
            }
            case 4: {
                unpackedRowData[columnIndex] = binaryData.getBytes(4);
                break;
            }
            case 5: {
                unpackedRowData[columnIndex] = binaryData.getBytes(8);
            }
            case 6: {
                break;
            }
            case 7: 
            case 12: {
                int length = (int)binaryData.readFieldLength();
                unpackedRowData[columnIndex] = binaryData.getBytes(length);
                break;
            }
            case 8: {
                unpackedRowData[columnIndex] = binaryData.getBytes(8);
                break;
            }
            case 10: {
                int length = (int)binaryData.readFieldLength();
                unpackedRowData[columnIndex] = binaryData.getBytes(length);
                break;
            }
            case 11: {
                int length = (int)binaryData.readFieldLength();
                unpackedRowData[columnIndex] = binaryData.getBytes(length);
                break;
            }
            default: {
                throw SQLError.createSQLException(Messages.getString("MysqlIO.97") + curField.getMysqlType() + Messages.getString("MysqlIO.98") + columnIndex + Messages.getString("MysqlIO.99") + fields.length + Messages.getString("MysqlIO.100"), "S1000", this.getExceptionInterceptor());
            }
        }
    }

    private final void unpackNativeEncodedColumn(Buffer binaryData, Field[] fields, int columnIndex, byte[][] unpackedRowData) throws SQLException {
        Field curField = fields[columnIndex];
        switch (curField.getMysqlType()) {
            case 0: 
            case 15: 
            case 16: 
            case 245: 
            case 246: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: {
                unpackedRowData[columnIndex] = binaryData.readLenByteArray(0);
                break;
            }
            case 1: {
                byte tinyVal = binaryData.readByte();
                if (!curField.isUnsigned()) {
                    unpackedRowData[columnIndex] = StringUtils.getBytes(String.valueOf(tinyVal));
                    break;
                }
                short shortVal = (short)(tinyVal & 0xFF);
                unpackedRowData[columnIndex] = StringUtils.getBytes(String.valueOf(shortVal));
                break;
            }
            case 2: 
            case 13: {
                short shortVal = (short)binaryData.readInt();
                if (!curField.isUnsigned()) {
                    unpackedRowData[columnIndex] = StringUtils.getBytes(String.valueOf(shortVal));
                    break;
                }
                int intVal = shortVal & 0xFFFF;
                unpackedRowData[columnIndex] = StringUtils.getBytes(String.valueOf(intVal));
                break;
            }
            case 3: 
            case 9: {
                int intVal = (int)binaryData.readLong();
                if (!curField.isUnsigned()) {
                    unpackedRowData[columnIndex] = StringUtils.getBytes(String.valueOf(intVal));
                    break;
                }
                long longVal = (long)intVal & 0xFFFFFFFFL;
                unpackedRowData[columnIndex] = StringUtils.getBytes(String.valueOf(longVal));
                break;
            }
            case 4: {
                float floatVal = Float.intBitsToFloat(binaryData.readIntAsLong());
                unpackedRowData[columnIndex] = StringUtils.getBytes(String.valueOf(floatVal));
                break;
            }
            case 5: {
                double doubleVal = Double.longBitsToDouble(binaryData.readLongLong());
                unpackedRowData[columnIndex] = StringUtils.getBytes(String.valueOf(doubleVal));
            }
            case 6: {
                break;
            }
            case 7: 
            case 12: {
                int length = (int)binaryData.readFieldLength();
                int year = 0;
                byte month = 0;
                byte day = 0;
                byte hour = 0;
                byte minute = 0;
                byte seconds = 0;
                int nanos = 0;
                if (length != 0) {
                    year = binaryData.readInt();
                    month = binaryData.readByte();
                    day = binaryData.readByte();
                    if (length > 4) {
                        hour = binaryData.readByte();
                        minute = binaryData.readByte();
                        seconds = binaryData.readByte();
                    }
                }
                if (year == 0 && month == 0 && day == 0) {
                    if ("convertToNull".equals(this.connection.getZeroDateTimeBehavior())) {
                        unpackedRowData[columnIndex] = null;
                        break;
                    }
                    if ("exception".equals(this.connection.getZeroDateTimeBehavior())) {
                        throw SQLError.createSQLException("Value '0000-00-00' can not be represented as java.sql.Timestamp", "S1009", this.getExceptionInterceptor());
                    }
                    year = 1;
                    month = 1;
                    day = 1;
                }
                int stringLength = 19;
                byte[] nanosAsBytes = StringUtils.getBytes(Integer.toString(nanos));
                stringLength = stringLength + 1 + nanosAsBytes.length;
                byte[] datetimeAsBytes = new byte[stringLength];
                datetimeAsBytes[0] = (byte)Character.forDigit(year / 1000, 10);
                int after1000 = year % 1000;
                datetimeAsBytes[1] = (byte)Character.forDigit(after1000 / 100, 10);
                int after100 = after1000 % 100;
                datetimeAsBytes[2] = (byte)Character.forDigit(after100 / 10, 10);
                datetimeAsBytes[3] = (byte)Character.forDigit(after100 % 10, 10);
                datetimeAsBytes[4] = 45;
                datetimeAsBytes[5] = (byte)Character.forDigit(month / 10, 10);
                datetimeAsBytes[6] = (byte)Character.forDigit(month % 10, 10);
                datetimeAsBytes[7] = 45;
                datetimeAsBytes[8] = (byte)Character.forDigit(day / 10, 10);
                datetimeAsBytes[9] = (byte)Character.forDigit(day % 10, 10);
                datetimeAsBytes[10] = 32;
                datetimeAsBytes[11] = (byte)Character.forDigit(hour / 10, 10);
                datetimeAsBytes[12] = (byte)Character.forDigit(hour % 10, 10);
                datetimeAsBytes[13] = 58;
                datetimeAsBytes[14] = (byte)Character.forDigit(minute / 10, 10);
                datetimeAsBytes[15] = (byte)Character.forDigit(minute % 10, 10);
                datetimeAsBytes[16] = 58;
                datetimeAsBytes[17] = (byte)Character.forDigit(seconds / 10, 10);
                datetimeAsBytes[18] = (byte)Character.forDigit(seconds % 10, 10);
                datetimeAsBytes[19] = 46;
                int nanosOffset = 20;
                System.arraycopy(nanosAsBytes, 0, datetimeAsBytes, 20, nanosAsBytes.length);
                unpackedRowData[columnIndex] = datetimeAsBytes;
                break;
            }
            case 8: {
                long longVal = binaryData.readLongLong();
                if (!curField.isUnsigned()) {
                    unpackedRowData[columnIndex] = StringUtils.getBytes(String.valueOf(longVal));
                    break;
                }
                BigInteger asBigInteger = ResultSetImpl.convertLongToUlong(longVal);
                unpackedRowData[columnIndex] = StringUtils.getBytes(asBigInteger.toString());
                break;
            }
            case 10: {
                int length = (int)binaryData.readFieldLength();
                int year = 0;
                byte month = 0;
                byte day = 0;
                boolean hour = false;
                boolean minute = false;
                boolean seconds = false;
                if (length != 0) {
                    year = binaryData.readInt();
                    month = binaryData.readByte();
                    day = binaryData.readByte();
                }
                if (year == 0 && month == 0 && day == 0) {
                    if ("convertToNull".equals(this.connection.getZeroDateTimeBehavior())) {
                        unpackedRowData[columnIndex] = null;
                        break;
                    }
                    if ("exception".equals(this.connection.getZeroDateTimeBehavior())) {
                        throw SQLError.createSQLException("Value '0000-00-00' can not be represented as java.sql.Date", "S1009", this.getExceptionInterceptor());
                    }
                    year = 1;
                    month = 1;
                    day = 1;
                }
                byte[] dateAsBytes = new byte[10];
                dateAsBytes[0] = (byte)Character.forDigit(year / 1000, 10);
                int after1000 = year % 1000;
                dateAsBytes[1] = (byte)Character.forDigit(after1000 / 100, 10);
                int after100 = after1000 % 100;
                dateAsBytes[2] = (byte)Character.forDigit(after100 / 10, 10);
                dateAsBytes[3] = (byte)Character.forDigit(after100 % 10, 10);
                dateAsBytes[4] = 45;
                dateAsBytes[5] = (byte)Character.forDigit(month / 10, 10);
                dateAsBytes[6] = (byte)Character.forDigit(month % 10, 10);
                dateAsBytes[7] = 45;
                dateAsBytes[8] = (byte)Character.forDigit(day / 10, 10);
                dateAsBytes[9] = (byte)Character.forDigit(day % 10, 10);
                unpackedRowData[columnIndex] = dateAsBytes;
                break;
            }
            case 11: {
                int length = (int)binaryData.readFieldLength();
                int hour = 0;
                byte minute = 0;
                byte seconds = 0;
                if (length != 0) {
                    binaryData.readByte();
                    binaryData.readLong();
                    hour = binaryData.readByte();
                    minute = binaryData.readByte();
                    seconds = binaryData.readByte();
                    if (length > 8) {
                        binaryData.readLong();
                    }
                }
                byte[] timeAsBytes = new byte[]{(byte)Character.forDigit(hour / 10, 10), (byte)Character.forDigit(hour % 10, 10), 58, (byte)Character.forDigit(minute / 10, 10), (byte)Character.forDigit(minute % 10, 10), 58, (byte)Character.forDigit(seconds / 10, 10), (byte)Character.forDigit(seconds % 10, 10)};
                unpackedRowData[columnIndex] = timeAsBytes;
                break;
            }
            default: {
                throw SQLError.createSQLException(Messages.getString("MysqlIO.97") + curField.getMysqlType() + Messages.getString("MysqlIO.98") + columnIndex + Messages.getString("MysqlIO.99") + fields.length + Messages.getString("MysqlIO.100"), "S1000", this.getExceptionInterceptor());
            }
        }
    }

    private void negotiateSSLConnection(String user, String password, String database, int packLength) throws SQLException {
        if (!ExportControlled.enabled()) {
            throw new ConnectionFeatureNotAvailableException(this.connection, this.lastPacketSentTimeMs, null);
        }
        if ((this.serverCapabilities & 0x8000) != 0) {
            this.clientParam |= 0x8000L;
        }
        this.clientParam |= 0x800L;
        Buffer packet = new Buffer(packLength);
        if (this.use41Extensions) {
            packet.writeLong(this.clientParam);
            packet.writeLong(this.maxThreeBytes);
            this.appendCharsetByteForHandshake(packet, this.getEncodingForHandshake());
            packet.writeBytesNoNull(new byte[23]);
        } else {
            packet.writeInt((int)this.clientParam);
        }
        this.send(packet, packet.getPosition());
        ExportControlled.transformSocketToSSLSocket(this);
    }

    public boolean isSSLEstablished() {
        return ExportControlled.enabled() && ExportControlled.isSSLEstablished(this);
    }

    protected int getServerStatus() {
        return this.serverStatus;
    }

    protected List<ResultSetRow> fetchRowsViaCursor(List<ResultSetRow> fetchedRows, long statementId, Field[] columnTypes, int fetchSize, boolean useBufferRowExplicit) throws SQLException {
        try {
            if (fetchedRows == null) {
                fetchedRows = new ArrayList<ResultSetRow>(fetchSize);
            } else {
                fetchedRows.clear();
            }
            this.sharedSendPacket.clear();
            this.sharedSendPacket.writeByte((byte)28);
            this.sharedSendPacket.writeLong(statementId);
            this.sharedSendPacket.writeLong(fetchSize);
            this.sendCommand(28, null, this.sharedSendPacket, true, null, 0);
            ResultSetRow row = null;
            while ((row = this.nextRow(columnTypes, columnTypes.length, true, 1007, false, useBufferRowExplicit, false, null)) != null) {
                fetchedRows.add(row);
            }
            return fetchedRows;
        }
        catch (SQLException var8) {
            this.printDumpStack();
            throw var8;
        }
    }

    public long getThreadId() {
        return this.threadId;
    }

    protected boolean useNanosForElapsedTime() {
        return this.useNanosForElapsedTime;
    }

    public long getSlowQueryThreshold() {
        return this.slowQueryThreshold;
    }

    public String getQueryTimingUnits() {
        return this.queryTimingUnits;
    }

    protected int getCommandCount() {
        return this.commandCount;
    }

    private void checkTransactionState(int oldStatus) throws SQLException {
        boolean previouslyInTrans = (oldStatus & 1) != 0;
        boolean currentlyInTrans = this.inTransactionOnServer();
        if (previouslyInTrans && !currentlyInTrans) {
            this.connection.transactionCompleted();
        } else if (!previouslyInTrans && currentlyInTrans) {
            this.connection.transactionBegun();
        }
    }

    private void preserveOldTransactionState() {
        this.serverStatus |= this.oldServerStatus & 1;
    }

    protected void setStatementInterceptors(List<StatementInterceptorV2> statementInterceptors) {
        this.statementInterceptors = statementInterceptors.isEmpty() ? null : statementInterceptors;
    }

    public ExceptionInterceptor getExceptionInterceptor() {
        return this.exceptionInterceptor;
    }

    protected void setSocketTimeout(int milliseconds) throws SQLException {
        try {
            if (this.mysqlConnection != null) {
                this.mysqlConnection.setSoTimeout(milliseconds);
            }
        }
        catch (SocketException var4) {
            SQLException sqlEx = SQLError.createSQLException("Invalid socket timeout value or state", "S1009", this.getExceptionInterceptor());
            sqlEx.initCause(var4);
            throw sqlEx;
        }
    }

    protected void releaseResources() {
        if (this.deflater != null) {
            this.deflater.end();
            this.deflater = null;
        }
    }

    String getEncodingForHandshake() {
        String enc = this.connection.getEncoding();
        if (enc == null) {
            enc = "UTF-8";
        }
        return enc;
    }

    private void appendCharsetByteForHandshake(Buffer packet, String enc) throws SQLException {
        int charsetIndex = 0;
        if (enc != null) {
            charsetIndex = CharsetMapping.getCollationIndexForJavaEncoding(enc, this.connection);
        }
        if (charsetIndex == 0) {
            charsetIndex = 33;
        }
        if (charsetIndex > 255) {
            throw SQLError.createSQLException("Invalid character set index for encoding: " + enc, "S1009", this.getExceptionInterceptor());
        }
        packet.writeByte((byte)charsetIndex);
    }

    public boolean isEOFDeprecated() {
        return (this.clientParam & 0x1000000L) != 0L;
    }

    private void recordDump(Buffer buf, boolean isSend, int off, int len, String msg) {
        try {
            if (this.myDumpInfo == null || 0 == this.myDumpInfo.geTDumpListSize()) {
                return;
            }
            this.myDumpInfo.setDumpInfo(buf, false, off, len, msg);
        }
        catch (Exception var7) {
            System.out.println("Failed to print io dump stack." + var7.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void printDumpStack() {
        try {
            block12: {
                block11: {
                    if (this.myDumpInfo == null) break block11;
                    if (0 != this.myDumpInfo.geTDumpListSize()) break block12;
                }
                var3_1 = null;
                ** GOTO lbl37
            }
            if (null != this.socketInfo && null != this.orgIP) {
                this.connection.getLog().logStandardError("Socket info as below:\n" + this.socketInfo + ",[orgIP:" + this.orgIP + ",orgPort:" + this.orgPort + "]");
            }
            this.connection.getLog().logStandardError("Begin to print io dump stack:");
            this.myDumpInfo.printDumpStack(this.connection);
            this.connection.getLog().logStandardError("End to print io dump stack.");
            ** GOTO lbl44
        }
        catch (Exception var12) {
            System.out.println("Failed to print io dump stack." + var12.getMessage());
            var3_3 = null;
            try {
                if (null == this.myDumpInfo) return;
                this.myDumpInfo.clearDumpStack();
                return;
            }
            catch (Exception var11) {
                System.out.println("Failed to print io dump stack." + var11.getMessage());
            }
            return;
        }
        {
            catch (Throwable var2_10) {
                var3_4 = null;
                ** try [egrp 2[TRYBLOCK] [6 : 199->217)] { 
lbl31:
                // 1 sources

                if (null == this.myDumpInfo) throw var2_10;
                this.myDumpInfo.clearDumpStack();
                throw var2_10;
lbl34:
                // 1 sources

                catch (Exception var11) {
                    System.out.println("Failed to print io dump stack." + var11.getMessage());
                }
                throw var2_10;
            }
lbl37:
            // 1 sources

            ** try [egrp 2[TRYBLOCK] [6 : 199->217)] { 
lbl38:
            // 1 sources

            if (null == this.myDumpInfo) return;
            this.myDumpInfo.clearDumpStack();
            return;
lbl41:
            // 1 sources

            catch (Exception var11) {
                System.out.println("Failed to print io dump stack." + var11.getMessage());
            }
            return;
lbl44:
            // 1 sources

            var3_2 = null;
            try {}
            catch (Exception var11) {}
            System.out.println("Failed to print io dump stack." + var11.getMessage());
            return;
            if (null == this.myDumpInfo) return;
            this.myDumpInfo.clearDumpStack();
            return;
        }
    }

    void parseUse(String query) throws SQLException {
        if (null != query) {
            String use = "USE";
            String schema = query.toUpperCase();
            if (schema.startsWith(use)) {
                int index = use.length();
                schema = query.substring(index).trim();
                int length = schema.length();
                if (length > 0) {
                    int end = schema.indexOf(";");
                    if (end > 0) {
                        schema = schema.substring(0, end);
                    }
                    schema = schema.replace("`", "");
                    length = schema.length();
                    if (schema.charAt(0) == '\'' && schema.charAt(length - 1) == '\'') {
                        schema = schema.substring(1, length - 1);
                    }
                }
                this.connection.setDatabase(schema);
            }
        }
    }

    void exceptionChecker(SQLException ex) throws SQLException {
        LoadBalanceExceptionChecker exceptionChecker = this.connection.getLoadBakanceExceptionChecker();
        if (null != exceptionChecker && exceptionChecker.shouldExceptionTriggerFailover(ex)) {
            throw SQLError.createCommunicationsException(this.connection, this.lastPacketSentTimeMs, this.lastPacketReceivedTimeMs, ex, this.getExceptionInterceptor());
        }
    }

    public String getLinkInfo() {
        String linkInfo = "";
        if (null != this.socketInfo) {
            linkInfo = this.socketInfo.getLinkInfo();
        }
        if (null != this.orgIP) {
            linkInfo = linkInfo + " ,[orgIP:" + this.orgIP + ",orgPort:" + this.orgPort + "]";
        }
        return linkInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        OutputStreamWriter outWriter = null;
        try {
            outWriter = new OutputStreamWriter(new ByteArrayOutputStream());
            jvmPlatformCharset = outWriter.getEncoding();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            try {
                if (outWriter != null) {
                    outWriter.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (outWriter != null) {
                outWriter.close();
            }
        }
        catch (IOException iOException) {}
    }

    class SocketInfo {
        int localPort;
        String localAddr;
        String remoteSocketAddr;

        public SocketInfo(Socket so) {
            if (so == null) {
                return;
            }
            this.localPort = so.getLocalPort();
            this.localAddr = so.getLocalAddress().toString();
            this.remoteSocketAddr = so.getRemoteSocketAddress().toString();
        }

        public String toString() {
            return "[localPort:" + this.localPort + ",localAddr:" + this.localAddr + ",remoteSocketAddr:" + this.remoteSocketAddr + "]";
        }

        public String getLinkInfo() {
            String srcIp = this.localAddr;
            String dstIp = this.remoteSocketAddr;
            if (srcIp.startsWith("/")) {
                srcIp = srcIp.replaceFirst("/", "");
            }
            if (dstIp.startsWith("/")) {
                dstIp = dstIp.replaceFirst("/", "");
            }
            return "LinkInfo:[client]=" + srcIp + ":" + this.localPort + " ==> [target]=" + dstIp;
        }

        public String getLocalAddr() {
            String srcIp = this.localAddr;
            if (srcIp.startsWith("/")) {
                srcIp = srcIp.replaceFirst("/", "");
            }
            return srcIp;
        }

        public int getLocalPort() {
            int srcPort = this.localPort;
            return srcPort;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DumpInfo {
        private long currentTMillis = System.currentTimeMillis();
        private String dumpInfo;
        private boolean isSend = false;
        private String msg = null;
        private List<byte[]> byteList = new ArrayList<byte[]>();

        public DumpInfo(Buffer buf, boolean isSend, int off, int len) {
            byte[] b = new byte[len];
            System.arraycopy(buf.getByteBuffer(), off, b, 0, len);
            this.byteList.add(b);
            this.isSend = isSend;
        }

        public void setDumpInfo(Buffer buf, boolean isSend, int off, int len, String msg) {
            byte[] b = new byte[len];
            ArrayList<byte[]> byteList = new ArrayList<byte[]>();
            System.arraycopy(buf.getByteBuffer(), off, b, 0, len);
            byteList.add(b);
            this.byteList = byteList;
            this.isSend = isSend;
            this.currentTMillis = System.currentTimeMillis();
            this.msg = msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public void setByteList(List<byte[]> list) {
            this.byteList = list;
        }

        public List<byte[]> getByteList() {
            return this.byteList;
        }

        public String toString() {
            this.dumpInfo = StringUtils.dumpAsHex(this.byteList.get(0), this.byteList.get(0).length);
            if (this.byteList.size() > 1) {
                this.dumpInfo = this.dumpInfo + "...\n" + StringUtils.dumpAsHex(this.byteList.get(1), this.byteList.get(1).length);
            }
            return (this.isSend ? "--> " : "<-- ") + "currentTimeMillis:" + this.currentTMillis + ",msg:" + this.msg + ",\ndumpInfo:\n" + this.dumpInfo;
        }
    }

    class MyDumpInfo {
        public Map<String, DumpInfo> dumpInfoList = new HashMap<String, DumpInfo>();
        int index = 0;
        int sysDumpListSize = 0;
        int infoLength = 0;

        public MyDumpInfo(int dumpListSize, int dumpInfoLength) {
            this.sysDumpListSize = dumpListSize;
            this.infoLength = dumpInfoLength;
        }

        public int getNextIndex() {
            int next = this.index + 1;
            this.index = next < this.sysDumpListSize ? ++this.index : 0;
            return this.index;
        }

        public int geTDumpListSize() {
            return this.sysDumpListSize;
        }

        public void setDumpInfo(Buffer buf, boolean isSend, int off, int len, String msg) {
            DumpInfo dumpinfo = null;
            if (len > this.infoLength) {
                len = this.infoLength;
            }
            if (this.dumpInfoList.size() < this.sysDumpListSize) {
                dumpinfo = new DumpInfo(buf, isSend, off, len);
                this.index = this.dumpInfoList.size();
                String key = String.valueOf(this.index);
                this.dumpInfoList.put(key, dumpinfo);
            } else {
                String key = String.valueOf(this.getNextIndex());
                dumpinfo = this.dumpInfoList.get(key);
                if (null != dumpinfo) {
                    dumpinfo.setDumpInfo(buf, isSend, off, len, msg);
                }
            }
            dumpinfo.setMsg(msg);
        }

        public void printDumpStack(MySQLConnection connection) throws SQLException {
            String key;
            int i;
            if (0 == this.dumpInfoList.size() || null == connection) {
                return;
            }
            for (i = this.index + 1; i < this.dumpInfoList.size(); ++i) {
                key = String.valueOf(i);
                if (null == this.dumpInfoList.get(key)) continue;
                connection.getLog().logStandardError(this.dumpInfoList.get(key).toString());
            }
            for (i = 0; i <= this.index; ++i) {
                key = String.valueOf(i);
                if (null == this.dumpInfoList.get(key)) continue;
                connection.getLog().logStandardError(this.dumpInfoList.get(key).toString());
            }
        }

        public void clearDumpStack() {
            this.index = 0;
            Iterator<Map.Entry<String, DumpInfo>> it = this.dumpInfoList.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, DumpInfo> item = it.next();
                it.remove();
            }
        }
    }
}

