/*
 * Decompiled with CFR 0.152.
 */
package com.goldendb.jdbc.internal.core.jdbc4;

import com.goldendb.jdbc.MySQLConnection;
import com.goldendb.jdbc.StatementImpl;
import com.goldendb.jdbc.internal.core.JDBC4ResultSet;
import com.goldendb.jdbc.internal.core.io.Field;
import com.goldendb.jdbc.internal.core.io.NotUpdatable;
import com.goldendb.jdbc.internal.core.io.RowData;
import com.goldendb.jdbc.internal.util.SQLError;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.util.concurrent.TimeUnit;

public class JDBC42ResultSet
extends JDBC4ResultSet {
    public JDBC42ResultSet(long updateCount, long updateID, MySQLConnection conn, StatementImpl creatorStmt) {
        super(updateCount, updateID, conn, creatorStmt);
    }

    public JDBC42ResultSet(String catalog, Field[] fields, RowData tuples, MySQLConnection conn, StatementImpl creatorStmt) throws SQLException {
        super(catalog, fields, tuples, conn, creatorStmt);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        if (type == null) {
            throw SQLError.createSQLException("Type parameter can not be null", "S1009", this.getExceptionInterceptor());
        }
        if (type.equals(LocalDate.class)) {
            Date date = this.getDate(columnIndex);
            return date == null ? null : (T)type.cast(date.toLocalDate());
        }
        if (type.equals(LocalDateTime.class)) {
            Timestamp timestamp = this.getTimestamp(columnIndex);
            return timestamp == null ? null : (T)type.cast(timestamp.toLocalDateTime());
        }
        if (type.equals(LocalTime.class)) {
            Timestamp timestamp = this.getTimestamp(columnIndex);
            return timestamp == null ? null : (T)type.cast(timestamp.toLocalDateTime().toLocalTime());
        }
        if (type.equals(OffsetDateTime.class)) {
            Timestamp timestamp = this.getTimestamp(columnIndex);
            Instant instant = timestamp.toInstant();
            int offsetMillis = this.getDefaultTimeZone().getRawOffset();
            int offsetHours = (int)TimeUnit.MILLISECONDS.toHours(offsetMillis);
            ZoneOffset zoneOffset = ZoneOffset.ofHours(offsetHours);
            OffsetDateTime offsetDateTime = instant.atOffset(zoneOffset);
            return (T)offsetDateTime;
        }
        if (type.equals(OffsetTime.class)) {
            try {
                String string = this.getString(columnIndex);
                return string == null ? null : (T)type.cast(OffsetTime.parse(string));
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return super.getObject(columnIndex, type);
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType) throws SQLException {
        throw new NotUpdatable();
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        throw new NotUpdatable();
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType) throws SQLException {
        throw new NotUpdatable();
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        throw new NotUpdatable();
    }
}

