/*
 * Decompiled with CFR 0.152.
 */
package com.goldendb.jdbc.internal.custom;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class ConfigStmtRuleManager {
    private static final Object lock = new Object();
    private static volatile boolean inited = false;
    public static volatile boolean enableConfigStmtRule = false;
    private static String url;
    private static Properties info;
    private static int period;
    private static Connection connection;
    public static ConcurrentHashMap<String, RuleEntity> cacheRuleMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(String inputUrl, Properties inputInfo, int checkConfigStmtRulePeriod) {
        if (!inited) {
            Object object = lock;
            synchronized (object) {
                if (!inited) {
                    url = inputUrl;
                    info = inputInfo;
                    period = checkConfigStmtRulePeriod;
                    enableConfigStmtRule = true;
                    Thread thread = new Thread(new Task());
                    thread.setDaemon(true);
                    thread.setName("Config Stmt Rule Schedule Thread");
                    thread.start();
                    inited = true;
                }
            }
        }
    }

    static {
        cacheRuleMap = new ConcurrentHashMap();
    }

    public static class RuleEntity {
        private int id;
        private String targetSql;
        private int matchingRule;
        private int handlingRule;

        public RuleEntity(int id, String targetSql, int matchingRule, int handlingRule) {
            this.id = id;
            this.targetSql = targetSql;
            this.matchingRule = matchingRule;
            this.handlingRule = handlingRule;
        }

        public String generateKey() {
            return this.matchingRule + "@" + this.handlingRule + "@" + this.targetSql;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getTargetSql() {
            return this.targetSql;
        }

        public void setTargetSql(String targetSql) {
            this.targetSql = targetSql;
        }

        public int getMatchingRule() {
            return this.matchingRule;
        }

        public void setMatchingRule(int matchingRule) {
            this.matchingRule = matchingRule;
        }

        public int getHandlingRule() {
            return this.handlingRule;
        }

        public void setHandlingRule(int handlingRule) {
            this.handlingRule = handlingRule;
        }

        public String toString() {
            return "RuleEntity{id=" + this.id + ", targetSql='" + this.targetSql + '\'' + ", matchingRule=" + this.matchingRule + ", handlingRule=" + this.handlingRule + '}';
        }
    }

    static class Task
    implements Runnable {
        Task() {
        }

        public void run() {
            while (true) {
                Task.freshConn();
                this.freshConfig();
                try {
                    Thread.sleep((long)period * 1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void freshConfig() {
            block24: {
                if (connection != null) {
                    SQLException e222;
                    ResultSet rs;
                    Statement st;
                    block22: {
                        st = null;
                        rs = null;
                        st = connection.createStatement();
                        rs = st.executeQuery("select * from gdb_stmt_handle_rule");
                        Enumeration<String> keys = cacheRuleMap.keys();
                        HashSet<String> expireKeys = new HashSet<String>();
                        while (keys.hasMoreElements()) {
                            expireKeys.add(keys.nextElement());
                        }
                        while (rs.next()) {
                            int id = rs.getInt(1);
                            String targetSql = rs.getString(2);
                            int matchingRule = rs.getInt(3);
                            int handlingRule = rs.getInt(4);
                            if (targetSql == null || targetSql.length() == 0) continue;
                            RuleEntity entity = new RuleEntity(id, targetSql, matchingRule, handlingRule);
                            String key = entity.generateKey();
                            RuleEntity hit = cacheRuleMap.get(key);
                            if (hit == null) {
                                cacheRuleMap.put(key, entity);
                            }
                            expireKeys.remove(key);
                        }
                        for (String expireKey : expireKeys) {
                            cacheRuleMap.remove(expireKey);
                        }
                        Object var13_14 = null;
                        if (rs == null) break block22;
                        try {
                            rs.close();
                        }
                        catch (SQLException e222) {
                            // empty catch block
                        }
                    }
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e222) {}
                    }
                    break block24;
                    {
                        catch (Exception e3) {
                            SQLException e222;
                            e3.printStackTrace();
                            Object var13_15 = null;
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (SQLException e222) {
                                    // empty catch block
                                }
                            }
                            if (st != null) {
                                try {
                                    st.close();
                                }
                                catch (SQLException e222) {}
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        SQLException e222;
                        Object var13_16 = null;
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (SQLException e222) {
                                // empty catch block
                            }
                        }
                        if (st != null) {
                            try {
                                st.close();
                            }
                            catch (SQLException e222) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                }
            }
        }

        public static void freshConn() {
            boolean flag = Task.checkConn();
            if (flag) {
                return;
            }
            try {
                connection = DriverManager.getConnection(url, info);
            }
            catch (SQLException e) {
                connection = null;
            }
        }

        public static boolean checkConn() {
            if (connection == null) {
                return false;
            }
            Statement st = null;
            try {
                st = connection.createStatement();
                st.execute("select 1");
                st.close();
                return true;
            }
            catch (SQLException e) {
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException var2) {
                        // empty catch block
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                return false;
            }
        }
    }
}

