/*
 * Decompiled with CFR 0.152.
 */
package com.goldendb.jdbc.internal.jdbc2;

import com.goldendb.jdbc.Connection;
import com.goldendb.jdbc.internal.util.SQLError;
import com.goldendb.jdbc.jdbc2.optional.ConnectionWrapper;
import com.goldendb.jdbc.jdbc2.optional.GoldendbPooledConnection;
import com.goldendb.jdbc.jdbc2.optional.WrapperBase;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Properties;

public class JDBC4ConnectionWrapper
extends ConnectionWrapper {
    public JDBC4ConnectionWrapper(GoldendbPooledConnection mysqlPooledConnection, Connection mysqlConnection, boolean forXa) throws SQLException {
        super(mysqlPooledConnection, mysqlConnection, forXa);
    }

    @Override
    public void close() throws SQLException {
        try {
            super.close();
        }
        finally {
            this.unwrappedInterfaces = null;
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkClosed();
        try {
            return this.mc.createSQLXML();
        }
        catch (SQLException var2) {
            this.checkAndFireConnectionError(var2);
            return null;
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkClosed();
        try {
            return this.mc.createArrayOf(typeName, elements);
        }
        catch (SQLException var4) {
            this.checkAndFireConnectionError(var4);
            return null;
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.checkClosed();
        try {
            return this.mc.createStruct(typeName, attributes);
        }
        catch (SQLException var4) {
            this.checkAndFireConnectionError(var4);
            return null;
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkClosed();
        try {
            return this.mc.getClientInfo();
        }
        catch (SQLException var2) {
            this.checkAndFireConnectionError(var2);
            return null;
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkClosed();
        try {
            return this.mc.getClientInfo(name);
        }
        catch (SQLException var3) {
            this.checkAndFireConnectionError(var3);
            return null;
        }
    }

    @Override
    public synchronized boolean isValid(int timeout) throws SQLException {
        try {
            return this.mc.isValid(timeout);
        }
        catch (SQLException var3) {
            this.checkAndFireConnectionError(var3);
            return false;
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.checkClosed();
            this.mc.setClientInfo(properties);
        }
        catch (SQLException var7) {
            SQLException sqlException = var7;
            try {
                this.checkAndFireConnectionError(sqlException);
            }
            catch (SQLException var6) {
                SQLClientInfoException clientEx = new SQLClientInfoException();
                clientEx.initCause(var6);
                throw clientEx;
            }
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.checkClosed();
            this.mc.setClientInfo(name, value);
        }
        catch (SQLException var8) {
            SQLException sqlException = var8;
            try {
                this.checkAndFireConnectionError(sqlException);
            }
            catch (SQLException var7) {
                SQLClientInfoException clientEx = new SQLClientInfoException();
                clientEx.initCause(var7);
                throw clientEx;
            }
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.checkClosed();
        boolean isInstance = iface.isInstance(this);
        if (isInstance) {
            return true;
        }
        return iface.getName().equals("com.goldendb.jdbc.Connection") || iface.getName().equals("com.goldendb.jdbc.ConnectionProperties");
    }

    @Override
    public synchronized <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            if (!"java.sql.Connection".equals(iface.getName()) && !"java.sql.Wrapper.class".equals(iface.getName())) {
                Object cachedUnwrapped;
                if (this.unwrappedInterfaces == null) {
                    this.unwrappedInterfaces = new HashMap();
                }
                if ((cachedUnwrapped = this.unwrappedInterfaces.get(iface)) == null) {
                    cachedUnwrapped = Proxy.newProxyInstance(this.mc.getClass().getClassLoader(), new Class[]{iface}, (InvocationHandler)new WrapperBase.ConnectionErrorFiringInvocationHandler(this, this.mc));
                    this.unwrappedInterfaces.put(iface, cachedUnwrapped);
                }
                return iface.cast(cachedUnwrapped);
            }
            return iface.cast(this);
        }
        catch (ClassCastException var3) {
            throw SQLError.createSQLException("Unable to unwrap to " + iface.toString(), "S1009", this.exceptionInterceptor);
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkClosed();
        try {
            return this.mc.createBlob();
        }
        catch (SQLException var2) {
            this.checkAndFireConnectionError(var2);
            return null;
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkClosed();
        try {
            return this.mc.createClob();
        }
        catch (SQLException var2) {
            this.checkAndFireConnectionError(var2);
            return null;
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkClosed();
        try {
            return this.mc.createNClob();
        }
        catch (SQLException var2) {
            this.checkAndFireConnectionError(var2);
            return null;
        }
    }
}

