/*
 * Decompiled with CFR 0.152.
 */
package com.goldendb.jdbc.internal.log;

import com.goldendb.jdbc.ExceptionInterceptor;
import com.goldendb.jdbc.Util;
import com.goldendb.jdbc.internal.log.GoldendbLog;
import com.goldendb.jdbc.internal.util.SQLError;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;

public class LogFactory {
    public static GoldendbLog getLogger(String className, String instanceName, ExceptionInterceptor exceptionInterceptor) throws SQLException {
        if (className == null) {
            throw SQLError.createSQLException("Logger class can not be NULL", "S1009", exceptionInterceptor);
        }
        if (instanceName == null) {
            throw SQLError.createSQLException("Logger instance name can not be NULL", "S1009", exceptionInterceptor);
        }
        try {
            Class<?> loggerClass = null;
            try {
                loggerClass = Class.forName(className);
            }
            catch (ClassNotFoundException var5) {
                loggerClass = Class.forName(Util.getPackageName(GoldendbLog.class) + "." + className);
            }
            Constructor<?> constructor = loggerClass.getConstructor(String.class);
            return (GoldendbLog)constructor.newInstance(instanceName);
        }
        catch (ClassNotFoundException var6) {
            SQLException sqlEx = SQLError.createSQLException("Unable to load class for logger '" + className + "'", "S1009", exceptionInterceptor);
            sqlEx.initCause(var6);
            throw sqlEx;
        }
        catch (NoSuchMethodException var7) {
            SQLException sqlEx = SQLError.createSQLException("Logger class does not have a single-arg constructor that takes an instance name", "S1009", exceptionInterceptor);
            sqlEx.initCause(var7);
            throw sqlEx;
        }
        catch (InstantiationException var8) {
            SQLException sqlEx = SQLError.createSQLException("Unable to instantiate logger class '" + className + "', exception in constructor?", "S1009", exceptionInterceptor);
            sqlEx.initCause(var8);
            throw sqlEx;
        }
        catch (InvocationTargetException var9) {
            SQLException sqlEx = SQLError.createSQLException("Unable to instantiate logger class '" + className + "', exception in constructor?", "S1009", exceptionInterceptor);
            sqlEx.initCause(var9);
            throw sqlEx;
        }
        catch (IllegalAccessException var10) {
            SQLException sqlEx = SQLError.createSQLException("Unable to instantiate logger class '" + className + "', constructor not public", "S1009", exceptionInterceptor);
            sqlEx.initCause(var10);
            throw sqlEx;
        }
        catch (ClassCastException var11) {
            SQLException sqlEx = SQLError.createSQLException("Logger class '" + className + "' does not implement the '" + GoldendbLog.class.getName() + "' interface", "S1009", exceptionInterceptor);
            sqlEx.initCause(var11);
            throw sqlEx;
        }
    }
}

