/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.oracle.visitor;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLHint;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLOver;
import com.alibaba.druid.sql.ast.SQLParameter;
import com.alibaba.druid.sql.ast.SQLPartitionBy;
import com.alibaba.druid.sql.ast.SQLPartitionValue;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.SQLSubPartition;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterProcedureStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRename;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLBlockStatement;
import com.alibaba.druid.sql.ast.statement.SQLCharacterDataType;
import com.alibaba.druid.sql.ast.statement.SQLCheck;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLForeignKeyImpl;
import com.alibaba.druid.sql.ast.statement.SQLIfStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSavePointStatement;
import com.alibaba.druid.sql.ast.statement.SQLScriptCommitStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLTableSampling;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTruncateStatement;
import com.alibaba.druid.sql.ast.statement.SQLUnique;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.dialect.oracle.ast.OracleDataTypeIntervalYear;
import com.alibaba.druid.sql.dialect.oracle.ast.OracleSegmentAttributes;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.ModelClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleLobStorageClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleStorageClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.PartitionExtensionClause;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleAnalytic;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleAnalyticWindowing;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleArgumentExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleBinaryFloatExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleDatetimeExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleIntervalExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleOuterExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleRangeExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleSysdateExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTableDropPartition;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTableModify;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTableMoveTablespace;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTableSplitPartition;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTableTruncatePartition;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTablespaceAddDataFile;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTablespaceStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCheck;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleConstraint;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateDatabaseDbLinkStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateIndexStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreatePackageStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateTableStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateTypeStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleDeleteStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleDropDbLinkStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleExceptionStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleExecuteImmediateStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleExitStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleExplainStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleFileSpecification;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleForStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleForeignKey;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleLockTableStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleMultiInsertStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OraclePipeRowStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OraclePrimaryKey;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleRaiseStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectJoin;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectPivot;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectPivotBase;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectQueryBlock;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectRestriction;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectSubqueryTableSource;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectTableReference;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSetTransactionStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleUnique;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleUsingIndexClause;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleXmlColumnProperties;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.alibaba.druid.sql.visitor.OracleExtendAstOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import java.util.List;

public class OracleOutputVisitor
extends OracleExtendAstOutputVisitor
implements OracleASTVisitor {
    public static final String UNIQUE = "UNIQUE";
    private final boolean printPostSemi;

    public OracleOutputVisitor(Appendable appender) {
        this(appender, true);
    }

    public OracleOutputVisitor(Appendable appender, boolean printPostSemi) {
        super(appender);
        this.dbType = DbType.oracle;
        this.printPostSemi = printPostSemi;
    }

    public boolean isPrintPostSemi() {
        return this.printPostSemi;
    }

    private void printHints(List<SQLHint> hints) {
        if (hints.size() > 0) {
            this.print0("/*+ ");
            this.printAndAccept(hints, ", ");
            this.print0(" */");
        }
    }

    public boolean visit(OracleAnalytic x) {
        super.visit(x);
        if (x.isWindowingPreceding()) {
            this.print0(this.ucase ? " PRECEDING" : " preceding");
        }
        this.print(')');
        return false;
    }

    public boolean visit(OracleAnalyticWindowing x) {
        this.print0(x.getType().name().toUpperCase());
        this.print(' ');
        SQLExpr expr = x.getExpr();
        if (expr instanceof SQLBetweenExpr && x.getParent() instanceof SQLOver) {
            SQLOver over = (SQLOver)x.getParent();
            SQLBetweenExpr betweenExpr = (SQLBetweenExpr)expr;
            SQLOver.WindowingBound beginBound = over.getWindowingBetweenBeginBound();
            if (beginBound != null) {
                this.print0(this.ucase ? " BETWEEN " : " between ");
                betweenExpr.getBeginExpr().accept((SQLASTVisitor)this);
                this.print(' ');
                this.print0(this.ucase ? beginBound.name : beginBound.nameLCase);
                this.print0(this.ucase ? " AND " : " and ");
                betweenExpr.getEndExpr().accept((SQLASTVisitor)this);
                return false;
            }
        }
        expr.accept((SQLASTVisitor)this);
        return false;
    }

    public boolean visit(OracleDeleteStatement x) {
        this.print0(this.ucase ? "DELETE " : "delete ");
        SQLTableSource tableSource = x.getTableSource();
        if (x.getHints().size() > 0) {
            this.printAndAccept(x.getHints(), ", ");
            this.print(' ');
        }
        this.print0(this.ucase ? "FROM " : "from ");
        if (x.isOnly()) {
            this.print0(this.ucase ? "ONLY (" : "only (");
            x.getTableName().accept((SQLASTVisitor)this);
            this.print(')');
            this.printAlias(x.getAlias());
        } else {
            x.getTableSource().accept((SQLASTVisitor)this);
        }
        if (x.getWhere() != null) {
            this.println();
            ++this.indentCount;
            this.print0(this.ucase ? "WHERE " : "where ");
            x.getWhere().accept((SQLASTVisitor)this);
            --this.indentCount;
        }
        if (x.getReturning() != null) {
            this.println();
            x.getReturning().accept((SQLASTVisitor)this);
        }
        return false;
    }

    public boolean visit(OracleIntervalExpr x) {
        SQLExpr value = x.getValue();
        if (value instanceof SQLLiteralExpr || value instanceof SQLVariantRefExpr) {
            this.print0(this.ucase ? "INTERVAL " : "interval ");
            value.accept((SQLASTVisitor)this);
            this.print(' ');
        } else {
            this.print('(');
            value.accept((SQLASTVisitor)this);
            this.print0(") ");
        }
        this.print0(x.getType().name());
        if (x.getPrecision() != null) {
            this.print('(');
            this.printExpr(x.getPrecision(), this.parameterized);
            if (x.getFactionalSecondsPrecision() != null) {
                this.print0(", ");
                this.print(x.getFactionalSecondsPrecision().intValue());
            }
            this.print(')');
        }
        if (x.getToType() != null) {
            this.print0(this.ucase ? " TO " : " to ");
            this.print0(x.getToType().name());
            if (x.getToFactionalSecondsPrecision() != null) {
                this.print('(');
                this.printExpr(x.getToFactionalSecondsPrecision(), this.parameterized);
                this.print(')');
            }
        }
        return false;
    }

    public boolean visit(OracleOuterExpr x) {
        x.getExpr().accept((SQLASTVisitor)this);
        this.print0("(+)");
        return false;
    }

    public boolean visit(SQLScriptCommitStatement astNode) {
        this.print('/');
        this.println();
        return false;
    }

    public boolean visit(SQLSelect x) {
        SQLOrderBy orderBy;
        SQLWithSubqueryClause with = x.getWithSubQuery();
        if (with != null) {
            with.accept((SQLASTVisitor)this);
            this.println();
        }
        SQLSelectQuery query = x.getQuery();
        query.accept((SQLASTVisitor)this);
        if (x.getRestriction() != null) {
            this.println();
            this.print("WITH ");
            x.getRestriction().accept((SQLASTVisitor)this);
        }
        if ((orderBy = x.getOrderBy()) != null) {
            boolean hasFirst = false;
            if (query instanceof SQLSelectQueryBlock) {
                SQLSelectQueryBlock queryBlock = (SQLSelectQueryBlock)query;
                boolean bl = hasFirst = queryBlock.getFirst() != null;
            }
            if (!hasFirst) {
                this.println();
                orderBy.accept((SQLASTVisitor)this);
            }
        }
        return false;
    }

    public boolean visit(OracleSelectJoin x) {
        x.getLeft().accept((SQLASTVisitor)this);
        SQLTableSource right = x.getRight();
        if (x.getJoinType() == SQLJoinTableSource.JoinType.COMMA) {
            this.print0(", ");
            x.getRight().accept((SQLASTVisitor)this);
        } else {
            boolean isRoot = x.getParent() instanceof SQLSelectQueryBlock;
            if (isRoot) {
                ++this.indentCount;
            }
            this.println();
            this.print0(this.ucase ? x.getJoinType().name : x.getJoinType().nameLCase);
            this.print(' ');
            if (right instanceof SQLJoinTableSource) {
                this.print('(');
                this.incrementIndent();
                this.println();
                right.accept((SQLASTVisitor)this);
                this.decrementIndent();
                this.println();
                this.print(')');
            } else {
                right.accept((SQLASTVisitor)this);
            }
            if (isRoot) {
                --this.indentCount;
            }
            if (x.getCondition() != null) {
                this.print0(this.ucase ? " ON " : " on ");
                this.incrementIndent();
                x.getCondition().accept((SQLASTVisitor)this);
                this.decrementIndent();
                this.print(' ');
            }
            if (x.getUsing().size() > 0) {
                this.print0(this.ucase ? " USING (" : " using (");
                this.printAndAccept(x.getUsing(), ", ");
                this.print(')');
            }
            this.printFlashback(x.getFlashback());
        }
        OracleSelectPivotBase pivot = x.getPivot();
        if (pivot != null) {
            this.println();
            pivot.accept((SQLASTVisitor)this);
        }
        return false;
    }

    public boolean visit(SQLSelectOrderByItem x) {
        x.getExpr().accept((SQLASTVisitor)this);
        if (x.getType() != null) {
            this.print(' ');
            String typeName = x.getType().name();
            this.print0(this.ucase ? typeName.toUpperCase() : typeName.toLowerCase());
        }
        if (x.getNullsOrderType() != null) {
            this.print(' ');
            this.print0(x.getNullsOrderType().toFormalString());
        }
        return false;
    }

    public boolean visit(OracleSelectPivot.Item x) {
        x.getExpr().accept((SQLASTVisitor)this);
        if (x.getAlias() != null && x.getAlias().length() > 0) {
            this.print0(this.ucase ? " AS " : " as ");
            this.print0(x.getAlias());
        }
        return false;
    }

    public boolean visit(SQLSelectQueryBlock select) {
        if (select instanceof OracleSelectQueryBlock) {
            return this.visit((OracleSelectQueryBlock)select);
        }
        return super.visit(select);
    }

    public boolean visit(OracleSelectRestriction.CheckOption x) {
        this.print0(this.ucase ? "CHECK OPTION" : "check option");
        if (x.getConstraint() != null) {
            this.print0(this.ucase ? " CONSTRAINT" : " constraint");
            this.print(' ');
            x.getConstraint().accept((SQLASTVisitor)this);
        }
        return false;
    }

    public boolean visit(OracleSelectRestriction.ReadOnly x) {
        this.print0(this.ucase ? "READ ONLY" : "read only");
        if (x.getConstraint() != null) {
            this.print0(this.ucase ? " CONSTRAINT" : " constraint");
            this.print(' ');
            x.getConstraint().accept((SQLASTVisitor)this);
        }
        return false;
    }

    public boolean visit(OracleSelectSubqueryTableSource x) {
        this.print('(');
        ++this.indentCount;
        this.println();
        x.getSelect().accept((SQLASTVisitor)this);
        --this.indentCount;
        this.println();
        this.print(')');
        OracleSelectPivotBase pivot = x.getPivot();
        if (pivot != null) {
            this.println();
            pivot.accept((SQLASTVisitor)this);
        }
        this.printFlashback(x.getFlashback());
        if (x.getAlias() != null && x.getAlias().length() != 0) {
            this.print0(" AS ");
            this.print0(x.getAlias());
        } else {
            this.print0(" AS XXX ");
        }
        return false;
    }

    public boolean visit(SQLExprTableSource x) {
        this.printTableSourceExpr(x.getExpr());
        SQLTableSampling sampling = x.getSampling();
        if (sampling != null) {
            this.print(' ');
            sampling.accept((SQLASTVisitor)this);
        }
        String alias = x.getAlias();
        List columns = x.getColumnsDirect();
        if (alias != null) {
            this.print(' ');
            if (columns != null && columns.size() > 0) {
                this.print0(this.ucase ? " AS " : " as ");
            } else if (x.getParent() instanceof SQLInsertStatement) {
                this.print0(this.ucase ? " AS " : " as ");
            }
            this.print0(alias);
        }
        if (columns != null && columns.size() > 0) {
            this.print(" (");
            this.printAndAccept(columns, ", ");
            this.print(')');
        }
        if (this.isPrettyFormat() && x.hasAfterComment()) {
            this.print(' ');
            this.printlnComment(x.getAfterCommentsDirect());
        }
        return false;
    }

    public boolean visit(OracleSelectTableReference x) {
        super.visit(x);
        if (x.getHints().size() > 0) {
            this.printHints(x.getHints());
        }
        if (x.getSampleClause() != null) {
            this.print(' ');
            x.getSampleClause().accept((SQLASTVisitor)this);
        }
        this.printFlashback(x.getFlashback());
        this.printAlias(x.getAlias());
        return false;
    }

    private void printFlashback(SQLExpr flashback) {
        if (flashback == null) {
            return;
        }
        this.println();
        if (flashback instanceof SQLBetweenExpr) {
            flashback.accept((SQLASTVisitor)this);
        } else {
            this.print0(this.ucase ? "AS OF " : "as of ");
            flashback.accept((SQLASTVisitor)this);
        }
    }

    public boolean visit(PartitionExtensionClause x) {
        if (x.isSubPartition()) {
            this.print0(this.ucase ? "SUBPARTITION " : "subpartition ");
        } else {
            this.print0(this.ucase ? "PARTITION " : "partition ");
        }
        if (x.getPartition() != null) {
            this.print('(');
            x.getPartition().accept((SQLASTVisitor)this);
            this.print(')');
        } else {
            this.print0(this.ucase ? "FOR (" : "for (");
            this.printAndAccept(x.getFor(), ",");
            this.print(')');
        }
        return false;
    }

    public boolean visit(OracleBinaryFloatExpr x) {
        if (x != null && x.getValue() != null) {
            this.print0(x.getValue().toString());
            this.print('F');
        }
        return false;
    }

    public boolean visit(ModelClause.ReturnRowsClause x) {
        if (x.isAll()) {
            this.print0(this.ucase ? "RETURN ALL ROWS" : "return all rows");
        } else {
            this.print0(this.ucase ? "RETURN UPDATED ROWS" : "return updated rows");
        }
        return false;
    }

    public boolean visit(ModelClause x) {
        this.print0(this.ucase ? "MODEL" : "model");
        ++this.indentCount;
        for (ModelClause.CellReferenceOption opt : x.getCellReferenceOptions()) {
            this.print(' ');
            this.print0(opt.name);
        }
        if (x.getReturnRowsClause() != null) {
            this.print(' ');
            x.getReturnRowsClause().accept((SQLASTVisitor)this);
        }
        for (ModelClause.ReferenceModelClause item : x.getReferenceModelClauses()) {
            this.print(' ');
            item.accept((SQLASTVisitor)this);
        }
        x.getMainModel().accept((SQLASTVisitor)this);
        --this.indentCount;
        return false;
    }

    public boolean visit(ModelClause.MainModelClause x) {
        if (x.getMainModelName() != null) {
            this.print0(this.ucase ? " MAIN " : " main ");
            x.getMainModelName().accept((SQLASTVisitor)this);
        }
        this.println();
        x.getModelColumnClause().accept((SQLASTVisitor)this);
        for (ModelClause.CellReferenceOption opt : x.getCellReferenceOptions()) {
            this.println();
            this.print0(opt.name);
        }
        this.println();
        x.getModelRulesClause().accept((SQLASTVisitor)this);
        return false;
    }

    public boolean visit(ModelClause.QueryPartitionClause x) {
        this.print0(this.ucase ? "PARTITION BY (" : "partition by (");
        this.printAndAccept(x.getExprList(), ", ");
        this.print(')');
        return false;
    }

    public boolean visit(ModelClause.ModelColumn x) {
        x.getExpr().accept((SQLASTVisitor)this);
        if (x.getAlias() != null) {
            this.print(' ');
            this.print0(x.getAlias());
        }
        return false;
    }

    public boolean visit(ModelClause.CellAssignment x) {
        x.getMeasureColumn().accept((SQLASTVisitor)this);
        this.print0("[");
        this.printAndAccept(x.getConditions(), ", ");
        this.print0("]");
        return false;
    }

    public boolean visit(OracleMultiInsertStatement x) {
        this.print0(this.ucase ? "INSERT " : "insert ");
        if (x.getHints().size() > 0) {
            this.printHints(x.getHints());
        }
        if (x.getOption() != null) {
            this.print0(x.getOption().name());
            this.print(' ');
        }
        int size = x.getEntries().size();
        for (int i = 0; i < size; ++i) {
            ++this.indentCount;
            this.println();
            ((OracleMultiInsertStatement.Entry)x.getEntries().get(i)).accept((SQLASTVisitor)this);
            --this.indentCount;
        }
        this.println();
        x.getSubQuery().accept((SQLASTVisitor)this);
        return false;
    }

    public boolean visit(OracleLockTableStatement x) {
        this.print0(this.ucase ? "LOCK TABLE " : "lock table ");
        x.getTable().accept((SQLASTVisitor)this);
        if (x.getPartition() != null) {
            this.print0(" PARTITION (");
            x.getPartition().accept((SQLASTVisitor)this);
            this.print0(") ");
        }
        this.print0(this.ucase ? " IN " : " in ");
        this.print0(x.getLockMode().toString());
        this.print0(this.ucase ? " MODE " : " mode ");
        if (x.isNoWait()) {
            this.print0(this.ucase ? "NOWAIT" : "nowait");
        } else if (x.getWait() != null) {
            this.print0(this.ucase ? "WAIT " : "wait ");
            x.getWait().accept((SQLASTVisitor)this);
        }
        return false;
    }

    public boolean visit(OracleDatetimeExpr x) {
        x.getExpr().accept((SQLASTVisitor)this);
        SQLExpr timeZone = x.getTimeZone();
        if (timeZone instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)timeZone).getName().equalsIgnoreCase("LOCAL")) {
            this.print0(this.ucase ? " AT LOCAL" : "alter session set ");
            return false;
        }
        this.print0(this.ucase ? " AT TIME ZONE " : " at time zone ");
        timeZone.accept((SQLASTVisitor)this);
        return false;
    }

    public boolean visit(OracleSysdateExpr x) {
        this.print0(this.ucase ? "SYSDATE" : "sysdate");
        if (x.getOption() != null) {
            this.print('@');
            this.print0(x.getOption());
        }
        return false;
    }

    public boolean visit(OracleExceptionStatement.Item x) {
        this.print0(this.ucase ? "WHEN " : "when ");
        if (MotionEtlGlobalCtx.getInstance().isExceptionVar(x.getWhen().toString())) {
            this.print0("LOGIN_DENIED");
        } else {
            x.getWhen().accept((SQLASTVisitor)this);
        }
        this.print0(this.ucase ? " THEN" : " then");
        ++this.indentCount;
        if (x.getStatements().size() > 1) {
            this.println();
        } else if (x.getStatements().size() == 1 && x.getStatements().get(0) instanceof SQLIfStatement) {
            this.println();
        } else {
            this.print(' ');
        }
        int size = x.getStatements().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0 && size > 1) {
                this.println();
            }
            SQLStatement stmt = (SQLStatement)x.getStatements().get(i);
            stmt.accept((SQLASTVisitor)this);
        }
        --this.indentCount;
        return false;
    }

    public boolean visit(OracleExceptionStatement x) {
        this.print0(this.ucase ? "EXCEPTION" : "exception");
        ++this.indentCount;
        List items = x.getItems();
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            this.println();
            OracleExceptionStatement.Item item = (OracleExceptionStatement.Item)items.get(i);
            item.accept((SQLASTVisitor)this);
        }
        --this.indentCount;
        return false;
    }

    public boolean visit(OracleArgumentExpr x) {
        this.print0(x.getArgumentName());
        this.print0(" => ");
        x.getValue().accept((SQLASTVisitor)this);
        return false;
    }

    public boolean visit(OracleSetTransactionStatement x) {
        if (x.isReadOnly()) {
            this.print0(this.ucase ? "SET TRANSACTION READ ONLY" : "set transaction read only");
        } else {
            this.print0(this.ucase ? "SET TRANSACTION" : "set transaction");
        }
        SQLExpr name = x.getName();
        if (name != null) {
            this.print0(this.ucase ? " NAME " : " name ");
            name.accept((SQLASTVisitor)this);
        }
        return false;
    }

    public boolean visit(OracleExplainStatement x) {
        this.print0(this.ucase ? "EXPLAIN PLAN" : "explain plan");
        ++this.indentCount;
        this.println();
        if (x.getStatementId() != null) {
            this.print0(this.ucase ? "SET STATEMENT_ID = " : "set statement_id = ");
            x.getStatementId().accept((SQLASTVisitor)this);
            this.println();
        }
        if (x.getInto() != null) {
            this.print0(this.ucase ? "INTO " : "into ");
            x.getInto().accept((SQLASTVisitor)this);
            this.println();
        }
        this.print0(this.ucase ? "FOR" : "for");
        this.println();
        x.getStatement().accept((SQLASTVisitor)this);
        --this.indentCount;
        return false;
    }

    public boolean visit(SQLAlterProcedureStatement x) {
        this.print0(this.ucase ? "ALTER PROCEDURE " : "alter procedure ");
        x.getName().accept((SQLASTVisitor)this);
        if (x.isCompile()) {
            this.print0(this.ucase ? " COMPILE" : " compile");
        }
        if (x.isReuseSettings()) {
            this.print0(this.ucase ? " REUSE SETTINGS" : " reuse settings");
        }
        return false;
    }

    public boolean visit(OracleAlterTableDropPartition x) {
        this.print0(this.ucase ? "DROP PARTITION " : "drop partition ");
        x.getName().accept((SQLASTVisitor)this);
        return false;
    }

    public boolean visit(SQLAlterTableStatement x) {
        SQLAlterTableItem item;
        if (x.getItems().size() == 1 && (item = (SQLAlterTableItem)x.getItems().get(0)) instanceof SQLAlterTableRename) {
            SQLExpr to = ((SQLAlterTableRename)item).getTo().getExpr();
            this.print0(this.ucase ? "RENAME " : "rename ");
            x.getName().accept((SQLASTVisitor)this);
            this.print0(this.ucase ? " TO " : " to ");
            to.accept((SQLASTVisitor)this);
            return false;
        }
        this.print0(this.ucase ? "ALTER TABLE " : "alter table ");
        this.printTableSourceExpr((SQLExpr)x.getName());
        ++this.indentCount;
        for (SQLAlterTableItem item2 : x.getItems()) {
            this.println();
            item2.accept((SQLASTVisitor)this);
        }
        if (x.isUpdateGlobalIndexes()) {
            this.println();
            this.print0(this.ucase ? "UPDATE GLOABL INDEXES" : "update gloabl indexes");
        }
        --this.indentCount;
        return false;
    }

    public boolean visit(OracleAlterTableTruncatePartition x) {
        this.print0(this.ucase ? "TRUNCATE PARTITION " : "truncate partition ");
        x.getName().accept((SQLASTVisitor)this);
        return false;
    }

    public boolean visit(OracleAlterTableSplitPartition.TableSpaceItem x) {
        this.print0(this.ucase ? "TABLESPACE " : "tablespace ");
        x.getTablespace().accept((SQLASTVisitor)this);
        return false;
    }

    public boolean visit(OracleAlterTableSplitPartition.UpdateIndexesClause x) {
        this.print0(this.ucase ? "UPDATE INDEXES" : "update indexes");
        if (x.getItems().size() > 0) {
            this.print('(');
            this.printAndAccept(x.getItems(), ", ");
            this.print(')');
        }
        return false;
    }

    public boolean visit(OracleAlterTableSplitPartition x) {
        this.print0(this.ucase ? "SPLIT PARTITION " : "split partition ");
        x.getName().accept((SQLASTVisitor)this);
        if (x.getAt().size() > 0) {
            ++this.indentCount;
            this.println();
            this.print0(this.ucase ? "AT (" : "at (");
            this.printAndAccept(x.getAt(), ", ");
            this.print(')');
            --this.indentCount;
        }
        if (x.getInto().size() > 0) {
            this.println();
            ++this.indentCount;
            this.print0(this.ucase ? "INTO (" : "into (");
            this.printAndAccept(x.getInto(), ", ");
            this.print(')');
            --this.indentCount;
        }
        if (x.getUpdateIndexes() != null) {
            this.println();
            ++this.indentCount;
            x.getUpdateIndexes().accept((SQLASTVisitor)this);
            --this.indentCount;
        }
        return false;
    }

    public boolean visit(OracleAlterTableSplitPartition.NestedTablePartitionSpec x) {
        this.print0(this.ucase ? "PARTITION " : "partition ");
        x.getPartition().accept((SQLASTVisitor)this);
        for (SQLObject item : x.getSegmentAttributeItems()) {
            this.print(' ');
            item.accept((SQLASTVisitor)this);
        }
        return false;
    }

    public boolean visit(OracleAlterTableModify x) {
        this.print0(this.ucase ? "MODIFY (" : "modify (");
        ++this.indentCount;
        int size = x.getColumns().size();
        for (int i = 0; i < size; ++i) {
            this.println();
            SQLColumnDefinition column = (SQLColumnDefinition)x.getColumns().get(i);
            column.accept((SQLASTVisitor)this);
            if (i == size - 1) continue;
            this.print0(", ");
        }
        --this.indentCount;
        this.println();
        this.print(')');
        return false;
    }

    public boolean visit(OracleCreateIndexStatement x) {
        List globalPartitions;
        this.print0(this.ucase ? "CREATE " : "create ");
        if (UNIQUE.equals(x.getType())) {
            this.print0(x.getType());
            this.print(' ');
        }
        this.print0(this.ucase ? "INDEX " : "index ");
        x.getName().accept((SQLASTVisitor)this);
        this.print0(this.ucase ? " ON " : " on ");
        if (x.isCluster()) {
            this.print0(this.ucase ? "CLUSTER " : "cluster ");
        }
        x.getTable().accept((SQLASTVisitor)this);
        List items = x.getItems();
        if (items.size() > 0) {
            this.print('(');
            this.printAndAccept(items, ", ");
            this.print(')');
        }
        if (x.isIndexOnlyTopLevel()) {
            this.println();
            this.print0(this.ucase ? "INDEX ONLY TOPLEVEL" : "index only toplevel");
        }
        if (x.isComputeStatistics()) {
            this.println();
            this.print0(this.ucase ? "COMPUTE STATISTICS" : "compute statistics");
        }
        if (x.isReverse()) {
            this.println();
            this.print0(this.ucase ? "REVERSE" : "reverse");
        }
        this.printOracleSegmentAttributes((OracleSegmentAttributes)x);
        if (x.isOnline()) {
            this.print0(this.ucase ? " ONLINE" : " online");
        }
        if (x.isNoParallel()) {
            this.print0(this.ucase ? " NOPARALLEL" : " noparallel");
        } else if (x.getParallel() != null) {
            this.print0(this.ucase ? " PARALLEL " : " parallel ");
            x.getParallel().accept((SQLASTVisitor)this);
        }
        Boolean sort = x.getSort();
        if (sort != null) {
            if (sort.booleanValue()) {
                this.print0(this.ucase ? " SORT" : " sort");
            } else {
                this.print0(this.ucase ? " NOSORT" : " nosort");
            }
        }
        if (x.getLocalPartitions().size() > 0) {
            this.println();
            this.print0(this.ucase ? "LOCAL (" : "local (");
            ++this.indentCount;
            this.println();
            this.printlnAndAccept(x.getLocalPartitions(), ",");
            --this.indentCount;
            this.println();
            this.print(')');
        } else if (x.isLocal()) {
            this.print0(this.ucase ? " LOCAL" : " local");
        }
        List localStoreIn = x.getLocalStoreIn();
        if (localStoreIn.size() > 0) {
            this.print0(this.ucase ? " STORE IN (" : " store in (");
            this.printAndAccept(localStoreIn, ", ");
            this.print(')');
        }
        if ((globalPartitions = x.getGlobalPartitions()).size() > 0) {
            for (SQLPartitionBy globalPartition : globalPartitions) {
                this.println();
                this.print0(this.ucase ? "GLOBAL " : "global ");
                this.print0(this.ucase ? "PARTITION BY " : "partition by ");
                globalPartition.accept((SQLASTVisitor)this);
            }
        } else if (x.isGlobal()) {
            this.print0(this.ucase ? " GLOBAL" : " global");
        }
        return false;
    }

    public boolean visit(OracleForStatement x) {
        boolean all = x.isAll();
        if (all) {
            this.print0(this.ucase ? "FORALL " : "forall ");
        } else {
            this.print0(this.ucase ? "FOR " : "for ");
        }
        x.getIndex().accept((SQLASTVisitor)this);
        this.print0(this.ucase ? " IN " : " in ");
        SQLExpr range = x.getRange();
        range.accept((SQLASTVisitor)this);
        super.visit(x);
        return false;
    }

    public boolean visit(OracleRangeExpr x) {
        x.getLowBound().accept((SQLASTVisitor)this);
        this.print0("..");
        x.getUpBound().accept((SQLASTVisitor)this);
        return false;
    }

    protected void visitColumnDefault(SQLColumnDefinition x) {
        if (x.getParent() instanceof SQLBlockStatement) {
            this.print0(" := ");
        } else {
            this.print0(this.ucase ? " DEFAULT " : " default ");
        }
        this.printExpr(x.getDefaultExpr(), false);
    }

    public boolean visit(OraclePrimaryKey x) {
        if (x.getName() != null) {
            this.print0(this.ucase ? "CONSTRAINT " : "constraint ");
            x.getName().accept((SQLASTVisitor)this);
            this.print(' ');
        }
        this.print0(this.ucase ? "PRIMARY KEY (" : "primary key (");
        this.printAndAccept(x.getColumns(), ", ");
        this.print(')');
        Boolean rely = x.getRely();
        if (rely != null && rely.booleanValue()) {
            this.print0(this.ucase ? " RELY" : " rely");
        }
        this.printConstraintState((OracleConstraint)x);
        Boolean validate = x.getValidate();
        if (validate != null) {
            if (validate.booleanValue()) {
                this.print0(this.ucase ? " VALIDATE" : " validate");
            } else {
                this.print0(this.ucase ? " NOVALIDATE" : " novalidate");
            }
        }
        return false;
    }

    protected void printConstraintState(OracleConstraint x) {
        Boolean enable;
        ++this.indentCount;
        if (x.getUsing() != null) {
            this.println();
            x.getUsing().accept((SQLASTVisitor)this);
        }
        if (x.getExceptionsInto() != null) {
            this.println();
            this.print0(this.ucase ? "EXCEPTIONS INTO " : "exceptions into ");
            x.getExceptionsInto().accept((SQLASTVisitor)this);
        }
        if ((enable = x.getEnable()) != null) {
            if (enable.booleanValue()) {
                this.print0(this.ucase ? " ENABLE" : " enable");
            } else {
                this.print0(this.ucase ? " DISABLE" : " disable");
            }
        }
        if (x.getInitially() != null) {
            this.print0(this.ucase ? " INITIALLY " : " initially ");
            this.print0(x.getInitially().name());
        }
        if (x.getDeferrable() != null) {
            if (x.getDeferrable().booleanValue()) {
                this.print0(this.ucase ? " DEFERRABLE" : " deferrable");
            } else {
                this.print0(this.ucase ? " NOT DEFERRABLE" : " not deferrable");
            }
        }
        --this.indentCount;
    }

    public boolean visit(OracleCreateTableStatement x) {
        SQLSelect select;
        OracleXmlColumnProperties xmlTypeColumnProperties;
        OracleCreateTableStatement.Organization organization;
        OracleCreateTableStatement.OIDIndex oidIndex;
        this.printCreateTable((SQLCreateTableStatement)x, false);
        if (x.getOf() != null) {
            this.println();
            this.print0(this.ucase ? "OF " : "of ");
            x.getOf().accept((SQLASTVisitor)this);
        }
        if ((oidIndex = x.getOidIndex()) != null) {
            this.println();
            oidIndex.accept((SQLASTVisitor)this);
        }
        if ((organization = x.getOrganization()) != null) {
            this.println();
            ++this.indentCount;
            organization.accept((SQLASTVisitor)this);
            --this.indentCount;
        }
        if (x.getIncluding().size() > 0) {
            this.print0(this.ucase ? " INCLUDING " : " including ");
            this.printAndAccept(x.getIncluding(), ", ");
            this.print0(this.ucase ? " OVERFLOW " : " overflow ");
        }
        this.printOracleSegmentAttributes((OracleSegmentAttributes)x);
        if (x.isInMemoryMetadata()) {
            this.println();
            this.print0(this.ucase ? "IN_MEMORY_METADATA" : "in_memory_metadata");
        }
        if (x.isCursorSpecificSegment()) {
            this.println();
            this.print0(this.ucase ? "CURSOR_SPECIFIC_SEGMENT" : "cursor_specific_segment");
        }
        if (x.getParallel() == Boolean.TRUE) {
            this.println();
            this.print0(this.ucase ? "PARALLEL" : "parallel");
            SQLExpr parallelValue = x.getParallelValue();
            if (parallelValue != null) {
                this.print(' ');
                this.printExpr(parallelValue);
            }
        } else if (x.getParallel() == Boolean.FALSE) {
            this.println();
            this.print0(this.ucase ? "NOPARALLEL" : "noparallel");
        }
        if (x.getCache() == Boolean.TRUE) {
            this.println();
            this.print0(this.ucase ? "CACHE" : "cache");
        } else if (x.getCache() == Boolean.FALSE) {
            this.println();
            this.print0(this.ucase ? "NOCACHE" : "nocache");
        }
        if (x.getLobStorage() != null) {
            this.println();
            x.getLobStorage().accept((SQLASTVisitor)this);
        }
        if (x.isOnCommitPreserveRows()) {
            this.println();
            this.print0(this.ucase ? "ON COMMIT PRESERVE ROWS" : "on commit preserve rows");
        } else if (x.isOnCommitDeleteRows()) {
            this.println();
            this.print0(this.ucase ? "ON COMMIT DELETE ROWS" : "on commit delete rows");
        }
        if (x.isMonitoring()) {
            this.println();
            this.print0(this.ucase ? "MONITORING" : "monitoring");
        }
        if (x.getPartitioning() != null) {
            this.println();
            this.print0(this.ucase ? "PARTITION BY " : "partition by ");
            x.getPartitioning().accept((SQLASTVisitor)this);
        }
        if (x.getCluster() != null) {
            this.println();
            this.print0(this.ucase ? "CLUSTER " : "cluster ");
            x.getCluster().accept((SQLASTVisitor)this);
            this.print0(" (");
            this.printAndAccept(x.getClusterColumns(), ",");
            this.print0(")");
        }
        if ((xmlTypeColumnProperties = x.getXmlTypeColumnProperties()) != null) {
            this.println();
            xmlTypeColumnProperties.accept((SQLASTVisitor)this);
        }
        if ((select = x.getSelect()) != null) {
            this.println();
            this.print0(this.ucase ? "AS" : "as");
            this.println();
            select.accept((SQLASTVisitor)this);
        }
        return false;
    }

    public boolean visit(OracleStorageClause x) {
        SQLExpr objno;
        SQLExpr bufferPool;
        SQLExpr freeListGroups;
        SQLExpr freeLists;
        SQLExpr maxSize;
        SQLExpr pctIncrease;
        SQLExpr maxExtents;
        SQLExpr minExtents;
        SQLExpr next;
        this.print0(this.ucase ? "STORAGE (" : "storage (");
        ++this.indentCount;
        SQLExpr initial = x.getInitial();
        if (initial != null) {
            this.println();
            this.print0(this.ucase ? "INITIAL " : "initial ");
            this.printExpr(initial, false);
        }
        if ((next = x.getNext()) != null) {
            this.println();
            this.print0(this.ucase ? "NEXT " : "next ");
            this.printExpr(next, false);
        }
        if ((minExtents = x.getMinExtents()) != null) {
            this.println();
            this.print0(this.ucase ? "MINEXTENTS " : "minextents ");
            this.printExpr(minExtents, false);
        }
        if ((maxExtents = x.getMaxExtents()) != null) {
            this.println();
            this.print0(this.ucase ? "MAXEXTENTS " : "maxextents ");
            this.printExpr(maxExtents, false);
        }
        if ((pctIncrease = x.getPctIncrease()) != null) {
            this.println();
            this.print0(this.ucase ? "PCTINCREASE " : "pctincrease ");
            this.printExpr(pctIncrease, false);
        }
        if ((maxSize = x.getMaxSize()) != null) {
            this.println();
            this.print0(this.ucase ? "MAXSIZE " : "maxsize ");
            this.printExpr(maxSize, false);
        }
        if ((freeLists = x.getFreeLists()) != null) {
            this.println();
            this.print0(this.ucase ? "FREELISTS " : "freelists ");
            this.printExpr(freeLists, false);
        }
        if ((freeListGroups = x.getFreeListGroups()) != null) {
            this.println();
            this.print0(this.ucase ? "FREELIST GROUPS " : "freelist groups ");
            this.printExpr(freeListGroups, false);
        }
        if ((bufferPool = x.getBufferPool()) != null) {
            this.println();
            this.print0(this.ucase ? "BUFFER_POOL " : "buffer_pool ");
            this.printExpr(bufferPool, false);
        }
        if ((objno = x.getObjno()) != null) {
            this.println();
            this.print0(this.ucase ? "OBJNO " : "objno ");
            this.printExpr(objno, false);
        }
        if (x.getFlashCache() != null) {
            this.println();
            this.print0(this.ucase ? "FLASH_CACHE " : "flash_cache ");
            this.print0(this.ucase ? x.getFlashCache().name() : x.getFlashCache().name().toLowerCase());
        }
        if (x.getCellFlashCache() != null) {
            this.println();
            this.print0(this.ucase ? "CELL_FLASH_CACHE " : "cell_flash_cache ");
            this.print0(this.ucase ? x.getCellFlashCache().name() : x.getCellFlashCache().name().toLowerCase());
        }
        --this.indentCount;
        this.println();
        this.print(')');
        return false;
    }

    public boolean visit(OracleAlterTableMoveTablespace x) {
        this.print0(this.ucase ? " MOVE TABLESPACE " : " move tablespace ");
        x.getName().accept((SQLASTVisitor)this);
        return false;
    }

    public boolean visit(OracleFileSpecification x) {
        this.printAndAccept(x.getFileNames(), ", ");
        if (x.getSize() != null) {
            this.print0(this.ucase ? " SIZE " : " size ");
            x.getSize().accept((SQLASTVisitor)this);
        }
        if (x.isAutoExtendOff()) {
            this.print0(this.ucase ? " AUTOEXTEND OFF" : " autoextend off");
        } else if (x.getAutoExtendOn() != null) {
            this.print0(this.ucase ? " AUTOEXTEND ON " : " autoextend on ");
            x.getAutoExtendOn().accept((SQLASTVisitor)this);
        }
        return false;
    }

    public boolean visit(OracleAlterTablespaceAddDataFile x) {
        this.print0(this.ucase ? "ADD DATAFILE" : "add datafile");
        ++this.indentCount;
        for (OracleFileSpecification file : x.getFiles()) {
            this.println();
            file.accept((SQLASTVisitor)this);
        }
        --this.indentCount;
        return false;
    }

    public boolean visit(OracleAlterTablespaceStatement x) {
        this.print0(this.ucase ? "ALTER TABLESPACE " : "alter tablespace ");
        x.getName().accept((SQLASTVisitor)this);
        this.println();
        x.getItem().accept((SQLASTVisitor)this);
        return false;
    }

    public boolean visit(SQLTruncateStatement x) {
        this.print0(this.ucase ? "TRUNCATE TABLE " : "truncate table ");
        this.printAndAccept(x.getTableSources(), ", ");
        if (x.isPurgeSnapshotLog()) {
            this.print0(this.ucase ? " PURGE SNAPSHOT LOG" : " purge snapshot log");
        }
        return false;
    }

    public boolean visit(OracleExitStatement x) {
        this.print0(this.ucase ? "EXIT" : "exit");
        if (x.getLabel() != null) {
            this.print(' ');
            this.print0(x.getLabel());
        }
        if (x.getWhen() != null) {
            this.print0(this.ucase ? " WHEN " : " when ");
            x.getWhen().accept((SQLASTVisitor)this);
        }
        return false;
    }

    public boolean visit(OracleRaiseStatement x) {
        this.print0(this.ucase ? "RAISE" : "raise");
        if (x.getException() != null) {
            if (MotionEtlGlobalCtx.getInstance().isExceptionVar(x.getException().toString())) {
                this.print0(" LOGIN_DENIED; ");
                return false;
            }
            this.print(' ');
            x.getException().accept((SQLASTVisitor)this);
        }
        this.print(';');
        return false;
    }

    public boolean visit(SQLSavePointStatement x) {
        this.print0(this.ucase ? "SAVEPOINT" : "savepoint");
        if (x.getName() != null) {
            this.print0(this.ucase ? " TO " : " to ");
            x.getName().accept((SQLASTVisitor)this);
        }
        return false;
    }

    public boolean visit(SQLCreateFunctionStatement x) {
        SQLName using;
        SQLStatement block;
        SQLName authid;
        String wrappedSource;
        boolean create = x.isCreate();
        if (!create) {
            this.print0(this.ucase ? "FUNCTION " : "function ");
        } else if (x.isOrReplace()) {
            this.print0(this.ucase ? "CREATE OR REPLACE FUNCTION " : "create or replace function ");
        } else {
            this.print0(this.ucase ? "CREATE FUNCTION " : "create function ");
        }
        x.getName().accept((SQLASTVisitor)this);
        int paramSize = x.getParameters().size();
        if (paramSize > 0) {
            this.print0(" (");
            ++this.indentCount;
            this.println();
            for (int i = 0; i < paramSize; ++i) {
                if (i != 0) {
                    this.print0(", ");
                    this.println();
                }
                SQLParameter param = (SQLParameter)x.getParameters().get(i);
                param.accept((SQLASTVisitor)this);
            }
            --this.indentCount;
            this.println();
            this.print(')');
        }
        if ((wrappedSource = x.getWrappedSource()) != null) {
            this.print0(this.ucase ? " WRAPPED " : " wrapped ");
            this.print0(wrappedSource);
            if (x.isAfterSemi()) {
                this.print(';');
            }
            return false;
        }
        this.println();
        this.print(this.ucase ? "RETURN " : "return ");
        x.getReturnDataType().accept((SQLASTVisitor)this);
        if (x.isPipelined()) {
            this.print(this.ucase ? "PIPELINED " : "pipelined ");
        }
        if (x.isDeterministic()) {
            this.print(this.ucase ? "DETERMINISTIC " : "deterministic ");
        }
        if ((authid = x.getAuthid()) != null) {
            this.print(this.ucase ? " AUTHID " : " authid ");
            authid.accept((SQLASTVisitor)this);
        }
        if ((block = x.getBlock()) != null && create) {
            this.println();
            this.println("IS");
        } else {
            SQLBlockStatement blockStatement;
            this.println();
            if (block instanceof SQLBlockStatement && ((blockStatement = (SQLBlockStatement)block).getParameters().size() > 0 || authid != null)) {
                this.println(this.ucase ? "AS" : "as");
            }
        }
        String javaCallSpec = x.getJavaCallSpec();
        if (javaCallSpec != null) {
            this.print0(this.ucase ? "LANGUAGE JAVA NAME '" : "language java name '");
            this.print0(javaCallSpec);
            this.print('\'');
            return false;
        }
        if (x.isParallelEnable()) {
            this.print0(this.ucase ? "PARALLEL_ENABLE" : "parallel_enable");
            this.println();
        }
        if (x.isAggregate()) {
            this.print0(this.ucase ? "AGGREGATE" : "aggregate");
            this.println();
        }
        if ((using = x.getUsing()) != null) {
            this.print0(this.ucase ? "USING " : "using ");
            using.accept((SQLASTVisitor)this);
        }
        if (block != null) {
            block.accept((SQLASTVisitor)this);
        }
        return false;
    }

    public boolean visit(OracleCreateDatabaseDbLinkStatement x) {
        this.print0(this.ucase ? "CREATE " : "create ");
        if (x.isShared()) {
            this.print0(this.ucase ? "SHARE " : "share ");
        }
        if (x.isPublic()) {
            this.print0(this.ucase ? "PUBLIC " : "public ");
        }
        this.print0(this.ucase ? "DATABASE LINK " : "database link ");
        x.getName().accept((SQLASTVisitor)this);
        if (x.getUser() != null) {
            this.print0(this.ucase ? " CONNECT TO " : " connect to ");
            x.getUser().accept((SQLASTVisitor)this);
            if (x.getPassword() != null) {
                this.print0(this.ucase ? " IDENTIFIED BY " : " identified by ");
                this.print0(x.getPassword());
            }
        }
        if (x.getAuthenticatedUser() != null) {
            this.print0(this.ucase ? " AUTHENTICATED BY " : " authenticated by ");
            x.getAuthenticatedUser().accept((SQLASTVisitor)this);
            if (x.getAuthenticatedPassword() != null) {
                this.print0(this.ucase ? " IDENTIFIED BY " : " identified by ");
                this.print0(x.getAuthenticatedPassword());
            }
        }
        if (x.getUsing() != null) {
            this.print0(this.ucase ? " USING " : " using ");
            x.getUsing().accept((SQLASTVisitor)this);
        }
        return false;
    }

    public boolean visit(OracleDropDbLinkStatement x) {
        this.print0(this.ucase ? "DROP " : "drop ");
        if (x.isPublic()) {
            this.print0(this.ucase ? "PUBLIC " : "public ");
        }
        this.print0(this.ucase ? "DATABASE LINK " : "database link ");
        x.getName().accept((SQLASTVisitor)this);
        return false;
    }

    public boolean visit(SQLCharacterDataType x) {
        this.print0(x.getName());
        List arguments = x.getArguments();
        if (arguments.size() > 0) {
            this.print('(');
            SQLExpr arg0 = (SQLExpr)arguments.get(0);
            this.printExpr(arg0, false);
            if (x.getCharType() != null) {
                this.print(' ');
                this.print0(x.getCharType());
            }
            this.print(')');
        }
        return false;
    }

    public boolean visit(OracleDataTypeIntervalYear x) {
        this.print0(x.getName());
        if (x.getArguments().size() > 0) {
            this.print('(');
            ((SQLExpr)x.getArguments().get(0)).accept((SQLASTVisitor)this);
            this.print(')');
        }
        this.print0(this.ucase ? " TO MONTH" : " to month");
        return false;
    }

    public boolean visit(OracleUsingIndexClause x) {
        this.print0(this.ucase ? "USING INDEX" : "using index");
        SQLObject index = x.getIndex();
        if (index != null) {
            this.print(' ');
            if (index instanceof SQLCreateIndexStatement) {
                this.print('(');
                index.accept((SQLASTVisitor)this);
                this.print(')');
            } else {
                index.accept((SQLASTVisitor)this);
            }
        }
        this.printOracleSegmentAttributes((OracleSegmentAttributes)x);
        if (x.isComputeStatistics()) {
            this.println();
            this.print0(this.ucase ? "COMPUTE STATISTICS" : "compute statistics");
        }
        if (x.getEnable() != null) {
            if (x.getEnable().booleanValue()) {
                this.println();
                this.print0(this.ucase ? "ENABLE" : "enable");
            } else {
                this.println();
                this.print0(this.ucase ? "DISABLE" : "disable");
            }
        }
        if (x.isReverse()) {
            this.println();
            this.print0(this.ucase ? "REVERSE" : "reverse");
        }
        return false;
    }

    public boolean visit(OracleLobStorageClause x) {
        SQLName segementName;
        this.print0(this.ucase ? "LOB (" : "lob (");
        this.printAndAccept(x.getItems(), ",");
        this.print0(this.ucase ? ") STORE AS" : ") store as");
        if (x.isSecureFile()) {
            this.print0(this.ucase ? " SECUREFILE" : " securefile");
        }
        if (x.isBasicFile()) {
            this.print0(this.ucase ? " BASICFILE" : " basicfile");
        }
        if ((segementName = x.getSegementName()) != null) {
            this.print(' ');
            segementName.accept((SQLASTVisitor)this);
        }
        this.print0(" (");
        ++this.indentCount;
        this.printOracleSegmentAttributes((OracleSegmentAttributes)x);
        if (x.getEnable() != null) {
            this.println();
            if (x.getEnable().booleanValue()) {
                this.print0(this.ucase ? "ENABLE STORAGE IN ROW" : "enable storage in row");
            } else {
                this.print0(this.ucase ? "DISABLE STORAGE IN ROW" : "disable storage in row");
            }
        }
        if (x.getChunk() != null) {
            this.println();
            this.print0(this.ucase ? "CHUNK " : "chunk ");
            x.getChunk().accept((SQLASTVisitor)this);
        }
        if (x.getCache() != null) {
            this.println();
            if (x.getCache().booleanValue()) {
                this.print0(this.ucase ? "CACHE" : "cache");
            } else {
                this.print0(this.ucase ? "NOCACHE" : "nocache");
            }
        }
        if (x.getKeepDuplicate() != null) {
            this.println();
            if (x.getKeepDuplicate().booleanValue()) {
                this.print0(this.ucase ? "KEEP_DUPLICATES" : "keep_duplicates");
            } else {
                this.print0(this.ucase ? "DEDUPLICATE" : "deduplicate");
            }
        }
        if (x.isRetention()) {
            this.println();
            this.print0(this.ucase ? "RETENTION" : "retention");
        }
        --this.indentCount;
        this.println();
        this.print(')');
        return false;
    }

    public boolean visit(OracleUnique x) {
        this.visit((SQLUnique)x);
        this.printConstraintState((OracleConstraint)x);
        return false;
    }

    public boolean visit(OracleForeignKey x) {
        this.visit((SQLForeignKeyImpl)x);
        this.printConstraintState((OracleConstraint)x);
        return false;
    }

    public boolean visit(OracleCheck x) {
        this.visit((SQLCheck)x);
        this.printConstraintState((OracleConstraint)x);
        return false;
    }

    protected void printCascade() {
        this.print0(this.ucase ? " CASCADE CONSTRAINTS" : " cascade constraints");
    }

    public boolean visit(SQLCharExpr x, boolean parameterized) {
        if (x.getText() != null && x.getText().length() == 0) {
            this.print0(this.ucase ? "NULL" : "null");
        } else {
            super.visit(x, parameterized);
        }
        return false;
    }

    public boolean visit(OracleCreateTableStatement.Organization x) {
        String type = x.getType();
        this.print0(this.ucase ? "ORGANIZATION " : "organization ");
        this.print0(this.ucase ? type : type.toLowerCase());
        this.printOracleSegmentAttributes((OracleSegmentAttributes)x);
        if (x.getPctthreshold() != null) {
            this.println();
            this.print0(this.ucase ? "PCTTHRESHOLD " : "pctthreshold ");
            this.print(x.getPctthreshold().intValue());
        }
        if ("EXTERNAL".equalsIgnoreCase(type)) {
            this.print0(" (");
            ++this.indentCount;
            if (x.getExternalType() != null) {
                this.println();
                this.print0(this.ucase ? "TYPE " : "type ");
                x.getExternalType().accept((SQLASTVisitor)this);
            }
            if (x.getExternalDirectory() != null) {
                this.println();
                this.print0(this.ucase ? "DEFAULT DIRECTORY " : "default directory ");
                x.getExternalDirectory().accept((SQLASTVisitor)this);
            }
            if (x.getExternalDirectoryRecordFormat() != null) {
                this.println();
                ++this.indentCount;
                this.print0(this.ucase ? "ACCESS PARAMETERS (" : "access parameters (");
                x.getExternalDirectoryRecordFormat().accept((SQLASTVisitor)this);
                --this.indentCount;
                this.println();
                this.print(')');
            }
            if (x.getExternalDirectoryLocation().size() > 0) {
                this.println();
                this.print0(this.ucase ? "LOCATION (" : " location(");
                this.printAndAccept(x.getExternalDirectoryLocation(), ", ");
                this.print(')');
            }
            --this.indentCount;
            this.println();
            this.print(')');
            if (x.getExternalRejectLimit() != null) {
                this.println();
                this.print0(this.ucase ? "REJECT LIMIT " : "reject limit ");
                x.getExternalRejectLimit().accept((SQLASTVisitor)this);
            }
        }
        return false;
    }

    public boolean visit(OracleCreatePackageStatement x) {
        if (x.isOrReplace()) {
            this.print0(this.ucase ? "CREATE OR REPLACE PACKAGE " : "create or replace procedure ");
        } else {
            this.print0(this.ucase ? "CREATE PACKAGE " : "create procedure ");
        }
        if (x.isBody()) {
            this.print0(this.ucase ? "BODY " : "body ");
        }
        x.getName().accept((SQLASTVisitor)this);
        if (x.isBody()) {
            this.println();
            this.print0(this.ucase ? "BEGIN" : "begin");
        }
        ++this.indentCount;
        List statements = x.getStatements();
        int size = statements.size();
        for (int i = 0; i < size; ++i) {
            this.println();
            SQLStatement stmt = (SQLStatement)statements.get(i);
            stmt.accept((SQLASTVisitor)this);
        }
        --this.indentCount;
        if (x.isBody() || statements.size() > 0) {
            this.println();
            this.print0(this.ucase ? "END " : "end ");
            x.getName().accept((SQLASTVisitor)this);
            this.print(';');
        }
        return false;
    }

    public boolean visit(SQLAssignItem x) {
        x.getTarget().accept((SQLASTVisitor)this);
        this.print0(" := ");
        x.getValue().accept((SQLASTVisitor)this);
        return false;
    }

    public boolean visit(OracleExecuteImmediateStatement x) {
        List returnInto;
        List using;
        this.print0(this.ucase ? "EXECUTE IMMEDIATE " : "execute immediate ");
        x.getDynamicSql().accept((SQLASTVisitor)this);
        List into = x.getInto();
        if (into.size() > 0) {
            this.print0(this.ucase ? " INTO " : " into ");
            this.printAndAccept(into, ", ");
        }
        if ((using = x.getArguments()).size() > 0) {
            this.print0(this.ucase ? " USING " : " using ");
            this.printAndAccept(using, ", ");
        }
        if ((returnInto = x.getReturnInto()).size() > 0) {
            this.print0(this.ucase ? " RETURNNING INTO " : " returnning into ");
            this.printAndAccept(returnInto, ", ");
        }
        return false;
    }

    public boolean visit(OracleCreateTypeStatement x) {
        super.visit(x);
        String wrappedSource = x.getWrappedSource();
        if (wrappedSource != null) {
            this.print0(this.ucase ? " WRAPPED" : " wrapped");
            this.print0(wrappedSource);
        }
        return false;
    }

    public boolean visit(OraclePipeRowStatement x) {
        this.print0(this.ucase ? "PIPE ROW(" : "pipe row(");
        this.printAndAccept(x.getParameters(), ", ");
        this.print(')');
        return false;
    }

    public boolean visit(OracleXmlColumnProperties x) {
        Boolean allowAnySchema;
        Boolean allowNonSchema;
        this.print0(this.ucase ? "XMLTYPE " : "xmltype ");
        x.getColumn().accept((SQLASTVisitor)this);
        OracleXmlColumnProperties.OracleXMLTypeStorage storage = x.getStorage();
        if (storage != null) {
            storage.accept((SQLASTVisitor)this);
        }
        if ((allowNonSchema = x.getAllowNonSchema()) != null) {
            if (allowNonSchema.booleanValue()) {
                this.print0(this.ucase ? " ALLOW NONSCHEMA" : " allow nonschema");
            } else {
                this.print0(this.ucase ? " DISALLOW NONSCHEMA" : " disallow nonschema");
            }
        }
        if ((allowAnySchema = x.getAllowAnySchema()) != null) {
            if (allowAnySchema.booleanValue()) {
                this.print0(this.ucase ? " ALLOW ANYSCHEMA" : " allow anyschema");
            } else {
                this.print0(this.ucase ? " DISALLOW ANYSCHEMA" : " disallow anyschema");
            }
        }
        return false;
    }

    public boolean visit(OracleXmlColumnProperties.OracleXMLTypeStorage x) {
        return false;
    }

    public boolean visit(SQLSubPartition x) {
        super.visit(x);
        this.incrementIndent();
        this.printOracleSegmentAttributes((OracleSegmentAttributes)x);
        this.decrementIndent();
        return false;
    }

    public boolean visit(SQLPartitionValue x) {
        super.visit(x);
        this.incrementIndent();
        this.printOracleSegmentAttributes((OracleSegmentAttributes)x);
        this.decrementIndent();
        return false;
    }

    public boolean visit(SQLIfStatement.ElseIf x) {
        this.print0(this.ucase ? "ELSIF " : "elsif ");
        super.visit(x);
        return false;
    }
}

