/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.postgresql.visitor;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLArrayDataType;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLHint;
import com.alibaba.druid.sql.ast.SQLIndexOptions;
import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLParameter;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddColumn;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLBlockStatement;
import com.alibaba.druid.sql.ast.statement.SQLCheck;
import com.alibaba.druid.sql.ast.statement.SQLCommitStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateProcedureStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateSequenceStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTriggerStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateUserStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeclareStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprStatement;
import com.alibaba.druid.sql.ast.statement.SQLForeignKeyImpl;
import com.alibaba.druid.sql.ast.statement.SQLGrantStatement;
import com.alibaba.druid.sql.ast.statement.SQLIfStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLMergeStatement;
import com.alibaba.druid.sql.ast.statement.SQLPrivilegeItem;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSetStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTruncateStatement;
import com.alibaba.druid.sql.ast.statement.SQLUnique;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.dialect.oracle.ast.OracleDataTypeIntervalDay;
import com.alibaba.druid.sql.dialect.oracle.ast.OracleDataTypeIntervalYear;
import com.alibaba.druid.sql.dialect.oracle.ast.OracleSegmentAttributes;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.ModelClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleLobStorageClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleStorageClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.PartitionExtensionClause;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleAnalytic;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleAnalyticWindowing;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleArgumentExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleBinaryFloatExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleIntervalExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleOuterExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleRangeExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleSysdateExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTableDropPartition;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTableModify;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTableMoveTablespace;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTableSplitPartition;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTableTruncatePartition;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTablespaceAddDataFile;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTablespaceStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCheck;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateDatabaseDbLinkStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateIndexStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreatePackageStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateTableStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateTypeStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleDeleteStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleDropDbLinkStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleExceptionStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleExecuteImmediateStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleExitStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleExplainStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleFileSpecification;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleForStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleForeignKey;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleInsertStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleLockTableStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleMultiInsertStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OraclePipeRowStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OraclePrimaryKey;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleRaiseStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectJoin;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectPivot;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectRestriction;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectSubqueryTableSource;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectTableReference;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSetTransactionStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleUnique;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleUsingIndexClause;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleXmlColumnProperties;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleFunctionDataType;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleProcedureDataType;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGBoxExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGCidrExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGCircleExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGExtractExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGInetExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGLineSegmentsExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGMacAddrExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGPointExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGPolygonExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGTypeCastExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGAlterSchemaStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGConnectToStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGCreateSchemaStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGDeleteStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGDropSchemaStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGFunctionTableSource;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGInsertStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGSelectQueryBlock;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGSelectStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGShowStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGStartTransactionStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGUpdateStatement;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGASTVisitor;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGOutputVisitor;
import com.alibaba.druid.sql.visitor.OracleExtendAstOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.util.FnvHash;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.transformer.Ora2LightdbOracleTransformer;
import com.hundsun.lightdb.utils.CommonUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class PGOutputVisitor
extends OracleExtendAstOutputVisitor
implements PGASTVisitor,
OracleASTVisitor {
    private static final Logger log = LoggerFactory.getLogger(PGOutputVisitor.class);
    public static final String BINARY_INTEGER = "binary_integer";
    static Pattern pattern = Pattern.compile("(?i)^exit.*notfound.*");
    Set<String> paramNames = new HashSet();
    static Map<String, String> nameMapping = new HashMap(32);
    static Map<String, String> keywords = new HashMap();
    Ora2LightdbOracleTransformer etlTransformer;

    public PGOutputVisitor(Appendable appender) {
        super(appender);
        nameMapping.put("varchar2", "varchar");
        nameMapping.put("sys_refcursor", "REFCURSOR");
        nameMapping.put("raw", "bytea");
        nameMapping.put("blob", "bytea");
        nameMapping.put("clob", "text");
        nameMapping.put("rowid", "char(10)");
        nameMapping.put("binary_float", "REAL");
        nameMapping.put("binary_double", "DOUBLE PRECISION");
        nameMapping.put("date", "TIMESTAMP(0)");
        nameMapping.put("integer", "DECIMAL(38)");
        nameMapping.put("long", "text");
        nameMapping.put("real", "DOUBLE PRECISION");
        nameMapping.put("nvl", "coalesce");
        nameMapping.put("table", "unnest");
        nameMapping.put("sys_guid", "uuid_generate_v4");
        nameMapping.put(":old", "OLD");
        nameMapping.put(":new", "NEW");
        this.etlTransformer = new Ora2LightdbOracleTransformer();
        this.dbType = DbType.postgresql;
    }

    public PGOutputVisitor(Appendable appender, boolean parameterized) {
        super(appender, parameterized);
        nameMapping.put("varchar2", "varchar");
        nameMapping.put("sys_refcursor", "REFCURSOR");
        nameMapping.put("raw", "bytea");
        nameMapping.put("blob", "bytea");
        nameMapping.put("clob", "text");
        nameMapping.put("rowid", "char(10)");
        nameMapping.put("binary_float", "REAL");
        nameMapping.put("binary_double", "DOUBLE PRECISION");
        nameMapping.put("date", "TIMESTAMP(0)");
        nameMapping.put("integer", "DECIMAL(38)");
        nameMapping.put("long", "text");
        nameMapping.put("real", "DOUBLE PRECISION");
        nameMapping.put("nvl", "coalesce");
        nameMapping.put("table", "unnest");
        nameMapping.put("sys_guid", "uuid_generate_v4");
        nameMapping.put(":old", "OLD");
        nameMapping.put(":new", "NEW");
        this.etlTransformer = new Ora2LightdbOracleTransformer();
        this.dbType = DbType.postgresql;
    }

    public boolean visit(PGSelectQueryBlock.FetchClause x) {
        this.print0(this.ucase ? "FETCH " : "fetch ");
        if (PGSelectQueryBlock.FetchClause.Option.FIRST.equals((Object)x.getOption())) {
            this.print0(this.ucase ? "FIRST " : "first ");
        } else if (PGSelectQueryBlock.FetchClause.Option.NEXT.equals((Object)x.getOption())) {
            this.print0(this.ucase ? "NEXT " : "next ");
        }
        x.getCount().accept((SQLASTVisitor)this);
        this.print0(this.ucase ? " ROWS ONLY" : " rows only");
        return false;
    }

    public boolean visit(PGSelectQueryBlock.ForClause x) {
        this.print0(this.ucase ? "FOR " : "for ");
        if (PGSelectQueryBlock.ForClause.Option.UPDATE.equals((Object)x.getOption())) {
            this.print0(this.ucase ? "UPDATE" : "update");
        } else if (PGSelectQueryBlock.ForClause.Option.SHARE.equals((Object)x.getOption())) {
            this.print0(this.ucase ? "SHARE" : "share");
        }
        if (x.getOf().size() > 0) {
            this.print(' ');
            for (int i = 0; i < x.getOf().size(); ++i) {
                if (i != 0) {
                    this.println(", ");
                }
                ((SQLExpr)x.getOf().get(i)).accept((SQLASTVisitor)this);
            }
        }
        if (x.isNoWait()) {
            this.print0(this.ucase ? " NOWAIT" : " nowait");
        } else if (x.isSkipLocked()) {
            this.print0(this.ucase ? " SKIP LOCKED" : " skip locked");
        }
        return false;
    }

    public boolean visit(PGSelectQueryBlock x) {
        List windows;
        SQLExpr where;
        boolean bracket;
        if (!this.isParameterized() && this.isPrettyFormat() && x.hasBeforeComment()) {
            this.printlnComments(x.getBeforeCommentsDirect());
        }
        if (bracket = x.isParenthesized()) {
            this.print('(');
        }
        this.print0(this.ucase ? "SELECT " : "select ");
        if (1 == x.getDistionOption()) {
            this.print0(this.ucase ? "ALL " : "all ");
        } else if (2 == x.getDistionOption()) {
            this.print0(this.ucase ? "DISTINCT " : "distinct ");
            List distinctOn = x.getDistinctOn();
            if (distinctOn != null && distinctOn.size() > 0) {
                this.print0(this.ucase ? "ON " : "on ");
                if (distinctOn.size() == 1 && distinctOn.get(0) instanceof SQLListExpr) {
                    this.printExpr((SQLExpr)distinctOn.get(0));
                    this.print(' ');
                } else {
                    this.print0("(");
                    this.printAndAccept(distinctOn, ", ");
                    this.print0(") ");
                }
            }
        }
        this.printSelectList(x.getSelectList());
        if (x.getInto() != null) {
            this.println();
            if (x.getIntoOption() != null) {
                this.print0(x.getIntoOption().name());
                this.print(' ');
            }
            this.print0(this.ucase ? "INTO " : "into ");
            x.getInto().accept((SQLASTVisitor)this);
        }
        if (x.getFrom() != null) {
            this.println();
            this.print0(this.ucase ? "FROM " : "from ");
            x.getFrom().accept((SQLASTVisitor)this);
        }
        if ((where = x.getWhere()) != null) {
            this.printWhere(where);
        }
        if (x.getGroupBy() != null) {
            this.println();
            x.getGroupBy().accept((SQLASTVisitor)this);
        }
        if ((windows = x.getWindows()) != null && windows.size() > 0) {
            this.println();
            this.print0(this.ucase ? "WINDOW " : "window ");
            this.printAndAccept(windows, ", ");
        }
        if (x.getOrderBy() != null) {
            this.println();
            x.getOrderBy().accept((SQLASTVisitor)this);
        }
        if (x.getLimit() != null) {
            this.println();
            x.getLimit().accept((SQLASTVisitor)this);
        }
        if (x.getFetch() != null) {
            this.println();
            x.getFetch().accept((SQLASTVisitor)this);
        }
        if (x.getForClause() != null) {
            this.println();
            x.getForClause().accept((SQLASTVisitor)this);
        }
        if (bracket) {
            this.print(')');
        }
        return false;
    }

    public boolean visit(OracleCreateTypeStatement x) {
        Boolean instantiable;
        SQLName authId;
        this.print0(this.ucase ? "CREATE " : "create ");
        if (x.isOrReplace()) {
            this.print0(this.ucase ? "OR REPLACE " : "or replace ");
        }
        this.print0(this.ucase ? "TYPE " : "type ");
        if (x.isBody()) {
            this.print0(this.ucase ? "BODY " : "body ");
        }
        x.getName().accept((SQLASTVisitor)this);
        SQLName under = x.getUnder();
        if (under != null) {
            this.print0(this.ucase ? " UNDER " : " under ");
            under.accept((SQLASTVisitor)this);
        }
        if ((authId = x.getAuthId()) != null) {
            this.print0(this.ucase ? " AUTHID " : " authid ");
            authId.accept((SQLASTVisitor)this);
        }
        if (x.isForce()) {
            this.print0(this.ucase ? "FORCE " : "force ");
        }
        List parameters = x.getParameters();
        SQLDataType tableOf = x.getTableOf();
        if (x.isObject()) {
            this.print0(" AS OBJECT");
        }
        if (parameters.size() > 0) {
            if (x.isParen()) {
                this.print(" (");
            } else {
                this.print0(this.ucase ? " IS" : " is");
            }
            ++this.indentCount;
            this.println();
            for (int i = 0; i < parameters.size(); ++i) {
                SQLParameter param = (SQLParameter)parameters.get(i);
                param.accept((SQLASTVisitor)this);
                SQLDataType dataType = param.getDataType();
                if (i >= parameters.size() - 1) continue;
                if (dataType instanceof OracleFunctionDataType && ((OracleFunctionDataType)dataType).getBlock() != null) {
                    this.println();
                    continue;
                }
                if (dataType instanceof OracleProcedureDataType && ((OracleProcedureDataType)dataType).getBlock() != null) {
                    this.println();
                    continue;
                }
                this.println(", ");
            }
            --this.indentCount;
            this.println();
            if (x.isParen()) {
                this.print0(")");
            } else {
                this.print0("END");
            }
        } else if (tableOf != null) {
            this.print0(this.ucase ? " AS TABLE OF " : " as table of ");
            tableOf.accept((SQLASTVisitor)this);
        } else if (x.getVarraySizeLimit() != null) {
            this.print0(this.ucase ? " VARRAY (" : " varray (");
            x.getVarraySizeLimit().accept((SQLASTVisitor)this);
            this.print0(this.ucase ? ") OF " : ") of ");
            x.getVarrayDataType().accept((SQLASTVisitor)this);
        }
        Boolean isFinal = x.getFinal();
        if (isFinal != null) {
            if (isFinal.booleanValue()) {
                this.print0(this.ucase ? " FINAL" : " final");
            } else {
                this.print0(this.ucase ? " NOT FINAL" : " not final");
            }
        }
        if ((instantiable = x.getInstantiable()) != null) {
            if (instantiable.booleanValue()) {
                this.print0(this.ucase ? " INSTANTIABLE" : " instantiable");
            } else {
                this.print0(this.ucase ? " NOT INSTANTIABLE" : " not instantiable");
            }
        }
        return false;
    }

    public boolean visit(SQLTruncateStatement x) {
        this.print0(this.ucase ? "TRUNCATE TABLE " : "truncate table ");
        if (x.isOnly()) {
            this.print0(this.ucase ? "ONLY " : "only ");
        }
        this.printlnAndAccept(x.getTableSources(), ", ");
        if (x.getRestartIdentity() != null) {
            if (x.getRestartIdentity().booleanValue()) {
                this.print0(this.ucase ? " RESTART IDENTITY" : " restart identity");
            } else {
                this.print0(this.ucase ? " CONTINUE IDENTITY" : " continue identity");
            }
        }
        if (x.getCascade() != null) {
            if (x.getCascade().booleanValue()) {
                this.print0(this.ucase ? " CASCADE" : " cascade");
            } else {
                this.print0(this.ucase ? " RESTRICT" : " restrict");
            }
        }
        return false;
    }

    public boolean visit(PGDeleteStatement x) {
        SQLTableSource using;
        if (x.getWith() != null) {
            x.getWith().accept((SQLASTVisitor)this);
            this.println();
        }
        this.print0(this.ucase ? "DELETE FROM " : "delete from ");
        if (x.isOnly()) {
            this.print0(this.ucase ? "ONLY " : "only ");
        }
        this.printTableSourceExpr((SQLExpr)x.getTableName());
        if (x.getAlias() != null) {
            this.print0(this.ucase ? " AS " : " as ");
            this.print0(x.getAlias());
        }
        if ((using = x.getUsing()) != null) {
            this.println();
            this.print0(this.ucase ? "USING " : "using ");
            using.accept((SQLASTVisitor)this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.print0(this.ucase ? "WHERE " : "where ");
            ++this.indentCount;
            x.getWhere().accept((SQLASTVisitor)this);
            --this.indentCount;
        }
        if (x.isReturning()) {
            this.println();
            this.print0(this.ucase ? "RETURNING *" : "returning *");
        }
        return false;
    }

    public boolean visit(PGInsertStatement x) {
        if (x.getWith() != null) {
            x.getWith().accept((SQLASTVisitor)this);
            this.println();
        }
        this.print0(this.ucase ? "INSERT INTO " : "insert into ");
        x.getTableSource().accept((SQLASTVisitor)this);
        this.printInsertColumns(x.getColumns());
        if (x.getValues() != null) {
            this.println();
            this.print0(this.ucase ? "VALUES " : "values ");
            this.printlnAndAccept(x.getValuesList(), ", ");
        } else if (x.getQuery() != null) {
            this.println();
            x.getQuery().accept((SQLASTVisitor)this);
        }
        List onConflictTarget = x.getOnConflictTarget();
        List onConflictUpdateSetItems = x.getOnConflictUpdateSetItems();
        boolean onConflictDoNothing = x.isOnConflictDoNothing();
        if (onConflictDoNothing || onConflictTarget != null && onConflictTarget.size() > 0 || onConflictUpdateSetItems != null && onConflictUpdateSetItems.size() > 0) {
            SQLExpr onConflictWhere;
            SQLName onConflictConstraint;
            this.println();
            this.print0(this.ucase ? "ON CONFLICT" : "on conflict");
            if (onConflictTarget != null && onConflictTarget.size() > 0) {
                this.print0(" (");
                this.printAndAccept(onConflictTarget, ", ");
                this.print(')');
            }
            if ((onConflictConstraint = x.getOnConflictConstraint()) != null) {
                this.print0(this.ucase ? " ON CONSTRAINT " : " on constraint ");
                this.printExpr((SQLExpr)onConflictConstraint);
            }
            if ((onConflictWhere = x.getOnConflictWhere()) != null) {
                this.print0(this.ucase ? " WHERE " : " where ");
                this.printExpr(onConflictWhere);
            }
            if (onConflictDoNothing) {
                this.print0(this.ucase ? " DO NOTHING" : " do nothing");
            } else if (onConflictUpdateSetItems != null && onConflictUpdateSetItems.size() > 0) {
                this.print0(this.ucase ? " DO UPDATE SET " : " do update set ");
                this.printAndAccept(onConflictUpdateSetItems, ", ");
                SQLExpr onConflictUpdateWhere = x.getOnConflictUpdateWhere();
                if (onConflictUpdateWhere != null) {
                    this.print0(this.ucase ? " WHERE " : " where ");
                    this.printExpr(onConflictUpdateWhere);
                }
            }
        }
        if (x.getReturning() != null) {
            this.println();
            this.print0(this.ucase ? "RETURNING " : "returning ");
            x.getReturning().accept((SQLASTVisitor)this);
        }
        return false;
    }

    public boolean visit(PGSelectStatement x) {
        return this.visit((SQLSelectStatement)x);
    }

    public boolean visit(PGUpdateStatement x) {
        List returning;
        SQLExpr where;
        SQLWithSubqueryClause with = x.getWith();
        if (with != null) {
            this.visit(with);
            this.println();
        }
        this.print0(this.ucase ? "UPDATE " : "update ");
        if (x.isOnly()) {
            this.print0(this.ucase ? "ONLY " : "only ");
        }
        this.printTableSource(x.getTableSource());
        this.println();
        this.print0(this.ucase ? "SET " : "set ");
        int size = x.getItems().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print0(", ");
            }
            SQLUpdateSetItem item = (SQLUpdateSetItem)x.getItems().get(i);
            this.visit(item);
        }
        SQLTableSource from = x.getFrom();
        if (from != null) {
            this.println();
            this.print0(this.ucase ? "FROM " : "from ");
            this.printTableSource(from);
        }
        if ((where = x.getWhere()) != null) {
            this.println();
            ++this.indentCount;
            this.print0(this.ucase ? "WHERE " : "where ");
            this.printExpr(where);
            --this.indentCount;
        }
        if ((returning = x.getReturning()).size() > 0) {
            this.println();
            this.print0(this.ucase ? "RETURNING " : "returning ");
            this.printAndAccept(returning, ", ");
        }
        return false;
    }

    public boolean visit(PGFunctionTableSource x) {
        x.getExpr().accept((SQLASTVisitor)this);
        if (x.getAlias() != null) {
            this.print0(this.ucase ? " AS " : " as ");
            this.print0(x.getAlias());
        }
        if (x.getParameters().size() > 0) {
            this.print('(');
            this.printAndAccept(x.getParameters(), ", ");
            this.print(')');
        }
        return false;
    }

    public boolean visit(PGTypeCastExpr x) {
        SQLExpr expr = x.getExpr();
        SQLDataType dataType = x.getDataType();
        if (dataType.nameHashCode64() == FnvHash.Constants.VARBIT) {
            dataType.accept((SQLASTVisitor)this);
            this.print(' ');
            this.printExpr(expr);
            return false;
        }
        if (expr != null) {
            if (expr instanceof SQLBinaryOpExpr) {
                this.print('(');
                expr.accept((SQLASTVisitor)this);
                this.print(')');
            } else {
                if (expr instanceof PGTypeCastExpr && dataType.getArguments().isEmpty()) {
                    dataType.accept((SQLASTVisitor)this);
                    this.print('(');
                    this.visit((PGTypeCastExpr)expr);
                    this.print(')');
                    return false;
                }
                expr.accept((SQLASTVisitor)this);
            }
        }
        this.print0("::");
        dataType.accept((SQLASTVisitor)this);
        return false;
    }

    public boolean visit(PGExtractExpr x) {
        this.print0(this.ucase ? "EXTRACT (" : "extract (");
        this.print0(x.getField().name());
        this.print0(this.ucase ? " FROM " : " from ");
        x.getSource().accept((SQLASTVisitor)this);
        this.print(')');
        return false;
    }

    public boolean visit(PGBoxExpr x) {
        this.print0(this.ucase ? "BOX " : "box ");
        x.getValue().accept((SQLASTVisitor)this);
        return false;
    }

    public boolean visit(PGPointExpr x) {
        this.print0(this.ucase ? "POINT " : "point ");
        x.getValue().accept((SQLASTVisitor)this);
        return false;
    }

    public boolean visit(PGMacAddrExpr x) {
        this.print0("macaddr ");
        x.getValue().accept((SQLASTVisitor)this);
        return false;
    }

    public boolean visit(PGInetExpr x) {
        this.print0("inet ");
        x.getValue().accept((SQLASTVisitor)this);
        return false;
    }

    public boolean visit(PGCidrExpr x) {
        this.print0("cidr ");
        x.getValue().accept((SQLASTVisitor)this);
        return false;
    }

    public boolean visit(PGPolygonExpr x) {
        this.print0("polygon ");
        x.getValue().accept((SQLASTVisitor)this);
        return false;
    }

    public boolean visit(PGCircleExpr x) {
        this.print0("circle ");
        x.getValue().accept((SQLASTVisitor)this);
        return false;
    }

    public boolean visit(PGLineSegmentsExpr x) {
        this.print0("lseg ");
        x.getValue().accept((SQLASTVisitor)this);
        return false;
    }

    public boolean visit(SQLBinaryExpr x) {
        this.print0(this.ucase ? "B'" : "b'");
        this.print0(x.getText());
        this.print('\'');
        return false;
    }

    public boolean visit(PGShowStatement x) {
        this.print0(this.ucase ? "SHOW " : "show ");
        x.getExpr().accept((SQLASTVisitor)this);
        return false;
    }

    public boolean visit(SQLLimit x) {
        this.print0(this.ucase ? "LIMIT " : "limit ");
        x.getRowCount().accept((SQLASTVisitor)this);
        if (x.getOffset() != null) {
            this.print0(this.ucase ? " OFFSET " : " offset ");
            x.getOffset().accept((SQLASTVisitor)this);
        }
        return false;
    }

    public boolean visit(PGStartTransactionStatement x) {
        this.print0(this.ucase ? "START TRANSACTION" : "start transaction");
        return false;
    }

    public boolean visit(PGConnectToStatement x) {
        this.print0(this.ucase ? "CONNECT TO " : "connect to ");
        x.getTarget().accept((SQLASTVisitor)this);
        return false;
    }

    public boolean visit(PGCreateSchemaStatement x) {
        this.printUcase("CREATE SCHEMA ");
        if (x.isIfNotExists()) {
            this.printUcase("IF NOT EXISTS ");
        }
        if (x.getSchemaName() != null) {
            x.getSchemaName().accept((SQLASTVisitor)this);
        }
        if (x.isAuthorization()) {
            this.printUcase("AUTHORIZATION ");
            x.getUserName().accept((SQLASTVisitor)this);
        }
        return false;
    }

    public void endVisit(PGDropSchemaStatement x) {
        this.printUcase("DROP SCHEMA ");
        if (x.isIfExists()) {
            this.printUcase("IF EXISTS ");
        }
        x.getSchemaName().accept((SQLASTVisitor)this);
    }

    public boolean visit(PGDropSchemaStatement x) {
        return false;
    }

    public boolean visit(PGAlterSchemaStatement x) {
        this.printUcase("ALTER SCHEMA ");
        x.getSchemaName().accept((SQLASTVisitor)this);
        if (x.getNewName() != null) {
            this.print0(" RENAME TO ");
            x.getNewName().accept((SQLASTVisitor)this);
        } else if (x.getNewOwner() != null) {
            this.print0(" OWNER TO ");
            x.getNewOwner().accept((SQLASTVisitor)this);
        }
        return false;
    }

    public boolean visit(SQLSetStatement x) {
        SQLSetStatement.Option option = x.getOption();
        if (option != null) {
            this.print(option.name());
            this.print(' ');
        }
        List items = x.getItems();
        for (int i = 0; i < items.size(); ++i) {
            if (i != 0) {
                this.print0(", ");
            }
            SQLAssignItem item = (SQLAssignItem)x.getItems().get(i);
            SQLExpr target = item.getTarget();
            target.accept((SQLASTVisitor)this);
            SQLExpr value = item.getValue();
            if (target instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)target).getName().equalsIgnoreCase("TIME ZONE")) {
                this.print(' ');
            } else {
                this.print0(" := ");
            }
            if (value instanceof SQLListExpr) {
                SQLListExpr listExpr = (SQLListExpr)value;
                this.printAndAccept(listExpr.getItems(), ", ");
                continue;
            }
            value.accept((SQLASTVisitor)this);
        }
        return false;
    }

    public boolean visit(SQLCreateUserStatement x) {
        this.print0(this.ucase ? "CREATE USER " : "create user ");
        x.getUser().accept((SQLASTVisitor)this);
        this.print0(this.ucase ? " PASSWORD " : " password ");
        SQLExpr passoword = x.getPassword();
        if (passoword instanceof SQLIdentifierExpr) {
            this.print('\'');
            passoword.accept((SQLASTVisitor)this);
            this.print('\'');
        } else {
            passoword.accept((SQLASTVisitor)this);
        }
        return false;
    }

    protected void printGrantPrivileges(SQLGrantStatement x) {
        List privileges = x.getPrivileges();
        int i = 0;
        for (SQLPrivilegeItem privilege : privileges) {
            String name;
            SQLExpr action;
            if (i != 0) {
                this.print(", ");
            }
            if ((action = privilege.getAction()) instanceof SQLIdentifierExpr && "RESOURCE".equalsIgnoreCase(name = ((SQLIdentifierExpr)action).getName())) continue;
            privilege.accept((SQLASTVisitor)this);
            ++i;
        }
    }

    public boolean visit(SQLGrantStatement x) {
        if (x.getResource() == null) {
            this.print("ALTER ROLE ");
            this.printAndAccept(x.getUsers(), ",");
            this.print(' ');
            LinkedHashSet<SQLIdentifierExpr> pgPrivilegs = new LinkedHashSet<SQLIdentifierExpr>();
            for (SQLPrivilegeItem privilege : x.getPrivileges()) {
                SQLExpr sQLExpr = privilege.getAction();
                if (!(sQLExpr instanceof SQLIdentifierExpr)) continue;
                String name = ((SQLIdentifierExpr)sQLExpr).getName();
                if (name.equalsIgnoreCase("CONNECT")) {
                    pgPrivilegs.add(new SQLIdentifierExpr("LOGIN"));
                }
                if (!name.toLowerCase().startsWith("create ")) continue;
                pgPrivilegs.add(new SQLIdentifierExpr("CREATEDB"));
            }
            int i = 0;
            for (SQLExpr sQLExpr : pgPrivilegs) {
                if (i != 0) {
                    this.print(' ');
                }
                sQLExpr.accept((SQLASTVisitor)this);
                ++i;
            }
            return false;
        }
        return super.visit(x);
    }

    public boolean visit(OracleSysdateExpr x) {
        this.print0(this.ucase ? "CURRENT_TIMESTAMP" : "CURRENT_TIMESTAMP");
        return false;
    }

    public boolean visit(OracleExceptionStatement x) {
        return false;
    }

    public boolean visit(OracleExceptionStatement.Item x) {
        return false;
    }

    public boolean visit(OracleArgumentExpr x) {
        x.getValue().accept((SQLASTVisitor)this);
        return false;
    }

    public boolean visit(OracleSetTransactionStatement x) {
        return false;
    }

    public boolean visit(OracleExplainStatement x) {
        return false;
    }

    public boolean visit(OracleAlterTableDropPartition x) {
        return false;
    }

    public boolean visit(OracleAlterTableTruncatePartition x) {
        return false;
    }

    public boolean visit(OracleAlterTableSplitPartition.TableSpaceItem x) {
        return false;
    }

    public boolean visit(OracleAlterTableSplitPartition.UpdateIndexesClause x) {
        return false;
    }

    public boolean visit(OracleAlterTableSplitPartition.NestedTablePartitionSpec x) {
        return false;
    }

    public boolean visit(OracleAlterTableSplitPartition x) {
        return false;
    }

    public boolean visit(OracleAlterTableModify x) {
        return false;
    }

    public boolean visit(OracleCreateIndexStatement x) {
        this.print0(this.ucase ? "CREATE " : "create ");
        String type = x.getType();
        if (type != null) {
            this.print0(this.ucase ? type.toUpperCase() : type.toLowerCase());
            this.print(' ');
        }
        this.print0(this.ucase ? "INDEX " : "index ");
        if (x.getName() instanceof SQLPropertyExpr) {
            SQLPropertyExpr sqlPropertyExpr = (SQLPropertyExpr)x.getName();
            String name = sqlPropertyExpr.getName();
            this.print0(CommonUtils.trimLeadTailDoubleQuote((String)name));
        } else {
            x.getName().accept((SQLASTVisitor)this);
        }
        this.print0(this.ucase ? " ON " : " on ");
        x.getTable().accept((SQLASTVisitor)this);
        this.print0(" (");
        this.printAndAccept(x.getItems(), ", ");
        this.print(')');
        return false;
    }

    public boolean visit(OracleForStatement x) {
        boolean all = x.isAll();
        if (all) {
            this.print0(this.ucase ? "FORALL " : "forall ");
        } else {
            this.print0(this.ucase ? "FOR " : "for ");
        }
        this.fillIndexParam(x.getIndex());
        x.getIndex().accept((SQLASTVisitor)this);
        this.print0(this.ucase ? " IN " : " in ");
        SQLExpr range = x.getRange();
        range.accept((SQLASTVisitor)this);
        super.visit(x);
        return false;
    }

    public boolean visit(OracleFileSpecification x) {
        return false;
    }

    public boolean visit(OracleAlterTablespaceAddDataFile x) {
        return false;
    }

    public boolean visit(OracleAlterTablespaceStatement x) {
        return false;
    }

    public boolean visit(OracleExitStatement x) {
        String interceptSql;
        this.decorate();
        this.print0(this.ucase ? "EXIT" : "exit");
        if (x.getLabel() != null) {
            this.print(' ');
            this.print0(x.getLabel());
        }
        if (x.getWhen() != null) {
            this.print0(this.ucase ? " WHEN " : " when ");
            x.getWhen().accept((SQLASTVisitor)this);
        }
        if (pattern.matcher(interceptSql = this.restoreAndGetInterceptSql()).matches()) {
            this.print0("EXIT WHEN NOT FOUND");
        } else {
            this.print0(interceptSql);
        }
        return false;
    }

    public boolean visit(OracleRaiseStatement x) {
        return false;
    }

    public boolean visit(OracleCreateDatabaseDbLinkStatement x) {
        return false;
    }

    public boolean visit(OracleDropDbLinkStatement x) {
        return false;
    }

    public boolean visit(OracleDataTypeIntervalYear x) {
        this.decorate();
        this.print0(x.getName());
        if (x.getArguments().size() > 0) {
            this.print('(');
            ((SQLExpr)x.getArguments().get(0)).accept((SQLASTVisitor)this);
            this.print(')');
        }
        this.print0(this.ucase ? " TO MONTH" : " to month");
        this.print0(this.parseType());
        return false;
    }

    public boolean visit(OracleDataTypeIntervalDay x) {
        this.decorate();
        super.visit(x);
        this.print0(this.parseType());
        return false;
    }

    public boolean visit(OracleUsingIndexClause x) {
        return false;
    }

    public boolean visit(OracleLobStorageClause x) {
        return false;
    }

    public boolean visit(OracleSelectTableReference x) {
        super.visit(x);
        if (x.getHints().size() > 0) {
            this.printHints(x.getHints());
        }
        if (x.getSampleClause() != null) {
            this.print(' ');
            x.getSampleClause().accept((SQLASTVisitor)this);
        }
        if (x.getPivot() != null) {
            this.println();
            x.getPivot().accept((SQLASTVisitor)this);
        }
        this.printAlias(x.getAlias());
        return false;
    }

    public boolean visit(PartitionExtensionClause x) {
        return false;
    }

    private void printHints(List<SQLHint> hints) {
        if (hints.size() > 0) {
            this.print0("/*+ ");
            this.printAndAccept(hints, ", ");
            this.print0(" */");
        }
    }

    public boolean visit(OracleIntervalExpr x) {
        if (x.getValue() instanceof SQLLiteralExpr) {
            this.print0(this.ucase ? "INTERVAL " : "interval ");
            x.getValue().accept((SQLASTVisitor)this);
            this.print(' ');
        } else {
            this.print('(');
            x.getValue().accept((SQLASTVisitor)this);
            this.print0(") ");
        }
        this.print0(x.getType().name());
        if (x.getPrecision() != null) {
            this.print('(');
            this.printExpr(x.getPrecision());
            if (x.getFactionalSecondsPrecision() != null) {
                this.print0(", ");
                this.print(x.getFactionalSecondsPrecision().intValue());
            }
            this.print(')');
        }
        if (x.getToType() != null) {
            this.print0(this.ucase ? " TO " : " to ");
            this.print0(x.getToType().name());
            if (x.getToFactionalSecondsPrecision() != null) {
                this.print('(');
                this.printExpr(x.getToFactionalSecondsPrecision());
                this.print(')');
            }
        }
        return false;
    }

    public boolean visit(OracleOuterExpr x) {
        x.getExpr().accept((SQLASTVisitor)this);
        this.print0("(+)");
        return false;
    }

    public boolean visit(OracleBinaryFloatExpr x) {
        if (x != null && x.getValue() != null) {
            this.print0(x.getValue().toString());
            this.print('F');
        }
        return false;
    }

    public boolean visit(ModelClause.ReturnRowsClause x) {
        if (x.isAll()) {
            this.print0(this.ucase ? "RETURN ALL ROWS" : "return all rows");
        } else {
            this.print0(this.ucase ? "RETURN UPDATED ROWS" : "return updated rows");
        }
        return false;
    }

    public boolean visit(ModelClause.MainModelClause x) {
        if (x.getMainModelName() != null) {
            this.print0(this.ucase ? " MAIN " : " main ");
            x.getMainModelName().accept((SQLASTVisitor)this);
        }
        this.println();
        x.getModelColumnClause().accept((SQLASTVisitor)this);
        for (ModelClause.CellReferenceOption opt : x.getCellReferenceOptions()) {
            this.println();
            this.print0(opt.name);
        }
        this.println();
        x.getModelRulesClause().accept((SQLASTVisitor)this);
        return false;
    }

    public boolean visit(ModelClause.QueryPartitionClause x) {
        this.print0(this.ucase ? "PARTITION BY (" : "partition by (");
        this.printAndAccept(x.getExprList(), ", ");
        this.print(')');
        return false;
    }

    public boolean visit(ModelClause.ModelColumn x) {
        x.getExpr().accept((SQLASTVisitor)this);
        if (x.getAlias() != null) {
            this.print(' ');
            this.print0(x.getAlias());
        }
        return false;
    }

    public boolean visit(ModelClause.CellAssignment x) {
        x.getMeasureColumn().accept((SQLASTVisitor)this);
        this.print0("[");
        this.printAndAccept(x.getConditions(), ", ");
        this.print0("]");
        return false;
    }

    public boolean visit(ModelClause x) {
        this.print0(this.ucase ? "MODEL" : "model");
        ++this.indentCount;
        for (ModelClause.CellReferenceOption opt : x.getCellReferenceOptions()) {
            this.print(' ');
            this.print0(opt.name);
        }
        if (x.getReturnRowsClause() != null) {
            this.print(' ');
            x.getReturnRowsClause().accept((SQLASTVisitor)this);
        }
        for (ModelClause.ReferenceModelClause item : x.getReferenceModelClauses()) {
            this.print(' ');
            item.accept((SQLASTVisitor)this);
        }
        x.getMainModel().accept((SQLASTVisitor)this);
        --this.indentCount;
        return false;
    }

    public boolean visit(OracleInsertStatement x) {
        this.decorate();
        super.visit(x);
        this.transformAndRestore();
        return false;
    }

    public boolean visit(OracleMultiInsertStatement x) {
        this.decorate();
        this.print0(this.ucase ? "INSERT " : "insert ");
        if (x.getHints().size() > 0) {
            this.printHints(x.getHints());
        }
        if (x.getOption() != null) {
            this.print0(x.getOption().name());
            this.print(' ');
        }
        int size = x.getEntries().size();
        for (int i = 0; i < size; ++i) {
            ++this.indentCount;
            this.println();
            ((OracleMultiInsertStatement.Entry)x.getEntries().get(i)).accept((SQLASTVisitor)this);
            --this.indentCount;
        }
        this.println();
        x.getSubQuery().accept((SQLASTVisitor)this);
        this.transformAndRestore();
        return false;
    }

    public boolean visit(OracleLockTableStatement x) {
        this.print0(this.ucase ? "LOCK TABLE " : "lock table ");
        x.getTable().accept((SQLASTVisitor)this);
        this.print0(this.ucase ? " IN " : " in ");
        this.print0(x.getLockMode().toString());
        this.print0(this.ucase ? " MODE " : " mode ");
        if (x.isNoWait()) {
            this.print0(this.ucase ? "NOWAIT" : "nowait");
        } else if (x.getWait() != null) {
            this.print0(this.ucase ? "WAIT " : "wait ");
            x.getWait().accept((SQLASTVisitor)this);
        }
        return false;
    }

    public boolean visit(OracleRangeExpr x) {
        x.getLowBound().accept((SQLASTVisitor)this);
        this.print0("..");
        x.getUpBound().accept((SQLASTVisitor)this);
        return false;
    }

    public boolean visit(OracleCheck x) {
        this.visit((SQLCheck)x);
        return false;
    }

    public boolean visit(OracleCreateTableStatement.Organization x) {
        String type = x.getType();
        this.print0(this.ucase ? "ORGANIZATION " : "organization ");
        this.print0(this.ucase ? type : type.toLowerCase());
        this.printOracleSegmentAttributes((OracleSegmentAttributes)x);
        if (x.getPctthreshold() != null) {
            this.println();
            this.print0(this.ucase ? "PCTTHRESHOLD " : "pctthreshold ");
            this.print(x.getPctfree().intValue());
        }
        if ("EXTERNAL".equalsIgnoreCase(type)) {
            this.print0(" (");
            ++this.indentCount;
            if (x.getExternalType() != null) {
                this.println();
                this.print0(this.ucase ? "TYPE " : "type ");
                x.getExternalType().accept((SQLASTVisitor)this);
            }
            if (x.getExternalDirectory() != null) {
                this.println();
                this.print0(this.ucase ? "DEFAULT DIRECTORY " : "default directory ");
                x.getExternalDirectory().accept((SQLASTVisitor)this);
            }
            if (x.getExternalDirectoryRecordFormat() != null) {
                this.println();
                ++this.indentCount;
                this.print0(this.ucase ? "ACCESS PARAMETERS (" : "access parameters (");
                x.getExternalDirectoryRecordFormat().accept((SQLASTVisitor)this);
                --this.indentCount;
                this.println();
                this.print(')');
            }
            if (x.getExternalDirectoryLocation().size() > 0) {
                this.println();
                this.print0(this.ucase ? "LOCATION (" : " location(");
                this.printAndAccept(x.getExternalDirectoryLocation(), ", ");
                this.print(')');
            }
            --this.indentCount;
            this.println();
            this.print(')');
            if (x.getExternalRejectLimit() != null) {
                this.println();
                this.print0(this.ucase ? "REJECT LIMIT " : "reject limit ");
                x.getExternalRejectLimit().accept((SQLASTVisitor)this);
            }
        }
        return false;
    }

    public boolean visit(OracleCreatePackageStatement x) {
        this.useUnisql = true;
        String simpleName = MotionEtlGlobalCtx.getInstance().removeQuotes(x.getName().getSimpleName());
        String schemaSql = String.format("create schema %s;", simpleName);
        this.print0(schemaSql);
        List statements = x.getStatements();
        int size = statements.size();
        for (int i = 0; i < size; ++i) {
            this.println();
            SQLStatement stmt = (SQLStatement)statements.get(i);
            if (stmt instanceof SQLDeclareStatement) {
                this.print0("create domain " + simpleName + ".");
                stmt.accept((SQLASTVisitor)this);
                continue;
            }
            if (!log.isErrorEnabled()) continue;
            log.error("\u4e0d\u652f\u6301\u7684 package \u5143\u7d20 {}", (Object)stmt.getClass().getName());
        }
        return false;
    }

    public boolean visit(OracleExecuteImmediateStatement x) {
        List returnInto;
        List using;
        this.print0(this.ucase ? "EXECUTE " : "execute ");
        this.decorate();
        x.getDynamicSql().accept((SQLASTVisitor)this);
        String interceptSql = this.restoreAndGetInterceptSql();
        int count = 1;
        while (interceptSql.indexOf(":" + count) != -1) {
            interceptSql = interceptSql.replace(":" + count, "$" + count);
            ++count;
        }
        this.print0(interceptSql);
        List into = x.getInto();
        if (into.size() > 0) {
            this.print0(this.ucase ? " INTO " : " into ");
            this.printAndAccept(into, ", ");
        }
        if ((using = x.getArguments()).size() > 0) {
            this.print0(this.ucase ? " USING " : " using ");
            this.printAndAccept(using, ", ");
        }
        if ((returnInto = x.getReturnInto()).size() > 0) {
            this.print0(this.ucase ? " RETURNNING INTO " : " returnning into ");
            this.printAndAccept(returnInto, ", ");
        }
        return false;
    }

    public boolean visit(OraclePipeRowStatement x) {
        this.print0(this.ucase ? "PIPE ROW(" : "pipe row(");
        this.printAndAccept(x.getParameters(), ", ");
        this.print(')');
        return false;
    }

    public boolean visit(OraclePrimaryKey x) {
        if (x.getName() != null) {
            this.print0(this.ucase ? "CONSTRAINT " : "constraint ");
            x.getName().accept((SQLASTVisitor)this);
            this.print(' ');
        }
        this.print0(this.ucase ? "PRIMARY KEY (" : "primary key (");
        this.printAndAccept(x.getColumns(), ", ");
        this.print(')');
        return false;
    }

    public boolean visit(OracleCreateTableStatement x) {
        this.printCreateTable((SQLCreateTableStatement)x, false);
        if (x.isOnCommitPreserveRows()) {
            this.println();
            this.print0(this.ucase ? "ON COMMIT PRESERVE ROWS" : "on commit preserve rows");
        } else if (x.isOnCommitDeleteRows()) {
            this.println();
            this.print0(this.ucase ? "ON COMMIT DELETE ROWS" : "on commit delete rows");
        }
        if (x.getPartitioning() != null) {
            this.println();
            this.print0(this.ucase ? "PARTITION BY " : "partition by ");
            x.getPartitioning().accept((SQLASTVisitor)this);
        }
        if (x.getSelect() != null) {
            this.println();
            this.print0(this.ucase ? "AS" : "as");
            this.println();
            x.getSelect().accept((SQLASTVisitor)this);
        }
        return false;
    }

    public boolean visit(OracleStorageClause x) {
        return false;
    }

    public boolean visit(OracleAlterTableMoveTablespace x) {
        this.print0(this.ucase ? " MOVE TABLESPACE " : " move tablespace ");
        x.getName().accept((SQLASTVisitor)this);
        return false;
    }

    public boolean visit(OracleForeignKey x) {
        this.visit((SQLForeignKeyImpl)x);
        return false;
    }

    public boolean visit(OracleUnique x) {
        this.visit((SQLUnique)x);
        return false;
    }

    public boolean visit(OracleSelectSubqueryTableSource x) {
        this.print('(');
        ++this.indentCount;
        this.println();
        x.getSelect().accept((SQLASTVisitor)this);
        --this.indentCount;
        this.println();
        this.print(')');
        if (x.getPivot() != null) {
            this.println();
            x.getPivot().accept((SQLASTVisitor)this);
        }
        this.printFlashback(x.getFlashback());
        if (x.getAlias() != null && x.getAlias().length() != 0) {
            this.print(' ');
            this.print0(x.getAlias());
        }
        return false;
    }

    public boolean visit(OracleSelectJoin x) {
        x.getLeft().accept((SQLASTVisitor)this);
        SQLTableSource right = x.getRight();
        if (x.getJoinType() == SQLJoinTableSource.JoinType.COMMA) {
            this.print0(", ");
            x.getRight().accept((SQLASTVisitor)this);
        } else {
            boolean isRoot = x.getParent() instanceof SQLSelectQueryBlock;
            if (isRoot) {
                ++this.indentCount;
            }
            this.println();
            this.print0(this.ucase ? x.getJoinType().name : x.getJoinType().nameLCase);
            this.print(' ');
            if (right instanceof SQLJoinTableSource) {
                this.print('(');
                right.accept((SQLASTVisitor)this);
                this.print(')');
            } else {
                right.accept((SQLASTVisitor)this);
            }
            if (isRoot) {
                --this.indentCount;
            }
            if (x.getCondition() != null) {
                this.print0(this.ucase ? " ON " : " on ");
                x.getCondition().accept((SQLASTVisitor)this);
                this.print(' ');
            }
            if (x.getUsing().size() > 0) {
                this.print0(this.ucase ? " USING (" : " using (");
                this.printAndAccept(x.getUsing(), ", ");
                this.print(')');
            }
            this.printFlashback(x.getFlashback());
        }
        return false;
    }

    public boolean visit(OracleSelectPivot.Item x) {
        x.getExpr().accept((SQLASTVisitor)this);
        if (x.getAlias() != null && x.getAlias().length() > 0) {
            this.print0(this.ucase ? " AS " : " as ");
            this.print0(x.getAlias());
        }
        return false;
    }

    public boolean visit(OracleSelectRestriction.CheckOption x) {
        this.print0(this.ucase ? "CHECK OPTION" : "check option");
        if (x.getConstraint() != null) {
            this.print0(this.ucase ? " CONSTRAINT" : " constraint");
            this.print(' ');
            x.getConstraint().accept((SQLASTVisitor)this);
        }
        return false;
    }

    public boolean visit(OracleSelectRestriction.ReadOnly x) {
        this.print0(this.ucase ? "READ ONLY" : "read only");
        if (x.getConstraint() != null) {
            this.print0(this.ucase ? " CONSTRAINT" : " constraint");
            this.print(' ');
            x.getConstraint().accept((SQLASTVisitor)this);
        }
        return false;
    }

    public boolean visit(OracleDeleteStatement x) {
        return this.visit((SQLDeleteStatement)x);
    }

    private void printFlashback(SQLExpr flashback) {
        if (flashback == null) {
            return;
        }
        this.println();
        if (flashback instanceof SQLBetweenExpr) {
            flashback.accept((SQLASTVisitor)this);
        } else {
            this.print0(this.ucase ? "AS OF " : "as of ");
            flashback.accept((SQLASTVisitor)this);
        }
    }

    public boolean visit(OracleAnalytic x) {
        super.visit(x);
        this.print(')');
        return false;
    }

    public boolean visit(OracleAnalyticWindowing x) {
        this.print0(x.getType().name().toUpperCase());
        this.print(' ');
        x.getExpr().accept((SQLASTVisitor)this);
        return false;
    }

    public boolean visit(OracleXmlColumnProperties x) {
        return false;
    }

    public boolean visit(SQLIfStatement.ElseIf x) {
        this.print0(this.ucase ? "ELSEIF " : "elseif ");
        super.visit(x);
        return false;
    }

    public boolean visit(SQLCreateIndexStatement x) {
        SQLName tablespace;
        SQLIndexOptions indexOptions;
        SQLName name;
        this.print0(this.ucase ? "CREATE " : "create ");
        if (x.getType() != null) {
            this.print0(x.getType());
            this.print(' ');
        }
        this.print0(this.ucase ? "INDEX" : "index");
        if (x.isIfNotExists()) {
            this.print0(this.ucase ? " IF NOT EXISTS" : " if not exists");
        }
        if (x.isConcurrently()) {
            this.print0(this.ucase ? " CONCURRENTLY" : " concurrently");
        }
        if ((name = x.getName()) != null) {
            this.print(' ');
            name.accept((SQLASTVisitor)this);
        }
        this.print0(this.ucase ? " ON " : " on ");
        x.getTable().accept((SQLASTVisitor)this);
        if (x.getUsing() != null) {
            this.print0(this.ucase ? " USING " : " using ");
            this.print0(x.getUsing());
        }
        this.print0(" (");
        this.printAndAccept(x.getItems(), ", ");
        this.print(')');
        SQLExpr comment = x.getComment();
        if (comment != null) {
            this.print0(this.ucase ? " COMMENT " : " comment ");
            comment.accept((SQLASTVisitor)this);
        }
        boolean hasOptions = false;
        if (x.getIndexDefinition().hasOptions() && ((indexOptions = x.getIndexDefinition().getOptions()).getKeyBlockSize() != null || indexOptions.getParserName() != null || indexOptions.getAlgorithm() != null || indexOptions.getLock() != null || indexOptions.getOtherOptions().size() > 0)) {
            hasOptions = true;
        }
        if (hasOptions) {
            String lock;
            String algorithm;
            String parserName;
            this.print0(this.ucase ? " WITH (" : " with (");
            indexOptions = x.getIndexDefinition().getOptions();
            SQLExpr keyBlockSize = indexOptions.getKeyBlockSize();
            if (keyBlockSize != null) {
                this.print0(this.ucase ? " KEY_BLOCK_SIZE = " : " key_block_size = ");
                this.printExpr(keyBlockSize, this.parameterized);
            }
            if ((parserName = indexOptions.getParserName()) != null) {
                this.print0(this.ucase ? " WITH PARSER " : " with parser ");
                this.print0(parserName);
            }
            if ((algorithm = indexOptions.getAlgorithm()) != null) {
                this.print0(this.ucase ? " ALGORITHM = " : " algorithm = ");
                this.print0(algorithm);
            }
            if ((lock = indexOptions.getLock()) != null) {
                this.print0(this.ucase ? " LOCK " : " lock ");
                this.print0(lock);
            }
            for (SQLAssignItem option : indexOptions.getOtherOptions()) {
                option.accept((SQLASTVisitor)this);
            }
            this.print(')');
        }
        if ((tablespace = x.getTablespace()) != null) {
            this.print0(this.ucase ? " TABLESPACE " : " tablespace ");
            tablespace.accept((SQLASTVisitor)this);
        }
        return false;
    }

    public boolean visit(SQLAlterTableAddColumn x) {
        boolean odps = this.isOdps();
        this.print0(this.ucase ? "ADD COLUMN " : "add column ");
        this.printAndAccept(x.getColumns(), ", ");
        return false;
    }

    public boolean visit(OracleXmlColumnProperties.OracleXMLTypeStorage x) {
        return false;
    }

    public boolean visit(SQLArrayDataType x) {
        x.getComponentType().accept((SQLASTVisitor)this);
        this.print('[');
        this.printAndAccept(x.getArguments(), ", ");
        this.print(']');
        return false;
    }

    public boolean visit(SQLCreateSequenceStatement x) {
        SQLExpr unitIndex;
        SQLExpr unitCount;
        Boolean cache;
        this.print0(this.ucase ? "CREATE " : "create ");
        this.print0(this.ucase ? "SEQUENCE " : "sequence ");
        x.getName().accept((SQLASTVisitor)this);
        long[] max = new long[1];
        if (x.getMaxValue() != null) {
            this.print0(this.ucase ? " MAXVALUE " : " maxvalue ");
            this.handleLong(x.getMaxValue(), max, true);
        }
        if (x.getStartWith() != null) {
            this.print0(this.ucase ? " START WITH " : " start with ");
            this.handleLong(x.getStartWith(), max, false);
        }
        if (x.getIncrementBy() != null) {
            this.print0(this.ucase ? " INCREMENT BY " : " increment by ");
            x.getIncrementBy().accept((SQLASTVisitor)this);
        }
        if (x.isNoMaxValue()) {
            this.print0(this.ucase ? " NO MAXVALUE " : " no maxvalue ");
        }
        if (x.getMinValue() != null) {
            this.print0(this.ucase ? " MINVALUE " : " minvalue ");
            x.getMinValue().accept((SQLASTVisitor)this);
        }
        if (x.isNoMinValue()) {
            this.print0(this.ucase ? " NO MINVALUE" : " no minvalue");
        }
        if (x.getCycle() != null) {
            if (x.getCycle().booleanValue()) {
                this.print0(this.ucase ? " CYCLE" : " cycle");
            } else {
                this.print0(this.ucase ? " NO CYCLE" : " no cycle");
            }
        }
        if ((cache = x.getCache()) != null && cache.booleanValue()) {
            this.print0(this.ucase ? " CACHE" : " cache");
            SQLExpr cacheValue = x.getCacheValue();
            if (cacheValue != null) {
                this.print(' ');
                cacheValue.accept((SQLASTVisitor)this);
            }
        }
        if ((unitCount = x.getUnitCount()) != null) {
            this.print0(this.ucase ? " UNIT COUNT " : " unit count ");
            this.printExpr(unitCount);
        }
        if ((unitIndex = x.getUnitIndex()) != null) {
            this.print0(this.ucase ? " INDEX " : " index ");
            this.printExpr(unitIndex);
        }
        if (x.getStep() != null) {
            this.print0(this.ucase ? " STEP " : " step ");
            this.printExpr(x.getStep());
        }
        return false;
    }

    private void handleLong(SQLExpr expr, long[] max, boolean extract) {
        if (expr instanceof SQLIntegerExpr) {
            long transitionData;
            SQLIntegerExpr maxValue = (SQLIntegerExpr)expr;
            BigInteger cur = new BigInteger(maxValue.getNumber().toString());
            if (cur.compareTo(BigInteger.valueOf(transitionData = Long.MAX_VALUE)) > 0) {
                cur = BigInteger.valueOf(transitionData);
            }
            if (extract) {
                max[0] = Math.max(max[0], cur.longValue());
                this.print(max[0]);
            } else {
                this.print(Math.min(max[0], cur.longValue()));
            }
        } else {
            expr.accept((SQLASTVisitor)this);
        }
    }

    public boolean visit(SQLCreateProcedureStatement x) {
        this.useUnisql = true;
        boolean create = x.isCreate();
        this.print0(this.ucase ? "CREATE OR REPLACE PROCEDURE " : "create or replace procedure ");
        x.getName().accept((SQLASTVisitor)this);
        int paramSize = x.getParameters().size();
        if (paramSize > 0) {
            this.print0(" (");
            ++this.indentCount;
            this.println();
            for (int i = 0; i < paramSize; ++i) {
                if (i != 0) {
                    this.print0(", ");
                    this.println();
                }
                SQLParameter param = (SQLParameter)x.getParameters().get(i);
                param.accept((SQLASTVisitor)this);
            }
            --this.indentCount;
            this.println();
            this.print(')');
        } else {
            this.print0("()");
        }
        SQLStatement block = x.getBlock();
        String wrappedSource = x.getWrappedSource();
        if (wrappedSource != null) {
            this.print0(this.ucase ? " WRAPPED " : " wrapped ");
            this.print0(wrappedSource);
        } else {
            if (block != null && !create) {
                this.println();
                this.print("IS");
                this.println();
            } else {
                this.println();
                if (block instanceof SQLBlockStatement) {
                    this.println(this.ucase ? "AS $body$" : "as $body$ ");
                    SQLBlockStatement sqlBlockStatement = (SQLBlockStatement)block;
                    if (sqlBlockStatement.getParameters().size() > 0) {
                        this.println("declare");
                    }
                }
            }
            String javaCallSpec = x.getJavaCallSpec();
            if (javaCallSpec != null) {
                this.print0(this.ucase ? "LANGUAGE JAVA NAME '" : "language java name '");
                this.print0(javaCallSpec);
                this.print('\'');
                return false;
            }
        }
        boolean afterSemi = false;
        if (block != null) {
            block.accept((SQLASTVisitor)this);
            if (block instanceof SQLBlockStatement && ((SQLBlockStatement)block).getStatementList().size() > 0) {
                afterSemi = ((SQLStatement)((SQLBlockStatement)block).getStatementList().get(0)).isAfterSemi();
            }
        }
        if (!afterSemi && x.getParent() instanceof OracleCreatePackageStatement) {
            this.print(';');
        }
        this.print0(" $body$ LANGUAGE PLPGSQL;");
        return false;
    }

    private void collectParameterName(SQLName name) {
        this.paramNames.add(name.getSimpleName());
    }

    private void fillIndexParam(SQLName forIndex) {
        if (!this.paramNames.contains(forIndex.getSimpleName())) {
            StringBuilder sb = (StringBuilder)this.appender;
            int indexOf = sb.indexOf(this.ucase ? "BEGIN" : "begin");
            sb.insert(indexOf, String.format("    %s record;\n", forIndex.getSimpleName()));
            this.paramNames.add(forIndex.getSimpleName());
        }
    }

    protected void printDataType(SQLDataType x) {
        Boolean withTimeZone;
        boolean parameterized = this.parameterized;
        this.parameterized = false;
        this.decorate();
        this.print0(CommonUtils.trimLeadTailDoubleQuote((String)MotionEtlGlobalCtx.getInstance().tryReplaceType(x.getName())));
        List arguments = x.getArguments();
        if (arguments.size() > 0 && x.getName().equalsIgnoreCase("FLOAT") && ((SQLIntegerExpr)arguments.get(0)).getNumber().intValue() > 53) {
            ((SQLIntegerExpr)arguments.get(0)).setNumber((Number)53);
        }
        if (arguments.size() > 0) {
            this.print('(');
            int size = arguments.size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    this.print0(", ");
                }
                this.printExpr((SQLExpr)arguments.get(i), false);
            }
            this.print(')');
        }
        if ((withTimeZone = x.getWithTimeZone()) != null) {
            if (withTimeZone.booleanValue()) {
                if (x.isWithLocalTimeZone()) {
                    this.print0(this.ucase ? " WITH LOCAL TIME ZONE" : " with local time zone");
                } else {
                    this.print0(this.ucase ? " WITH TIME ZONE" : " with time zone");
                }
            } else {
                this.print0(this.ucase ? " WITHOUT TIME ZONE" : " without time zone");
            }
        }
        String toPrint = this.parseType();
        if (x instanceof SQLDataTypeImpl) {
            SQLExpr indexBy = ((SQLDataTypeImpl)x).getIndexBy();
            if (indexBy != null) {
                StringBuilder append = (StringBuilder)this.appender;
                if (BINARY_INTEGER.equals(indexBy.toString())) {
                    int index = append.lastIndexOf("domain");
                    append.replace(index, index + 6, "TYPE");
                    append.append(" AS TABLE OF ").append(toPrint);
                } else {
                    log.error("current unsupported index type: " + indexBy.toString());
                    int index = append.lastIndexOf(";");
                    append.delete(index, append.length());
                }
            } else {
                this.print0(toPrint);
            }
        } else {
            this.print0(toPrint);
        }
        this.parameterized = parameterized;
    }

    private String parseType() {
        String sql = this.restoreAndGetInterceptSql();
        if (this.useUnisql) {
            String parsed = this.goParse(String.format("CREATE TABLE a (b %s )", sql));
            sql = parsed.substring(18, parsed.length() - 1);
        }
        return sql;
    }

    private void printTransformName(String name) {
        if (this.useUnisql) {
            String mapName = nameMapping.getOrDefault(name.toLowerCase(), name);
            this.print0(mapName);
        } else {
            this.print0(name);
        }
    }

    protected void transformName(String name) {
        this.printTransformName(name);
    }

    public boolean visit(SQLCommitStatement x) {
        x.setAfterSemi(false);
        return false;
    }

    public boolean visit(SQLExprStatement x) {
        if (x.getExpr() instanceof SQLMethodInvokeExpr) {
            SQLMethodInvokeExpr invoke = (SQLMethodInvokeExpr)x.getExpr();
            String methodName = invoke.getMethodName();
            if (methodName.equalsIgnoreCase("RAISE_APPLICATION_ERROR")) {
                List arguments = invoke.getArguments();
                StringBuilder append = new StringBuilder().append("RAISE EXCEPTION '%s',").append(((SQLExpr)arguments.get(1)).toString()).append(" USING ERRCODE=").append(((SQLExpr)arguments.get(0)).toString());
                this.print0(append.toString());
                return false;
            }
            if (MotionEtlGlobalCtx.getInstance().isProcedure(methodName.toLowerCase())) {
                this.print0("call ");
            } else {
                this.print0("perform ");
            }
        }
        x.getExpr().accept((SQLASTVisitor)this);
        return false;
    }

    public boolean visit(SQLParameter x) {
        SQLName name = x.getName();
        this.collectParameterName(name);
        if (x.getDataType().getName().equalsIgnoreCase("CURSOR")) {
            x.getName().accept((SQLASTVisitor)this);
            this.print0(this.ucase ? " CURSOR" : " cursor");
            List parameters = x.getCursorParameters();
            if (!CollectionUtils.isEmpty((Collection)parameters)) {
                this.print0("(");
                for (int i = 0; i < parameters.size(); ++i) {
                    if (i != 0) {
                        this.print0(",");
                    }
                    ((SQLParameter)parameters.get(i)).accept((SQLASTVisitor)this);
                }
                this.print0(")");
            }
            this.print0(this.ucase ? " FOR " : " for ");
            ++this.indentCount;
            this.println();
            SQLSelect select = ((SQLQueryExpr)x.getDefaultValue()).getSubQuery();
            select.accept((SQLASTVisitor)this);
            --this.indentCount;
        } else {
            if (x.isMap()) {
                this.print0(this.ucase ? "MAP MEMBER " : "map member ");
            } else if (x.isOrder()) {
                this.print0(this.ucase ? "ORDER MEMBER " : "order member ");
            } else if (x.isMember()) {
                this.print0(this.ucase ? "MEMBER " : "member ");
            }
            SQLDataType dataType = x.getDataType();
            if (DbType.oracle == this.dbType || dataType instanceof OracleFunctionDataType || dataType instanceof OracleProcedureDataType) {
                boolean printType;
                if (dataType instanceof OracleFunctionDataType) {
                    OracleFunctionDataType functionDataType = (OracleFunctionDataType)dataType;
                    this.visit(functionDataType);
                    return false;
                }
                if (dataType instanceof OracleProcedureDataType) {
                    OracleProcedureDataType procedureDataType = (OracleProcedureDataType)dataType;
                    this.visit(procedureDataType);
                    return false;
                }
                String dataTypeName = dataType.getName();
                boolean bl = printType = dataTypeName.startsWith("TABLE OF") && x.getDefaultValue() == null || dataTypeName.equalsIgnoreCase("REFCURSOR") || dataTypeName.startsWith("VARRAY(");
                if (printType) {
                    this.print0(this.ucase ? "TYPE " : "type ");
                }
                name.accept((SQLASTVisitor)this);
                if (x.getParamType() == SQLParameter.ParameterType.IN) {
                    this.print0(this.ucase ? " IN " : " in ");
                } else if (x.getParamType() == SQLParameter.ParameterType.OUT) {
                    this.print0(this.ucase ? " OUT " : " out ");
                } else if (x.getParamType() == SQLParameter.ParameterType.INOUT) {
                    this.print0(this.ucase ? " IN OUT " : " in out ");
                } else {
                    this.print(' ');
                }
                if (x.isNoCopy()) {
                    this.print0(this.ucase ? "NOCOPY " : "nocopy ");
                }
                if (x.isConstant()) {
                    this.print0(this.ucase ? "CONSTANT " : "constant ");
                }
                if (printType) {
                    this.print0(this.ucase ? "IS " : "is ");
                }
            } else {
                if (x.getParamType() == SQLParameter.ParameterType.IN) {
                    this.print0(this.ucase ? "IN " : "in ");
                } else if (x.getParamType() == SQLParameter.ParameterType.OUT) {
                    this.print0(this.ucase ? "INOUT " : "inout ");
                } else if (x.getParamType() == SQLParameter.ParameterType.INOUT) {
                    this.print0(this.ucase ? "INOUT " : "inout ");
                }
                x.getName().accept((SQLASTVisitor)this);
                this.print(' ');
            }
            dataType.accept((SQLASTVisitor)this);
            this.printAssignedValue(x);
        }
        return false;
    }

    protected void printName0(String text) {
        if (this.appender == null || text.length() == 0) {
            return;
        }
        if (text.indexOf("#") < 0) {
            text = MotionEtlGlobalCtx.getInstance().removeQuotes(text);
        }
        text = keywords.getOrDefault(text.toLowerCase(), text);
        try {
            if (this.printNameQuote) {
                char c0 = text.charAt(0);
                if (c0 == this.quote) {
                    this.appender.append(text);
                } else if (c0 == '\"' && text.charAt(text.length() - 1) == '\"') {
                    this.appender.append(this.quote);
                    this.appender.append(text.substring(1, text.length() - 1));
                    this.appender.append(this.quote);
                } else if (c0 == '`' && text.charAt(text.length() - 1) == '`') {
                    this.appender.append(this.quote);
                    this.appender.append(text.substring(1, text.length() - 1));
                    this.appender.append(this.quote);
                } else {
                    this.appender.append(this.quote);
                    this.appender.append(text);
                    this.appender.append(this.quote);
                }
            } else {
                this.appender.append(text);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("println error", e);
        }
    }

    public void decorate() {
        this.appender = new AppendableWrap(this.appender);
        this.createProcedureOrFunctionBak = this.useUnisql;
        this.useUnisql = false;
    }

    public void transformAndRestore() {
        String interceptSql = this.restoreAndGetInterceptSql();
        this.goParseAndPrint(interceptSql);
    }

    private void goParseAndPrint(String interceptSql) {
        String parse = this.goParse(interceptSql);
        this.print0(parse);
    }

    private String goParse(String interceptSql) {
        String parsedSql = this.etlTransformer.goParse(interceptSql);
        if (parsedSql.endsWith("ERROR")) {
            return interceptSql;
        }
        return parsedSql;
    }

    private String restoreAndGetInterceptSql() {
        AppendableWrap appendableWrap = (AppendableWrap)this.appender;
        String interceptSql = appendableWrap.interceptSql();
        this.appender = appendableWrap.raw;
        this.useUnisql = this.createProcedureOrFunctionBak;
        return interceptSql;
    }

    protected void print0(String text) {
        if (this.appender == null) {
            return;
        }
        try {
            this.appender.append(text);
        }
        catch (IOException e) {
            throw new RuntimeException("println error", e);
        }
    }

    public boolean visit(SQLMergeStatement x) {
        this.decorate();
        boolean visit = super.visit(x);
        this.transformAndRestore();
        return visit;
    }

    public boolean visit(SQLCreateFunctionStatement x) {
        SQLName using;
        SQLStatement block;
        this.useUnisql = true;
        boolean create = x.isCreate();
        this.print0(this.ucase ? "CREATE OR REPLACE FUNCTION " : "create or replace function ");
        x.getName().accept((SQLASTVisitor)this);
        int paramSize = x.getParameters().size();
        if (paramSize > 0) {
            this.print0(" (");
            ++this.indentCount;
            this.println();
            for (int i = 0; i < paramSize; ++i) {
                if (i != 0) {
                    this.print0(", ");
                    this.println();
                }
                SQLParameter param = (SQLParameter)x.getParameters().get(i);
                param.accept((SQLASTVisitor)this);
            }
            --this.indentCount;
            this.println();
            this.print(')');
        } else {
            this.print("()");
        }
        String wrappedSource = x.getWrappedSource();
        if (wrappedSource != null) {
            this.print0(this.ucase ? " WRAPPED " : " wrapped ");
            this.print0(wrappedSource);
            if (x.isAfterSemi()) {
                this.print(';');
            }
            return false;
        }
        this.println();
        this.print(this.ucase ? "RETURNS " : "returns ");
        x.getReturnDataType().accept((SQLASTVisitor)this);
        if (x.isPipelined()) {
            this.print(this.ucase ? "PIPELINED " : "pipelined ");
        }
        if (x.isDeterministic()) {
            this.print(this.ucase ? "DETERMINISTIC " : "deterministic ");
        }
        if ((block = x.getBlock()) != null && !create) {
            this.println();
            this.println("IS");
        } else {
            this.println();
            if (block instanceof SQLBlockStatement) {
                this.println(this.ucase ? "AS $body$" : "as $body$ ");
                SQLBlockStatement sqlBlockStatement = (SQLBlockStatement)block;
                if (sqlBlockStatement.getParameters().size() > 0) {
                    this.println("declare");
                }
            }
        }
        String javaCallSpec = x.getJavaCallSpec();
        if (javaCallSpec != null) {
            this.print0(this.ucase ? "LANGUAGE JAVA NAME '" : "language java name '");
            this.print0(javaCallSpec);
            this.print('\'');
            return false;
        }
        if (x.isParallelEnable()) {
            this.print0(this.ucase ? "PARALLEL_ENABLE" : "parallel_enable");
            this.println();
        }
        if (x.isAggregate()) {
            this.print0(this.ucase ? "AGGREGATE" : "aggregate");
            this.println();
        }
        if ((using = x.getUsing()) != null) {
            this.print0(this.ucase ? "USING " : "using ");
            using.accept((SQLASTVisitor)this);
        }
        if (block != null) {
            block.accept((SQLASTVisitor)this);
        }
        this.print0(" $body$ LANGUAGE PLPGSQL;");
        return false;
    }

    public boolean visit(SQLCreateTriggerStatement x) {
        SQLExpr when;
        this.decorate();
        this.print0(this.ucase ? "CREATE " : "create ");
        if (x.isOrReplace()) {
            this.print0(this.ucase ? "OR REPLACE " : "or replace ");
        }
        this.print0(this.ucase ? "TRIGGER " : "trigger ");
        if (x.getName() instanceof SQLPropertyExpr) {
            SQLPropertyExpr sqlPropertyExpr = (SQLPropertyExpr)x.getName();
            String name = sqlPropertyExpr.getName();
            this.print0(CommonUtils.trimLeadTailDoubleQuote((String)name));
        } else {
            x.getName().accept((SQLASTVisitor)this);
        }
        ++this.indentCount;
        this.println();
        if (SQLCreateTriggerStatement.TriggerType.INSTEAD_OF.equals((Object)x.getTriggerType())) {
            this.print0(this.ucase ? "INSTEAD OF" : "instead of");
        } else {
            String triggerTypeName = x.getTriggerType().name();
            this.print0(this.ucase ? triggerTypeName : triggerTypeName.toLowerCase());
        }
        if (x.isInsert()) {
            this.print0(this.ucase ? " INSERT" : " insert");
        }
        if (x.isDelete()) {
            if (x.isInsert()) {
                this.print0(this.ucase ? " OR" : " or");
            }
            this.print0(this.ucase ? " DELETE" : " delete");
        }
        if (x.isUpdate()) {
            if (x.isInsert() || x.isDelete()) {
                this.print0(this.ucase ? " OR" : " or");
            }
            this.print0(this.ucase ? " UPDATE " : " update ");
            List colums = x.getUpdateOfColumns();
            if (!colums.isEmpty()) {
                this.print0(this.ucase ? " OF " : " of ");
            }
            boolean first = true;
            for (SQLName colum : colums) {
                if (first) {
                    this.print(' ');
                } else {
                    this.print(", ");
                }
                colum.accept((SQLASTVisitor)this);
                first = false;
            }
        }
        this.println();
        this.print0(this.ucase ? "ON " : "on ");
        x.getOn().accept((SQLASTVisitor)this);
        if (x.isForEachRow()) {
            this.println();
            this.print0(this.ucase ? "FOR EACH ROW" : "for each row");
        }
        if ((when = x.getWhen()) != null) {
            this.println();
            this.print0(this.ucase ? "WHEN " : "when ");
            when.accept((SQLASTVisitor)this);
        }
        --this.indentCount;
        this.println();
        String createTrigger = this.restoreAndGetInterceptSql();
        this.decorate();
        x.getBody().accept((SQLASTVisitor)this);
        String suffix = RandomStringUtils.randomAlphanumeric((int)8);
        String simpleName = CommonUtils.trimLeadTailDoubleQuote((String)x.getName().getSimpleName());
        String triggerFunc = simpleName + "_" + suffix;
        String createTriggerBody = this.restoreAndGetInterceptSql();
        this.print0(String.format("CREATE OR REPLACE FUNCTION %s() RETURNS TRIGGER AS $$\n%s\n$$ LANGUAGE plpgsql;", triggerFunc, createTriggerBody));
        this.print0(String.format("%s EXECUTE FUNCTION %s();", createTrigger, triggerFunc));
        return false;
    }

    static {
        keywords.put("sqlcode", "sqlstate");
        keywords.put("minus", "expect");
        keywords.put(":old", "OLD");
        keywords.put(":new", "NEW");
    }
}

