/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.visitor;

import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLParameter;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTriggerStatement;
import com.alibaba.druid.sql.ast.statement.SQLIfStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLWhileStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.OracleDataTypeIntervalDay;
import com.alibaba.druid.sql.dialect.oracle.ast.OracleSegmentAttributes;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.CycleClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.ModelClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleReturningClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleWithSubqueryEntry;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.SampleClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.SearchClause;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleAnalytic;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleAnalyticWindowing;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleBinaryDoubleExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleIsOfTypeExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleIsSetExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleTreatExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterSessionStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterSynonymStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTriggerStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterViewStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleContinueStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateSynonymStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateTableStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateTypeStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleForStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleGotoStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleInsertStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleLabelStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleMultiInsertStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleRunStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectPivot;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectQueryBlock;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectTableReference;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectUnPivot;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSupplementalIdKey;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSupplementalLogGrp;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleUpdateStatement;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleFunctionDataType;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleProcedureDataType;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.List;

public class OracleExtendAstOutputVisitor
extends SQLASTOutputVisitor
implements OracleASTVisitor {
    public OracleExtendAstOutputVisitor(Appendable appender) {
        super(appender);
    }

    public OracleExtendAstOutputVisitor(Appendable appender, boolean parameterized) {
        super(appender, parameterized);
    }

    public boolean visit(SQLWhileStatement x) {
        String label = x.getLabelName();
        if (label != null && label.length() != 0) {
            this.print0(x.getLabelName());
            this.print0(": ");
        }
        this.print0(this.ucase ? "WHILE " : "while ");
        x.getCondition().accept((SQLASTVisitor)this);
        this.print0(this.ucase ? " LOOP" : " loop");
        this.println();
        int size = x.getStatements().size();
        for (int i = 0; i < size; ++i) {
            SQLStatement item = (SQLStatement)x.getStatements().get(i);
            item.accept((SQLASTVisitor)this);
            if (i == size - 1) continue;
            this.println();
        }
        this.println();
        this.print0(this.ucase ? "END LOOP;" : "end loop;");
        if (label != null && label.length() != 0) {
            this.print(' ');
            this.print0(label);
        }
        return false;
    }

    public boolean visit(OracleBinaryDoubleExpr x) {
        if (x != null && x.getValue() != null) {
            this.print0(x.getValue().toString());
            this.print('D');
        }
        return false;
    }

    public boolean visit(OracleIsSetExpr x) {
        x.getNestedTable().accept((SQLASTVisitor)this);
        this.print0(this.ucase ? " IS A SET" : " is a set");
        return false;
    }

    public boolean visit(ModelClause.ModelColumnClause x) {
        if (x.getQueryPartitionClause() != null) {
            x.getQueryPartitionClause().accept((SQLASTVisitor)this);
            this.println();
        }
        this.print0(this.ucase ? "DIMENSION BY (" : "dimension by (");
        this.printAndAccept(x.getDimensionByColumns(), ", ");
        this.print(')');
        this.println();
        this.print0(this.ucase ? "MEASURES (" : "measures (");
        this.printAndAccept(x.getMeasuresColumns(), ", ");
        this.print(')');
        return false;
    }

    public boolean visit(ModelClause.ModelRulesClause x) {
        if (x.getOptions().size() > 0) {
            this.print0(this.ucase ? "RULES" : "rules");
            for (ModelClause.ModelRuleOption opt : x.getOptions()) {
                this.print(' ');
                this.print0(opt.name);
            }
        }
        if (x.getIterate() != null) {
            this.print0(this.ucase ? " ITERATE (" : " iterate (");
            x.getIterate().accept((SQLASTVisitor)this);
            this.print(')');
            if (x.getUntil() != null) {
                this.print0(this.ucase ? " UNTIL (" : " until (");
                x.getUntil().accept((SQLASTVisitor)this);
                this.print(')');
            }
        }
        this.print0(" (");
        this.printAndAccept(x.getCellAssignmentItems(), ", ");
        this.print(')');
        return false;
    }

    public boolean visit(ModelClause.CellAssignmentItem x) {
        if (x.getOption() != null) {
            this.print0(x.getOption().name);
            this.print(' ');
        }
        x.getCellAssignment().accept((SQLASTVisitor)this);
        if (x.getOrderBy() != null) {
            this.print(' ');
            x.getOrderBy().accept((SQLASTVisitor)this);
        }
        this.print0(" = ");
        x.getExpr().accept((SQLASTVisitor)this);
        return false;
    }

    public boolean visit(OracleReturningClause x) {
        this.print0(this.ucase ? "RETURNING " : "returning ");
        this.printAndAccept(x.getItems(), ", ");
        this.print0(this.ucase ? " INTO " : " into ");
        this.printAndAccept(x.getValues(), ", ");
        return false;
    }

    public boolean visit(OracleMultiInsertStatement.InsertIntoClause x) {
        this.print0(this.ucase ? "INTO " : "into ");
        x.getTableSource().accept((SQLASTVisitor)this);
        if (x.getColumns().size() > 0) {
            ++this.indentCount;
            this.println();
            this.print('(');
            int size = x.getColumns().size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    if (i % 5 == 0) {
                        this.println();
                    }
                    this.print0(", ");
                }
                ((SQLExpr)x.getColumns().get(i)).accept((SQLASTVisitor)this);
            }
            this.print(')');
            --this.indentCount;
        }
        if (x.getValues() != null) {
            this.println();
            this.print0(this.ucase ? "VALUES " : "values ");
            x.getValues().accept((SQLASTVisitor)this);
        } else if (x.getQuery() != null) {
            this.println();
            x.getQuery().accept((SQLASTVisitor)this);
        }
        return false;
    }

    public boolean visit(OracleMultiInsertStatement.ConditionalInsertClause x) {
        int size = x.getItems().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.println();
            }
            OracleMultiInsertStatement.ConditionalInsertClauseItem item = (OracleMultiInsertStatement.ConditionalInsertClauseItem)x.getItems().get(i);
            item.accept((SQLASTVisitor)this);
        }
        if (x.getElseItem() != null) {
            this.println();
            this.print0(this.ucase ? "ELSE" : "else");
            ++this.indentCount;
            this.println();
            x.getElseItem().accept((SQLASTVisitor)this);
            --this.indentCount;
        }
        return false;
    }

    public boolean visit(OracleSelectQueryBlock x) {
        SQLOrderBy orderBy;
        if (this.isPrettyFormat() && x.hasBeforeComment()) {
            this.printlnComments(x.getBeforeCommentsDirect());
        }
        this.print0(this.ucase ? "SELECT " : "select ");
        if (x.getHintsSize() > 0) {
            this.printAndAccept(x.getHints(), ", ");
            this.print(' ');
        }
        if (1 == x.getDistionOption()) {
            this.print0(this.ucase ? "ALL " : "all ");
        } else if (2 == x.getDistionOption()) {
            this.print0(this.ucase ? "DISTINCT " : "distinct ");
        } else if (3 == x.getDistionOption()) {
            this.print0(this.ucase ? "UNIQUE " : "unique ");
        }
        this.printSelectList(x.getSelectList());
        if (x.getInto() != null) {
            this.println();
            this.print0(this.ucase ? "INTO " : "into ");
            x.getInto().accept((SQLASTVisitor)this);
        }
        this.println();
        this.print0(this.ucase ? "FROM " : "from ");
        if (x.getFrom() == null) {
            this.print0(this.ucase ? "DUAL" : "dual");
        } else {
            x.getFrom().accept((SQLASTVisitor)this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.print0(this.ucase ? "WHERE " : "where ");
            x.getWhere().accept((SQLASTVisitor)this);
        }
        this.printHierarchical((SQLSelectQueryBlock)x);
        if (x.getGroupBy() != null) {
            this.println();
            x.getGroupBy().accept((SQLASTVisitor)this);
        }
        if (x.getModelClause() != null) {
            this.println();
            x.getModelClause().accept((SQLASTVisitor)this);
        }
        if ((orderBy = x.getOrderBy()) != null) {
            this.println();
            orderBy.accept((SQLASTVisitor)this);
        }
        this.printFetchFirst((SQLSelectQueryBlock)x);
        if (x.isForUpdate()) {
            this.println();
            this.print0(this.ucase ? "FOR UPDATE" : "for update");
            if (x.getForUpdateOfSize() > 0) {
                this.print('(');
                this.printAndAccept(x.getForUpdateOf(), ", ");
                this.print(')');
            }
            if (x.isNoWait()) {
                this.print0(this.ucase ? " NOWAIT" : " nowait");
            } else if (x.isSkipLocked()) {
                this.print0(this.ucase ? " SKIP LOCKED" : " skip locked");
            } else if (x.getWaitTime() != null) {
                this.print0(this.ucase ? " WAIT " : " wait ");
                x.getWaitTime().accept((SQLASTVisitor)this);
            }
        }
        return false;
    }

    public boolean visit(OracleAlterSessionStatement x) {
        this.print0(this.ucase ? "ALTER SESSION SET " : "alter session set ");
        this.printAndAccept(x.getItems(), ", ");
        return false;
    }

    public boolean visit(OracleSupplementalLogGrp x) {
        this.print0(this.ucase ? "SUPPLEMENTAL LOG GROUP " : "supplemental log group ");
        x.getGroup().accept((SQLASTVisitor)this);
        this.print0(" (");
        this.printAndAccept(x.getColumns(), ", ");
        this.print(')');
        if (x.isAlways()) {
            this.print0(this.ucase ? " ALWAYS" : " always");
        }
        return false;
    }

    public boolean visit(OracleSupplementalIdKey x) {
        this.print0(this.ucase ? "SUPPLEMENTAL LOG DATA (" : "supplemental log data (");
        int count = 0;
        if (x.isAll()) {
            this.print0(this.ucase ? "ALL" : "all");
            ++count;
        }
        if (x.isPrimaryKey()) {
            if (count != 0) {
                this.print0(", ");
            }
            this.print0(this.ucase ? "PRIMARY KEY" : "primary key");
            ++count;
        }
        if (x.isUnique()) {
            if (count != 0) {
                this.print0(", ");
            }
            this.print0(this.ucase ? "UNIQUE" : "unique");
            ++count;
        }
        if (x.isUniqueIndex()) {
            if (count != 0) {
                this.print0(", ");
            }
            this.print0(this.ucase ? "UNIQUE INDEX" : "unique index");
            ++count;
        }
        if (x.isForeignKey()) {
            if (count != 0) {
                this.print0(", ");
            }
            this.print0(this.ucase ? "FOREIGN KEY" : "foreign key");
            ++count;
        }
        this.print0(this.ucase ? ") COLUMNS" : ") columns");
        return false;
    }

    public boolean visit(OracleCreateTableStatement.OIDIndex x) {
        this.print0(this.ucase ? "OIDINDEX" : "oidindex");
        if (x.getName() != null) {
            this.print(' ');
            x.getName().accept((SQLASTVisitor)this);
        }
        this.print(" (");
        ++this.indentCount;
        this.printOracleSegmentAttributes((OracleSegmentAttributes)x);
        --this.indentCount;
        this.println();
        this.print(")");
        return false;
    }

    public boolean visit(OracleTreatExpr x) {
        this.print0(this.ucase ? "TREAT (" : "treat (");
        x.getExpr().accept((SQLASTVisitor)this);
        this.print0(this.ucase ? " AS " : " as ");
        if (x.isRef()) {
            this.print0(this.ucase ? "REF " : "ref ");
        }
        x.getType().accept((SQLASTVisitor)this);
        this.print(')');
        return false;
    }

    public boolean visit(OracleCreateSynonymStatement x) {
        if (x.isOrReplace()) {
            this.print0(this.ucase ? "CREATE OR REPLACE " : "create or replace ");
        } else {
            this.print0(this.ucase ? "CREATE " : "create ");
        }
        if (x.isPublic()) {
            this.print0(this.ucase ? "PUBLIC " : "public ");
        }
        this.print0(this.ucase ? "SYNONYM " : "synonym ");
        x.getName().accept((SQLASTVisitor)this);
        this.print0(this.ucase ? " FOR " : " for ");
        x.getObject().accept((SQLASTVisitor)this);
        return false;
    }

    public boolean visit(OracleGotoStatement x) {
        this.print0(this.ucase ? "GOTO " : "GOTO ");
        x.getLabel().accept((SQLASTVisitor)this);
        return false;
    }

    public boolean visit(OracleLabelStatement x) {
        this.print0("<<");
        x.getLabel().accept((SQLASTVisitor)this);
        this.print0(">>");
        return false;
    }

    public boolean visit(OracleAlterTriggerStatement x) {
        this.print0(this.ucase ? "ALTER TRIGGER " : "alter trigger ");
        x.getName().accept((SQLASTVisitor)this);
        if (x.isCompile()) {
            this.print0(this.ucase ? " COMPILE" : " compile");
        }
        if (x.getEnable() != null) {
            if (x.getEnable().booleanValue()) {
                this.print0(this.ucase ? " ENABLE" : " enable");
            } else {
                this.print0(this.ucase ? " DISABLE" : " disable");
            }
        }
        return false;
    }

    public boolean visit(SQLCreateTriggerStatement x) {
        SQLExpr when;
        this.print0(this.ucase ? "CREATE " : "create ");
        if (x.isOrReplace()) {
            this.print0(this.ucase ? "OR REPLACE " : "or replace ");
        }
        this.print0(this.ucase ? "TRIGGER " : "trigger ");
        x.getName().accept((SQLASTVisitor)this);
        ++this.indentCount;
        this.println();
        if (SQLCreateTriggerStatement.TriggerType.INSTEAD_OF.equals((Object)x.getTriggerType())) {
            this.print0(this.ucase ? "INSTEAD OF" : "instead of");
        } else {
            String triggerTypeName = x.getTriggerType().name();
            this.print0(this.ucase ? triggerTypeName : triggerTypeName.toLowerCase());
        }
        if (x.isInsert()) {
            this.print0(this.ucase ? " INSERT" : " insert");
        }
        if (x.isDelete()) {
            if (x.isInsert()) {
                this.print0(this.ucase ? " OR" : " or");
            }
            this.print0(this.ucase ? " DELETE" : " delete");
        }
        if (x.isUpdate()) {
            if (x.isInsert() || x.isDelete()) {
                this.print0(this.ucase ? " OR" : " or");
            }
            this.print0(this.ucase ? " UPDATE " : " update ");
            List colums = x.getUpdateOfColumns();
            if (!colums.isEmpty()) {
                this.print0(this.ucase ? " OF " : " of ");
            }
            boolean first = true;
            for (SQLName colum : colums) {
                if (first) {
                    this.print(' ');
                } else {
                    this.print(", ");
                }
                colum.accept((SQLASTVisitor)this);
                first = false;
            }
        }
        this.println();
        this.print0(this.ucase ? "ON " : "on ");
        x.getOn().accept((SQLASTVisitor)this);
        if (x.isForEachRow()) {
            this.println();
            this.print0(this.ucase ? "FOR EACH ROW" : "for each row");
        }
        if ((when = x.getWhen()) != null) {
            this.println();
            this.print0(this.ucase ? "WHEN " : "when ");
            when.accept((SQLASTVisitor)this);
        }
        --this.indentCount;
        this.println();
        x.getBody().accept((SQLASTVisitor)this);
        return false;
    }

    public boolean visit(OracleSelectUnPivot x) {
        this.print0(this.ucase ? "UNPIVOT" : "unpivot");
        if (x.getNullsIncludeType() != null) {
            this.print(' ');
            this.print0(OracleSelectUnPivot.NullsIncludeType.toString((OracleSelectUnPivot.NullsIncludeType)x.getNullsIncludeType(), (boolean)this.ucase));
        }
        this.print0(" (");
        if (x.getItems().size() == 1) {
            ((SQLExpr)x.getItems().get(0)).accept((SQLASTVisitor)this);
        } else {
            this.print0(" (");
            this.printAndAccept(x.getItems(), ", ");
            this.print(')');
        }
        if (x.getPivotFor().size() > 0) {
            this.print0(this.ucase ? " FOR " : " for ");
            if (x.getPivotFor().size() == 1) {
                ((SQLExpr)x.getPivotFor().get(0)).accept((SQLASTVisitor)this);
            } else {
                this.print('(');
                this.printAndAccept(x.getPivotFor(), ", ");
                this.print(')');
            }
        }
        if (x.getPivotIn().size() > 0) {
            this.print0(this.ucase ? " IN (" : " in (");
            this.printAndAccept(x.getPivotIn(), ", ");
            this.print(')');
        }
        this.print(')');
        return false;
    }

    public boolean visit(OracleSelectPivot x) {
        this.print0(this.ucase ? "PIVOT" : "pivot");
        if (x.isXml()) {
            this.print0(this.ucase ? " XML" : " xml");
        }
        this.print0(" (");
        this.printAndAccept(x.getItems(), ", ");
        if (x.getPivotFor().size() > 0) {
            this.print0(this.ucase ? " FOR " : " for ");
            if (x.getPivotFor().size() == 1) {
                ((SQLExpr)x.getPivotFor().get(0)).accept((SQLASTVisitor)this);
            } else {
                this.print('(');
                this.printAndAccept(x.getPivotFor(), ", ");
                this.print(')');
            }
        }
        if (x.getPivotIn().size() > 0) {
            this.print0(this.ucase ? " IN (" : " in (");
            this.printAndAccept(x.getPivotIn(), ", ");
            this.print(')');
        }
        this.print(')');
        return false;
    }

    public boolean visit(OracleUpdateStatement x) {
        this.print0(this.ucase ? "UPDATE " : "update ");
        if (x.getHints().size() > 0) {
            this.printAndAccept(x.getHints(), ", ");
            this.print(' ');
        }
        if (x.isOnly()) {
            this.print0(this.ucase ? "ONLY (" : "only (");
            x.getTableSource().accept((SQLASTVisitor)this);
            this.print(')');
        } else {
            x.getTableSource().accept((SQLASTVisitor)this);
        }
        this.printAlias(x.getAlias());
        this.println();
        this.print0(this.ucase ? "SET " : "set ");
        int size = x.getItems().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print0(", ");
            }
            ((SQLUpdateSetItem)x.getItems().get(i)).accept((SQLASTVisitor)this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.print0(this.ucase ? "WHERE " : "where ");
            ++this.indentCount;
            x.getWhere().accept((SQLASTVisitor)this);
            --this.indentCount;
        }
        if (x.getReturning().size() > 0) {
            this.println();
            this.print0(this.ucase ? "RETURNING " : "returning ");
            this.printAndAccept(x.getReturning(), ", ");
            this.print0(this.ucase ? " INTO " : " into ");
            this.printAndAccept(x.getReturningInto(), ", ");
        }
        return false;
    }

    public boolean visit(SampleClause x) {
        this.print0(this.ucase ? "SAMPLE " : "sample ");
        if (x.isBlock()) {
            this.print0(this.ucase ? "BLOCK " : "block ");
        }
        this.print('(');
        this.printAndAccept(x.getPercent(), ", ");
        this.print(')');
        if (x.getSeedValue() != null) {
            this.print0(this.ucase ? " SEED (" : " seed (");
            x.getSeedValue().accept((SQLASTVisitor)this);
            this.print(')');
        }
        return false;
    }

    public boolean visit(OracleWithSubqueryEntry x) {
        this.print0(x.getAlias());
        if (x.getColumns().size() > 0) {
            this.print0(" (");
            this.printAndAccept(x.getColumns(), ", ");
            this.print(')');
        }
        this.print0(this.ucase ? " AS " : " as ");
        this.print('(');
        ++this.indentCount;
        this.println();
        x.getSubQuery().accept((SQLASTVisitor)this);
        --this.indentCount;
        this.println();
        this.print(')');
        if (x.getSearchClause() != null) {
            this.println();
            x.getSearchClause().accept((SQLASTVisitor)this);
        }
        if (x.getCycleClause() != null) {
            this.println();
            x.getCycleClause().accept((SQLASTVisitor)this);
        }
        return false;
    }

    public boolean visit(SearchClause x) {
        this.print0(this.ucase ? "SEARCH " : "search ");
        this.print0(x.getType().name());
        this.print0(this.ucase ? " FIRST BY " : " first by ");
        this.printAndAccept(x.getItems(), ", ");
        this.print0(this.ucase ? " SET " : " set ");
        x.getOrderingColumn().accept((SQLASTVisitor)this);
        return false;
    }

    public boolean visit(CycleClause x) {
        this.print0(this.ucase ? "CYCLE " : "cycle ");
        this.printAndAccept(x.getAliases(), ", ");
        this.print0(this.ucase ? " SET " : " set ");
        x.getMark().accept((SQLASTVisitor)this);
        this.print0(this.ucase ? " TO " : " to ");
        x.getValue().accept((SQLASTVisitor)this);
        this.print0(this.ucase ? " DEFAULT " : " default ");
        x.getDefaultValue().accept((SQLASTVisitor)this);
        return false;
    }

    public boolean visit(OracleIsOfTypeExpr x) {
        this.printExpr(x.getExpr());
        this.print0(this.ucase ? " IS OF TYPE (" : " is of type (");
        List types = x.getTypes();
        int size = types.size();
        for (int i = 0; i < size; ++i) {
            SQLExpr type;
            if (i != 0) {
                this.print0(", ");
            }
            if (Boolean.TRUE == (type = (SQLExpr)types.get(i)).getAttribute("ONLY")) {
                this.print0(this.ucase ? "ONLY " : "only ");
            }
            type.accept((SQLASTVisitor)this);
        }
        this.print(')');
        return false;
    }

    public boolean visit(OracleRunStatement x) {
        this.print0("@@");
        this.printExpr(x.getExpr());
        return false;
    }

    public boolean visit(SQLIfStatement x) {
        this.print0(this.ucase ? "IF " : "if ");
        int lines = this.lines;
        ++this.indentCount;
        x.getCondition().accept((SQLASTVisitor)this);
        --this.indentCount;
        if (lines != this.lines) {
            this.println();
        } else {
            this.print(' ');
        }
        this.print0(this.ucase ? "THEN" : "then");
        ++this.indentCount;
        int size = x.getStatements().size();
        for (int i = 0; i < size; ++i) {
            this.println();
            SQLStatement item = (SQLStatement)x.getStatements().get(i);
            item.accept((SQLASTVisitor)this);
        }
        --this.indentCount;
        for (SQLIfStatement.ElseIf elseIf : x.getElseIfList()) {
            this.println();
            elseIf.accept((SQLASTVisitor)this);
        }
        if (x.getElseItem() != null) {
            this.println();
            x.getElseItem().accept((SQLASTVisitor)this);
        }
        this.println();
        this.print0(this.ucase ? "END IF" : "end if");
        return false;
    }

    public boolean visit(OracleContinueStatement x) {
        this.print0(this.ucase ? "CONTINUE" : "continue");
        String label = x.getLabel();
        if (label != null) {
            this.print(' ');
            this.print0(label);
        }
        if (x.getWhen() != null) {
            this.print0(this.ucase ? " WHEN " : " when ");
            x.getWhen().accept((SQLASTVisitor)this);
        }
        return false;
    }

    public boolean visit(OracleSelectTableReference x) {
        if (x.isOnly()) {
            this.print0(this.ucase ? "ONLY (" : "only (");
            this.printTableSourceExpr(x.getExpr());
            if (x.getPartition() != null) {
                this.print(' ');
                x.getPartition().accept((SQLASTVisitor)this);
            }
            this.print(')');
        } else {
            this.printTableSourceExpr(x.getExpr());
            if (x.getPartition() != null) {
                this.print(' ');
                x.getPartition().accept((SQLASTVisitor)this);
            }
        }
        return false;
    }

    public boolean visit(OracleDataTypeIntervalDay x) {
        this.print0(x.getName());
        if (x.getArguments().size() > 0) {
            this.print('(');
            ((SQLExpr)x.getArguments().get(0)).accept((SQLASTVisitor)this);
            this.print(')');
        }
        this.print0(this.ucase ? " TO SECOND" : " to second");
        if (x.getFractionalSeconds().size() > 0) {
            this.print('(');
            ((SQLExpr)x.getFractionalSeconds().get(0)).accept((SQLASTVisitor)this);
            this.print(')');
        }
        return false;
    }

    public boolean visit(OracleInsertStatement x) {
        this.print0(this.ucase ? "INSERT " : "insert ");
        if (x.getHints().size() > 0) {
            this.printAndAccept(x.getHints(), ", ");
            this.print(' ');
        }
        this.print0(this.ucase ? "INTO " : "into ");
        x.getTableSource().accept((SQLASTVisitor)this);
        this.printInsertColumns(x.getColumns());
        if (x.getValues() != null) {
            this.println();
            this.print0(this.ucase ? "VALUES " : "values ");
            x.getValues().accept((SQLASTVisitor)this);
        } else if (x.getQuery() != null) {
            this.println();
            x.getQuery().accept((SQLASTVisitor)this);
        }
        if (x.getReturning() != null) {
            this.println();
            x.getReturning().accept((SQLASTVisitor)this);
        }
        if (x.getErrorLogging() != null) {
            this.println();
            x.getErrorLogging().accept((SQLASTVisitor)this);
        }
        return false;
    }

    public boolean visit(OracleMultiInsertStatement.ConditionalInsertClauseItem x) {
        this.print0(this.ucase ? "WHEN " : "when ");
        x.getWhen().accept((SQLASTVisitor)this);
        this.print0(this.ucase ? " THEN" : " then");
        ++this.indentCount;
        this.println();
        x.getThen().accept((SQLASTVisitor)this);
        --this.indentCount;
        return false;
    }

    public boolean visit(OracleCreateTypeStatement x) {
        Boolean instantiable;
        SQLName authId;
        this.print0(this.ucase ? "CREATE TYPE " : "create type ");
        if (x.isBody()) {
            this.print0(this.ucase ? "BODY " : "body ");
        }
        x.getName().accept((SQLASTVisitor)this);
        SQLName under = x.getUnder();
        if (under != null) {
            this.print0(this.ucase ? " UNDER " : " under ");
            under.accept((SQLASTVisitor)this);
        }
        if ((authId = x.getAuthId()) != null) {
            this.print0(this.ucase ? " AUTHID " : " authid ");
            authId.accept((SQLASTVisitor)this);
        }
        if (x.isForce()) {
            this.print0(this.ucase ? "FORCE " : "force ");
        }
        List parameters = x.getParameters();
        SQLDataType tableOf = x.getTableOf();
        if (x.isObject()) {
            this.print0(" AS OBJECT");
        }
        if (parameters.size() > 0) {
            if (x.isParen()) {
                this.print(" (");
            } else {
                this.print0(this.ucase ? " IS" : " is");
            }
            ++this.indentCount;
            this.println();
            for (int i = 0; i < parameters.size(); ++i) {
                SQLParameter param = (SQLParameter)parameters.get(i);
                param.accept((SQLASTVisitor)this);
                SQLDataType dataType = param.getDataType();
                if (i >= parameters.size() - 1) continue;
                if (dataType instanceof OracleFunctionDataType && ((OracleFunctionDataType)dataType).getBlock() != null) {
                    this.println();
                    continue;
                }
                if (dataType instanceof OracleProcedureDataType && ((OracleProcedureDataType)dataType).getBlock() != null) {
                    this.println();
                    continue;
                }
                this.println(", ");
            }
            --this.indentCount;
            this.println();
            if (x.isParen()) {
                this.print0(")");
            } else {
                this.print0("END");
            }
        } else if (tableOf != null) {
            this.print0(this.ucase ? " AS TABLE OF " : " as table of ");
            tableOf.accept((SQLASTVisitor)this);
        } else if (x.getVarraySizeLimit() != null) {
            this.print0(this.ucase ? " VARRAY (" : " varray (");
            x.getVarraySizeLimit().accept((SQLASTVisitor)this);
            this.print0(this.ucase ? ") OF " : ") of ");
            x.getVarrayDataType().accept((SQLASTVisitor)this);
        }
        Boolean isFinal = x.getFinal();
        if (isFinal != null) {
            if (isFinal.booleanValue()) {
                this.print0(this.ucase ? " FINAL" : " final");
            } else {
                this.print0(this.ucase ? " NOT FINAL" : " not final");
            }
        }
        if ((instantiable = x.getInstantiable()) != null) {
            if (instantiable.booleanValue()) {
                this.print0(this.ucase ? " INSTANTIABLE" : " instantiable");
            } else {
                this.print0(this.ucase ? " NOT INSTANTIABLE" : " not instantiable");
            }
        }
        return false;
    }

    public boolean visit(OracleAlterSynonymStatement x) {
        this.print0(this.ucase ? "ALTER SYNONYM " : "alter synonym ");
        x.getName().accept((SQLASTVisitor)this);
        if (x.isCompile()) {
            this.print0(this.ucase ? " COMPILE" : " compile");
        }
        if (x.getEnable() != null) {
            if (x.getEnable().booleanValue()) {
                this.print0(this.ucase ? "ENABLE" : "enable");
            } else {
                this.print0(this.ucase ? "DISABLE" : "disable");
            }
        }
        return false;
    }

    public boolean visit(OracleAlterViewStatement x) {
        this.print0(this.ucase ? "ALTER VIEW " : "alter view ");
        x.getName().accept((SQLASTVisitor)this);
        if (x.isCompile()) {
            this.print0(this.ucase ? " COMPILE" : " compile");
        }
        if (x.getConstraint() != null) {
            this.print0(this.ucase ? " ADD " : " add ");
            x.getConstraint().accept((SQLASTVisitor)this);
        }
        if (x.getEnable() != null) {
            if (x.getEnable().booleanValue()) {
                this.print0(this.ucase ? "ENABLE" : "enable");
            } else {
                this.print0(this.ucase ? "DISABLE" : "disable");
            }
        }
        return false;
    }

    public boolean visit(OracleAnalytic x) {
        OracleAnalyticWindowing windowing;
        SQLOrderBy orderBy;
        this.print0(this.ucase ? "(" : "(");
        boolean space = false;
        if (x.getPartitionBy().size() > 0) {
            this.print0(this.ucase ? "PARTITION BY " : "partition by ");
            this.printAndAccept(x.getPartitionBy(), ", ");
            space = true;
        }
        if ((orderBy = x.getOrderBy()) != null) {
            if (space) {
                this.print(' ');
            }
            this.visit(orderBy);
            space = true;
        }
        if ((windowing = x.getWindowing()) != null) {
            if (space) {
                this.print(' ');
            }
            this.visit(windowing);
        }
        return false;
    }

    public boolean visit(SQLIfStatement.ElseIf x) {
        x.getCondition().accept((SQLASTVisitor)this);
        this.print0(this.ucase ? " THEN" : " then");
        ++this.indentCount;
        int size = x.getStatements().size();
        for (int i = 0; i < size; ++i) {
            this.println();
            SQLStatement item = (SQLStatement)x.getStatements().get(i);
            item.accept((SQLASTVisitor)this);
        }
        --this.indentCount;
        return false;
    }

    public boolean visit(OracleForStatement x) {
        boolean all = x.isAll();
        if (!all) {
            this.println();
            this.print0(this.ucase ? "LOOP" : "loop");
        }
        ++this.indentCount;
        this.println();
        int size = x.getStatements().size();
        for (int i = 0; i < size; ++i) {
            SQLStatement stmt = (SQLStatement)x.getStatements().get(i);
            stmt.accept((SQLASTVisitor)this);
            if (all || i == size - 1) continue;
            this.println();
        }
        --this.indentCount;
        if (!all) {
            this.println();
            this.print0(this.ucase ? "END LOOP" : "end loop");
            SQLName endLabel = x.getEndLabel();
            if (endLabel != null) {
                this.print(' ');
                endLabel.accept((SQLASTVisitor)this);
            }
        }
        return false;
    }
}

