/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CustomClassLoader
extends URLClassLoader {
    private Set<String> whiteListedPackages = new HashSet();

    public CustomClassLoader(URL[] urls, ClassLoader parent, String ... whiteListedPackages) {
        super(urls, parent);
        this.whiteListedPackages.addAll(List.of(whiteListedPackages));
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        for (String packageName : this.whiteListedPackages) {
            if (!name.startsWith(packageName)) continue;
            return super.loadClass(name);
        }
        return this.findClass(name);
    }
}

