/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb;

import com.hundsun.lightdb.TableInfo;
import com.hundsun.lightdb.core.EtlGlobalCtx;
import com.hundsun.lightdb.core.target.TargetImporter;
import com.hundsun.lightdb.core.target.TargetJdbcMeta;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FilenameUtils;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportFileWorker
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ImportFileWorker.class);
    TableInfo tableInfo;
    TargetImporter targetImporter;
    TargetJdbcMeta target;
    String filePath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Connection targetConn = this.target.openConnection();
        try {
            long start = System.nanoTime();
            targetConn.setAutoCommit(false);
            FileInputStream fileInputStream = null;
            try {
                CopyManager copyManager = new CopyManager((BaseConnection)this.targetImporter.targetJdbcMeta().openConnection());
                fileInputStream = new FileInputStream(String.format(this.filePath + "%s", FilenameUtils.getName((String)"")));
                copyManager.copyIn(String.format("COPY %s FROM STDIN with csv header", this.tableInfo.formatTableName()), (InputStream)fileInputStream);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (log.isInfoEnabled()) {
                log.info("end transfer table [{} \u8017\u65f6 {} \u79d2]", (Object)this.tableInfo.formatTableName(), (Object)TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - start));
            }
        }
        catch (Exception e) {
            EtlGlobalCtx.INSTANCE.handleException(String.format("error data transmission for table %s", this.tableInfo.formatTableName()), (Throwable)e);
        }
        finally {
            try {
                targetConn.commit();
                targetConn.setAutoCommit(true);
            }
            catch (SQLException e) {
                EtlGlobalCtx.INSTANCE.handleException("\u4fee\u6539autocommit\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public ImportFileWorker(TableInfo tableInfo, TargetImporter targetImporter, TargetJdbcMeta target, String filePath) {
        this.tableInfo = tableInfo;
        this.targetImporter = targetImporter;
        this.target = target;
        this.filePath = filePath;
    }
}

