/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb;

import com.hundsun.lightdb.TableInfo;
import com.hundsun.lightdb.core.EtlGlobalCtx;
import com.hundsun.lightdb.core.KeyValuePair;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.MotionParameters;
import com.hundsun.lightdb.core.ObjectTypeEnum;
import com.hundsun.lightdb.core.source.SourceJdbcMeta;
import com.hundsun.lightdb.core.target.TargetJdbcMeta;
import com.hundsun.lightdb.event.GlobalApplicationContext;
import com.hundsun.lightdb.event.TaskExcuteEvent;
import com.hundsun.lightdb.motion.enums.DataBaseTypeEnum;
import com.hundsun.lightdb.motion.enums.TaskResultEnum;
import com.hundsun.lightdb.utils.CommonUtils;
import com.hundsun.lightdb.utils.JdbcUtils;
import com.hundsun.lightdb.utils.SuppressFBWarnings;
import dm.jdbc.driver.DmdbRowId;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;

@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN", "COMMAND_INJECTION", "DM_SYSTEM_OUT", "DM_SYSTEM_ERR", "SQL_INJECTION_JDBC"})
public class ImportWorker
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ImportWorker.class);
    MotionParameters motionParameters;
    int batchSize;
    TableInfo tableInfo;
    SourceJdbcMeta source;
    TargetJdbcMeta target;
    int from;
    int to;
    String customSql;
    public static final String ZERO_DATE = "0000-00-00 00:00:00";
    String resultMessage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        AtomicLong oracle2DmRowid = new AtomicLong(0L);
        String targetDatabase = MotionEtlGlobalCtx.getInstance().targetDatabase;
        Connection targetConn = this.target.openConnection();
        String sql = StringUtils.isBlank((CharSequence)this.customSql) ? this.source.formatSelect2(this.tableInfo) : this.customSql;
        AtomicReference<KeyValuePair> pair = new AtomicReference<KeyValuePair>(new KeyValuePair("", ""));
        this.resultMessage = "SUCCESS";
        try {
            String sourceDBType = MotionEtlGlobalCtx.getInstance().getGlobalConfig().getSourceDatabase();
            targetConn.setAutoCommit(false);
            PreparedStatement preparedStatement = targetConn.prepareStatement(this.tableInfo.formatInsert());
            ParameterMetaData targetDbParameterMetaData = preparedStatement.getParameterMetaData();
            if (CommonUtils.isMysqlFamilyDB((String)sourceDBType) && this.tableInfo.getNotNullCols().size() == 0) {
                Set notNullColsSet = this.source.getNotNullColumns(this.tableInfo.getTableName());
                this.tableInfo.setNotNullCols(notNullColsSet);
            }
            long start = System.nanoTime();
            if (log.isInfoEnabled()) {
                log.info("begin data transmission for table [ {} ]", (Object)this.tableInfo.formatTableName());
            }
            if (CommonUtils.isMysqlFamilyDB((String)sourceDBType)) {
                PreparedStatement preparedStatement1 = this.source.openConnection().prepareStatement("set sql_mode=(select replace(@@sql_mode,'NO_ZERO_DATE',''))");
                preparedStatement1.execute();
            }
            JdbcUtils.doQuery((Connection)this.source.openConnection(), (String)sql, (int)this.batchSize, resultSet -> {
                try {
                    int i;
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    int columnCount = resultSetMetaData.getColumnCount();
                    String tableName = this.tableInfo.getTableName();
                    String blankStrTransformTo = MotionEtlGlobalCtx.getInstance().getGlobalConfig().getBlankStrTransformTo();
                    int rowCount = 0;
                    int[] sourceDbParameterTypes = new int[columnCount];
                    int[] targetDbParameterTypes = new int[columnCount];
                    for (i = 0; i < columnCount; ++i) {
                        int sourceDbParameterType = 1111;
                        int targetDbParameterType = 1111;
                        try {
                            sourceDbParameterType = resultSetMetaData.getColumnType(i + 1);
                        }
                        catch (Exception e) {
                            log.warn("\u5e95\u5c42\u9a71\u52a8\u4e0d\u652f\u6301getParameterType: " + this.source.openConnection().getClass().getName());
                        }
                        try {
                            targetDbParameterType = targetDbParameterMetaData.getParameterType(i + 1);
                        }
                        catch (Exception e) {
                            targetDbParameterType = sourceDbParameterType;
                            log.warn("\u5e95\u5c42\u9a71\u52a8\u4e0d\u652f\u6301getParameterType: " + targetConn.getClass().getName());
                        }
                        sourceDbParameterTypes[i] = sourceDbParameterType;
                        targetDbParameterTypes[i] = targetDbParameterType;
                    }
                    while (resultSet.next()) {
                        for (i = 1; i <= columnCount; ++i) {
                            Object boolValue;
                            String columnName = resultSetMetaData.getColumnName(i);
                            String columnTypeName = resultSetMetaData.getColumnTypeName(i);
                            int sourceDbParameterType = sourceDbParameterTypes[i - 1];
                            int targetDbParameterType = targetDbParameterTypes[i - 1];
                            Object objectValue = resultSet.getObject(i);
                            boolean wasNull = resultSet.wasNull();
                            if (wasNull) {
                                preparedStatement.setObject(i, null);
                                continue;
                            }
                            if (CommonUtils.isStringType((int)sourceDbParameterType)) {
                                String strValue = null;
                                strValue = CommonUtils.isOracleLongType((String)columnTypeName) ? objectValue.toString() : resultSet.getString(i);
                                if (sourceDBType.toLowerCase().contains(DataBaseTypeEnum.MYSQL.getName()) && this.tableInfo.getNotNullCols().contains(columnName) && blankStrTransformTo != null && StringUtils.isBlank((CharSequence)strValue) && strValue.length() == 0) {
                                    strValue = blankStrTransformTo;
                                }
                                if (EtlGlobalCtx.booleanColumn((String)tableName, (String)columnName)) {
                                    boolValue = this.boolAndCharConvert((Object)strValue, columnTypeName);
                                    preparedStatement.setObject(i, boolValue);
                                    continue;
                                }
                                preparedStatement.setString(i, strValue);
                                continue;
                            }
                            if (CommonUtils.isDecimalType((int)sourceDbParameterType)) {
                                BigDecimal decimal = resultSet.getBigDecimal(i);
                                preparedStatement.setBigDecimal(i, decimal);
                                continue;
                            }
                            if (CommonUtils.isIntType((int)sourceDbParameterType)) {
                                int intValue = resultSet.getInt(i);
                                preparedStatement.setInt(i, intValue);
                                continue;
                            }
                            if (CommonUtils.isBooleanType((int)sourceDbParameterType, (String)columnTypeName)) {
                                boolean boolValue2 = resultSet.getBoolean(i);
                                if (EtlGlobalCtx.booleanColumn((String)tableName, (String)columnName)) {
                                    Object strValue = this.boolAndCharConvert((Object)boolValue2, columnTypeName);
                                    preparedStatement.setObject(i, strValue);
                                    continue;
                                }
                                preparedStatement.setBoolean(i, boolValue2);
                                continue;
                            }
                            if (CommonUtils.isBitType((int)sourceDbParameterType)) {
                                String bitStr = resultSet.getString(i);
                                preparedStatement.setInt(i, bitStr.equalsIgnoreCase("false") ? 0 : Integer.parseInt(bitStr));
                                continue;
                            }
                            if (CommonUtils.isLongType((int)sourceDbParameterType)) {
                                long longValue = resultSet.getLong(i);
                                preparedStatement.setLong(i, longValue);
                                continue;
                            }
                            if (CommonUtils.isDateType((int)sourceDbParameterType)) {
                                Date date = resultSet.getDate(i);
                                preparedStatement.setDate(i, date);
                                continue;
                            }
                            if (CommonUtils.isTimestampType((int)sourceDbParameterType, (String)columnTypeName)) {
                                String timestampStr = resultSet.getString(i);
                                if (StringUtils.isNotBlank((CharSequence)timestampStr) && ZERO_DATE.equals(timestampStr)) {
                                    preparedStatement.setString(i, timestampStr);
                                    continue;
                                }
                                Timestamp timestamp = resultSet.getTimestamp(i);
                                preparedStatement.setTimestamp(i, timestamp);
                                continue;
                            }
                            if (CommonUtils.isBlobType((int)sourceDbParameterType)) {
                                if (targetDatabase.equalsIgnoreCase(DataBaseTypeEnum.OCEAN_BASE_MYSQL.getName()) || targetDatabase.equalsIgnoreCase(DataBaseTypeEnum.OCEAN_BASE_ORACLE.getName()) || CommonUtils.oracle2Dm()) {
                                    byte[] bytesValue = resultSet.getBytes(i);
                                    preparedStatement.setBytes(i, bytesValue);
                                    continue;
                                }
                                if (CommonUtils.isBlobType((int)targetDbParameterType)) {
                                    Blob blob = resultSet.getBlob(i);
                                    preparedStatement.setBlob(i, blob);
                                    continue;
                                }
                                if (CommonUtils.isBytesType((int)targetDbParameterType)) {
                                    byte[] bytesValue = resultSet.getBytes(i);
                                    preparedStatement.setBytes(i, bytesValue);
                                    continue;
                                }
                                Object object = resultSet.getObject(i);
                                preparedStatement.setObject(i, object);
                                continue;
                            }
                            if (CommonUtils.isClobType((int)sourceDbParameterType)) {
                                if (EtlGlobalCtx.booleanColumn((String)tableName, (String)columnName)) {
                                    Clob clob = resultSet.getClob(i);
                                    boolValue = this.boolAndCharConvert((Object)clob, columnTypeName);
                                    preparedStatement.setObject(i, boolValue);
                                    continue;
                                }
                                if (CommonUtils.oracle2OceanBaseOracle()) {
                                    String str = resultSet.getString(i);
                                    preparedStatement.setString(i, str);
                                    continue;
                                }
                                Clob clob = resultSet.getClob(i);
                                preparedStatement.setClob(i, clob);
                                continue;
                            }
                            if (CommonUtils.isBytesType((int)sourceDbParameterType)) {
                                byte[] bytesValue = resultSet.getBytes(i);
                                preparedStatement.setBytes(i, bytesValue);
                                continue;
                            }
                            if (CommonUtils.isTimeType((int)sourceDbParameterType)) {
                                Time timeValue = resultSet.getTime(i);
                                preparedStatement.setTime(i, timeValue);
                                continue;
                            }
                            if (CommonUtils.isDoubleType((int)sourceDbParameterType)) {
                                double doubleValue = resultSet.getDouble(i);
                                preparedStatement.setDouble(i, doubleValue);
                                continue;
                            }
                            if (CommonUtils.isFloatType((int)sourceDbParameterType)) {
                                float floatValue = resultSet.getFloat(i);
                                preparedStatement.setFloat(i, floatValue);
                                continue;
                            }
                            if (CommonUtils.isRowidType((int)sourceDbParameterType)) {
                                if (CommonUtils.oracle2Dm()) {
                                    DmdbRowId dmRowId = new DmdbRowId(oracle2DmRowid.incrementAndGet(), null, null);
                                    preparedStatement.setRowId(i, (RowId)dmRowId);
                                    continue;
                                }
                                RowId rowidValue = resultSet.getRowId(i);
                                preparedStatement.setObject(i, rowidValue);
                                continue;
                            }
                            if (CommonUtils.isIntervalymType((String)columnTypeName)) {
                                if (CommonUtils.oracle2Dm()) {
                                    String str = resultSet.getString(i);
                                    preparedStatement.setString(i, "INTERVAL '" + str + "' YEAR TO MONTH");
                                    continue;
                                }
                                if (CommonUtils.oracle2OceanBaseOracle() || CommonUtils.oracle2GaussdbOracle505()) {
                                    String str = resultSet.getString(i);
                                    preparedStatement.setString(i, str);
                                    continue;
                                }
                                Object object = resultSet.getObject(i);
                                preparedStatement.setObject(i, object);
                                continue;
                            }
                            if (CommonUtils.isIntervaldsType((String)columnTypeName)) {
                                if (CommonUtils.oracle2Dm()) {
                                    String str = resultSet.getString(i);
                                    preparedStatement.setString(i, "INTERVAL '" + str + "' DAY TO SECOND");
                                    continue;
                                }
                                if (CommonUtils.oracle2OceanBaseOracle() || CommonUtils.oracle2GaussdbOracle505()) {
                                    String str = resultSet.getString(i);
                                    preparedStatement.setString(i, str);
                                    continue;
                                }
                                Object object = resultSet.getObject(i);
                                preparedStatement.setObject(i, object);
                                continue;
                            }
                            Object object = resultSet.getObject(i);
                            preparedStatement.setObject(i, object);
                        }
                        preparedStatement.addBatch();
                        if (++rowCount % this.batchSize != 0) continue;
                        preparedStatement.executeBatch();
                        targetConn.commit();
                        if (log.isInfoEnabled()) {
                            log.info("executed batch {} {}", (Object)this.tableInfo.formatTableName(), (Object)rowCount);
                        }
                        pair.set(new KeyValuePair(TaskResultEnum.TASK_SUCCESS.getStatus(), String.format("\u8868:%s \u8fc1\u79fb\u6570\u636e%s\u6761", this.tableInfo.formatTableName(), rowCount)));
                        this.publishEvent(sql, pair);
                    }
                    if (rowCount % this.batchSize != 0) {
                        preparedStatement.executeBatch();
                        targetConn.commit();
                        if (log.isInfoEnabled()) {
                            log.info("executed batch {} {}", (Object)this.tableInfo.formatTableName(), (Object)rowCount);
                        }
                        pair.set(new KeyValuePair(TaskResultEnum.TASK_SUCCESS.getStatus(), String.format("\u8868:%s \u8fc1\u79fb\u6570\u636e%s\u6761", this.tableInfo.formatTableName(), rowCount)));
                        this.publishEvent(sql, pair);
                    }
                }
                catch (SQLException e) {
                    this.resultMessage = String.format("%s:%s\n", this.tableInfo.formatTableName(), e.getMessage());
                    EtlGlobalCtx.INSTANCE.handleException(String.format("error data transmission for table %s", this.tableInfo.getTableName()), (Throwable)e);
                    pair.set(new KeyValuePair(TaskResultEnum.TASK_FAIL.getStatus(), e.getMessage()));
                    this.publishEvent(sql, pair);
                }
                return 1;
            });
            preparedStatement.close();
            if (log.isInfoEnabled()) {
                log.info("end transfer table [{} \u8017\u65f6 {} \u79d2]", (Object)this.tableInfo.formatTableName(), (Object)TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - start));
            }
        }
        catch (Exception e) {
            this.resultMessage = String.format("%s:%s\n", this.tableInfo.formatTableName(), e.getMessage());
            EtlGlobalCtx.INSTANCE.handleException(String.format("error data transmission for table %s", this.tableInfo.formatTableName()), (Throwable)e);
            pair.set(new KeyValuePair(TaskResultEnum.TASK_FAIL.getStatus(), e.getMessage()));
            this.publishEvent(sql, pair);
        }
        finally {
            try {
                targetConn.commit();
                targetConn.setAutoCommit(true);
            }
            catch (SQLException e) {
                this.resultMessage = "\u4fee\u6539autocommit\u5931\u8d25" + e.getMessage();
                EtlGlobalCtx.INSTANCE.handleException("\u4fee\u6539autocommit\u5931\u8d25", (Throwable)e);
            }
        }
        CommonUtils.writeTransferTableDataResult((String)this.resultMessage);
    }

    private void publishEvent(String sql, AtomicReference<KeyValuePair> pair) {
        block2: {
            try {
                GlobalApplicationContext.context.publishEvent((ApplicationEvent)new TaskExcuteEvent((Object)this, this.motionParameters, ObjectTypeEnum.TABLEDATA.getName(), this.tableInfo.getTableName(), sql, sql, pair.get()));
            }
            catch (Exception e) {
                if (!log.isInfoEnabled()) break block2;
                log.info("ImportWorker publishEvent info:", (Throwable)e);
            }
        }
    }

    private boolean isString(String typeName) {
        switch (typeName) {
            case "varchar2": 
            case "nvarchar2": 
            case "varchar": 
            case "char": 
            case "nchar": 
            case "clob": {
                return true;
            }
        }
        return false;
    }

    private boolean isBool(String typeName) {
        switch (typeName) {
            case "bool": 
            case "boolean": {
                return true;
            }
        }
        return false;
    }

    private Object boolAndCharConvert(Object value, String typeName) {
        String f;
        String t;
        String trueString = "true";
        String falseString = "false";
        String valueString = "";
        if (Objects.isNull(value)) {
            return value;
        }
        valueString = value.toString();
        MotionEtlGlobalCtx.getInstance();
        switch (EtlGlobalCtx.boolToCharMode()) {
            case 0: {
                t = "1";
                f = "0";
                break;
            }
            case 1: {
                t = "t";
                f = "f";
                break;
            }
            case 2: {
                t = "true";
                f = "false";
                break;
            }
            default: {
                return value;
            }
        }
        if (this.isString(typeName.toLowerCase())) {
            if (t.equals(valueString)) {
                return true;
            }
            if (f.equals(valueString)) {
                return false;
            }
            return null;
        }
        if (this.isBool(typeName.toLowerCase())) {
            if (trueString.equals(valueString)) {
                return t;
            }
            if (falseString.equals(valueString)) {
                return f;
            }
            return null;
        }
        return value;
    }

    public ImportWorker(MotionParameters motionParameters, int batchSize, TableInfo tableInfo, SourceJdbcMeta source, TargetJdbcMeta target, int from, int to, String customSql, String resultMessage) {
        this.motionParameters = motionParameters;
        this.batchSize = batchSize;
        this.tableInfo = tableInfo;
        this.source = source;
        this.target = target;
        this.from = from;
        this.to = to;
        this.customSql = customSql;
        this.resultMessage = resultMessage;
    }
}

