/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb;

import com.google.common.base.Joiner;
import com.hundsun.lightdb.core.EtlGlobalCtx;
import com.hundsun.lightdb.core.IndexInfo;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.motion.enums.DataBaseTypeEnum;
import com.hundsun.lightdb.motion.enums.DataTypeEnum;
import com.hundsun.lightdb.utils.CommonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableInfo {
    static final Logger logger = LoggerFactory.getLogger(TableInfo.class);
    private String schema;
    private String tableName;
    private List<String> columnTypes = new ArrayList();
    private List<String> columnNames = new ArrayList();
    private List<String> uniqueIndexCols = new ArrayList();
    private List<Long> columnCharacterMaximumLengths = new ArrayList();
    private boolean lowerCase;
    private Set<String> notNullCols = new HashSet();
    private String compareSql;

    public void setCompareSql(String compareSql) {
        this.compareSql = compareSql;
    }

    public TableInfo(String tableName, boolean lowerCase) {
        this.lowerCase = lowerCase;
        this.setTableName(tableName);
    }

    public TableInfo(String tableName, List<String> columns) {
        this.setTableName(tableName);
        for (String column : columns) {
            this.addColumnName(column);
        }
    }

    public static TableInfo from(IndexInfo indexInfo) {
        TableInfo tableInfo = new TableInfo(indexInfo.getTableName(), true);
        tableInfo.getColumnNames().addAll(indexInfo.getColumnNames());
        tableInfo.setSchema(indexInfo.getSchema());
        return tableInfo;
    }

    public void setSchema(String schema) {
        this.schema = CommonUtils.trimLeadTailDoubleQuote((String)schema);
    }

    public void setTableName(String tableName) {
        this.tableName = CommonUtils.trimLeadTailDoubleQuote((String)tableName, (boolean)this.lowerCase);
    }

    public void setNotNullCols(Set<String> notNullColsSet) {
        this.notNullCols = notNullColsSet;
    }

    public void tableHandler() {
        ArrayList<String> keywords = new ArrayList<String>(16);
        String keyWords = MotionEtlGlobalCtx.getInstance().getGlobalConfig().getKeywords();
        if (!StringUtils.isBlank((CharSequence)keyWords)) {
            keywords.addAll(Arrays.asList(keyWords.toLowerCase().split(",")));
        }
        if (keywords.contains(this.tableName) && DataBaseTypeEnum.ORACLE.getName().equals(MotionEtlGlobalCtx.getInstance().getGlobalConfig().getTargetDatabase())) {
            this.tableName = "\"" + this.tableName + "\"";
        }
    }

    public String addColumnName(String columnName) {
        if (EtlGlobalCtx.excludeColumn((String)this.tableName, (String)columnName)) {
            logger.info("\u6392\u9664\u6307\u5b9a\u8868\u7684\u5217 [{}] [{}]", (Object)this.tableName, (Object)columnName);
            return null;
        }
        ArrayList<String> keywords = new ArrayList<String>(16);
        String by = "by";
        keywords.add(by);
        String keyWords = MotionEtlGlobalCtx.getInstance().getGlobalConfig().getKeywords();
        if (!StringUtils.isBlank((CharSequence)keyWords)) {
            keywords.addAll(Arrays.asList(keyWords.toLowerCase().split(",")));
        }
        Object column = "";
        column = keywords.contains(columnName.toLowerCase()) ? (CommonUtils.isMysqlFamilyDB((String)MotionEtlGlobalCtx.getInstance().getGlobalConfig().getSourceDatabase()) ? "`" + columnName + "`" : "\"" + columnName + "\"") : CommonUtils.trimLeadTailDoubleQuote((String)columnName, (boolean)this.lowerCase);
        if (!this.columnNames.contains(column)) {
            this.columnNames.add(column);
            return "SUCCESS";
        }
        return null;
    }

    public void addColumn(String columnName, String columnType) {
        String result = this.addColumnName(columnName);
        if (StringUtils.isNotBlank((CharSequence)result)) {
            this.columnTypes.add(columnType);
        }
    }

    public void addCharacterMaximumLength(Long characterMaximumLength) {
        this.columnCharacterMaximumLengths.add(characterMaximumLength);
    }

    public void addUniqueIndexCols(String columnName) {
        String keywords = MotionEtlGlobalCtx.getInstance().getGlobalConfig().getKeywords();
        Object column = columnName;
        if (keywords != null && keywords.contains(columnName.toLowerCase())) {
            column = CommonUtils.isMysqlFamilyDB((String)MotionEtlGlobalCtx.getInstance().getGlobalConfig().getSourceDatabase()) ? "`" + columnName + "`" : "\"" + columnName + "\"";
        }
        this.uniqueIndexCols.add(column);
    }

    public String formatMysqlSelect(int from, int to) {
        String join = Joiner.on((String)",").join((Iterable)this.columnNames);
        return String.format("SELECT %s from %s limit %d,%d", join, this.formatTableName(), from, to);
    }

    public String formatSelect(int from, int to) {
        String join = Joiner.on((String)",").join((Iterable)this.columnNames);
        String selectSql = "SELECT %s FROM (SELECT %s,ROWNUM R FROM %s WHERE ROWNUM<=%d) WHERE R>%d ";
        return String.format(selectSql, join, join, this.formatTableName(), to, from);
    }

    public String formatSelect2() {
        String join = Joiner.on((String)",").join((Iterable)this.columnNames);
        StringBuffer cols = new StringBuffer();
        String sourceDBType = MotionEtlGlobalCtx.getInstance().getGlobalConfig().getSourceDatabase();
        String targetDBType = MotionEtlGlobalCtx.getInstance().getGlobalConfig().getTargetDatabase();
        boolean isMysqlFamilyDB = CommonUtils.isMysqlFamilyDB((String)sourceDBType);
        for (String columnName : this.columnNames) {
            int indexOf = this.getColumnNames().indexOf(columnName);
            String columnType = (String)this.getColumnTypes().get(indexOf);
            String transformedCol = null;
            if (EtlGlobalCtx.dataTransformColumn((String)this.tableName, (String)columnName) && isMysqlFamilyDB) {
                String srcVal = EtlGlobalCtx.getColumnDataTransform((String)this.tableName, (String)columnName).getSrcColData();
                String destVal = EtlGlobalCtx.getColumnDataTransform((String)this.tableName, (String)columnName).getDestColData();
                String casewhenFormattedColumn = String.format("case when %s=%s then %s else %s end %s", columnName, srcVal, destVal, columnName, columnName);
                transformedCol = targetDBType.equalsIgnoreCase(DataBaseTypeEnum.ORACLE.getName()) ? (columnType.equalsIgnoreCase(DataTypeEnum.ORACLE_TIMESTAMP_6.getName()) ? String.format("case when %s=%s then str_to_date(%s, '%%Y-%%m-%%d %%H:%%i:%%s') else %s end %s", columnName, srcVal, destVal, columnName, columnName) : casewhenFormattedColumn) : casewhenFormattedColumn;
            } else {
                transformedCol = columnName;
            }
            if (isMysqlFamilyDB && targetDBType.equalsIgnoreCase(DataBaseTypeEnum.OCEAN_BASE_MYSQL.getName()) && (columnType.equalsIgnoreCase(DataTypeEnum.TIMESTAMP.getName()) || columnType.equalsIgnoreCase(DataTypeEnum.DATETIME.getName()) || columnType.equalsIgnoreCase(DataTypeEnum.TIME.getName()) || columnType.equalsIgnoreCase(DataTypeEnum.DATE.getName()))) {
                cols.append("cast(" + transformedCol + " as char),");
                continue;
            }
            cols.append(transformedCol + ",");
        }
        String selectSql = "SELECT %s FROM  %s";
        return String.format(selectSql, cols.substring(0, cols.length() - 1), this.formatTableName());
    }

    public String formatInsert() {
        StringBuilder sb = new StringBuilder();
        boolean isTargetPGDB = CommonUtils.isPgFamilyDB((String)MotionEtlGlobalCtx.getInstance().getGlobalConfig().getTargetDatabase());
        for (int i = 0; i < this.columnNames.size(); ++i) {
            if (isTargetPGDB) {
                if (((String)this.columnTypes.get(i)).equalsIgnoreCase(DataTypeEnum.JSON.getName())) {
                    sb.append("?::json,");
                    continue;
                }
                if (((String)this.columnTypes.get(i)).equalsIgnoreCase(DataTypeEnum.BIT.getName())) {
                    sb.append("?::bit(").append(this.columnCharacterMaximumLengths.get(i)).append("),");
                    continue;
                }
                sb.append("?,");
                continue;
            }
            sb.append("?,");
        }
        String placeHolders = org.springframework.util.StringUtils.trimTrailingCharacter((String)sb.toString(), (char)',');
        String insertColumnNames = Joiner.on((String)",").join((Iterable)this.columnNames);
        if (!CommonUtils.isMysqlFamilyDB((String)MotionEtlGlobalCtx.getInstance().getGlobalConfig().getTargetDatabase())) {
            insertColumnNames = insertColumnNames.replaceAll("`", "\"");
        }
        return String.format("insert into %s (%s) values (%s)", this.formatTargetTableName(), insertColumnNames, placeHolders);
    }

    public String formatTableName() {
        if (org.springframework.util.StringUtils.hasText((String)MotionEtlGlobalCtx.getInstance().currentSchema())) {
            return MotionEtlGlobalCtx.getInstance().currentSchema() + "." + this.tableName;
        }
        return this.tableName;
    }

    public String formatTargetTableName() {
        if (org.springframework.util.StringUtils.hasText((String)MotionEtlGlobalCtx.getInstance().currentTargetSchema())) {
            return MotionEtlGlobalCtx.getInstance().currentTargetSchema() + "." + this.tableName;
        }
        return this.tableName;
    }

    public void compareColumns(int compareColumns) {
        if (this.columnNames.size() > compareColumns) {
            this.columnNames = this.columnNames.subList(0, compareColumns);
        }
    }

    public String formatSelectMaxRownum() {
        return String.format("SELECT count(*) maxrownum from %s ", this.formatTableName());
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<String> getColumnTypes() {
        return this.columnTypes;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public List<String> getUniqueIndexCols() {
        return this.uniqueIndexCols;
    }

    public List<Long> getColumnCharacterMaximumLengths() {
        return this.columnCharacterMaximumLengths;
    }

    public boolean isLowerCase() {
        return this.lowerCase;
    }

    public Set<String> getNotNullCols() {
        return this.notNullCols;
    }

    public String getCompareSql() {
        return this.compareSql;
    }

    public TableInfo() {
    }
}

