/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hundsun.lightdb.core.EtlGlobalCtx;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerGroup {
    private static final Logger log = LoggerFactory.getLogger(WorkerGroup.class);
    ExecutorService executors;
    Queue<Future> futures = new LinkedList();
    private static final Integer TIMEOUT = 60;

    public WorkerGroup(int concurrentThreadCount) {
        if (log.isInfoEnabled()) {
            log.info("concurrentThreadCount {}", (Object)concurrentThreadCount);
        }
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("etl-pool-%d").build();
        this.executors = new ThreadPoolExecutor(concurrentThreadCount, concurrentThreadCount, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), namedThreadFactory);
    }

    public void addTask(Runnable importWorker) {
        Future<?> submit = this.executors.submit(importWorker);
        this.futures.add(submit);
    }

    public void waitCompletion() {
        try {
            Future poll = (Future)this.futures.poll();
            while (poll != null) {
                poll.get();
                poll = (Future)this.futures.poll();
            }
        }
        catch (Exception e) {
            EtlGlobalCtx.INSTANCE.handleException("\u4efb\u52a1\u6267\u884c\u4e2d\u65ad", (Throwable)e);
        }
    }

    public void shutdown() {
        if (!this.executors.isShutdown()) {
            this.executors.shutdown();
            try {
                if (!this.executors.awaitTermination(TIMEOUT.intValue(), TimeUnit.SECONDS)) {
                    this.executors.shutdownNow();
                }
                if (log.isInfoEnabled()) {
                    log.info("\u7ebf\u7a0b\u6c60\u5173\u95ed\u6210\u529f\u3002");
                }
            }
            catch (InterruptedException e) {
                if (log.isErrorEnabled()) {
                    log.error("\u7ebf\u7a0b\u6c60\u5173\u95ed\u5f02\u5e38\uff1a{}", (Throwable)e);
                }
                this.executors.shutdownNow();
            }
        }
    }
}

