/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core;

import com.hundsun.lightdb.core.EtlConfig;
import com.hundsun.lightdb.core.EtlGlobalCtx;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.MotionParameters;
import com.hundsun.lightdb.core.actuator.Actuator;
import com.hundsun.lightdb.core.actuator.ActuatorBuilder;
import com.hundsun.lightdb.core.source.SourceFetcher;
import com.hundsun.lightdb.core.target.TargetImporter;
import com.hundsun.lightdb.core.transformer.EtlTransformer;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"etl.global.runModel"}, havingValue="0")
public class EtlDirector
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(EtlDirector.class);
    SourceFetcher sourceFetcher;
    EtlTransformer transformer;
    TargetImporter targetImporter;
    EtlConfig.GlobalConfig globalConfig;
    MotionParameters motionParameters;

    @Autowired
    public EtlDirector(SourceFetcher sourceFetcher, EtlTransformer transformer, TargetImporter targetImporter, EtlConfig.GlobalConfig globalConfig, MotionParameters motionParameters) {
        this.sourceFetcher = sourceFetcher;
        this.transformer = transformer;
        this.targetImporter = targetImporter;
        this.globalConfig = globalConfig;
        this.motionParameters = motionParameters;
    }

    public void begin() throws ClassNotFoundException {
        long begin = System.nanoTime();
        if (log.isInfoEnabled()) {
            log.info("lightdb motion begin schema {}", (Object)MotionEtlGlobalCtx.getInstance().schemas.toString());
        }
        this.sourceFetcher.init();
        this.targetImporter.init();
        Actuator actuator = new ActuatorBuilder(this.sourceFetcher, this.transformer, this.targetImporter).build();
        actuator.start();
        this.targetImporter.saveError();
        if (log.isInfoEnabled()) {
            log.info("taskMainId:{} taskExectueSnapshotId:{} ETL SCHEMA {} \u8fc1\u79fb\u5b8c\u6210, \u8017\u65f6 {} \u79d2", new Object[]{this.motionParameters.taskMainId, this.motionParameters.taskExectueSnapshotId, MotionEtlGlobalCtx.getInstance().currentSchema(), TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - begin)});
        }
    }

    public void run(ApplicationArguments args) throws Exception {
        try {
            EtlGlobalCtx etlGlobalCtx = new EtlGlobalCtx();
            etlGlobalCtx.init(this.globalConfig, this.motionParameters, this.sourceFetcher, this.targetImporter);
            MotionEtlGlobalCtx.setCtxInheritableThreadLocal((EtlGlobalCtx)etlGlobalCtx);
            MotionEtlGlobalCtx.getInstance().transferType("query");
            this.begin();
        }
        catch (Exception e) {
            EtlGlobalCtx.INSTANCE.handleException("\u4efb\u52a1\u6267\u884c\u4e2d\u65ad", (Throwable)e);
        }
        MotionEtlGlobalCtx.getInstance().releaseResources();
        if (!MotionEtlGlobalCtx.getInstance().runModel()) {
            System.exit(0);
        }
        MotionEtlGlobalCtx.removeEtlGlobalCtx();
    }
}

