/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core;

import com.alibaba.druid.support.json.JSONUtils;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.HashBasedTable;
import com.hundsun.lightdb.SqlLogger;
import com.hundsun.lightdb.TableInfo;
import com.hundsun.lightdb.WorkerGroup;
import com.hundsun.lightdb.core.EtlConfig;
import com.hundsun.lightdb.core.KeyValuePair;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.MotionParameters;
import com.hundsun.lightdb.core.source.SourceFetcher;
import com.hundsun.lightdb.core.target.TargetImporter;
import com.hundsun.lightdb.motion.enums.DataBaseTypeEnum;
import com.hundsun.lightdb.unisql.proxy.jdbc.DbType;
import com.hundsun.lightdb.utils.ColumnDataTransform;
import com.hundsun.lightdb.utils.CommonUtils;
import com.hundsun.lightdb.utils.JdbcUtils;
import com.hundsun.lightdb.utils.ProcessUtils;
import java.io.File;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class EtlGlobalCtx {
    private static final Logger log = LoggerFactory.getLogger(EtlGlobalCtx.class);
    public static final String TYPE_SUFFIX = "%type";
    public static final String RELATION_ALREADY_EXISTS = "already exists";
    public static final String COMMAND_NOT_FOUND = "ProcessUtils Cmd Error";
    public static final String SQLULDR2DIR = String.join((CharSequence)File.separator, System.getProperty("user.dir"), "sqluldr2Dir");
    public static final String LIGHTDB = "lightdb";
    public static final String LIGHTDB_A = "lightdb-a";
    public static final String LTSQL_TEST_CMD = "LTPASSWORD='%s' ltsql -c 'select 1'";
    public static final String COMPARE_SQL_RESULT = "comparesqlresult";
    public static EtlGlobalCtx INSTANCE = new EtlGlobalCtx();
    public static HashMap<String, String> etlMessage = new HashMap();
    public MotionParameters motionParameters;
    WorkerGroup workerGroup;
    EtlConfig.GlobalConfig globalConfig = EtlConfig.GlobalConfig.DEFAULT;
    Set<String> functionSet;
    static Set<String> functionsTrue = new HashSet(16);
    Set<String> procedures = new HashSet();
    public String sourceDatabase = DbType.ORACLE.name();
    public String targetDatabase = DbType.POSTGRESQL.name();
    LinkedBlockingQueue<Connection> queue = new LinkedBlockingQueue();
    Set<String> pgTypes = new HashSet();
    List<KeyValuePair> fkSqls = new ArrayList();
    List<String> schemas;
    List<String> targetSchemas;
    public List<String> syncCustomSql = new ArrayList();
    String currentSchema;
    String currentTargetSchema;
    int schemaIndex;
    Set<String> onlyProcedures = new HashSet();
    String type;
    HashBasedTable<String, String, AtomicInteger> summaryTable;
    Set<String> keywordsSet = new HashSet();
    static Map<String, Set<String>> excludeTableColumnsMap = new HashMap();
    static Map<String, Set<String>> booleanTableColumnsMap = new HashMap();
    static Map<String, Map<String, ColumnDataTransform>> dataTransformColumnsMap = new HashMap();
    static Map<String, ColumnDataTransform> defaultValueTransformMap = new HashMap();
    static Map<String, Set<String>> orderByColumnsMap = new HashMap();
    static int boolAndCharMode;
    private Set<String> sqluldr2TablesSet = new HashSet();
    static Map<String, String> plpgsqlTypeMapping;
    static Map<String, String> ploraTypeMapping;

    public boolean runModel() {
        return this.globalConfig.runModel == "1";
    }

    public void setSqluldr2TablesSet(Set<String> sqluldr2TablesSet) {
        this.sqluldr2TablesSet = sqluldr2TablesSet.stream().map(String::toLowerCase).collect(Collectors.toSet());
    }

    public boolean isProcedure(String procedure) {
        return this.procedures.contains(procedure);
    }

    public void initProcedureNames(List<String> procedureNames) {
        this.procedures.addAll(procedureNames);
    }

    public List<String> getSchemas() {
        return this.schemas;
    }

    public HashMap<String, String> getEtlMessage() {
        return etlMessage;
    }

    public String getEtlMessageValue(String key) {
        return (String)etlMessage.get(key);
    }

    public void putEtlMessage(String key, String value) {
        etlMessage.put(key, value);
    }

    public Integer currentSchemaIndex() {
        return this.schemaIndex;
    }

    public void init(EtlConfig.GlobalConfig globalConfig, MotionParameters motionParameters, SourceFetcher sourceFetcher, TargetImporter targetImporter) {
        String orderByColumns;
        String defaultValueTransform;
        String dataTransformColumns;
        String booleanColumns;
        this.summaryTable = HashBasedTable.create();
        this.globalConfig = globalConfig;
        this.motionParameters = motionParameters;
        SqlLogger.showSql = globalConfig.showSql;
        if (StringUtils.isBlank((CharSequence)globalConfig.transferSchemas) && log.isWarnEnabled()) {
            log.warn("ALET-0001:transferSchemas\u8fc1\u79fb\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)globalConfig.targetDatabase)) {
            throw new RuntimeException("ALET-0002:targetDatabase\u8fc1\u79fb\u76ee\u6807\u6570\u636e\u5e93\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)globalConfig.sourceDatabase)) {
            throw new RuntimeException("ALET-0003:sourceDatabase\u8fc1\u79fb\u6e90\u6570\u636e\u5e93\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)globalConfig.enableFunctions) && log.isWarnEnabled()) {
            log.warn("ALET-0004:\u8fc1\u79fb\u529f\u80fdetl.global.enableFunctions\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.functionSet = new HashSet();
        String[] functions = globalConfig.enableFunctions.split(",");
        String str = "";
        for (String function : functions) {
            if (str.equals(function)) {
                if (!log.isWarnEnabled()) continue;
                log.warn("ALET-0005:\u8fc1\u79fb\u529f\u80fd\u591a\u4e86\u9017\u53f7");
                continue;
            }
            if (!functionsTrue.contains(function.toLowerCase())) {
                if (!log.isWarnEnabled()) continue;
                log.warn("ALET-0006:\u8fc1\u79fb\u529f\u80fd\u5355\u8bcd:%s\u62fc\u5199\u9519\u8bef:{}", (Object)function);
                continue;
            }
            this.functionSet.add(function.toLowerCase());
        }
        if (log.isInfoEnabled()) {
            log.info("enable functions {}", (Object)JSONUtils.toJSONString((Object)this.functionSet));
        }
        if (StringUtils.isNotBlank((CharSequence)globalConfig.keywords)) {
            this.keywordsSet = Splitter.on((String)",").splitToList((CharSequence)globalConfig.keywords).stream().map(String::toLowerCase).collect(Collectors.toSet());
        }
        if (StringUtils.isNotBlank((CharSequence)globalConfig.syncCustomTableData)) {
            this.syncCustomSql = Splitter.on((String)";").splitToList((CharSequence)globalConfig.syncCustomTableData).stream().collect(Collectors.toList());
        }
        this.schemaIndex = 0;
        this.schemas = Splitter.on((String)",").splitToList((CharSequence)globalConfig.transferSchemas);
        if (StringUtils.isBlank((CharSequence)globalConfig.targetSchemas)) {
            globalConfig.targetSchemas = globalConfig.transferSchemas;
        }
        this.targetSchemas = Splitter.on((String)",").splitToList((CharSequence)globalConfig.targetSchemas);
        if (this.schemas.size() != this.targetSchemas.size()) {
            throw new RuntimeException(String.format("ALET-0007:\u6e90\u5e93\u548c\u76ee\u6807\u5e93\u7684\u8fc1\u79fbschema\u7684\u6570\u91cf\u4e0d\u4e00\u81f4,{\u6e90\u5e93[%s] \u76ee\u6807\u5e93[%s]}", this.schemas.size(), this.targetSchemas.size()));
        }
        if (StringUtils.isNotBlank((CharSequence)globalConfig.transferOnlyProcedures)) {
            this.onlyProcedures = Splitter.on((String)",").splitToList((CharSequence)globalConfig.transferOnlyProcedures).stream().map(procedure -> procedure.toLowerCase()).collect(Collectors.toSet());
        }
        this.sourceDatabase = globalConfig.sourceDatabase;
        this.targetDatabase = globalConfig.targetDatabase;
        String excludeColumns = globalConfig.getExcludeColumns();
        if (StringUtils.isNotBlank((CharSequence)excludeColumns)) {
            excludeTableColumnsMap.putAll(this.analyzeConfig(excludeColumns));
        }
        if (StringUtils.isNotBlank((CharSequence)(booleanColumns = globalConfig.getBooleanColumns()))) {
            booleanTableColumnsMap.putAll(this.analyzeConfig(booleanColumns));
        }
        if (StringUtils.isNotBlank((CharSequence)(dataTransformColumns = globalConfig.getDataTransformColumns()))) {
            dataTransformColumnsMap.putAll(this.analyzeConfigIllegalData(dataTransformColumns));
        }
        if (StringUtils.isNotBlank((CharSequence)(defaultValueTransform = globalConfig.getDefaultValueTransform()))) {
            defaultValueTransformMap.putAll(this.analyzeConfigDefaultValue(defaultValueTransform));
        }
        if (StringUtils.isNotBlank((CharSequence)(orderByColumns = globalConfig.getOrderByColumns()))) {
            orderByColumnsMap.putAll(this.analyzeConfig(orderByColumns));
        }
        try {
            int zero = 0;
            int three = 3;
            boolAndCharMode = Integer.parseInt(globalConfig.bool2charmode);
            if (boolAndCharMode < zero || boolAndCharMode > three) {
                throw new RuntimeException("ALET-0007:bool2charmode \u53c2\u6570\u503c\u8bbe\u7f6e\u9519\u8bef\uff0c\u76ee\u524d\u53ea\u652f\u63010\u30011\u30012\u4e09\u79cd\u6a21\u5f0f");
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("ALET-0007:bool2charmode \u53c2\u6570\u503c\u8bbe\u7f6e\u9519\u8bef\uff0c\u76ee\u524d\u53ea\u652f\u63010\u30011\u30012\u4e09\u79cd\u6a21\u5f0f");
        }
        EtlGlobalCtx.printFields((Object)globalConfig);
    }

    private Map<String, Set<String>> analyzeConfig(String configure) {
        String[] splits;
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(16);
        for (String tableColumn : splits = configure.split(";")) {
            int left = tableColumn.indexOf("[");
            int right = tableColumn.indexOf("]");
            if (left <= 0 || left >= right) continue;
            String tableName = tableColumn.substring(0, left);
            String columns = tableColumn.substring(left + 1, right);
            String[] columnArr = columns.split(",");
            Set set = Stream.of(columnArr).map(String::toLowerCase).collect(Collectors.toSet());
            result.put(tableName.toLowerCase(), set);
        }
        return result;
    }

    private Map<String, Map<String, ColumnDataTransform>> analyzeConfigIllegalData(String configure) {
        String[] splits;
        HashMap<String, Map<String, ColumnDataTransform>> result = new HashMap<String, Map<String, ColumnDataTransform>>(16);
        for (String perTableCfg : splits = configure.split("\\|")) {
            int left = perTableCfg.indexOf("[");
            int right = perTableCfg.indexOf("]");
            int start = perTableCfg.indexOf("(") + 1;
            int end = perTableCfg.indexOf(")");
            if (left <= 0 || left >= right || start <= left || end >= right) continue;
            String tableName = perTableCfg.substring(0, left).trim();
            String colsCfg = perTableCfg.substring(left + 1, right);
            String[] colTransSplits = colsCfg.split(";");
            HashMap<String, ColumnDataTransform> columnDataTransformMap = new HashMap<String, ColumnDataTransform>(16);
            for (String colTrans : colTransSplits) {
                int startSrcData = colTrans.indexOf("(") + 1;
                int endDestData = colTrans.indexOf(")");
                String columnName = colTrans.substring(0, startSrcData - 1).trim();
                String[] cols = colTrans.substring(startSrcData, endDestData).split(",");
                ColumnDataTransform columnDataTransform = new ColumnDataTransform();
                columnDataTransform.setSrcColData(cols[0].toLowerCase());
                columnDataTransform.setDestColData(cols[1].toLowerCase());
                columnDataTransformMap.putIfAbsent(columnName, columnDataTransform);
            }
            result.put(tableName.toLowerCase(), columnDataTransformMap);
        }
        return result;
    }

    private Map<String, ColumnDataTransform> analyzeConfigDefaultValue(String configure) {
        String[] splits;
        HashMap<String, ColumnDataTransform> result = new HashMap<String, ColumnDataTransform>(8);
        for (String perTableCfg : splits = configure.split("\\|")) {
            int left = perTableCfg.indexOf("(");
            int right = perTableCfg.indexOf(")");
            if (left <= 0 || left >= right) continue;
            String tableName = perTableCfg.substring(0, left).trim();
            String colsCfg = perTableCfg.substring(left + 1, right);
            String[] colTransSplits = colsCfg.split(",");
            ColumnDataTransform columnDataTransform = new ColumnDataTransform();
            columnDataTransform.setSrcColData(colTransSplits[0].trim());
            columnDataTransform.setDestColData(colTransSplits[1].trim());
            result.put(tableName.toLowerCase(), columnDataTransform);
        }
        return result;
    }

    public boolean oracleToOceanBaseOracle() {
        return this.sourceDatabase.equalsIgnoreCase(DataBaseTypeEnum.ORACLE.getName()) && this.targetDatabase.equalsIgnoreCase(DataBaseTypeEnum.OCEAN_BASE_ORACLE.getName());
    }

    public boolean supportDdlTransformer() {
        return this.sourceDatabase.equalsIgnoreCase(DataBaseTypeEnum.ORACLE.getName()) && this.targetDatabase.equalsIgnoreCase(DataBaseTypeEnum.LIGHTDB_ORACLE.getName());
    }

    public boolean oracleToLightdb() {
        return this.sourceDatabase.equalsIgnoreCase(DataBaseTypeEnum.ORACLE.getName()) && this.targetDatabase.equalsIgnoreCase(DataBaseTypeEnum.LIGHTDB_ORACLE.getName());
    }

    public boolean lightdbToOracle() {
        return this.sourceDatabase.equals(DataBaseTypeEnum.LIGHTDB_ORACLE.getName()) && this.targetDatabase.equals(DataBaseTypeEnum.ORACLE.getName());
    }

    public boolean oracleToDm() {
        return this.sourceDatabase.equalsIgnoreCase(DataBaseTypeEnum.ORACLE.getName()) && this.targetDatabase.equalsIgnoreCase(DataBaseTypeEnum.DM.getName());
    }

    private boolean checkCmdLimitation(String passWord) {
        String testCmd = String.format("LTPASSWORD='%s' ltsql -c 'select 1'", passWord);
        String result = ProcessUtils.exec((String)testCmd);
        return !result.contains("ProcessUtils Cmd Error");
    }

    public boolean enableTransferTable() {
        return this.functionSet.contains("transfertable");
    }

    public boolean syncTableDataOpenTruncate() {
        return this.globalConfig.syncTableDataOpenTruncate;
    }

    public boolean enableTransferTableData() {
        return this.functionSet.contains("transfertabledata");
    }

    public boolean enableTableCompare() {
        return this.functionSet.contains("tablecompare");
    }

    public boolean enableTableDataCompare() {
        return this.functionSet.contains("tabledatacompare");
    }

    public boolean enableTypeCountCompare() {
        return this.functionSet.contains("typecountcompare");
    }

    public boolean enableTransferIndex() {
        return this.functionSet.contains("transferindex");
    }

    public boolean enableTransferSequence() {
        return this.functionSet.contains("transfersequence");
    }

    public boolean enableTransferPackage() {
        return this.functionSet.contains("transferpackage");
    }

    public boolean enableTransferType() {
        return this.functionSet.contains("transfertype");
    }

    public boolean enableTransferView() {
        return this.functionSet.contains("transferview");
    }

    public boolean enableTransferProcedure() {
        return this.functionSet.contains("transferprocedure");
    }

    public boolean enableTransferFunction() {
        return this.functionSet.contains("transferfunction");
    }

    public boolean enableTransferTrigger() {
        return this.functionSet.contains("transfertrigger");
    }

    public boolean enableTransferTableFK() {
        return this.functionSet.contains("transfertablefk");
    }

    public boolean enableTransferTablePK() {
        return this.functionSet.contains("transfertablepk");
    }

    public boolean enableTransferTableCheckConstraints() {
        return this.functionSet.contains("transfertablecheckconstraints");
    }

    public boolean enableCompareSqlResult() {
        if (this.functionSet.contains("comparesqlresult")) {
            if (this.oracleToOceanBaseOracle() || this.oracleToDm()) {
                return true;
            }
            if (log.isWarnEnabled()) {
                log.warn("\u6682\u4e0d\u652f\u6301\u76ee\u6807\u5e93\u7684\u4e2d\u95f4\u6bd4\u5bf9\u529f\u80fd");
            }
        }
        return false;
    }

    public boolean enableTransferSynonym() {
        return this.functionSet.contains("transfersynonym");
    }

    public boolean fastFail() {
        return this.globalConfig.fastFail;
    }

    public boolean needCompareAll() {
        return this.globalConfig.compareAll;
    }

    public String ignoreCase(String name) {
        if (!this.globalConfig.ignoreCase) {
            return name;
        }
        if (!this.globalConfig.ignoreCaseMixing && this.hasBothUpperCaseAndLowerCase(name)) {
            return name;
        }
        return name.toLowerCase();
    }

    public String removeQuotes(String name) {
        String newName = name;
        if (this.globalConfig.removeDoubleQuote) {
            newName = CommonUtils.trimLeadTailDoubleQuote((String)name);
        }
        if (!this.globalConfig.ignoreCaseMixing && this.hasBothUpperCaseAndLowerCase(newName)) {
            return name;
        }
        if (this.iskeyWord(newName)) {
            return name;
        }
        return newName;
    }

    public boolean hasBothUpperCaseAndLowerCase(String str) {
        boolean hasUpperCase = false;
        boolean hasLowerCase = false;
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch >= 'A' && ch <= 'Z') {
                hasUpperCase = true;
            } else if (ch >= 'a' && ch <= 'z') {
                hasLowerCase = true;
            }
            if (!hasUpperCase || !hasLowerCase) continue;
            return true;
        }
        return hasUpperCase && hasLowerCase;
    }

    public void handleException(String msg, Throwable e) {
        if (e.getMessage() != null && e.getMessage().contains("already exists")) {
            if (log.isWarnEnabled()) {
                log.warn("\u5173\u7cfb\u5df2\u5b58\u5728 \r\n \u5806\u6808\uff1a{}", (Object)Throwables.getStackTraceAsString((Throwable)e));
            }
            return;
        }
        if (log.isErrorEnabled()) {
            log.error("\u4fe1\u606f: {} \r\n \u5806\u6808\uff1a{}", (Object)msg, (Object)Throwables.getStackTraceAsString((Throwable)e));
        }
        this.exitIfRequired();
    }

    public void handlePrimaryKeyException(String msg, Throwable e) {
        String meg1 = "multiple primary keys";
        if (e.getMessage() != null && e.getMessage().contains("already exists")) {
            if (log.isWarnEnabled()) {
                log.warn("\u5173\u7cfb\u5df2\u5b58\u5728 \r\n \u5806\u6808\uff1a{}", (Object)Throwables.getStackTraceAsString((Throwable)e).replace("ERROR", "WARN"));
            }
            return;
        }
        if (e.getMessage() != null && e.getMessage().contains(meg1)) {
            if (log.isWarnEnabled()) {
                log.warn("\u4fe1\u606f: {} \r\n \u5806\u6808\uff1a{}", (Object)msg, (Object)Throwables.getStackTraceAsString((Throwable)e).replace("ERROR", "WARN"));
            }
            return;
        }
        if (log.isErrorEnabled()) {
            log.error("\u4fe1\u606f: {} \r\n \u5806\u6808\uff1a{}", (Object)msg, (Object)Throwables.getStackTraceAsString((Throwable)e));
        }
        this.exitIfRequired();
    }

    public void handleException(Throwable e) {
        if (log.isErrorEnabled()) {
            log.error("\u5806\u6808: [{}]", (Object)Throwables.getStackTraceAsString((Throwable)e));
        }
        this.exitIfRequired();
    }

    public void handleException(String info) {
        if (log.isErrorEnabled()) {
            log.error("\u5806\u6808: [{}]", (Object)info);
        }
        System.exit(0);
    }

    private void exitIfRequired() {
        if (this.fastFail()) {
            if (log.isInfoEnabled()) {
                log.info("etl\u7cfb\u7edf\u9000\u51fa");
            }
            System.exit(1);
        }
    }

    public int batchCount() {
        return this.globalConfig.batchCount <= 0 ? 200000 : this.globalConfig.batchCount;
    }

    public String targetDatabase() {
        return this.targetDatabase;
    }

    public String filterTable(String column) {
        return (StringUtils.isBlank((CharSequence)this.globalConfig.includeTableRegexp) ? "" : String.format(" and REGEXP_LIKE(%s,'%s','i')", column, this.globalConfig.includeTableRegexp)) + (StringUtils.isBlank((CharSequence)this.globalConfig.excludeTableRegexp) ? "" : String.format(" and not REGEXP_LIKE(%s,'%s','i')", column, this.globalConfig.excludeTableRegexp));
    }

    public String filterMysqlTable(String column) {
        return (StringUtils.isBlank((CharSequence)this.globalConfig.includeTableRegexp) ? "" : String.format(" and %s REGEXP('%s')", column, this.globalConfig.includeTableRegexp)) + (StringUtils.isBlank((CharSequence)this.globalConfig.excludeTableRegexp) ? "" : String.format(" and %s not REGEXP('%s')", column, this.globalConfig.excludeTableRegexp));
    }

    public String filterGoldenDBTable(String column) {
        return (StringUtils.isBlank((CharSequence)this.globalConfig.includeTableRegexp) ? "" : String.format(" and regexp_like(%s, '%s','i')", column, this.globalConfig.includeTableRegexp)) + (StringUtils.isBlank((CharSequence)this.globalConfig.excludeTableRegexp) ? "" : String.format(" and not regexp_like(%s, '%s','i')", column, this.globalConfig.excludeTableRegexp));
    }

    public String filterObTable() {
        return StringUtils.isBlank((CharSequence)this.globalConfig.includeTableRegexp) ? "" : String.format(" and REGEXP_LIKE(table_name,'%s','i') ", this.globalConfig.includeTableRegexp);
    }

    public String filterPgTable() {
        return (StringUtils.isBlank((CharSequence)this.globalConfig.includeTableRegexp) ? "" : String.format(" and regexp_match(table_name,'%s','i') is not null", this.globalConfig.includeTableRegexp)) + (StringUtils.isBlank((CharSequence)this.globalConfig.excludeTableRegexp) ? "" : String.format(" and regexp_match(table_name,'%s','i') is null", this.globalConfig.excludeTableRegexp));
    }

    public String filterGaussdb500Table() {
        return (StringUtils.isBlank((CharSequence)this.globalConfig.includeTableRegexp) ? "" : String.format(" and table_name ~* '%s'", this.globalConfig.includeTableRegexp)) + (StringUtils.isBlank((CharSequence)this.globalConfig.excludeTableRegexp) ? "" : String.format("  and table_name !~* '%s'", this.globalConfig.excludeTableRegexp));
    }

    public String filterGaussdb505Table() {
        return (StringUtils.isBlank((CharSequence)this.globalConfig.includeTableRegexp) ? "" : String.format(" and table_name ~* '%s'", this.globalConfig.includeTableRegexp)) + (StringUtils.isBlank((CharSequence)this.globalConfig.excludeTableRegexp) ? "" : String.format("  and table_name !~* '%s'", this.globalConfig.excludeTableRegexp));
    }

    public String filterPgTable(String column) {
        return (StringUtils.isBlank((CharSequence)this.globalConfig.includeTableRegexp) ? "" : String.format(" and regexp_match(%s,'%s','i') is not null", column, this.globalConfig.includeTableRegexp)) + (StringUtils.isBlank((CharSequence)this.globalConfig.excludeTableRegexp) ? "" : String.format(" and regexp_match(%s,'%s','i') is null", column, this.globalConfig.excludeTableRegexp));
    }

    public String filterOracleTable(String column) {
        return (StringUtils.isBlank((CharSequence)this.globalConfig.includeTableRegexp) ? "" : String.format(" and regexp_like(%s, '%s','i')", column, this.globalConfig.includeTableRegexp)) + (StringUtils.isBlank((CharSequence)this.globalConfig.excludeTableRegexp) ? "" : String.format(" and not regexp_like(%s, '%s','i')", column, this.globalConfig.excludeTableRegexp));
    }

    public String filterOceanBaseOracleTable(String column) {
        return (StringUtils.isBlank((CharSequence)this.globalConfig.includeTableRegexp) ? "" : String.format(" and regexp_like(%s, '%s','i')", column, this.globalConfig.includeTableRegexp)) + (StringUtils.isBlank((CharSequence)this.globalConfig.excludeTableRegexp) ? "" : String.format(" and not regexp_like(%s, '%s','i')", column, this.globalConfig.excludeTableRegexp));
    }

    public String filterDMTable(String column) {
        return (StringUtils.isBlank((CharSequence)this.globalConfig.includeTableRegexp) ? "" : String.format(" and regexp_like(%s, '%s','i')", column, this.globalConfig.includeTableRegexp)) + (StringUtils.isBlank((CharSequence)this.globalConfig.excludeTableRegexp) ? "" : String.format(" and not regexp_like(%s, '%s','i')", column, this.globalConfig.excludeTableRegexp));
    }

    public String filterOceanBaseTable(String column) {
        return (StringUtils.isBlank((CharSequence)this.globalConfig.includeTableRegexp) ? "" : String.format(" and regexp_like(%s, '%s','i')", column, this.globalConfig.includeTableRegexp)) + (StringUtils.isBlank((CharSequence)this.globalConfig.excludeTableRegexp) ? "" : String.format(" and not regexp_like(%s, '%s','i')", column, this.globalConfig.excludeTableRegexp));
    }

    public void init(List<String> fetchPgTypes) {
        this.pgTypes.addAll(fetchPgTypes);
    }

    public boolean isDomainType(String name) {
        return this.pgTypes.contains(name.toLowerCase());
    }

    public EtlConfig.GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public String tryReplaceType(String typeName) {
        String procedure = "procedure";
        String function = "function";
        if (!Arrays.asList(procedure, function).contains(this.type)) {
            return typeName;
        }
        String lowerCase = typeName.toLowerCase();
        if (lowerCase.endsWith("%type")) {
            int domainIndex = lowerCase.indexOf(46);
            int index = lowerCase.indexOf(37);
            if (domainIndex != -1 && index != -1 && this.isDomainType(lowerCase.substring(domainIndex + 1, index))) {
                return typeName.substring(0, index);
            }
        }
        return MotionEtlGlobalCtx.getInstance().plpgSql() ? plpgsqlTypeMapping.getOrDefault(typeName.toLowerCase(), typeName) : ploraTypeMapping.getOrDefault(typeName.toLowerCase(), typeName);
    }

    public int concurrentThreadCount() {
        return this.globalConfig.concurrentThreadCount;
    }

    public void storeFkSqls(List<KeyValuePair> fkSqls) {
        this.fkSqls.addAll(fkSqls);
    }

    public List<String> getFkSqls() {
        return this.fkSqls.stream().map(KeyValuePair::getValue).collect(Collectors.toList());
    }

    public boolean isLightdbA() {
        return "lightdb-a".equals(this.globalConfig.targetDatabase);
    }

    public boolean plpgSql() {
        return this.globalConfig.plpgSql;
    }

    public boolean increaseSchema() {
        if (this.schemaIndex < this.schemas.size()) {
            this.currentSchema = (String)this.schemas.get(this.schemaIndex);
            this.currentTargetSchema = (String)this.targetSchemas.get(this.schemaIndex);
            ++this.schemaIndex;
            return true;
        }
        return false;
    }

    public void resetSchemaIndex() {
        this.schemaIndex = 0;
    }

    public String currentSchema() {
        return this.currentSchema;
    }

    public String currentTargetSchema() {
        return this.currentTargetSchema;
    }

    public boolean needTransfer(String procedure) {
        return this.onlyProcedures.isEmpty() || this.onlyProcedures.contains(procedure.toLowerCase());
    }

    public void transferType(String transferType) {
        this.type = transferType;
    }

    public String transferType() {
        return this.type;
    }

    public String tempTableCondition() {
        return this.globalConfig.onlyTransferTempTables ? " and a.TEMPORARY='Y' " : "";
    }

    public boolean onCommitPreserveRows() {
        return this.globalConfig.onCommitPreserveRows;
    }

    public void queueConnection(Connection connection) {
        if (log.isInfoEnabled()) {
            log.info("open connection {}", (Object)connection);
        }
        this.queue.offer(connection);
    }

    public void releaseResources() {
        Connection connection = (Connection)this.queue.poll();
        while (connection != null) {
            JdbcUtils.close((AutoCloseable)connection);
            if (log.isInfoEnabled()) {
                log.info("close connection {}", (Object)connection);
            }
            connection = (Connection)this.queue.poll();
        }
        if (this.workerGroup != null) {
            this.workerGroup.shutdown();
        }
    }

    public void setWorkerGroup(WorkerGroup workerGroup) {
        this.workerGroup = workerGroup;
    }

    public WorkerGroup getWorkerGroup() {
        return this.workerGroup;
    }

    public boolean isExceptionVar(String exception) {
        if (StringUtils.isBlank((CharSequence)this.globalConfig.customException)) {
            return false;
        }
        return this.globalConfig.customException.toLowerCase().contains(exception.toLowerCase());
    }

    public String sqluldr2CmdPrefix() {
        return this.globalConfig.sqluldr2CmdPrefix;
    }

    public boolean importUseFile(TableInfo tableInfo) {
        return this.sqluldr2TablesSet.contains(tableInfo.getTableName().toLowerCase());
    }

    public boolean iskeyWord(String keyWord) {
        return this.keywordsSet.contains(keyWord.toLowerCase());
    }

    public static boolean excludeColumn(String tableName, String columnName) {
        return ((Set)excludeTableColumnsMap.getOrDefault(tableName.toLowerCase(), new HashSet())).contains(columnName.toLowerCase());
    }

    public static boolean booleanColumn(String tableName, String columnName) {
        return ((Set)booleanTableColumnsMap.getOrDefault(tableName.toLowerCase(), new HashSet())).contains(columnName.toLowerCase());
    }

    public static boolean dataTransformColumn(String tableName, String columnName) {
        return ((Map)dataTransformColumnsMap.getOrDefault(tableName.toLowerCase(), new HashMap(16))).containsKey(columnName.toLowerCase());
    }

    public static ColumnDataTransform getColumnDataTransform(String tableName, String columnName) {
        return (ColumnDataTransform)((Map)dataTransformColumnsMap.getOrDefault(tableName.toLowerCase(), new HashMap(16))).get(columnName);
    }

    public static Map<String, ColumnDataTransform> getDefaultValueTransformMap() {
        return defaultValueTransformMap;
    }

    public static Set<String> getOrderByColumn(String tableName) {
        return (Set)orderByColumnsMap.get(tableName);
    }

    public static int boolToCharMode() {
        return boolAndCharMode;
    }

    public static void printFields(Object obj) {
        Field[] fields;
        StringBuffer sb = new StringBuffer();
        if (obj == null) {
            return;
        }
        Class<?> clazz = obj.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            field.setAccessible(true);
            String name = field.getName();
            Object value = null;
            try {
                value = field.get(obj);
            }
            catch (IllegalAccessException e) {
                log.error("\u83b7\u53d6\u5b57\u6bb5\u5f02\u5e38:", (Throwable)e);
            }
            sb.append(String.format("[\"%s\":\"%s\"];", name, value));
        }
        if (log.isInfoEnabled()) {
            log.info("Start initial configuration: {}", (Object)sb.toString());
        }
    }

    static {
        plpgsqlTypeMapping = new HashMap(32);
        plpgsqlTypeMapping.put("sys_refcursor", "refcursor");
        ploraTypeMapping = new HashMap(32);
        ploraTypeMapping.put("long", "text");
        functionsTrue.add("transfertable");
        functionsTrue.add("transfertabledata");
        functionsTrue.add("tablecompare");
        functionsTrue.add("tabledatacompare");
        functionsTrue.add("transfertype");
        functionsTrue.add("transferindex");
        functionsTrue.add("transfersequence");
        functionsTrue.add("transferview");
        functionsTrue.add("transferpackage");
        functionsTrue.add("transfertrigger");
        functionsTrue.add("typecountcompare");
        functionsTrue.add("transferprocedure");
        functionsTrue.add("transferfunction");
        functionsTrue.add("transfertablefk");
        functionsTrue.add("transfertablepk");
        functionsTrue.add("transfertablecheckconstraints");
        functionsTrue.add("transfersynonym");
        functionsTrue.add("comparesqlresult");
    }
}

