/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core;

import com.hundsun.lightdb.TableInfo;
import com.hundsun.lightdb.core.EtlGlobalCtx;
import com.hundsun.lightdb.core.target.TargetImporter;
import com.hundsun.lightdb.utils.ProcessUtils;
import com.hundsun.lightdb.utils.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN", "COMMAND_INJECTION", "DM_SYSTEM_OUT", "DM_SYSTEM_ERR", "SQL_INJECTION_JDBC"})
public class FileImporter {
    private static final Logger log = LoggerFactory.getLogger(FileImporter.class);
    TargetImporter target;
    String sqluldr2CmdPrefix;

    public void importFile(TableInfo tableInfo) {
        String csvPath = String.join((CharSequence)File.separator, EtlGlobalCtx.SQLULDR2DIR, tableInfo.formatTableName() + ".csv");
        String cmd = String.format("%s query=%s file=%s head=yes", this.sqluldr2CmdPrefix, tableInfo.formatTableName(), csvPath);
        ProcessUtils.exec((String)cmd);
        this.copyFile(csvPath, tableInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFile(String filePath, TableInfo tableInfo) {
        FileInputStream fileInputStream = null;
        try {
            CopyManager copyManager = new CopyManager((BaseConnection)this.target.targetJdbcMeta().openConnection());
            fileInputStream = new FileInputStream(filePath);
            copyManager.copyIn(String.format("COPY %s FROM STDIN with csv header", tableInfo.formatTableName()), (InputStream)fileInputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public FileImporter(TargetImporter target, String sqluldr2CmdPrefix) {
        this.target = target;
        this.sqluldr2CmdPrefix = sqluldr2CmdPrefix;
    }

    static {
        new File(EtlGlobalCtx.SQLULDR2DIR).mkdirs();
    }
}

