/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core;

import com.hundsun.lightdb.TableInfo;
import com.hundsun.lightdb.WorkerGroup;
import com.hundsun.lightdb.core.EtlGlobalCtx;
import com.hundsun.lightdb.utils.ProcessUtils;
import com.hundsun.lightdb.utils.SuppressFBWarnings;
import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplittingFiles
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(SplittingFiles.class);
    private static String SPLIT = "-";
    WorkerGroup workerGroup;
    TableInfo tableInfo;
    String splitCmd;
    String ltsqlCopyFrom;
    Integer batchNum;

    @Override
    public void run() {
        String csvPath = String.join((CharSequence)File.separator, EtlGlobalCtx.SQLULDR2DIR, this.tableInfo.formatTableName() + SPLIT + this.batchNum + "-%b.csv");
        String cmd = String.format(this.splitCmd, csvPath);
        ProcessUtils.exec((String)cmd);
        this.copyFile();
    }

    public void copyFile() {
        List fileNames = this.getAllFiles(EtlGlobalCtx.SQLULDR2DIR);
        fileNames = fileNames.stream().filter(f -> f.indexOf(this.tableInfo.formatTableName() + SPLIT + this.batchNum + SPLIT) >= 0).collect(Collectors.toList());
        for (int i = 0; i < fileNames.size(); ++i) {
            String cmd = String.format(this.ltsqlCopyFrom, this.tableInfo.formatTableName(), EtlGlobalCtx.SQLULDR2DIR, fileNames.get(i));
            this.workerGroup.addTask(() -> ProcessUtils.exec((String)cmd));
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_OUT", "PATH_TRAVERSAL_IN"})
    public List<String> getAllFiles(String dir) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Path folder = Paths.get(dir, new String[0]);
            Stream<Path> paths = Files.walk(folder, new FileVisitOption[0]);
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> list.add(path.getFileName().toString()));
        }
        catch (Exception e) {
            EtlGlobalCtx.INSTANCE.handleException("\u8bfb\u53d6sqluldr2\u5bfc\u5165\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
        return list;
    }

    public SplittingFiles(WorkerGroup workerGroup, TableInfo tableInfo, String splitCmd, String ltsqlCopyFrom, Integer batchNum) {
        this.workerGroup = workerGroup;
        this.tableInfo = tableInfo;
        this.splitCmd = splitCmd;
        this.ltsqlCopyFrom = ltsqlCopyFrom;
        this.batchNum = batchNum;
    }

    static {
        new File(String.format(EtlGlobalCtx.SQLULDR2DIR + "%s", FilenameUtils.getName((String)""))).mkdirs();
    }
}

