/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.actuator;

import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.actuator.Actuator;
import com.hundsun.lightdb.core.actuator.ActuatorInterface;
import com.hundsun.lightdb.core.actuator.CompareSqlResultActuator;
import com.hundsun.lightdb.core.actuator.CustomActuator;
import com.hundsun.lightdb.core.actuator.CustomTableDataActuator;
import com.hundsun.lightdb.core.actuator.FunctionActuator;
import com.hundsun.lightdb.core.actuator.IndexActuator;
import com.hundsun.lightdb.core.actuator.PackageActuator;
import com.hundsun.lightdb.core.actuator.ProcedureActuator;
import com.hundsun.lightdb.core.actuator.SequenceActuator;
import com.hundsun.lightdb.core.actuator.SynonymActuator;
import com.hundsun.lightdb.core.actuator.TableActuator;
import com.hundsun.lightdb.core.actuator.TableCheckConActuator;
import com.hundsun.lightdb.core.actuator.TableCompareActuator;
import com.hundsun.lightdb.core.actuator.TableDataActuator;
import com.hundsun.lightdb.core.actuator.TableDataCompareActuator;
import com.hundsun.lightdb.core.actuator.TableFkActuator;
import com.hundsun.lightdb.core.actuator.TablePkActuator;
import com.hundsun.lightdb.core.actuator.TriggerActuator;
import com.hundsun.lightdb.core.actuator.TypeActuator;
import com.hundsun.lightdb.core.actuator.TypeCountCompareActuator;
import com.hundsun.lightdb.core.actuator.ViewActuator;
import com.hundsun.lightdb.core.source.SourceFetcher;
import com.hundsun.lightdb.core.target.TargetImporter;
import com.hundsun.lightdb.core.transformer.EtlTransformer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActuatorBuilder {
    private static final Logger log = LoggerFactory.getLogger(ActuatorBuilder.class);
    List<ActuatorInterface> actuatorList = new ArrayList();
    SourceFetcher sourceFetcher;
    EtlTransformer transformer;
    TargetImporter targetImporter;

    public ActuatorBuilder(SourceFetcher sourceFetcher, EtlTransformer transformer, TargetImporter targetImporter) {
        this.sourceFetcher = sourceFetcher;
        this.transformer = transformer;
        this.targetImporter = targetImporter;
    }

    public Actuator build() {
        this.addExcuter((ActuatorInterface)new CustomTableDataActuator(this.sourceFetcher, this.transformer, this.targetImporter));
        if (MotionEtlGlobalCtx.getInstance().enableTransferTable()) {
            this.addExcuter((ActuatorInterface)new TableActuator(this.sourceFetcher, this.transformer, this.targetImporter));
        }
        if (MotionEtlGlobalCtx.getInstance().enableTransferTableData()) {
            this.addExcuter((ActuatorInterface)new TableDataActuator(this.sourceFetcher, this.transformer, this.targetImporter));
        }
        if (MotionEtlGlobalCtx.getInstance().enableTransferTablePK()) {
            this.addExcuter((ActuatorInterface)new TablePkActuator(this.sourceFetcher, this.transformer, this.targetImporter));
        }
        if (MotionEtlGlobalCtx.getInstance().enableTransferIndex()) {
            this.addExcuter((ActuatorInterface)new IndexActuator(this.sourceFetcher, this.transformer, this.targetImporter));
        }
        if (MotionEtlGlobalCtx.getInstance().enableTransferTableFK()) {
            this.addExcuter((ActuatorInterface)new TableFkActuator(this.sourceFetcher, this.transformer, this.targetImporter));
        }
        if (MotionEtlGlobalCtx.getInstance().enableTransferTableCheckConstraints()) {
            this.addExcuter((ActuatorInterface)new TableCheckConActuator(this.sourceFetcher, this.transformer, this.targetImporter));
        }
        if (MotionEtlGlobalCtx.getInstance().enableTransferSequence()) {
            this.addExcuter((ActuatorInterface)new SequenceActuator(this.sourceFetcher, this.transformer, this.targetImporter));
        }
        if (MotionEtlGlobalCtx.getInstance().enableTransferSynonym()) {
            this.addExcuter((ActuatorInterface)new SynonymActuator(this.sourceFetcher, this.transformer, this.targetImporter));
        }
        if (MotionEtlGlobalCtx.getInstance().enableTransferView()) {
            this.addExcuter((ActuatorInterface)new ViewActuator(this.sourceFetcher, this.transformer, this.targetImporter));
        }
        if (MotionEtlGlobalCtx.getInstance().enableTransferTrigger()) {
            this.addExcuter((ActuatorInterface)new TriggerActuator(this.sourceFetcher, this.transformer, this.targetImporter));
        }
        this.addExcuter((ActuatorInterface)new CustomActuator(this.sourceFetcher, this.transformer, this.targetImporter));
        if (MotionEtlGlobalCtx.getInstance().enableTransferPackage()) {
            this.addExcuter((ActuatorInterface)new PackageActuator(this.sourceFetcher, this.transformer, this.targetImporter));
        }
        if (MotionEtlGlobalCtx.getInstance().enableTransferType()) {
            this.addExcuter((ActuatorInterface)new TypeActuator(this.sourceFetcher, this.transformer, this.targetImporter));
        }
        if (MotionEtlGlobalCtx.getInstance().enableTransferProcedure()) {
            this.addExcuter((ActuatorInterface)new ProcedureActuator(this.sourceFetcher, this.transformer, this.targetImporter));
        }
        if (MotionEtlGlobalCtx.getInstance().enableTransferFunction()) {
            this.addExcuter((ActuatorInterface)new FunctionActuator(this.sourceFetcher, this.transformer, this.targetImporter));
        }
        if (MotionEtlGlobalCtx.getInstance().enableTableCompare()) {
            this.addExcuter((ActuatorInterface)new TableCompareActuator(this.sourceFetcher, this.transformer, this.targetImporter));
        }
        if (MotionEtlGlobalCtx.getInstance().enableTypeCountCompare()) {
            this.addExcuter((ActuatorInterface)new TypeCountCompareActuator(this.sourceFetcher, this.transformer, this.targetImporter));
        }
        if (MotionEtlGlobalCtx.getInstance().enableCompareSqlResult()) {
            this.addExcuter((ActuatorInterface)new CompareSqlResultActuator(this.sourceFetcher, this.transformer, this.targetImporter));
        }
        if (MotionEtlGlobalCtx.getInstance().enableTableDataCompare()) {
            this.addExcuter((ActuatorInterface)new TableDataCompareActuator(this.sourceFetcher, this.transformer, this.targetImporter));
        }
        return new Actuator(this.actuatorList);
    }

    public void addExcuter(ActuatorInterface actuator) {
        this.actuatorList.add(actuator);
    }
}

