/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.actuator;

import com.hundsun.lightdb.TableInfo;
import com.hundsun.lightdb.WorkerGroup;
import com.hundsun.lightdb.core.EtlConfig;
import com.hundsun.lightdb.core.KeyValuePair;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.actuator.AbstractActuator;
import com.hundsun.lightdb.core.source.SourceFetcher;
import com.hundsun.lightdb.core.target.TargetImporter;
import com.hundsun.lightdb.core.transformer.EtlTransformer;
import com.hundsun.lightdb.event.GlobalApplicationContext;
import com.hundsun.lightdb.utils.CommonUtils;
import com.hundsun.lightdb.utils.CompareTypeUtil;
import com.hundsun.lightdb.utils.DiffCompareData;
import com.hundsun.lightdb.utils.SuppressFBWarnings;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.sql.Connection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
public class CompareSqlResultActuator
extends AbstractActuator {
    private static final Logger log = LoggerFactory.getLogger(CompareSqlResultActuator.class);
    private final Map<String, KeyValuePair> loadSqlMap = new LinkedHashMap(8);
    private final Map<String, String> checkCountMap = new HashMap(8);
    private final ConcurrentHashMap<String, Boolean> compareResultList = new ConcurrentHashMap(8);

    public CompareSqlResultActuator(SourceFetcher sourceFetcher, EtlTransformer transformer, TargetImporter targetImporter) {
        super(sourceFetcher, transformer, targetImporter);
    }

    public void execute() {
        if (!this.loadSqlMappingsFromConfig()) {
            if (log.isErrorEnabled()) {
                log.error("\u4ece\u914d\u7f6e\u6587\u4ef6\u4e2d\u8bfb\u53d6\u6bd4\u8f83\u7684SQL\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5etl.sqldatacompare\u7684\u914d\u7f6e");
            }
            return;
        }
        WorkerGroup workerGroup = MotionEtlGlobalCtx.getInstance().getWorkerGroup();
        for (Map.Entry entry : this.loadSqlMap.entrySet()) {
            String sqlId = (String)entry.getKey();
            KeyValuePair pair = (KeyValuePair)entry.getValue();
            String sourceSql = pair.getKey();
            TableInfo sourceTable = new TableInfo();
            sourceTable.setCompareSql(sourceSql);
            sourceTable.setTableName(sqlId);
            String sourceFilePath = CommonUtils.compareSqlFilePath((String)String.format("%s_%s", "source", sqlId));
            String targetSql = pair.getValue();
            TableInfo targetTable = new TableInfo();
            targetTable.setCompareSql(targetSql);
            targetTable.setTableName(sqlId);
            String targetFilePath = CommonUtils.compareSqlFilePath((String)String.format("%s_%s", "target", sqlId));
            if (!this.compareSqlRowCounts(sqlId, sourceSql, targetSql)) continue;
            DiffCompareData diffCompareData = new DiffCompareData();
            diffCompareData.setGroup(workerGroup);
            diffCompareData.setSourceTable(sourceTable);
            diffCompareData.setTargetTable(targetTable);
            diffCompareData.setSourceJdbcMeta(this.sourceFetcher.sourceJdbcMeta());
            diffCompareData.setTargetJdbcMeta(this.targetImporter.targetJdbcMeta());
            diffCompareData.setCompareResultList(this.compareResultList);
            diffCompareData.setSourceFilePath(sourceFilePath);
            diffCompareData.setTargetFilePath(targetFilePath);
            diffCompareData.setBatchSize(MotionEtlGlobalCtx.getInstance().batchCount());
            diffCompareData.doCompare();
        }
        workerGroup.waitCompletion();
        String htmlContent = this.buildHtml(this.loadSqlMap);
        CompareTypeUtil.writeHtml((String)htmlContent, (String)"sqldatacompare");
    }

    private boolean compareSqlRowCounts(String sqlId, String sourceSql, String targetSql) {
        long sourceCount = CompareTypeUtil.getQueryCount((Connection)this.sourceFetcher.sourceJdbcMeta().openConnection(), (String)sourceSql);
        long targetCount = CompareTypeUtil.getQueryCount((Connection)this.targetImporter.targetJdbcMeta().openConnection(), (String)targetSql);
        if (sourceCount == -1L) {
            this.checkCountMap.put(sqlId, "\u6e90\u5e93\u7684SQL\u7684\u884c\u6570\u67e5\u8be2\u5931\u8d25");
            this.compareResultList.put(sqlId, false);
            return false;
        }
        if (targetCount == -1L) {
            this.checkCountMap.put(sqlId, "\u76ee\u6807\u5e93\u7684SQL\u7684\u884c\u6570\u67e5\u8be2\u5931\u8d25");
            this.compareResultList.put(sqlId, false);
            return false;
        }
        if (sourceCount != targetCount) {
            this.checkCountMap.put(sqlId, "\u6e90\u5e93\u548c\u76ee\u6807\u5e93\u7684SQL\u884c\u6570\u4e0d\u4e00\u81f4");
            this.compareResultList.put(sqlId, false);
            return false;
        }
        if (sourceCount == 0L) {
            this.checkCountMap.put(sqlId, "\u6e90\u5e93\u3001\u76ee\u6807\u5e93\u7684SQL\u7684\u884c\u6570\u4e3a0");
            this.compareResultList.put(sqlId, true);
            return false;
        }
        return true;
    }

    private boolean loadSqlMappingsFromConfig() {
        EtlConfig.SqlDataCompareConfig sqlDataCompareProperties = (EtlConfig.SqlDataCompareConfig)GlobalApplicationContext.context.getBean(EtlConfig.SqlDataCompareConfig.class);
        Map sourceKeyToSqlMap = sqlDataCompareProperties.getSource();
        Map targetKeyToSqlMap = sqlDataCompareProperties.getTarget();
        if (sourceKeyToSqlMap.isEmpty()) {
            if (log.isErrorEnabled()) {
                log.error("\u672a\u627e\u5230\u914d\u7f6e\u6e90\u5e93\u5f85\u6bd4\u8f83\u7684SQL,\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6etl.sqldatacompare.source.[id]\u914d\u7f6e\u5f85\u6bd4\u8f83\u7684sql");
            }
            return false;
        }
        if (sourceKeyToSqlMap.size() != targetKeyToSqlMap.size()) {
            if (log.isErrorEnabled()) {
                log.error("\u914d\u7f6e\u6e90\u5e93\u5f85\u6bd4\u8f83\u7684SQL\u548c\u76ee\u6807\u5e93\u7684\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5etl.sqldatacompare\u76f8\u5173\u914d\u7f6e");
            }
            return false;
        }
        for (Map.Entry entry : sourceKeyToSqlMap.entrySet()) {
            String key = (String)entry.getKey();
            if (StringUtils.isBlank((CharSequence)key)) {
                if (log.isErrorEnabled()) {
                    log.error("\u914d\u7f6e\u7684\u6e90\u5e93\u5f85\u6bd4\u8f83SQL\u7684ID\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5etl.sqldatacompare.source.[id]\u76f8\u5173\u914d\u7f6e");
                }
                return false;
            }
            String sourceSql = StringUtils.trimToNull((String)CommonUtils.removeTrailingSemicolon((String)((String)entry.getValue())));
            if (sourceSql == null) {
                if (log.isErrorEnabled()) {
                    log.error("\u914d\u7f6e\u7684\u6e90\u5e93\u5f85\u6bd4\u8f83SQL\u7684\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5etl.sqldatacompare.source.{}\u7684\u914d\u7f6e", (Object)key);
                }
                return false;
            }
            String targetSql = StringUtils.trimToNull((String)CommonUtils.removeTrailingSemicolon((String)((String)targetKeyToSqlMap.get(key))));
            if (targetSql == null) {
                if (log.isErrorEnabled()) {
                    log.error("\u914d\u7f6e\u7684\u76ee\u6807\u5e93\u5f85\u6bd4\u8f83SQL\u7684\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5etl.sqldatacompare.target.{}\u7684\u914d\u7f6e", (Object)key);
                }
                return false;
            }
            this.loadSqlMap.put(key, new KeyValuePair(sourceSql, targetSql));
        }
        return true;
    }

    private String buildHtml(Map<String, KeyValuePair> idToSqlMap) {
        int totalSql = idToSqlMap.size();
        long matchCount = this.compareResultList.values().stream().filter(Boolean::booleanValue).count();
        long notMatchCount = (long)this.compareResultList.size() - matchCount;
        StringBuilder sb = new StringBuilder();
        sb.append("<!DOCTYPE html>");
        sb.append("<html lang='zh-CN'>");
        sb.append("<head>");
        sb.append("<meta charset='UTF-8'>");
        sb.append("<title>SQL\u6bd4\u5bf9\u62a5\u544a</title>");
        sb.append("<style>");
        sb.append("table { border-collapse: collapse; width: 100%; margin-bottom:20px; }");
        sb.append("th, td { border: 1px solid #000; padding: 8px; text-align: center; }");
        sb.append("th { background-color: #f2f2f2; }");
        sb.append(".summary th { background-color: #ffe0b2; }");
        sb.append("</style>");
        sb.append("</head>");
        sb.append("<body>");
        sb.append("<h2 style='text-align:center;'>SQL\u6bd4\u5bf9\u62a5\u544a</h2>");
        sb.append("<table class='summary'>");
        sb.append("<tr>");
        sb.append("<th>\u603b\u6bd4\u5bf9SQL\u6570\u76ee(\u5bf9\u6570)</th>");
        sb.append("<th>\u6bd4\u5bf9\u7ed3\u679c\u4e00\u81f4\u7684\u6570\u76ee(\u5bf9\u6570)</th>");
        sb.append("<th>\u6bd4\u5bf9\u7ed3\u679c\u4e0d\u4e00\u81f4\u6570\u76ee(\u5bf9\u6570)</th>");
        sb.append("</tr>");
        sb.append("<tr>");
        sb.append("<td>").append(totalSql).append("</td>");
        sb.append("<td>").append(matchCount).append("</td>");
        sb.append("<td>").append(notMatchCount).append("</td>");
        sb.append("</tr>");
        sb.append("</table>");
        sb.append("<table>");
        sb.append("<tr>");
        sb.append("<th>SQL_ID</th>");
        sb.append("<th>\u6e90SQL</th>");
        sb.append("<th>\u76ee\u6807SQL</th>");
        sb.append("<th>\u6bd4\u5bf9\u7ed3\u679c\u662f\u5426\u4e00\u81f4</th>");
        sb.append("<th>\u9519\u8bef\u539f\u56e0\u548c\u64cd\u4f5c</th>");
        sb.append("</tr>");
        for (Map.Entry<String, KeyValuePair> entry : idToSqlMap.entrySet()) {
            String sqlId = entry.getKey();
            KeyValuePair pair = entry.getValue();
            String sourceSql = pair.getKey();
            String targetSql = pair.getValue();
            boolean isMatch = (Boolean)this.compareResultList.get(sqlId);
            String resultSourceToTarget = isMatch ? "\u662f" : "\u5426";
            String diffCommand = "";
            if (!isMatch && StringUtils.isBlank((CharSequence)(diffCommand = (String)this.checkCountMap.get(sqlId)))) {
                String sourceFilePath = CommonUtils.compareSqlFilePath((String)String.format("%s_%s", "source", sqlId));
                String targetFilePath = CommonUtils.compareSqlFilePath((String)String.format("%s_%s", "target", sqlId));
                diffCommand = !Files.exists(Paths.get(sourceFilePath, new String[0]), new LinkOption[0]) ? "\u6e90\u5e93\u5f85\u6bd4\u8f83\u7684\u6587\u4ef6\u672a\u751f\u6210\uff0c\u8bf7\u67e5\u770b\u5177\u4f53\u7684SQL\u6267\u884c\u65e5\u5fd7" : (!Files.exists(Paths.get(targetFilePath, new String[0]), new LinkOption[0]) ? "\u76ee\u6807\u5e93\u5f85\u6bd4\u8f83\u7684\u6587\u4ef6\u672a\u751f\u6210\uff0c\u8bf7\u67e5\u770b\u5177\u4f53\u7684SQL\u6267\u884c\u65e5\u5fd7" : String.format("diff %s %s", sourceFilePath, targetFilePath));
            }
            sb.append("<tr>");
            sb.append("<td>").append(sqlId).append("</td>");
            sb.append("<td>").append(sourceSql).append("</td>");
            sb.append("<td>").append(targetSql).append("</td>");
            sb.append("<td>").append(resultSourceToTarget).append("</td>");
            sb.append("<td>").append(diffCommand).append("</td>");
            sb.append("</tr>");
        }
        sb.append("</table>");
        sb.append("</body></html>");
        return sb.toString();
    }
}

