/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.actuator;

import com.hundsun.lightdb.core.KeyValuePair;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.ObjectTypeEnum;
import com.hundsun.lightdb.core.actuator.AbstractActuator;
import com.hundsun.lightdb.core.source.SourceFetcher;
import com.hundsun.lightdb.core.target.TargetImporter;
import com.hundsun.lightdb.core.transformer.EtlTransformer;
import com.hundsun.lightdb.utils.CommonUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class IndexActuator
extends AbstractActuator {
    public IndexActuator(SourceFetcher sourceFetcher, EtlTransformer transformer, TargetImporter targetImporter) {
        super(sourceFetcher, transformer, targetImporter);
    }

    public void execute() {
        LinkedHashMap<String, List> indexDdls = new LinkedHashMap<String, List>();
        while (MotionEtlGlobalCtx.getInstance().increaseSchema()) {
            String currentSchema = MotionEtlGlobalCtx.getInstance().currentSchema();
            MotionEtlGlobalCtx.getInstance().transferType(ObjectTypeEnum.INDEX.getName());
            List ddls = this.sourceFetcher.createIndexDdl();
            for (KeyValuePair ddl : ddls) {
                String tableName = ddl.getKey();
                String ddlKey = currentSchema + "." + tableName;
                List ddlList = indexDdls.computeIfAbsent(ddlKey, k -> new ArrayList());
                if (CommonUtils.oracle2Dm()) {
                    String[] parts;
                    Pattern pattern = Pattern.compile(";\\s+(?=ALTER\\b)", 2);
                    for (String part : parts = pattern.split(ddl.getValue())) {
                        String trimmed = part.trim();
                        if (trimmed.isEmpty()) continue;
                        String transformResult = this.transformer.transformIndexDdl(trimmed);
                        ddlList.add(transformResult);
                    }
                    continue;
                }
                String result = this.transformer.transformIndexDdl(ddl.getValue());
                ddlList.add(result);
            }
        }
        for (Map.Entry entry : indexDdls.entrySet()) {
            List ddlList = (List)entry.getValue();
            String ddlKey = (String)entry.getKey();
            this.targetImporter.executes(ObjectTypeEnum.INDEX.getName(), new KeyValuePair(ddlKey, ""), ddlList);
        }
        this.targetImporter.waitCompletion();
        MotionEtlGlobalCtx.getInstance().resetSchemaIndex();
    }
}

