/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.actuator;

import com.hundsun.lightdb.SqlLogger;
import com.hundsun.lightdb.core.KeyValuePair;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.ObjectTypeEnum;
import com.hundsun.lightdb.core.actuator.AbstractActuator;
import com.hundsun.lightdb.core.source.SourceFetcher;
import com.hundsun.lightdb.core.target.TargetImporter;
import com.hundsun.lightdb.core.transformer.EtlTransformer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class PackageActuator
extends AbstractActuator {
    public PackageActuator(SourceFetcher sourceFetcher, EtlTransformer transformer, TargetImporter targetImporter) {
        super(sourceFetcher, transformer, targetImporter);
    }

    public void execute() {
        while (MotionEtlGlobalCtx.getInstance().increaseSchema()) {
            MotionEtlGlobalCtx.getInstance().transferType(ObjectTypeEnum.PACKAGE.getName());
            List ddls = this.sourceFetcher.createPackageDdl();
            for (KeyValuePair ddl : ddls) {
                SqlLogger.printSql((String)"source-sql", (String)ddl.getValue());
                ArrayList<String> sqls = new ArrayList<String>();
                String result = this.transformer.transformPackageDdl(ddl.getValue());
                String regex = MotionEtlGlobalCtx.getInstance().getGlobalConfig().getPackageRegex();
                int packageBody = -1;
                if (StringUtils.isBlank((CharSequence)regex)) {
                    String regex1 = "(?i)CREATE\\s*OR\\s*REPLACE\\s*PACKAGE\\s*BODY";
                    String regex2 = "(?i)CREATE\\s*PACKAGE\\s*BODY";
                    Pattern pattern = Pattern.compile(regex1);
                    Matcher matcher = pattern.matcher(result);
                    if (matcher.find()) {
                        packageBody = matcher.start();
                    } else {
                        Pattern pattern2 = Pattern.compile(regex2);
                        Matcher matcher2 = pattern2.matcher(result);
                        if (matcher.find()) {
                            packageBody = matcher2.start();
                        }
                    }
                } else {
                    Pattern pattern = Pattern.compile(regex);
                    Matcher matcher = pattern.matcher(result);
                    if (matcher.find()) {
                        packageBody = matcher.start();
                    }
                }
                if (packageBody <= 0) {
                    sqls.add(result);
                } else {
                    String packageStmt = result.substring(0, packageBody);
                    String bodyStmt = result.substring(packageBody, result.length());
                    sqls.add(packageStmt);
                    sqls.add(bodyStmt);
                }
                this.targetImporter.executes(ObjectTypeEnum.PACKAGE.getName(), ddl, sqls);
            }
            this.targetImporter.waitCompletion();
        }
        MotionEtlGlobalCtx.getInstance().resetSchemaIndex();
    }
}

