/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.actuator;

import com.hundsun.lightdb.core.EtlGlobalCtx;
import com.hundsun.lightdb.core.KeyValuePair;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.ObjectTypeEnum;
import com.hundsun.lightdb.core.actuator.AbstractActuator;
import com.hundsun.lightdb.core.source.SourceFetcher;
import com.hundsun.lightdb.core.target.TargetImporter;
import com.hundsun.lightdb.core.transformer.EtlTransformer;
import com.hundsun.lightdb.motion.enums.DataBaseTypeEnum;
import com.hundsun.lightdb.utils.ColumnDataTransform;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class TableActuator
extends AbstractActuator {
    public TableActuator(SourceFetcher sourceFetcher, EtlTransformer transformer, TargetImporter targetImporter) {
        super(sourceFetcher, transformer, targetImporter);
    }

    public void execute() {
        Map defValTransformMap = EtlGlobalCtx.INSTANCE.getDefaultValueTransformMap();
        String targetDatabase = MotionEtlGlobalCtx.getInstance().targetDatabase;
        boolean targetIsOracle = targetDatabase.equalsIgnoreCase(DataBaseTypeEnum.ORACLE.getName());
        while (MotionEtlGlobalCtx.getInstance().increaseSchema()) {
            MotionEtlGlobalCtx.getInstance().transferType(ObjectTypeEnum.TABLE.getName());
            List ddls = this.sourceFetcher.createTableDdl();
            for (KeyValuePair ddl : ddls) {
                String result = this.transformer.transformTableDdl(ddl.getValue());
                if (defValTransformMap.containsKey(ddl.getKey())) {
                    ColumnDataTransform columnDataTransform = (ColumnDataTransform)defValTransformMap.get(ddl.getKey());
                    result = result.replaceAll(Pattern.quote(columnDataTransform.getSrcColData()), columnDataTransform.getDestColData());
                }
                if (targetIsOracle) {
                    this.targetImporter.executes(ObjectTypeEnum.TABLE.getName(), ddl, Arrays.asList(result.split(";")));
                    continue;
                }
                this.targetImporter.execute(ObjectTypeEnum.TABLE.getName(), ddl, result);
            }
        }
        MotionEtlGlobalCtx.getInstance().resetSchemaIndex();
        this.targetImporter.waitCompletion();
    }
}

