/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.actuator;

import com.hundsun.lightdb.core.KeyValuePair;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.ObjectTypeEnum;
import com.hundsun.lightdb.core.actuator.AbstractActuator;
import com.hundsun.lightdb.core.source.SourceFetcher;
import com.hundsun.lightdb.core.target.TargetImporter;
import com.hundsun.lightdb.core.transformer.EtlTransformer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class TableCheckConActuator
extends AbstractActuator {
    public TableCheckConActuator(SourceFetcher sourceFetcher, EtlTransformer transformer, TargetImporter targetImporter) {
        super(sourceFetcher, transformer, targetImporter);
    }

    public void execute() {
        LinkedHashMap<String, List> checkConDdls = new LinkedHashMap<String, List>();
        while (MotionEtlGlobalCtx.getInstance().increaseSchema()) {
            String currentSchema = MotionEtlGlobalCtx.getInstance().currentSchema();
            MotionEtlGlobalCtx.getInstance().transferType(ObjectTypeEnum.CHECK_CONSTRAINTS.getName());
            List ddls = this.sourceFetcher.createCheckConstraints();
            String regex = "(?i)\\bCHECK\\b";
            for (KeyValuePair ddl : ddls) {
                if (!Pattern.compile(regex).matcher(ddl.getValue()).find()) continue;
                String result = this.transformer.transformCheckConstraintsDdl(ddl.getValue());
                String tableName = ddl.getKey();
                String ddlKey = currentSchema + "." + tableName;
                List ddlList = checkConDdls.computeIfAbsent(ddlKey, k -> new ArrayList());
                ddlList.add(result);
            }
        }
        for (Map.Entry entry : checkConDdls.entrySet()) {
            List ddlList = (List)entry.getValue();
            String ddlKey = (String)entry.getKey();
            this.targetImporter.executes(ObjectTypeEnum.CHECK_CONSTRAINTS.getName(), new KeyValuePair(ddlKey, ""), ddlList);
        }
        MotionEtlGlobalCtx.getInstance().resetSchemaIndex();
        this.targetImporter.waitCompletion();
    }
}

