/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.actuator;

import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.actuator.AbstractActuator;
import com.hundsun.lightdb.core.source.SourceFetcher;
import com.hundsun.lightdb.core.target.TargetImporter;
import com.hundsun.lightdb.core.transformer.EtlTransformer;
import com.hundsun.lightdb.utils.CommonUtils;
import com.hundsun.lightdb.utils.CompareTypeUtil;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableDataCompareActuator
extends AbstractActuator {
    private static final Logger log = LoggerFactory.getLogger(TableDataCompareActuator.class);

    public TableDataCompareActuator(SourceFetcher sourceFetcher, EtlTransformer transformer, TargetImporter targetImporter) {
        super(sourceFetcher, transformer, targetImporter);
    }

    public void execute() {
        StringBuffer resultPath = new StringBuffer();
        resultPath.append(String.format("%s/%s", CommonUtils.getLogPath(), "table_data_compare.info"));
        CommonUtils.createNewFile((String)resultPath.toString());
        while (MotionEtlGlobalCtx.getInstance().increaseSchema()) {
            CommonUtils.delCompareTmpFile();
            HashMap source = this.sourceFetcher.tableDataColumnInfo();
            HashMap target = this.targetImporter.tableDataColumnInfo();
            CompareTypeUtil.compareTableData((HashMap)source, (HashMap)target, (SourceFetcher)this.sourceFetcher, (TargetImporter)this.targetImporter, (EtlTransformer)this.transformer);
        }
        CompareTypeUtil.produceTableDataCompareHtml();
        MotionEtlGlobalCtx.getInstance().resetSchemaIndex();
    }
}

