/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.actuator;

import com.hundsun.lightdb.core.KeyValuePair;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.ObjectTypeEnum;
import com.hundsun.lightdb.core.actuator.AbstractActuator;
import com.hundsun.lightdb.core.source.SourceFetcher;
import com.hundsun.lightdb.core.target.TargetImporter;
import com.hundsun.lightdb.core.transformer.EtlTransformer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TableFkActuator
extends AbstractActuator {
    public TableFkActuator(SourceFetcher sourceFetcher, EtlTransformer transformer, TargetImporter targetImporter) {
        super(sourceFetcher, transformer, targetImporter);
    }

    public void execute() {
        LinkedHashMap<String, List> tableDDLs = new LinkedHashMap<String, List>();
        while (MotionEtlGlobalCtx.getInstance().increaseSchema()) {
            String currentSchema = MotionEtlGlobalCtx.getInstance().currentSchema();
            MotionEtlGlobalCtx.getInstance().transferType(ObjectTypeEnum.FOREIGN_KEY.getName());
            List ddls = this.sourceFetcher.createForeignKey();
            for (KeyValuePair ddl : ddls) {
                String result = this.transformer.transformForeignKeyDdl(ddl.getValue());
                String tableName = ddl.getKey();
                String ddlKey = currentSchema + "." + tableName;
                List ddlList = tableDDLs.computeIfAbsent(ddlKey, k -> new ArrayList());
                ddlList.add(result);
            }
        }
        for (Map.Entry entry : tableDDLs.entrySet()) {
            List ddlList = (List)entry.getValue();
            String ddlKey = (String)entry.getKey();
            this.targetImporter.executes(ObjectTypeEnum.FOREIGN_KEY.getName(), new KeyValuePair(ddlKey, ""), ddlList);
        }
        this.targetImporter.waitCompletion();
        MotionEtlGlobalCtx.getInstance().resetSchemaIndex();
    }
}

