/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.actuator;

import com.hundsun.lightdb.core.KeyValuePair;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.ObjectTypeEnum;
import com.hundsun.lightdb.core.actuator.AbstractActuator;
import com.hundsun.lightdb.core.source.SourceFetcher;
import com.hundsun.lightdb.core.target.TargetImporter;
import com.hundsun.lightdb.core.transformer.EtlTransformer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TablePkActuator
extends AbstractActuator {
    public TablePkActuator(SourceFetcher sourceFetcher, EtlTransformer transformer, TargetImporter targetImporter) {
        super(sourceFetcher, transformer, targetImporter);
    }

    public void execute() {
        LinkedHashMap<String, List> primaryKeyDDLs = new LinkedHashMap<String, List>();
        while (MotionEtlGlobalCtx.getInstance().increaseSchema()) {
            String currentSchema = MotionEtlGlobalCtx.getInstance().currentSchema();
            MotionEtlGlobalCtx.getInstance().transferType(ObjectTypeEnum.PRIMARY_KEY.getName());
            List ddls = this.sourceFetcher.createPrimaryKey();
            for (KeyValuePair ddl : ddls) {
                String result = this.transformer.transformPrimaryKeyDdl(ddl.getValue());
                String tableName = ddl.getKey();
                String ddlKey = currentSchema + "." + tableName;
                List ddlList = primaryKeyDDLs.computeIfAbsent(ddlKey, k -> new ArrayList());
                ddlList.add(result);
            }
        }
        for (Map.Entry entry : primaryKeyDDLs.entrySet()) {
            String ddlKey = (String)entry.getKey();
            List ddlList = (List)entry.getValue();
            this.targetImporter.executes(ObjectTypeEnum.PRIMARY_KEY.getName(), new KeyValuePair(ddlKey, ""), ddlList);
        }
        MotionEtlGlobalCtx.getInstance().resetSchemaIndex();
        this.targetImporter.waitCompletion();
    }
}

