/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.actuator;

import com.hundsun.lightdb.SqlLogger;
import com.hundsun.lightdb.core.KeyValuePair;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.ObjectTypeEnum;
import com.hundsun.lightdb.core.actuator.AbstractActuator;
import com.hundsun.lightdb.core.source.SourceFetcher;
import com.hundsun.lightdb.core.target.TargetImporter;
import com.hundsun.lightdb.core.transformer.EtlTransformer;
import com.hundsun.lightdb.utils.CommonUtils;
import com.hundsun.lightdb.utils.StrategyUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class TypeActuator
extends AbstractActuator {
    public TypeActuator(SourceFetcher sourceFetcher, EtlTransformer transformer, TargetImporter targetImporter) {
        super(sourceFetcher, transformer, targetImporter);
    }

    public void execute() {
        while (MotionEtlGlobalCtx.getInstance().increaseSchema()) {
            MotionEtlGlobalCtx.getInstance().transferType(ObjectTypeEnum.TYPE.getName());
            List ddls = this.sourceFetcher.createTypeDdl();
            for (KeyValuePair ddl : ddls) {
                SqlLogger.printSql((String)"source-sql", (String)ddl.getValue());
                ArrayList<String> sqls = new ArrayList<String>();
                String source = this.transformer.transformTypeDdl(ddl.getValue());
                String regex = MotionEtlGlobalCtx.getInstance().getGlobalConfig().getTypeRegex();
                int typeBody = -1;
                if (StringUtils.isBlank((CharSequence)regex)) {
                    String regex1 = "(?i)CREATE\\s*OR\\s*REPLACE\\s*TYPE\\s*BODY";
                    String regex2 = "(?i)CREATE\\s*TYPE\\s*BODY";
                    Pattern pattern = Pattern.compile(regex1);
                    Matcher matcher = pattern.matcher(source);
                    if (matcher.find()) {
                        typeBody = matcher.start();
                    } else {
                        Pattern pattern2 = Pattern.compile(regex2);
                        Matcher matcher2 = pattern2.matcher(source);
                        if (matcher.find()) {
                            typeBody = matcher2.start();
                        }
                    }
                } else {
                    Pattern pattern = Pattern.compile(regex);
                    Matcher matcher = pattern.matcher(source);
                    if (matcher.find()) {
                        typeBody = matcher.start();
                    }
                }
                if (typeBody <= 0) {
                    String result = "";
                    if (MotionEtlGlobalCtx.getInstance().getGlobalConfig().isRemoveDoubleQuote()) {
                        result = StrategyUtils.removeQuoteForDDL((String)source, (String)"TYPE", (String)"(IS|AS)");
                    }
                    sqls.add(CommonUtils.preClean((String)result));
                } else {
                    String typeStmt = source.substring(0, typeBody);
                    String bodyStmt = source.substring(typeBody, source.length());
                    if (MotionEtlGlobalCtx.getInstance().getGlobalConfig().isRemoveDoubleQuote()) {
                        typeStmt = StrategyUtils.removeQuoteForDDL((String)typeStmt, (String)"TYPE", (String)"(IS|AS)");
                        bodyStmt = StrategyUtils.removeQuoteForDDL((String)bodyStmt, (String)"TYPE", (String)"(IS|AS)");
                    }
                    sqls.add(CommonUtils.preClean((String)typeStmt));
                    sqls.add(CommonUtils.preClean((String)bodyStmt));
                }
                this.targetImporter.executes(ObjectTypeEnum.TYPE.getName(), ddl, sqls);
            }
        }
        MotionEtlGlobalCtx.getInstance().resetSchemaIndex();
        this.targetImporter.waitCompletion();
    }
}

