/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.actuator;

import com.hundsun.lightdb.SqlLogger;
import com.hundsun.lightdb.core.KeyValuePair;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.ObjectTypeEnum;
import com.hundsun.lightdb.core.actuator.AbstractActuator;
import com.hundsun.lightdb.core.source.SourceFetcher;
import com.hundsun.lightdb.core.strategy.CreateObjectContextStrategy;
import com.hundsun.lightdb.core.target.TargetImporter;
import com.hundsun.lightdb.core.transformer.EtlTransformer;
import java.util.List;

public class ViewActuator
extends AbstractActuator {
    public ViewActuator(SourceFetcher sourceFetcher, EtlTransformer transformer, TargetImporter targetImporter) {
        super(sourceFetcher, transformer, targetImporter);
    }

    public void execute() {
        while (MotionEtlGlobalCtx.getInstance().increaseSchema()) {
            MotionEtlGlobalCtx.getInstance().transferType(ObjectTypeEnum.VIEW.getName());
            List ddls = this.sourceFetcher.createViewDdl();
            CreateObjectContextStrategy contextStrategy = CreateObjectContextStrategy.getInstance();
            for (KeyValuePair ddl : ddls) {
                SqlLogger.printSql((String)"source-sql", (String)ddl.getValue());
                String result = this.transformer.transformViewDdl(ddl.getValue());
                this.targetImporter.execute(ObjectTypeEnum.VIEW.getName(), ddl, result);
            }
            this.targetImporter.waitCompletion();
        }
        MotionEtlGlobalCtx.getInstance().resetSchemaIndex();
    }
}

