/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.source;

import com.hundsun.lightdb.TableInfo;
import com.hundsun.lightdb.core.EtlConfig;
import com.hundsun.lightdb.core.EtlGlobalCtx;
import com.hundsun.lightdb.core.KeyValuePair;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.ObjectTypeEnum;
import com.hundsun.lightdb.core.source.SourceJdbcMeta;
import com.hundsun.lightdb.event.GlobalApplicationContext;
import com.hundsun.lightdb.event.TaskExcuteEvent;
import com.hundsun.lightdb.motion.enums.TaskResultEnum;
import com.hundsun.lightdb.utils.AesDecryptUtils;
import com.hundsun.lightdb.utils.JdbcUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Comparator;
import java.util.TreeMap;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;

public abstract class AbstractSourceJdbcMeta
implements SourceJdbcMeta {
    private static final Logger log = LoggerFactory.getLogger(AbstractSourceJdbcMeta.class);
    public EtlConfig.DbConfig dbConfig;
    static ThreadLocal<Connection> connectionHolder = new ThreadLocal();

    public AbstractSourceJdbcMeta(EtlConfig.DbConfig dbConfig) {
        this.dbConfig = dbConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection openConnection() {
        Connection connection = (Connection)connectionHolder.get();
        if (connection == null || connection.isClosed()) {
            AbstractSourceJdbcMeta abstractSourceJdbcMeta = this;
            synchronized (abstractSourceJdbcMeta) {
                Connection newConnection;
                connection = newConnection = this.getConnection(this.dbConfig);
                connectionHolder.set(connection);
                MotionEtlGlobalCtx.getInstance().queueConnection(connection);
            }
        }
        return connection;
    }

    public Connection getConnection(EtlConfig.DbConfig dbConfig) {
        Connection newConnection = null;
        try {
            boolean pwdEncrypted = MotionEtlGlobalCtx.getInstance().getGlobalConfig().isPwdEncrypted();
            newConnection = DriverManager.getConnection(dbConfig.getUrl(), dbConfig.getUsername(), pwdEncrypted ? AesDecryptUtils.decryptStringWithInputKey((String)dbConfig.getPassword(), (String)System.getProperty("EncryptKey")) : dbConfig.getPassword());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return newConnection;
    }

    public void executeSql(String sql) {
        JdbcUtils.executeSql((Connection)this.openConnection(), (String)sql);
    }

    public EtlConfig.DbConfig getDbConfig() {
        return this.dbConfig;
    }

    public TreeMap<Integer, Integer> getFileBatch(TableInfo tableInfo) {
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>(Comparator.reverseOrder());
        int batchSize = MotionEtlGlobalCtx.getInstance().batchCount();
        String sql = tableInfo.formatSelectMaxRownum();
        try {
            JdbcUtils.doQuery((Connection)this.openConnection(), (String)sql, sourceResult -> {
                try {
                    if (sourceResult.next()) {
                        int batchNum = 1;
                        int maxRownum = sourceResult.getInt("MAXROWNUM");
                        if (maxRownum != 0) {
                            if (maxRownum >= batchSize) {
                                int n = batchNum = maxRownum % batchSize == 0 ? maxRownum / batchSize : maxRownum / batchSize + 1;
                            }
                            if (log.isInfoEnabled()) {
                                log.info("maxRownum is :{} batchNum is :{} batchSize is {}", new Object[]{maxRownum, batchNum, batchSize});
                            }
                            if (batchNum == 1) {
                                treeMap.put(0, maxRownum);
                            } else {
                                for (int i = 0; i < batchNum; ++i) {
                                    int from = 0;
                                    int to = 0;
                                    if (i == 0) {
                                        from = i;
                                        to = batchSize;
                                    } else {
                                        from = i * batchSize;
                                        to = (i + 1) * batchSize;
                                    }
                                    treeMap.put(from, to);
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    EtlGlobalCtx.INSTANCE.handleException(String.format("error getBatch doQuery for table %s", tableInfo.getTableName()), (Throwable)e);
                }
                return 1;
            });
        }
        catch (RuntimeException e) {
            EtlGlobalCtx.INSTANCE.handleException(String.format("error getBatch for table %s", tableInfo.getTableName()), (Throwable)e);
            KeyValuePair keyValuePair = new KeyValuePair(TaskResultEnum.TASK_FAIL.getStatus(), e.getMessage());
            GlobalApplicationContext.context.publishEvent((ApplicationEvent)new TaskExcuteEvent((Object)this, MotionEtlGlobalCtx.getInstance().motionParameters, ObjectTypeEnum.TABLEDATA.getName(), tableInfo.getTableName(), sql, sql, keyValuePair));
        }
        return treeMap;
    }

    public Pair<Integer, TreeMap<Integer, Integer>> getDataBatch(TableInfo tableInfo) {
        TreeMap treeMap = new TreeMap(Comparator.reverseOrder());
        int[] batchSize = new int[]{MotionEtlGlobalCtx.getInstance().batchCount()};
        int limitPageSize = 200000 > batchSize[0] ? batchSize[0] : 200000;
        String sql = tableInfo.formatSelectMaxRownum();
        try {
            JdbcUtils.doQuery((Connection)this.openConnection(), (String)sql, sourceResult -> {
                try {
                    if (sourceResult.next()) {
                        int batchNum = 1;
                        int sizeBatchNum = 1;
                        int pageSizeBatchNum = 1;
                        int maxRownum = sourceResult.getInt("MAXROWNUM");
                        if (maxRownum == 0) {
                            KeyValuePair keyValuePair = new KeyValuePair(TaskResultEnum.TASK_SUCCESS.getStatus(), String.format("\u8868:%s \u8fc1\u79fb\u6570\u636e0\u6761", tableInfo.getTableName()));
                            this.publishEvent(tableInfo.getTableName(), sql, keyValuePair);
                        } else {
                            if (maxRownum > limitPageSize) {
                                pageSizeBatchNum = maxRownum % limitPageSize == 0 ? maxRownum / limitPageSize : maxRownum / limitPageSize + 1;
                            }
                            batchNum = sizeBatchNum > pageSizeBatchNum ? sizeBatchNum : pageSizeBatchNum;
                            int n = batchSize[0] = maxRownum % batchNum == 0 ? maxRownum / batchNum : maxRownum / batchNum + 1;
                            if (log.isInfoEnabled()) {
                                log.info(" maxRownum is :{} batchNum is :{} batchSize is {}", new Object[]{maxRownum, batchNum, batchSize[0]});
                            }
                            if (batchNum == 1) {
                                treeMap.put(0, maxRownum);
                            } else {
                                for (int i = 0; i < batchNum; ++i) {
                                    int from = 0;
                                    int to = 0;
                                    if (i == 0) {
                                        from = i;
                                        to = batchSize[0];
                                    } else {
                                        from = i * batchSize[0];
                                        to = (i + 1) * batchSize[0];
                                    }
                                    treeMap.put(from, to);
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    EtlGlobalCtx.INSTANCE.handleException(String.format("error getBatch doQuery for table %s", tableInfo.getTableName()), (Throwable)e);
                }
                return 1;
            });
        }
        catch (RuntimeException e) {
            EtlGlobalCtx.INSTANCE.handleException(String.format("error getBatch for table %s", tableInfo.getTableName()), (Throwable)e);
            KeyValuePair keyValuePair = new KeyValuePair(TaskResultEnum.TASK_FAIL.getStatus(), e.getMessage());
            this.publishEvent(tableInfo.getTableName(), sql, keyValuePair);
        }
        return Pair.of((Object)batchSize[0], treeMap);
    }

    protected void publishEvent(String tableName, String sql, KeyValuePair keyValuePair) {
        block2: {
            try {
                GlobalApplicationContext.context.publishEvent((ApplicationEvent)new TaskExcuteEvent((Object)this, MotionEtlGlobalCtx.getInstance().motionParameters, ObjectTypeEnum.TABLEDATA.getName(), tableName, sql, sql, keyValuePair));
            }
            catch (Exception e) {
                if (!log.isInfoEnabled()) break block2;
                log.info("AbstractSourceJdbcMeta publishEvent info:{}", (Object)e.toString());
            }
        }
    }

    public static void releaseConnection() {
        Connection conn = (Connection)connectionHolder.get();
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Exception e) {
                log.error("\u5173\u95ed\u8fde\u63a5\u5f02\u5e38", (Throwable)e);
            }
            finally {
                connectionHolder.remove();
            }
        }
    }
}

