/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.source.goldenmysql;

import com.hundsun.lightdb.TableInfo;
import com.hundsun.lightdb.core.EtlConfig;
import com.hundsun.lightdb.core.source.AbstractSourceJdbcMeta;
import com.hundsun.lightdb.utils.CommonUtils;
import java.sql.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"etl.global.sourceDatabase"}, havingValue="golden-mysql")
public class GoldenMysqlSourceJdbcMeta
extends AbstractSourceJdbcMeta {
    private static final Logger log = LoggerFactory.getLogger(GoldenMysqlSourceJdbcMeta.class);

    @Autowired
    public GoldenMysqlSourceJdbcMeta(@Qualifier(value="source") EtlConfig.DbConfig dbConfig) {
        super(dbConfig);
    }

    public Connection getConnection(EtlConfig.DbConfig dbConfig) {
        String driverClassName = "com.mysql.cj.jdbc.Driver";
        String regex = "^mysql-connector-j.*\\.jar$";
        return CommonUtils.getConnectionByDbConfig((EtlConfig.DbConfig)dbConfig, (String)driverClassName, (String)regex, this.getClass());
    }

    public String formatSelect(TableInfo tableInfo, int from, int to) {
        return tableInfo.formatMysqlSelect(from, to);
    }
}

