/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.source.lightdb;

import com.hundsun.lightdb.core.EtlConfig;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.source.AbstractSourceJdbcMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"etl.global.sourceDatabase"}, havingValue="lightdb")
public class LightdbSourceJdbcMeta
extends AbstractSourceJdbcMeta {
    private static final Logger log = LoggerFactory.getLogger(LightdbSourceJdbcMeta.class);
    @Value(value="${etl.internal.driver-names.lightdb:classpath:drivers/ltjdbc.jar}")
    private String driverJarName;

    @Autowired
    public LightdbSourceJdbcMeta(@Qualifier(value="source") EtlConfig.DbConfig dbConfig) {
        super(dbConfig);
    }

    public String createColumnDdl() {
        return String.format("select table_name,column_name,udt_name,\n                        numeric_precision, numeric_scale,character_maximum_length,datetime_precision\n                        from information_schema.columns\n                        where table_schema = lower('%s') and is_identity = 'NO' \n                        and table_name not like 'BIN$%%$0'\n                        and (table_schema,table_name) in \n(\nSELECT  \nn.nspname,\nc.relname as tablename\nFROM pg_catalog.pg_class c \nLEFT JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace \nWHERE c.relkind IN ('r','p')\nAND n.nspname  = lower('%s') \nAND c.relispartition='f' \nAND c.relname not like 'BIN$%%$0'\n)", MotionEtlGlobalCtx.getInstance().currentSchema(), MotionEtlGlobalCtx.getInstance().currentSchema()) + MotionEtlGlobalCtx.getInstance().filterPgTable("table_name");
    }
}

