/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.source.mysql;

import com.hundsun.lightdb.TableInfo;
import com.hundsun.lightdb.core.KeyValuePair;
import com.hundsun.lightdb.core.source.AbstractSourceFetcher;
import com.hundsun.lightdb.core.source.SourceJdbcMeta;
import com.hundsun.lightdb.motion.enums.MysqlTypeEnum;
import com.hundsun.lightdb.utils.JdbcUtils;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"etl.global.sourceDatabase"}, havingValue="mysql")
public class MysqlSourceFetcher
extends AbstractSourceFetcher {
    private static final Logger log = LoggerFactory.getLogger(MysqlSourceFetcher.class);

    @Autowired
    public MysqlSourceFetcher(SourceJdbcMeta sourceJdbcMeta) {
        super(sourceJdbcMeta);
    }

    public List<KeyValuePair> createTableDdl() {
        ArrayList<KeyValuePair> pairs = new ArrayList();
        String sqlRelation = this.sourceJdbcMeta.createTableDdl();
        log.debug("\u83b7\u53d6\u5efa\u8868\u8bed\u53e5\uff1a{}", (Object)sqlRelation);
        int indexDdl = 2;
        pairs = JdbcUtils.fetchMysqlDdl((Connection)this.sourceJdbcMeta.openConnection(), (String)sqlRelation, (MysqlTypeEnum)MysqlTypeEnum.TABLE);
        return pairs;
    }

    public List<KeyValuePair> createIndexDdl() {
        String ddl = this.sourceJdbcMeta.createIndexDdl();
        return JdbcUtils.fetchDdl((Connection)this.sourceJdbcMeta.openConnection(), (String)ddl);
    }

    public List<KeyValuePair> createForeignKey() {
        String ddl = this.sourceJdbcMeta.createForeignKey();
        return JdbcUtils.fetchDdl((Connection)this.sourceJdbcMeta.openConnection(), (String)ddl);
    }

    public List<KeyValuePair> createPrimaryKey() {
        String ddl = this.sourceJdbcMeta.createPrimaryKey();
        return JdbcUtils.fetchDdl((Connection)this.sourceJdbcMeta.openConnection(), (String)ddl);
    }

    public List<KeyValuePair> createCheckConstraints() {
        String ddl = this.sourceJdbcMeta.createCheckConstraints();
        return JdbcUtils.fetchDdl((Connection)this.sourceJdbcMeta.openConnection(), (String)ddl);
    }

    public List<KeyValuePair> createViewDdl() {
        ArrayList<KeyValuePair> pairs = new ArrayList();
        String sqlRelation = this.sourceJdbcMeta.createViewDdl();
        pairs = JdbcUtils.fetchMysqlDdl((Connection)this.sourceJdbcMeta.openConnection(), (String)sqlRelation, (MysqlTypeEnum)MysqlTypeEnum.VIEW);
        return pairs;
    }

    public HashMap<String, HashMap<String, String>> columnInfo() {
        String ddl = this.sourceJdbcMeta.createColumnDdl();
        return JdbcUtils.fetchColumnInfo((Connection)this.sourceJdbcMeta.openConnection(), (String)ddl);
    }

    public Map<String, HashMap<String, String>> countType() {
        return this.sourceJdbcMeta.countType();
    }

    public HashMap<String, TableInfo> tableDataColumnInfo() {
        String ddl = this.sourceJdbcMeta.createTableDataColumnInfo();
        return JdbcUtils.fetchTableColumnInfo((Connection)this.sourceJdbcMeta.openConnection(), (String)ddl);
    }
}

