/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.source.oracle;

import com.hundsun.lightdb.TableInfo;
import com.hundsun.lightdb.core.KeyValuePair;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.RowValue;
import com.hundsun.lightdb.core.source.AbstractSourceFetcher;
import com.hundsun.lightdb.core.source.SourceJdbcMeta;
import com.hundsun.lightdb.unisql.proxy.jdbc.DbType;
import com.hundsun.lightdb.utils.JdbcUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"etl.global.sourceDatabase"}, havingValue="oracle")
public class OracleSourceFetcher
extends AbstractSourceFetcher {
    private static final Logger log = LoggerFactory.getLogger(OracleSourceFetcher.class);
    static HashMap<String, String> typeMapping = new HashMap(16);
    Map<String, TableInfo> tableInfos;

    @Autowired
    public OracleSourceFetcher(SourceJdbcMeta sourceJdbcMeta) {
        super(sourceJdbcMeta);
    }

    public void init() {
        List procedureNames = this.sourceJdbcMeta.fetchProcedureNames();
        MotionEtlGlobalCtx.getInstance().initProcedureNames(procedureNames);
    }

    public List<KeyValuePair> createTableDdl() {
        List<KeyValuePair> pairs = new ArrayList();
        String targetDatabaseName = MotionEtlGlobalCtx.getInstance().getGlobalConfig().getTargetDatabase().toUpperCase();
        if (targetDatabaseName.equals(DbType.DM.name()) || targetDatabaseName.equals(DbType.OCEAN_BASE_ORACLE.name())) {
            String transformParamSql = this.sourceJdbcMeta.getTransformParam();
            JdbcUtils.executeSql((Connection)this.sourceJdbcMeta.openConnection(), (String)transformParamSql);
            String ddl = this.sourceJdbcMeta.createTableDdl();
            pairs = JdbcUtils.fetchDdl((Connection)this.sourceJdbcMeta.openConnection(), (String)ddl);
            ddl = this.sourceJdbcMeta.createPartitionedTableDdl();
            pairs.addAll(JdbcUtils.fetchDdl((Connection)this.sourceJdbcMeta.openConnection(), (String)ddl));
        } else {
            String ddl = this.sourceJdbcMeta.createTableDdl();
            pairs = JdbcUtils.fetchDdl((Connection)this.sourceJdbcMeta.openConnection(), (String)ddl);
            String transformParamSql = this.sourceJdbcMeta.getTransformParam();
            JdbcUtils.executeSql((Connection)this.sourceJdbcMeta.openConnection(), (String)transformParamSql);
            ddl = this.sourceJdbcMeta.createPartitionedTableDdl();
            pairs.addAll(JdbcUtils.fetchDdl((Connection)this.sourceJdbcMeta.openConnection(), (String)ddl));
        }
        return pairs;
    }

    public List<KeyValuePair> createForeignKey() {
        if (MotionEtlGlobalCtx.getInstance().getGlobalConfig().getTargetDatabase().equalsIgnoreCase(DbType.DM.name())) {
            String transformParamSql = this.sourceJdbcMeta.getTransformParam();
            JdbcUtils.executeSql((Connection)this.sourceJdbcMeta.openConnection(), (String)transformParamSql);
        }
        String ddl = this.sourceJdbcMeta.createForeignKey();
        return JdbcUtils.fetchDdl((Connection)this.sourceJdbcMeta.openConnection(), (String)ddl);
    }

    public List<KeyValuePair> createSynonym() {
        String ddl = this.sourceJdbcMeta.createSynonym();
        return JdbcUtils.fetchDdl((Connection)this.sourceJdbcMeta.openConnection(), (String)ddl);
    }

    public List<KeyValuePair> createPrimaryKey() {
        if (MotionEtlGlobalCtx.getInstance().getGlobalConfig().getTargetDatabase().equalsIgnoreCase(DbType.DM.name())) {
            String transformParamSql = this.sourceJdbcMeta.getTransformParam();
            JdbcUtils.executeSql((Connection)this.sourceJdbcMeta.openConnection(), (String)transformParamSql);
        }
        String ddl = this.sourceJdbcMeta.createPrimaryKey();
        return JdbcUtils.fetchDdl((Connection)this.sourceJdbcMeta.openConnection(), (String)ddl);
    }

    public List<KeyValuePair> createCheckConstraints() {
        if (MotionEtlGlobalCtx.getInstance().getGlobalConfig().getTargetDatabase().equalsIgnoreCase(DbType.DM.name())) {
            String transformParamSql = this.sourceJdbcMeta.getTransformParam();
            JdbcUtils.executeSql((Connection)this.sourceJdbcMeta.openConnection(), (String)transformParamSql);
        }
        String ddl = this.sourceJdbcMeta.createCheckConstraints();
        return JdbcUtils.fetchDdl((Connection)this.sourceJdbcMeta.openConnection(), (String)ddl);
    }

    public Set<String> createKeywordsTableName() {
        return this.sourceJdbcMeta.createKeywordsTableName();
    }

    public HashMap<KeyValuePair, String> createDataDdl(HashMap<String, KeyValuePair> tables) {
        return this.sourceJdbcMeta.createDataDdl(tables);
    }

    public HashMap<String, KeyValuePair> createDataColumn() {
        return this.sourceJdbcMeta.createDataColumn();
    }

    public List<KeyValuePair> createIndexDdl() {
        if (MotionEtlGlobalCtx.getInstance().getGlobalConfig().getTargetDatabase().equalsIgnoreCase(DbType.DM.name())) {
            String transformParamSql = this.sourceJdbcMeta.getTransformParam();
            JdbcUtils.executeSql((Connection)this.sourceJdbcMeta.openConnection(), (String)transformParamSql);
        }
        String ddl = this.sourceJdbcMeta.createIndexDdl();
        return JdbcUtils.fetchDdl((Connection)this.sourceJdbcMeta.openConnection(), (String)ddl);
    }

    public List<KeyValuePair> createSequenceDdl() {
        String ddl = this.sourceJdbcMeta.createSequenceDdl();
        return JdbcUtils.fetchDdl((Connection)this.sourceJdbcMeta.openConnection(), (String)ddl);
    }

    public List<KeyValuePair> createViewDdl() {
        String ddl = this.sourceJdbcMeta.createViewDdl();
        return JdbcUtils.fetchDdl((Connection)this.sourceJdbcMeta.openConnection(), (String)ddl);
    }

    public List<KeyValuePair> createPackageDdl() {
        String ddl = this.sourceJdbcMeta.createPackageDdl();
        return JdbcUtils.fetchDdl((Connection)this.sourceJdbcMeta.openConnection(), (String)ddl);
    }

    public List<KeyValuePair> createTypeDdl() {
        String ddl = this.sourceJdbcMeta.createTypeDdl();
        return JdbcUtils.fetchDdl((Connection)this.sourceJdbcMeta.openConnection(), (String)ddl);
    }

    public List<KeyValuePair> createProcedureDdl() {
        String ddl = this.sourceJdbcMeta.createProcedureDdl();
        List ddls = JdbcUtils.fetchDdl((Connection)this.sourceJdbcMeta.openConnection(), (String)ddl);
        return this.filterWrapped(ddls);
    }

    public void compileProcedureInvalidDdl() {
        ArrayList compileSql = (ArrayList)JdbcUtils.doQuery((Connection)this.sourceJdbcMeta.openConnection(), (String)this.sourceJdbcMeta.compileProcedureInvalidDdl(), resultSet -> {
            ArrayList<String> result = new ArrayList<String>(8);
            try {
                while (resultSet.next()) {
                    result.add(resultSet.getString(1));
                }
                return result;
            }
            catch (SQLException e) {
                return new ArrayList(8);
            }
        });
        if (compileSql.isEmpty()) {
            return;
        }
        for (String sql : compileSql) {
            JdbcUtils.executeSql((Connection)this.sourceJdbcMeta.openConnection(), (String)sql);
        }
    }

    private List<KeyValuePair> filterWrapped(List<KeyValuePair> ddls) {
        return ddls.stream().filter(pair -> {
            String procedure;
            String prefix = procedure.substring(0, (procedure = pair.getValue()).length() > 100 ? 100 : procedure.length()).toLowerCase();
            return !prefix.contains(" wrapped");
        }).collect(Collectors.toList());
    }

    public List<KeyValuePair> createFunctionDdl() {
        String ddl = this.sourceJdbcMeta.createFunctionDdl();
        List ddls = JdbcUtils.fetchDdl((Connection)this.sourceJdbcMeta.openConnection(), (String)ddl);
        return this.filterWrapped(ddls);
    }

    public List<KeyValuePair> createTriggerDdl() {
        String ddl = this.sourceJdbcMeta.createTriggerDdl();
        return JdbcUtils.fetchDdl((Connection)this.sourceJdbcMeta.openConnection(), (String)ddl);
    }

    public Map<String, HashMap<String, String>> countType() {
        return this.sourceJdbcMeta.countType();
    }

    public HashMap<String, HashMap<String, String>> columnInfo() {
        String ddl = this.sourceJdbcMeta.createColumnDdl();
        return JdbcUtils.fetchColumnInfo((Connection)this.sourceJdbcMeta.openConnection(), (String)ddl);
    }

    public Set<String> keywordsTableName() {
        return this.createKeywordsTableName();
    }

    public HashMap<KeyValuePair, String> dataInfo(HashMap<String, KeyValuePair> tables) {
        return this.createDataDdl(tables);
    }

    public List<RowValue> fetchCompareData(TableInfo tableInfo) {
        return this.sourceJdbcMeta.fetchRandomData(tableInfo);
    }

    public Map<String, Map<String, List<String>>> uniqueIndexesOfTable() {
        return this.sourceJdbcMeta.uniqueIndexesOfTable();
    }

    public void saveFkFileWithDelete() {
        this.sourceJdbcMeta.saveForeignKeyFile();
    }

    public List<String> getCreateFkSqlList() {
        return MotionEtlGlobalCtx.getInstance().getFkSqls();
    }

    public void restoreFk() {
        this.getCreateFkSqlList().forEach(v -> this.sourceJdbcMeta.executeSql(v));
    }

    public HashMap<String, TableInfo> tableDataColumnInfo() {
        String ddl = this.sourceJdbcMeta.createTableDataColumnInfo();
        return JdbcUtils.fetchTableColumnInfo((Connection)this.sourceJdbcMeta.openConnection(), (String)ddl);
    }

    static {
        typeMapping.put("decimal", "numeric");
        typeMapping.put("timestamp", "timestamp without time zone");
    }
}

