/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.source.oracle;

import com.google.common.base.Joiner;
import com.hundsun.lightdb.TableInfo;
import com.hundsun.lightdb.core.EtlConfig;
import com.hundsun.lightdb.core.EtlGlobalCtx;
import com.hundsun.lightdb.core.IndexInfo;
import com.hundsun.lightdb.core.KeyValuePair;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.RowValue;
import com.hundsun.lightdb.core.source.AbstractSourceJdbcMeta;
import com.hundsun.lightdb.motion.enums.CompareTypeEnum;
import com.hundsun.lightdb.unisql.proxy.jdbc.DbType;
import com.hundsun.lightdb.utils.AesDecryptUtils;
import com.hundsun.lightdb.utils.JdbcUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"etl.global.sourceDatabase"}, havingValue="oracle")
public class OracleSourceJdbcMeta
extends AbstractSourceJdbcMeta {
    private static final Logger log = LoggerFactory.getLogger(OracleSourceJdbcMeta.class);
    static final String JDBC_DRIVER = "oracle.jdbc.driver.OracleDriver";

    @Autowired
    public OracleSourceJdbcMeta(@Qualifier(value="source") EtlConfig.DbConfig dbConfig) {
        super(dbConfig);
    }

    public Connection getConnection(EtlConfig.DbConfig dbConfig) {
        Connection newConnection = null;
        try {
            Class.forName(JDBC_DRIVER);
            boolean pwdEncrypted = MotionEtlGlobalCtx.getInstance().getGlobalConfig().isPwdEncrypted();
            newConnection = DriverManager.getConnection(dbConfig.getUrl(), dbConfig.getUsername(), pwdEncrypted ? AesDecryptUtils.decryptStringWithInputKey((String)dbConfig.getPassword(), (String)System.getProperty("EncryptKey")) : dbConfig.getPassword());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return newConnection;
    }

    public Map<String, TableInfo> compareColumnsOfTable() {
        Map indexesMap = this.allIndexes();
        HashMap<String, TableInfo> tableInfoMap = new HashMap<String, TableInfo>(32);
        for (Map.Entry entry : indexesMap.entrySet()) {
            IndexInfo unique = null;
            IndexInfo nonUnique = null;
            for (Map.Entry infoEntry : ((Map)entry.getValue()).entrySet()) {
                IndexInfo indexInfo = (IndexInfo)infoEntry.getValue();
                if (indexInfo.isUnique() && unique == null) {
                    unique = indexInfo;
                    continue;
                }
                if (indexInfo.isUnique() || nonUnique != null) continue;
                nonUnique = indexInfo;
            }
            tableInfoMap.put((String)entry.getKey(), TableInfo.from(unique != null ? unique : nonUnique));
        }
        return tableInfoMap;
    }

    private Map<String, Map<String, IndexInfo>> allIndexes() {
        String sqlIndex = String.format("SELECT a.table_name,\n        a.index_name,\n        b.column_name,\n        a.UNIQUENESS\n FROM all_indexes a\n          JOIN all_ind_columns b ON a.index_name = b.index_name\n WHERE a.table_owner = upper('%s')\n", MotionEtlGlobalCtx.getInstance().currentSchema()) + MotionEtlGlobalCtx.getInstance().filterTable("a.table_name");
        Map indexesMap = (Map)JdbcUtils.doQuery((Connection)this.openConnection(), (String)sqlIndex, resultSet -> {
            HashMap<String, Map> uniqueIndex = new HashMap<String, Map>(32);
            try {
                while (resultSet.next()) {
                    String tableName = resultSet.getString(1);
                    String indexName = resultSet.getString(2);
                    String columnName = resultSet.getString(3);
                    String unique = resultSet.getString(4);
                    Map indexMap = uniqueIndex.computeIfAbsent(tableName.toLowerCase(), key -> new HashMap(16));
                    IndexInfo indexInfo = indexMap.computeIfAbsent(indexName, key -> new IndexInfo());
                    indexInfo.setTableName(tableName.toLowerCase());
                    indexInfo.setSchema(MotionEtlGlobalCtx.getInstance().currentSchema());
                    indexInfo.setUnique(unique);
                    indexInfo.setIndex(indexName);
                    indexInfo.addColumn(columnName.toLowerCase());
                }
                return uniqueIndex;
            }
            catch (SQLException e) {
                EtlGlobalCtx.INSTANCE.handleException(sqlIndex, (Throwable)e);
                return Collections.emptyMap();
            }
        });
        return indexesMap;
    }

    public String createTableDdl() {
        return "SELECT   a.OBJECT_NAME, dbms_metadata.get_ddl('TABLE', a.object_name, a.owner) AS object_ddl \n                 FROM dba_objects a,dba_tables b\n                 WHERE a.object_type = 'TABLE' and a.STATUS = 'VALID' \n                 and a.owner=b.owner and a.OBJECT_NAME=b.table_name\n                 and b.partitioned!='YES' " + String.format(" and a.owner = upper('%s') AND b.NESTED = 'NO'", MotionEtlGlobalCtx.getInstance().currentSchema()) + MotionEtlGlobalCtx.getInstance().filterTable("a.OBJECT_NAME") + MotionEtlGlobalCtx.getInstance().tempTableCondition();
    }

    public String createForeignKey() {
        return String.format(" SELECT ac2.TABLE_NAME,                                 DBMS_METADATA.get_ddl ('REF_CONSTRAINT', ac1.constraint_name, ac1.owner)\nFROM   all_constraints ac1\n       JOIN all_constraints ac2 ON ac1.r_owner = ac2.owner AND ac1.r_constraint_name = ac2.constraint_name\nWHERE   ac1.constraint_type = 'R'\n and ac2.owner = UPPER('%s') \n %s order by ac2.TABLE_NAME", MotionEtlGlobalCtx.getInstance().currentSchema(), MotionEtlGlobalCtx.getInstance().filterTable("ac2.TABLE_NAME"));
    }

    public String createSynonym() {
        return String.format(" SELECT as1.synonym_name,  DBMS_METADATA.GET_DDL('SYNONYM', as1.synonym_name, as1.OWNER)\nFROM all_synonyms  as1\nWHERE as1.OWNER = UPPER('%s')  \n %s", MotionEtlGlobalCtx.getInstance().currentSchema(), MotionEtlGlobalCtx.getInstance().filterTable("as1.TABLE_NAME"));
    }

    public String createPrimaryKey() {
        return String.format(" SELECT ac1.TABLE_NAME,                                 DBMS_METADATA.get_ddl ('CONSTRAINT', ac1.constraint_name, ac1.owner)\nFROM   all_constraints ac1\nWHERE   ac1.constraint_type = 'P'\n and ac1.owner = UPPER('%s') \n AND ac1.TABLE_NAME NOT IN (SELECT object_name FROM DBA_RECYCLEBIN WHERE TYPE LIKE 'TABLE%%')\n %s order by ac1.TABLE_NAME", MotionEtlGlobalCtx.getInstance().currentSchema(), MotionEtlGlobalCtx.getInstance().filterTable("ac1.TABLE_NAME"));
    }

    public String createCheckConstraints() {
        return String.format(" SELECT ac1.TABLE_NAME,                                 DBMS_METADATA.get_ddl ('CONSTRAINT', ac1.constraint_name, ac1.owner)\nFROM   all_constraints ac1\nWHERE   ac1.constraint_type = 'C'\n and ac1.owner = UPPER('%s') \nand  ac1.TABLE_NAME NOT IN (SELECT object_name FROM DBA_RECYCLEBIN WHERE TYPE LIKE 'TABLE%%')\n %s order by ac1.TABLE_NAME\n", MotionEtlGlobalCtx.getInstance().currentSchema(), MotionEtlGlobalCtx.getInstance().filterTable("ac1.TABLE_NAME"));
    }

    public String getTransformParam() {
        String targetDatabaseName = MotionEtlGlobalCtx.getInstance().getGlobalConfig().getTargetDatabase().toUpperCase();
        if (targetDatabaseName.equals(DbType.DM.name()) || targetDatabaseName.equals(DbType.OCEAN_BASE_ORACLE.name())) {
            return "BEGIN\n  DBMS_METADATA.SET_TRANSFORM_PARAM(DBMS_METADATA.SESSION_TRANSFORM, 'DEFAULT');\n  DBMS_METADATA.SET_TRANSFORM_PARAM(DBMS_METADATA.SESSION_TRANSFORM, 'SQLTERMINATOR', TRUE);\n  DBMS_METADATA.SET_TRANSFORM_PARAM(DBMS_METADATA.SESSION_TRANSFORM, 'SEGMENT_ATTRIBUTES', FALSE);\nDBMS_METADATA.SET_TRANSFORM_PARAM(DBMS_METADATA.SESSION_TRANSFORM, 'CONSTRAINTS_AS_ALTER', TRUE); \nEND;\n";
        }
        return "BEGIN DBMS_METADATA.SET_TRANSFORM_PARAM(DBMS_METADATA.SESSION_TRANSFORM, 'CONSTRAINTS_AS_ALTER', true); END;";
    }

    public String createPartitionedTableDdl() {
        return "SELECT   a.OBJECT_NAME, dbms_metadata.get_ddl('TABLE', a.object_name, a.owner) AS object_ddl \n                 FROM dba_objects a,dba_tables b\n                 WHERE a.object_type = 'TABLE' and a.STATUS = 'VALID' \n                 and a.owner=b.owner and a.OBJECT_NAME=b.table_name\n                 and b.partitioned='YES' " + String.format(" and a.owner = upper('%s') AND b.NESTED = 'NO' ", MotionEtlGlobalCtx.getInstance().currentSchema()) + MotionEtlGlobalCtx.getInstance().filterTable("a.OBJECT_NAME") + MotionEtlGlobalCtx.getInstance().tempTableCondition();
    }

    public String createColumnDdl() {
        return "SELECT\n  a.TABLE_NAME, a.COLUMN_NAME, a.DATA_TYPE, a.DATA_PRECISION, a.DATA_SCALE,NULLIF(a.char_length,0),a.DATA_LENGTH \nFROM all_tab_columns a, dba_tables t \n" + String.format("WHERE  t.owner = a.owner AND a.TABLE_NAME = t.TABLE_NAME AND a.owner = upper('%s') ", MotionEtlGlobalCtx.getInstance().currentSchema()) + MotionEtlGlobalCtx.getInstance().filterTable("a.TABLE_NAME");
    }

    public Set<String> createKeywordsTableName() {
        String sql = "SELECT\n  a.TABLE_NAME, a.COLUMN_NAME \nFROM all_tab_columns a, dba_tables t \n" + String.format("WHERE  t.owner = a.owner AND a.TABLE_NAME = t.TABLE_NAME AND a.owner = upper('%s') ", MotionEtlGlobalCtx.getInstance().currentSchema()) + MotionEtlGlobalCtx.getInstance().filterTable("a.TABLE_NAME");
        String keywords = MotionEtlGlobalCtx.getInstance().getGlobalConfig().getKeywords();
        if (StringUtils.isBlank((CharSequence)keywords)) {
            return new HashSet<String>();
        }
        return (Set)JdbcUtils.doQuery((Connection)this.openConnection(), (String)sql, resultSet -> {
            HashSet<String> tableNames = new HashSet<String>();
            try {
                while (resultSet.next()) {
                    String tableName = resultSet.getString(1);
                    String column = resultSet.getString(2);
                    if (!MotionEtlGlobalCtx.getInstance().iskeyWord(column)) continue;
                    tableNames.add(tableName);
                }
                return tableNames;
            }
            catch (SQLException e) {
                EtlGlobalCtx.INSTANCE.handleException(sql, (Throwable)e);
                HashSet emput = new HashSet(16);
                return emput;
            }
        });
    }

    public HashMap<String, KeyValuePair> createDataColumn() {
        String defaultType = "xmltype,blob,nclob,clob,long raw";
        Set type = Arrays.stream(defaultType.split(",")).collect(Collectors.toSet());
        String by = "by";
        ArrayList<String> keywords = new ArrayList<String>();
        keywords.add(by);
        if (!StringUtils.isBlank((CharSequence)MotionEtlGlobalCtx.getInstance().getGlobalConfig().getKeywords())) {
            keywords.addAll(Arrays.asList(MotionEtlGlobalCtx.getInstance().getGlobalConfig().getKeywords().split(",")));
        }
        String ddl = String.format("SELECT * FROM ( \n        select a.TABLE_NAME, a.COLUMN_NAME, a.DATA_TYPE,\n           (Row_number() over(partition by a.TABLE_NAME ORDER BY a.TABLE_NAME )) rn  \n          FROM all_tab_columns a, dba_tables t\n          WHERE  t.owner = a.owner AND a.TABLE_NAME = t.TABLE_NAME AND a.owner = upper('%s') order by a.TABLE_NAME)\nwhere rn < 6", MotionEtlGlobalCtx.getInstance().currentSchema());
        HashMap info = (HashMap)JdbcUtils.doQuery((Connection)this.openConnection(), (String)ddl, resultSet -> {
            HashMap<String, KeyValuePair> table = new HashMap<String, KeyValuePair>(1000);
            try {
                while (resultSet.next()) {
                    String tableName = resultSet.getString(1);
                    Object columns = resultSet.getString(2);
                    Object types = resultSet.getString(3).toLowerCase();
                    if (columns == null || ((String)columns).length() == 0 || type.contains(types)) continue;
                    if (table.containsKey(tableName)) {
                        columns = keywords.contains(((String)columns).toLowerCase()) ? ((KeyValuePair)table.get(tableName)).getValue() + "," + String.format("\"%s\"", resultSet.getString(2)) : ((KeyValuePair)table.get(tableName)).getValue() + "," + resultSet.getString(2);
                        types = ((KeyValuePair)table.get(tableName)).getKey() + "," + resultSet.getString(3);
                    } else if (keywords.contains(((String)columns).toLowerCase())) {
                        columns = String.format("\"%s\"", resultSet.getString(2));
                    }
                    table.put(tableName, new KeyValuePair((String)types, (String)columns));
                }
                return table;
            }
            catch (SQLException e) {
                EtlGlobalCtx.INSTANCE.handleException(ddl, (Throwable)e);
                HashMap emput = new HashMap(8);
                return emput;
            }
        });
        return info;
    }

    public HashMap<KeyValuePair, String> createDataDdl(HashMap<String, KeyValuePair> info) {
        HashMap<KeyValuePair, String> infos = new HashMap<KeyValuePair, String>(100);
        for (Map.Entry<String, KeyValuePair> entry : info.entrySet()) {
            int number = entry.getValue().getValue().split(",").length;
            String sql = String.format(" select * from (select %s from %s  order by %s ) WHERE ROWNUM <=20", entry.getValue().getValue(), MotionEtlGlobalCtx.getInstance().currentSchema() + ".\"" + entry.getKey() + "\"", entry.getValue().getValue());
            try {
                String result = (String)JdbcUtils.doQuery((Connection)this.openConnection(), (String)sql, resultSet -> {
                    StringBuffer sb = new StringBuffer();
                    try {
                        while (resultSet.next()) {
                            for (int i = 1; i <= number; ++i) {
                                String str = resultSet.getString(i);
                                sb.append(str + " ");
                            }
                        }
                        return sb.toString();
                    }
                    catch (SQLException e) {
                        EtlGlobalCtx.INSTANCE.handleException("\u5217\u4e0d\u5b58\u5728", (Throwable)e);
                        return sb.toString();
                    }
                });
                infos.put(new KeyValuePair(MotionEtlGlobalCtx.getInstance().currentSchema() + "." + entry.getKey(), entry.getValue().getValue()), result);
            }
            catch (Exception e) {
                EtlGlobalCtx.INSTANCE.handleException((Throwable)e);
            }
        }
        return infos;
    }

    public String createIndexDdl() {
        return String.format(" SELECT TABLE_NAME, dbms_metadata.get_ddl('INDEX',index_name, owner) As object_ddl\nFROM dba_indexes where index_name not in (select DBA_LOBS.INDEX_NAME from DBA_LOBS) and owner = upper('%s') and index_name in (SELECT INDEX_NAME FROM DBA_INDEXES WHERE GENERATED ='N' and owner = upper('%s') )", MotionEtlGlobalCtx.getInstance().currentSchema(), MotionEtlGlobalCtx.getInstance().currentSchema()) + MotionEtlGlobalCtx.getInstance().filterTable("TABLE_NAME") + " order by TABLE_NAME";
    }

    public String createSequenceDdl() {
        return "SELECT\n  OBJECT_NAME, dbms_metadata.get_ddl(\n    CASE\n      WHEN object_type LIKE 'PACKAGE%' THEN 'PACKAGE'\n      WHEN object_type LIKE 'DATABASE LINK' THEN 'DB_LINK'\n      WHEN object_type LIKE 'MATERIALIZED VIEW' THEN 'MATERIALIZED_VIEW'\n      WHEN object_type = 'INDEX' THEN 'INDEX'\n      ELSE object_type\n    END,\n    object_name,\n    owner\n  ) AS object_ddl\nFROM dba_objects\nWHERE object_type = 'SEQUENCE' AND NOT object_name like 'ISEQ$$_%' and STATUS = 'VALID' " + String.format(" and owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentSchema());
    }

    public String createViewDdl() {
        return String.format("SELECT to_char(X.NAME),\nDBMS_METADATA.GET_DDL(X.TYPE, to_char(X.NAME), to_char(X.OWNER)) AS object_ddl\nFROM\n(\nSELECT DISTINCT LEVEL,\n       D.NAME,\n       D.TYPE,\n       D.OWNER\nFROM (\nSELECT NAME,TYPE,OWNER,REFERENCED_NAME,REFERENCED_OWNER\nFROM ALL_DEPENDENCIES A\nWHERE (A.OWNER ,A.NAME )IN (SELECT OWNER,VIEW_NAME FROM ALL_VIEWS WHERE OWNER = UPPER('%s'))\n) D\nSTART WITH D.OWNER=UPPER('%s')\nCONNECT BY NOCYCLE PRIOR D.REFERENCED_OWNER = D.OWNER\n               AND PRIOR D.REFERENCED_NAME =D.NAME\nORDER BY LEVEL, NAME\n) X ", MotionEtlGlobalCtx.getInstance().currentSchema(), MotionEtlGlobalCtx.getInstance().currentSchema());
    }

    public String createTriggerDdl() {
        return "SELECT\n  OBJECT_NAME, dbms_metadata.get_ddl(\n    CASE\n      WHEN object_type LIKE 'PACKAGE%' THEN 'PACKAGE'\n      WHEN object_type LIKE 'DATABASE LINK' THEN 'DB_LINK'\n      WHEN object_type LIKE 'MATERIALIZED VIEW' THEN 'MATERIALIZED_VIEW'\n      WHEN object_type = 'INDEX' THEN 'INDEX'\n      ELSE object_type\n    END,\n    object_name,\n    owner\n  ) AS object_ddl\nFROM dba_objects\nWHERE object_type = 'TRIGGER'  and STATUS = 'VALID' " + String.format(" and owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentSchema());
    }

    public String createPackageDdl() {
        return "SELECT\n  OBJECT_NAME, dbms_metadata.get_ddl(\n    CASE\n      WHEN object_type LIKE 'PACKAGE%' THEN 'PACKAGE'\n      WHEN object_type LIKE 'DATABASE LINK' THEN 'DB_LINK'\n      WHEN object_type LIKE 'MATERIALIZED VIEW' THEN 'MATERIALIZED_VIEW'\n      WHEN object_type = 'INDEX' THEN 'INDEX'\n      ELSE object_type\n    END,\n    object_name,\n    owner\n  ) AS object_ddl\nFROM dba_objects\nWHERE object_type = 'PACKAGE' and STATUS = 'VALID'" + String.format(" and owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentSchema());
    }

    public String createTypeDdl() {
        return "SELECT\n  OBJECT_NAME, dbms_metadata.get_ddl(\n    CASE\n      WHEN object_type LIKE 'PACKAGE%' THEN 'PACKAGE'\n      WHEN object_type LIKE 'DATABASE LINK' THEN 'DB_LINK'\n      WHEN object_type LIKE 'MATERIALIZED VIEW' THEN 'MATERIALIZED_VIEW'\n      WHEN object_type = 'INDEX' THEN 'INDEX'\n      ELSE object_type\n    END,\n    object_name,\n    owner\n  ) AS object_ddl\nFROM dba_objects\nWHERE object_type = 'TYPE' " + String.format(" and owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentSchema()) + "and not REGEXP_LIKE(OBJECT_NAME,'^SYS_PLSQL_','i')";
    }

    public String createProcedureDdl() {
        return "SELECT\n  OBJECT_NAME, dbms_metadata.get_ddl(\n    CASE\n      WHEN object_type LIKE 'PACKAGE%' THEN 'PACKAGE'\n      WHEN object_type LIKE 'DATABASE LINK' THEN 'DB_LINK'\n      WHEN object_type LIKE 'MATERIALIZED VIEW' THEN 'MATERIALIZED_VIEW'\n      WHEN object_type = 'INDEX' THEN 'INDEX'\n      ELSE object_type\n    END,\n    object_name,\n    owner\n  ) AS object_ddl\nFROM dba_objects\nWHERE object_type = 'PROCEDURE' and STATUS = 'VALID' " + String.format(" and owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentSchema());
    }

    public String createProcedureInvalidDdl() {
        return "SELECT\n  OBJECT_NAME,\n    owner\nFROM dba_objects\nWHERE object_type = 'PROCEDURE' and STATUS = 'INVALID' " + String.format(" and owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentSchema());
    }

    public String compileProcedureInvalidDdl() {
        return "select 'ALTER PROCEDURE ' || OWNER ||'.' || OBJECT_NAME || ' compile' AS XX  from dba_objects where object_type = 'PROCEDURE' and STATUS = 'INVALID' " + String.format(" and owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentSchema());
    }

    public String createFunctionDdl() {
        return "SELECT\n OBJECT_NAME, dbms_metadata.get_ddl(\n    CASE\n      WHEN object_type LIKE 'PACKAGE%' THEN 'PACKAGE'\n      WHEN object_type LIKE 'DATABASE LINK' THEN 'DB_LINK'\n      WHEN object_type LIKE 'MATERIALIZED VIEW' THEN 'MATERIALIZED_VIEW'\n      WHEN object_type = 'INDEX' THEN 'INDEX'\n      ELSE object_type\n    END,\n    object_name,\n    owner\n  ) AS object_ddl\nFROM dba_objects\nWHERE object_type = 'FUNCTION' and STATUS = 'VALID' " + String.format(" and owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentSchema());
    }

    public List<String> fetchProcedureNames() {
        String sql = "SELECT OBJECT_NAME, lower(OBJECT_NAME) FROM user_procedures\nwhere OBJECT_TYPE = 'PROCEDURE'";
        return (List)JdbcUtils.doQuery((Connection)this.openConnection(), (String)sql, resultSet -> {
            ArrayList<String> result = new ArrayList<String>(8);
            try {
                while (resultSet.next()) {
                    result.add(resultSet.getString(2));
                }
                return result;
            }
            catch (SQLException e) {
                return new ArrayList(8);
            }
        });
    }

    public Map<String, Map<String, List<String>>> uniqueIndexesOfTable() {
        Map allIndexes = this.allIndexes();
        HashMap<String, Map<String, List<String>>> uniqueIndexesOfTable = new HashMap<String, Map<String, List<String>>>(32);
        for (Map.Entry entry : allIndexes.entrySet()) {
            for (Map.Entry infoEntry : ((Map)entry.getValue()).entrySet()) {
                IndexInfo info = (IndexInfo)infoEntry.getValue();
                if (!info.isUnique()) continue;
                Map indexInfoMap = uniqueIndexesOfTable.computeIfAbsent(info.getTableName(), key -> new HashMap(16));
                indexInfoMap.put(info.getIndex(), info.getColumnNames());
            }
        }
        return uniqueIndexesOfTable;
    }

    public List<RowValue> fetchRandomData(TableInfo tableInfo) {
        String join = Joiner.on((char)',').join((Iterable)tableInfo.getColumnNames());
        String sql = String.format("SELECT B.*\nFROM (SELECT *\n    FROM (SELECT A.*, ROWNUM RN_INDEX\n    FROM (SELECT *\n    FROM %s order by %s\n    ) A)\n    WHERE ROWNUM <= 10000) B\nWHERE RN_INDEX >= 0", tableInfo.formatTableName(), join);
        return JdbcUtils.fetchData((Connection)this.openConnection(), (TableInfo)tableInfo, (String)sql);
    }

    public HashMap<String, HashMap<String, String>> countType() {
        HashMap<String, HashMap<String, String>> result = new HashMap<String, HashMap<String, String>>(8);
        String countTableSql = String.format("select TABLE_NAME,'0' as invalid_data_filling from dba_tables where owner = upper('%s') %s", MotionEtlGlobalCtx.getInstance().currentSchema(), MotionEtlGlobalCtx.getInstance().filterTable("TABLE_NAME"));
        result.put(CompareTypeEnum.TABLE.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)countTableSql));
        String indexCountSql = String.format("with indx_t as (SELECT \n                table_name , LISTAGG(index_name, ',') WITHIN GROUP (ORDER BY index_name) AS index_list\n                FROM \n                dba_indexes \n                WHERE \n                table_type = 'TABLE' \n                AND owner = upper('%s') AND GENERATED ='N' %s                GROUP BY \n                      table_name\n                ORDER BY \n                      table_name)\n                select table_name,index_list from indx_t", MotionEtlGlobalCtx.getInstance().currentSchema(), MotionEtlGlobalCtx.getInstance().filterTable("TABLE_NAME"));
        result.put(CompareTypeEnum.INDEX.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)indexCountSql));
        String viewCountSql = String.format("select VIEW_NAME,'0' as invalid_data_filling from dba_views  where owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentSchema());
        result.put(CompareTypeEnum.VIEW.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)viewCountSql));
        String sequenceCountSql = String.format("select sequence_name,'0' as invalid_data_filling from dba_sequences where sequence_owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentSchema());
        result.put(CompareTypeEnum.SEQUENCE.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)sequenceCountSql));
        String proceduresCountSql = String.format("select object_name,'0' as invalid_data_filling from  dba_objects \nwhere object_type = 'PROCEDURE' and STATUS = 'VALID' and owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentSchema());
        result.put(CompareTypeEnum.PROCEDURES.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)proceduresCountSql));
        String proceduresInvalidCountSql = String.format("select object_name,'0' as invalid_data_filling from  dba_objects \nwhere object_type = 'PROCEDURE' and STATUS = 'INVALID' and owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentSchema());
        result.put("proceduresInvalidCount", JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)proceduresInvalidCountSql));
        String functionCountSql = String.format("select object_name,'0' as invalid_data_filling from  dba_objects \nwhere object_type = 'FUNCTION' and STATUS = 'VALID' and owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentSchema());
        result.put(CompareTypeEnum.FUNCTION.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)functionCountSql));
        String triggerCountSql = String.format("SELECT TRIGGER_NAME,'0' as invalid_data_filling \nFROM dba_TRIGGERS \n where owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentSchema());
        result.put(CompareTypeEnum.TRIGGER.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)triggerCountSql));
        String typeCountSql = String.format("select type_name,'0' as invalid_data_filling from  dba_types \nwhere owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentSchema());
        result.put(CompareTypeEnum.TYPE.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)typeCountSql));
        String packageCountSql = String.format("select object_name,'0' as invalid_data_filling from  dba_objects \nwhere object_type = 'PACKAGE' and owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentSchema());
        result.put(CompareTypeEnum.PACKAGE.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)packageCountSql));
        String packageBodyCountSql = String.format("select object_name,'0' as invalid_data_filling from  dba_objects \nwhere object_type = 'PACKAGE BODY' and owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentSchema());
        result.put(CompareTypeEnum.PACKAGE_BODY.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)packageBodyCountSql));
        return result;
    }

    public void saveForeignKeyFile() {
        String getFkSql = String.format(" SELECT ac1.constraint_name,                                 DBMS_METADATA.get_ddl ('REF_CONSTRAINT', ac1.constraint_name, ac1.owner)\nFROM   all_constraints ac1\n       JOIN all_constraints ac2 ON ac1.r_owner = ac2.owner AND ac1.r_constraint_name = ac2.constraint_name\nWHERE   ac1.constraint_type = 'R'\n and ac2.owner = UPPER('%s')", MotionEtlGlobalCtx.getInstance().currentSchema());
        List keyValuePairs = JdbcUtils.fetchDdl((Connection)this.openConnection(), (String)getFkSql);
        MotionEtlGlobalCtx.getInstance().storeFkSqls(keyValuePairs);
    }

    public String createTableDataColumnInfo() {
        return String.format("select a.owner,a.table_name,a.column_name,a.data_type,nvl(b.is_unique,0) from \n     (select t.owner,t.table_name,c.column_name,c.data_type from dba_tab_cols c  JOIN dba_tables t \n      ON c.owner = t.owner \n     AND c.table_name = t.table_name \n     where c.owner=upper('%s') AND c.hidden_column = 'NO' and c.table_name not like 'BIN%%' %s) a\n     left join\n     (select distinct b.table_owner,b.table_name,b.column_name, 1 is_unique \n     from dba_indexes a,dba_ind_columns b where a.table_owner=upper('%s') and \n       (a.uniqueness='UNIQUE' or exists(select 1 from dba_constraints c        where owner=upper('%s') and constraint_type='P' AND c.index_name=A.INDEX_NAME))\n     and b.table_owner=upper('%s') %s and a.index_name=b.INDEX_NAME) b\n     on a.owner=b.table_owner and a.table_name=b.table_name and a.column_name=b.column_name", MotionEtlGlobalCtx.getInstance().currentSchema(), MotionEtlGlobalCtx.getInstance().filterOracleTable("c.table_name"), MotionEtlGlobalCtx.getInstance().currentSchema(), MotionEtlGlobalCtx.getInstance().currentSchema(), MotionEtlGlobalCtx.getInstance().currentSchema(), MotionEtlGlobalCtx.getInstance().filterOracleTable("b.table_name"));
    }
}

