/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.strategy;

import com.hundsun.lightdb.core.KeyValuePair;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.ObjectTypeEnum;
import com.hundsun.lightdb.core.strategy.BaseCreateObject;
import com.hundsun.lightdb.core.target.TargetImporter;
import com.hundsun.lightdb.core.transformer.EtlTransformer;
import com.hundsun.lightdb.utils.StrategyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCreateObject
implements BaseCreateObject {
    private static final Logger log = LoggerFactory.getLogger(AbstractCreateObject.class);
    private KeyValuePair ddl;
    private EtlTransformer transformer;
    private TargetImporter targetImporter;

    public void createObject(String ddlType) {
        if (log.isInfoEnabled()) {
            log.info("type is :{}", (Object)ddlType);
        }
        String sqlDDL = this.getSqlDDL().getValue();
        if (log.isInfoEnabled()) {
            log.info("before result is:{}", (Object)sqlDDL);
        }
        String objType = "";
        switch (ddlType) {
            case "VIEW": {
                objType = ObjectTypeEnum.VIEW.getName();
                if (log.isInfoEnabled()) {
                    log.info("view");
                }
                sqlDDL = StrategyUtils.getSplitDLLObjectByUnion((String)sqlDDL, (String)"VIEW");
                break;
            }
            case "PROCEDURE": {
                objType = ObjectTypeEnum.PROCEDURE.getName();
                if (log.isInfoEnabled()) {
                    log.info("procedure");
                }
                sqlDDL = StrategyUtils.getSplitDLLObjectByUnion((String)sqlDDL, (String)"PROCEDURE");
                break;
            }
            case "FUNCTION": {
                objType = ObjectTypeEnum.FUNCTION.getName();
                if (log.isInfoEnabled()) {
                    log.info("function");
                }
                sqlDDL = StrategyUtils.getSplitDLLObjectByUnion((String)sqlDDL, (String)"FUNCTION");
                if (!MotionEtlGlobalCtx.getInstance().needTransfer(this.ddl.getKey())) break;
                sqlDDL = this.transformer.transformFunctionDdl(sqlDDL);
                break;
            }
            default: {
                if (!log.isErrorEnabled()) break;
                log.error("ddlType not matched!");
            }
        }
        if (this.isNeedDruidTranse()) {
            if (log.isDebugEnabled()) {
                log.debug("isNeedDruidTranse now!!!");
            }
            sqlDDL = this.druidTrans(sqlDDL);
        }
        if (this.isNeedUnisqlTranse()) {
            if (log.isDebugEnabled()) {
                log.debug("isNeedUnisqlTranse now!!!");
            }
            sqlDDL = this.unisqlTrans(sqlDDL);
        }
        if (this.isNeedReplaceWithExpression()) {
            sqlDDL = this.replaceWithExpression(ddlType, sqlDDL);
        }
        this.transExecute(objType, this.getSqlDDL(), sqlDDL);
    }

    protected void setSqlDDL(KeyValuePair sqlDDL) {
        this.ddl = sqlDDL;
    }

    public void setEtlTransformer(EtlTransformer etlTransformer) {
        this.transformer = etlTransformer;
    }

    public void setTargetImporter(TargetImporter targetImporter) {
        this.targetImporter = targetImporter;
    }

    protected KeyValuePair getSqlDDL() {
        return this.ddl;
    }

    protected EtlTransformer getEtlTransformer() {
        return this.transformer;
    }

    protected TargetImporter getTargetImporter() {
        return this.targetImporter;
    }

    void transExecute(String objType, KeyValuePair ddl, String result) {
        this.getTargetImporter().execute(objType, ddl, result);
    }

    boolean isNeedDruidTranse() {
        return false;
    }

    boolean isNeedUnisqlTranse() {
        return false;
    }

    boolean isNeedReplaceWithExpression() {
        return false;
    }
}

