/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.strategy;

import com.hundsun.lightdb.core.KeyValuePair;
import com.hundsun.lightdb.core.strategy.AbstractCreateObject;
import com.hundsun.lightdb.core.strategy.CreateDdlObjectFactory;
import com.hundsun.lightdb.core.strategy.CreateObjectContextStrategy;
import com.hundsun.lightdb.core.target.TargetImporter;
import com.hundsun.lightdb.core.transformer.EtlTransformer;
import com.hundsun.lightdb.utils.StrategyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateObjectContextStrategy {
    private static final Logger log = LoggerFactory.getLogger(CreateObjectContextStrategy.class);

    private CreateObjectContextStrategy() {
    }

    public static CreateObjectContextStrategy getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void executeTransCreateObject(KeyValuePair ddl, EtlTransformer etlTransformer, TargetImporter targetImporter, String ddlType) {
        int code = 1;
        switch (ddlType) {
            case "VIEW": {
                code = StrategyUtils.getCreateViewTypeCode((KeyValuePair)ddl);
                if (!log.isDebugEnabled()) break;
                log.debug("DdlType:VIEW");
                break;
            }
            case "PROCEDURE": {
                if (!log.isDebugEnabled()) break;
                log.debug("DdlType:PROCEDURE");
                break;
            }
            case "FUNCTION": {
                if (!log.isDebugEnabled()) break;
                log.debug("DdlType:FUNCTION");
                break;
            }
            default: {
                if (!log.isDebugEnabled()) break;
                log.debug("default");
            }
        }
        AbstractCreateObject abstractCreateObject = CreateDdlObjectFactory.getConcreteCreateObject((Integer)code);
        if (log.isDebugEnabled()) {
            log.debug("code is:{},abstractCreateObject is:{}", (Object)code, (Object)abstractCreateObject);
        }
        abstractCreateObject.setSqlDDL(ddl);
        abstractCreateObject.setEtlTransformer(etlTransformer);
        abstractCreateObject.setTargetImporter(targetImporter);
        abstractCreateObject.createObject(ddlType);
    }
}

