/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.target;

import com.hundsun.lightdb.ImportWorker;
import com.hundsun.lightdb.TableInfo;
import com.hundsun.lightdb.WorkerGroup;
import com.hundsun.lightdb.core.EtlGlobalCtx;
import com.hundsun.lightdb.core.KeyValuePair;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.MotionParameters;
import com.hundsun.lightdb.core.source.SourceFetcher;
import com.hundsun.lightdb.core.source.SourceJdbcMeta;
import com.hundsun.lightdb.core.target.TargetImporter;
import com.hundsun.lightdb.core.target.TargetJdbcMeta;
import com.hundsun.lightdb.utils.CommonUtils;
import com.hundsun.lightdb.utils.JdbcUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTargetImporter
implements TargetImporter {
    private static final Logger log = LoggerFactory.getLogger(AbstractTargetImporter.class);
    protected TargetJdbcMeta targetJdbcMeta;
    protected SourceJdbcMeta sourceJdbcMeta;
    protected WorkerGroup workerGroup;

    public AbstractTargetImporter(TargetJdbcMeta targetJdbcMeta, SourceJdbcMeta sourceJdbcMeta) {
        this.targetJdbcMeta = targetJdbcMeta;
        this.sourceJdbcMeta = sourceJdbcMeta;
    }

    public void init() {
        if (this.workerGroup == null) {
            this.workerGroup = new WorkerGroup(MotionEtlGlobalCtx.getInstance().concurrentThreadCount());
            MotionEtlGlobalCtx.getInstance().setWorkerGroup(this.workerGroup);
        }
    }

    public void execute(String objectType, KeyValuePair ddl, String sql) {
        MotionParameters motionParameters = MotionEtlGlobalCtx.getInstance().motionParameters;
        this.workerGroup.addTask(() -> this.targetJdbcMeta.executeSql(motionParameters, objectType, ddl, sql));
    }

    public void executes(String objectType, KeyValuePair ddl, List<String> sqls) {
        MotionParameters motionParameters = MotionEtlGlobalCtx.getInstance().motionParameters;
        this.workerGroup.addTask(() -> this.targetJdbcMeta.executeSqls(motionParameters, objectType, ddl, sqls));
    }

    public void importData(SourceFetcher sourceFetcher) {
        Map tableInfos = this.tableInfo();
        StringBuffer resultPath = new StringBuffer();
        resultPath.append(String.format("%s/%s", CommonUtils.getLogPath(), "result.info"));
        CommonUtils.createNewFile((String)resultPath.toString());
        String tableName = MotionEtlGlobalCtx.getInstance().getGlobalConfig().getIncludeTableRegexp();
        if (tableInfos == null || tableInfos.isEmpty()) {
            if (StringUtils.isNotBlank((CharSequence)tableName)) {
                try {
                    tableName = tableName.substring(tableName.indexOf(94) + 1, tableName.indexOf(36));
                    CommonUtils.writeTransferTableDataResult((String)String.format("\u76ee\u6807\u5e93\u8868\u3010%s.%s\u3011\u4e0d\u5b58\u5728", MotionEtlGlobalCtx.getInstance().currentTargetSchema(), tableName));
                }
                catch (Exception e) {
                    CommonUtils.writeTransferTableDataResult((String)String.format("\u591a\u53d1\u6bd4\u5bf9\u914d\u7f6e\u53c2\u6570includeTableRegexp(%s)", MotionEtlGlobalCtx.getInstance().getGlobalConfig().getIncludeTableRegexp()));
                }
            } else {
                CommonUtils.writeTransferTableDataResult((String)"\u591a\u53d1\u6bd4\u5bf9\u672a\u914d\u7f6e\u53c2\u6570includeTableRegexp");
            }
        }
        for (TableInfo tableInfo : tableInfos.values()) {
            try {
                this.divideTasks(this.workerGroup, tableInfo, sourceFetcher.sourceJdbcMeta(), this.targetJdbcMeta);
            }
            catch (Exception e) {
                EtlGlobalCtx.INSTANCE.handleException("\u5bfc\u5165\u6570\u636e\u4e2d\u65ad", (Throwable)e);
            }
        }
        this.workerGroup.waitCompletion();
        if (log.isInfoEnabled()) {
            log.info("etl\u8868\u6570\u636e\u8fc1\u79fb\u5b8c\u6210");
        }
    }

    public void waitCompletion() {
        this.workerGroup.waitCompletion();
    }

    protected void divideTasks(WorkerGroup workerGroup, TableInfo tableInfo, SourceJdbcMeta source, TargetJdbcMeta target) throws SQLException {
        if (MotionEtlGlobalCtx.getInstance().syncTableDataOpenTruncate()) {
            Connection targetConn = target.openConnection();
            JdbcUtils.executeSql((Connection)targetConn, (String)("truncate table " + tableInfo.formatTargetTableName()));
        }
        ImportWorker importWorker = new ImportWorker(MotionEtlGlobalCtx.getInstance().motionParameters, MotionEtlGlobalCtx.getInstance().batchCount(), tableInfo, source, target, 0, 0, "", "");
        workerGroup.addTask((Runnable)importWorker);
    }

    protected TreeMap<Integer, Integer> getFileBatch(TableInfo tableInfo, SourceJdbcMeta source) {
        return source.getFileBatch(tableInfo);
    }

    public Map<String, TableInfo> tableInfo() {
        return this.targetJdbcMeta.tableInfo();
    }

    public TargetJdbcMeta targetJdbcMeta() {
        return this.targetJdbcMeta;
    }
}

