/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.target;

import com.hundsun.lightdb.TableInfo;
import com.hundsun.lightdb.core.EtlConfig;
import com.hundsun.lightdb.core.EtlGlobalCtx;
import com.hundsun.lightdb.core.KeyValuePair;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.MotionParameters;
import com.hundsun.lightdb.core.target.TargetJdbcMeta;
import com.hundsun.lightdb.event.GlobalApplicationContext;
import com.hundsun.lightdb.event.TaskExcuteEvent;
import com.hundsun.lightdb.motion.enums.CompareTypeEnum;
import com.hundsun.lightdb.utils.AesDecryptUtils;
import com.hundsun.lightdb.utils.CommonUtils;
import com.hundsun.lightdb.utils.JdbcUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;

public abstract class AbstractTargetJdbcMeta
implements TargetJdbcMeta {
    private static final Logger log = LoggerFactory.getLogger(AbstractTargetJdbcMeta.class);
    protected EtlConfig.DbConfig dbConfig;
    public static ThreadLocal<Connection> connectionHolder = new ThreadLocal();

    public AbstractTargetJdbcMeta(EtlConfig.DbConfig dbConfig) {
        this.dbConfig = dbConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection openConnection() {
        Connection connection = (Connection)connectionHolder.get();
        if (connection == null || connection.isClosed()) {
            AbstractTargetJdbcMeta abstractTargetJdbcMeta = this;
            synchronized (abstractTargetJdbcMeta) {
                connection = this.getConnection(this.dbConfig);
                DatabaseMetaData metaData = connection.getMetaData();
                log.info("driver loaded: " + metaData.getDriverName());
                connectionHolder.set(connection);
                MotionEtlGlobalCtx.getInstance().queueConnection(connection);
            }
        }
        return connection;
    }

    public Connection getConnection(EtlConfig.DbConfig dbConfig) {
        Connection newConnection = null;
        try {
            boolean pwdEncrypted = MotionEtlGlobalCtx.getInstance().getGlobalConfig().isPwdEncrypted();
            newConnection = DriverManager.getConnection(dbConfig.getUrl(), dbConfig.getUsername(), pwdEncrypted ? AesDecryptUtils.decryptStringWithInputKey((String)dbConfig.getPassword(), (String)System.getProperty("EncryptKey")) : dbConfig.getPassword());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return newConnection;
    }

    public void executeSql(MotionParameters motionParameters, String objectType, KeyValuePair ddl, String sql) {
        block2: {
            KeyValuePair keyValuePair = JdbcUtils.executeSql((Connection)this.openConnection(), (String)objectType, (String)ddl.getKey(), (String)sql);
            try {
                GlobalApplicationContext.context.publishEvent((ApplicationEvent)new TaskExcuteEvent((Object)this, motionParameters, objectType, ddl.getKey(), ddl.getValue(), sql, keyValuePair));
            }
            catch (Exception e) {
                if (!log.isInfoEnabled()) break block2;
                log.info("AbstractTargetJdbcMeta publishEvent info:{}", (Object)e.toString());
            }
        }
    }

    public void executeSqls(MotionParameters motionParameters, String objectType, KeyValuePair ddl, List<String> sqls) {
        for (String sql : sqls) {
            Object objectName = null;
            if (CompareTypeEnum.INDEX.getCompareName().equals(objectType)) {
                objectName = CommonUtils.getOneIndexFromSql((String)sql);
            } else if (CompareTypeEnum.PACKAGE.getCompareName().equals(objectType) && StringUtils.isNotBlank((CharSequence)(objectName = CommonUtils.getPackageBodyFromSql((String)sql)))) {
                objectName = (String)objectName + "_body";
            }
            KeyValuePair keyValuePair = JdbcUtils.executeSql((Connection)this.openConnection(), (String)objectType, (String)(StringUtils.isBlank((CharSequence)objectName) ? ddl.getKey() : objectName), (String)sql);
            try {
                GlobalApplicationContext.context.publishEvent((ApplicationEvent)new TaskExcuteEvent((Object)this, motionParameters, objectType, ddl.getKey(), ddl.getValue(), sql, keyValuePair));
            }
            catch (Exception e) {
                if (!log.isInfoEnabled()) continue;
                log.info("AbstractTargetJdbcMeta publishEvent info:{}", (Object)e.toString());
            }
        }
    }

    protected Map<String, TableInfo> getTableInfo(String selectSql) {
        return (Map)JdbcUtils.doQuery((Connection)this.openConnection(), (String)selectSql, resultSet -> {
            HashMap<String, TableInfo> tableInfos = new HashMap<String, TableInfo>(32);
            try {
                while (resultSet.next()) {
                    String tableName = resultSet.getString(1);
                    String columnName = resultSet.getString(2);
                    log.debug("\u5f00\u59cb\u5904\u7406{}.{}", (Object)tableName, (Object)columnName);
                    ArrayList<String> values = new ArrayList<String>();
                    values.add(columnName);
                    TableInfo tableInfo = tableInfos.computeIfAbsent(tableName.toLowerCase(), key -> new TableInfo(tableName, true));
                    tableInfo.setSchema(MotionEtlGlobalCtx.getInstance().currentTargetSchema());
                    String val = resultSet.getString(3);
                    values.add(val);
                    this.addValue(resultSet, 4, values);
                    this.addValue(resultSet, 5, values);
                    this.addValue(resultSet, 6, values);
                    tableInfo.addColumn(columnName, resultSet.getString(3));
                    tableInfo.addCharacterMaximumLength(Long.valueOf(resultSet.getLong(4)));
                    tableInfo.tableHandler();
                    log.debug("{}.{}\u5904\u7406\u5b8c\u6210", (Object)tableName, (Object)columnName);
                }
                return tableInfos;
            }
            catch (SQLException e) {
                EtlGlobalCtx.INSTANCE.handleException(selectSql, (Throwable)e);
                return Collections.emptyMap();
            }
        });
    }

    protected Map<String, TableInfo> getTableInfo(String schema, String selectSql) {
        return (Map)JdbcUtils.doQuery((Connection)this.openConnection(), (String)selectSql, resultSet -> {
            HashMap<String, TableInfo> tableInfos = new HashMap<String, TableInfo>(32);
            try {
                while (resultSet.next()) {
                    String tableName = resultSet.getString(1);
                    ArrayList<String> values = new ArrayList<String>();
                    String columnName = resultSet.getString(2);
                    values.add(columnName);
                    TableInfo tableInfo = tableInfos.computeIfAbsent(tableName.toLowerCase(), key -> new TableInfo(tableName, true));
                    tableInfo.setSchema(schema);
                    String val = resultSet.getString(3);
                    values.add(val);
                    this.addValue(resultSet, 4, values);
                    this.addValue(resultSet, 5, values);
                    this.addValue(resultSet, 6, values);
                    tableInfo.addColumnName(columnName);
                }
                return tableInfos;
            }
            catch (SQLException e) {
                EtlGlobalCtx.INSTANCE.handleException(selectSql, (Throwable)e);
                return Collections.emptyMap();
            }
        });
    }

    private void addValue(ResultSet resultSet, int index, List<String> values) throws SQLException {
        String val = resultSet.getString(index);
        if (val != null) {
            values.add(val);
        }
    }

    public EtlConfig.DbConfig getDbConfig() {
        return this.dbConfig;
    }
}

