/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.target.dm;

import com.hundsun.lightdb.TableInfo;
import com.hundsun.lightdb.core.EtlConfig;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.target.AbstractTargetJdbcMeta;
import com.hundsun.lightdb.motion.enums.CompareTypeEnum;
import com.hundsun.lightdb.utils.JdbcUtils;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"etl.global.targetDatabase"}, havingValue="dm")
public class DmTargetJdbcMeta
extends AbstractTargetJdbcMeta {
    private static final Logger log = LoggerFactory.getLogger(DmTargetJdbcMeta.class);

    @Autowired
    public DmTargetJdbcMeta(@Qualifier(value="target") EtlConfig.DbConfig dbConfig) {
        super(dbConfig);
    }

    public Map<String, TableInfo> tableInfo() {
        String sql = String.format(" SELECT \n                       table_name,\n                        column_name,\n                       CASE \n                           WHEN data_type = 'VARCHAR2' THEN 'varchar'\n                           WHEN data_type = 'CHAR' THEN 'char'\n                            ELSE data_type\n                        END AS udt_name,\n                        CASE \n                            WHEN data_type IN ('VARCHAR2', 'CHAR') THEN CHAR_LENGTH\n                           ELSE NULL\n                       END AS character_maximum_length,\n                        CASE \n                            WHEN data_type IN ('NUMBER', 'FLOAT', 'DECIMAL') THEN DATA_PRECISION\n                            ELSE NULL\n                        END AS numeric_precision,\n                       CASE \n                            WHEN data_type IN ('NUMBER', 'FLOAT', 'DECIMAL') THEN DATA_SCALE\n                           ELSE NULL\n                        END AS numeric_scale\n                    FROM \n                        dba_tab_columns \n                    where owner = upper('%s')  AND \n      table_name not like 'BIN$%%$%%' \n AND       table_name NOT IN ( select /*+NO_UNNEST*/VIEW_NAME from dba_views WHERE owner = upper('%s')) ", MotionEtlGlobalCtx.getInstance().currentTargetSchema(), MotionEtlGlobalCtx.getInstance().currentTargetSchema()) + MotionEtlGlobalCtx.getInstance().filterTable("table_name");
        return this.getTableInfo(sql);
    }

    public String createTableDataColumnInfo() {
        return String.format("select a.owner,a.table_name,a.column_name,a.data_type,nvl(b.is_unique,0) from \n     (select owner,table_name,column_name,data_type from dba_tab_cols \n     where owner=upper('%s') AND hidden_column = 'NO'  and table_name not like 'BIN%%' %s) a\n     left join\n     (select distinct b.table_owner,b.table_name,b.column_name, 1 is_unique \n     from dba_indexes a,dba_ind_columns b where a.table_owner=upper('%s') and a.uniqueness='UNIQUE'\n     and b.table_owner=upper('%s') %s and a.index_name=b.INDEX_NAME) b\n     on a.owner=b.table_owner and a.table_name=b.table_name and a.column_name=b.column_name", MotionEtlGlobalCtx.getInstance().currentTargetSchema(), MotionEtlGlobalCtx.getInstance().filterDMTable("table_name"), MotionEtlGlobalCtx.getInstance().currentTargetSchema(), MotionEtlGlobalCtx.getInstance().currentTargetSchema(), MotionEtlGlobalCtx.getInstance().filterDMTable("b.table_name"));
    }

    public String createColumnDdl() {
        return "SELECT\n  a.TABLE_NAME, a.COLUMN_NAME, a.DATA_TYPE, a.DATA_PRECISION, a.DATA_SCALE,NULLIF(a.char_length,0),0 \nFROM all_tab_columns a, dba_tables t \n" + String.format("WHERE  t.owner = a.owner AND a.TABLE_NAME = t.TABLE_NAME AND a.owner = upper('%s') ", MotionEtlGlobalCtx.getInstance().currentTargetSchema()) + MotionEtlGlobalCtx.getInstance().filterTable("a.TABLE_NAME");
    }

    public Map<String, HashMap<String, String>> countType() {
        HashMap<String, HashMap<String, String>> result = new HashMap<String, HashMap<String, String>>(8);
        String countTableSql = String.format("select TABLE_NAME,'0' as invalid_data_filling from dba_tables where owner = upper('%s') %s", MotionEtlGlobalCtx.getInstance().currentTargetSchema(), MotionEtlGlobalCtx.getInstance().filterTable("TABLE_NAME"));
        result.put(CompareTypeEnum.TABLE.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)countTableSql));
        String indexCountSql = String.format("with indx_t as (SELECT \n                table_name , LISTAGG(index_name, ',') WITHIN GROUP (ORDER BY index_name) AS index_list\n                FROM \n                dba_indexes \n                WHERE \n                table_type = 'TABLE' \n                AND owner = upper('%s') AND GENERATED ='N' %s                GROUP BY \n                      table_name\n                ORDER BY \n                      table_name)\n                select table_name,index_list from indx_t", MotionEtlGlobalCtx.getInstance().currentTargetSchema(), MotionEtlGlobalCtx.getInstance().filterTable("TABLE_NAME"));
        result.put(CompareTypeEnum.INDEX.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)indexCountSql));
        String viewCountSql = String.format("select VIEW_NAME,'0' as invalid_data_filling from dba_views  where owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentTargetSchema());
        result.put(CompareTypeEnum.VIEW.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)viewCountSql));
        String sequenceCountSql = String.format("select sequence_name,'0' as invalid_data_filling from dba_sequences where sequence_owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentTargetSchema());
        result.put(CompareTypeEnum.SEQUENCE.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)sequenceCountSql));
        String proceduresCountSql = String.format("select object_name,'0' as invalid_data_filling from  dba_objects \nwhere object_type = 'PROCEDURE' and STATUS = 'VALID' and owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentTargetSchema());
        result.put(CompareTypeEnum.PROCEDURES.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)proceduresCountSql));
        String proceduresInvalidCountSql = String.format("select object_name,'0' as invalid_data_filling from  dba_objects \nwhere object_type = 'PROCEDURE' and STATUS = 'INVALID' and owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentTargetSchema());
        result.put("proceduresInvalidCount", JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)proceduresInvalidCountSql));
        String functionCountSql = String.format("select object_name,'0' as invalid_data_filling from  dba_objects \nwhere object_type = 'FUNCTION' and STATUS = 'VALID' and owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentTargetSchema());
        result.put(CompareTypeEnum.FUNCTION.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)functionCountSql));
        String triggerCountSql = String.format("SELECT TRIGGER_NAME,'0' as invalid_data_filling \nFROM dba_TRIGGERS \n where owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentTargetSchema());
        result.put(CompareTypeEnum.TRIGGER.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)triggerCountSql));
        String typeCountSql = String.format("select type_name,'0' as invalid_data_filling from  dba_types \nwhere owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentTargetSchema());
        result.put(CompareTypeEnum.TYPE.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)typeCountSql));
        String packageCountSql = String.format("select object_name,'0' as invalid_data_filling from  dba_objects \nwhere object_type = 'PACKAGE' and owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentTargetSchema());
        result.put(CompareTypeEnum.PACKAGE.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)packageCountSql));
        String packageBodyCountSql = String.format("select object_name,'0' as invalid_data_filling from  dba_objects \nwhere object_type = 'PACKAGE BODY' and owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentTargetSchema());
        result.put(CompareTypeEnum.PACKAGE_BODY.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)packageBodyCountSql));
        return result;
    }
}

