/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.target.gaussdb500oracle;

import com.hundsun.lightdb.TableInfo;
import com.hundsun.lightdb.core.source.SourceJdbcMeta;
import com.hundsun.lightdb.core.target.AbstractTargetImporter;
import com.hundsun.lightdb.core.target.TargetJdbcMeta;
import com.hundsun.lightdb.utils.JdbcUtils;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"etl.global.targetDatabase"}, havingValue="gaussdb500_oracle")
public class Gaussdb500OracleTargetImporter
extends AbstractTargetImporter {
    private static final Logger log = LoggerFactory.getLogger(Gaussdb500OracleTargetImporter.class);
    public static final int PAIR_COUNT = 2;

    public void init() {
        super.init();
        this.targetJdbcMeta.createScehma();
    }

    @Autowired
    public Gaussdb500OracleTargetImporter(TargetJdbcMeta targetJdbcMeta, SourceJdbcMeta sourceJdbcMeta) {
        super(targetJdbcMeta, sourceJdbcMeta);
    }

    public HashMap<String, HashMap<String, String>> columnInfo() {
        String ddl = this.targetJdbcMeta.createColumnDdl();
        return JdbcUtils.fetchColumnInfo((Connection)this.targetJdbcMeta.openConnection(), (String)ddl);
    }

    public Map<String, HashMap<String, String>> countType() {
        return this.targetJdbcMeta.countType();
    }

    public HashMap<String, TableInfo> tableDataColumnInfo() {
        String ddl = this.targetJdbcMeta.createTableDataColumnInfo();
        return JdbcUtils.fetchTableColumnInfo((Connection)this.targetJdbcMeta.openConnection(), (String)ddl);
    }
}

