/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.target.gaussdb500oracle;

import com.hundsun.lightdb.TableInfo;
import com.hundsun.lightdb.core.EtlConfig;
import com.hundsun.lightdb.core.EtlGlobalCtx;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.target.AbstractTargetJdbcMeta;
import com.hundsun.lightdb.motion.enums.CompareTypeEnum;
import com.hundsun.lightdb.utils.CommonUtils;
import com.hundsun.lightdb.utils.JdbcUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"etl.global.targetDatabase"}, havingValue="gaussdb500_oracle")
public class Gaussdb500OracleTargetJdbcMeta
extends AbstractTargetJdbcMeta {
    private static final Logger log = LoggerFactory.getLogger(Gaussdb500OracleTargetJdbcMeta.class);

    @Autowired
    public Gaussdb500OracleTargetJdbcMeta(@Qualifier(value="target") EtlConfig.DbConfig dbConfig) {
        super(dbConfig);
    }

    public Connection getConnection(EtlConfig.DbConfig dbConfig) {
        String driverClassName = "com.huawei.opengauss.jdbc.Driver";
        String regex = "^gaussdbDriver.*\\.jar$";
        return CommonUtils.getConnectionByDbConfig((EtlConfig.DbConfig)dbConfig, (String)driverClassName, (String)regex, this.getClass());
    }

    public void createScehma() {
        while (MotionEtlGlobalCtx.getInstance().increaseSchema()) {
            String searchPath = (String)JdbcUtils.doQuery((Connection)this.openConnection(), (String)"show search_path;", resultSet -> {
                try {
                    resultSet.next();
                    return resultSet.getString(1);
                }
                catch (SQLException e) {
                    EtlGlobalCtx.INSTANCE.handleException((Throwable)e);
                    return "\"$user\", public, \"$lt_syntax_compatible_type\", lt_catalog";
                }
            });
            String schema = (String)JdbcUtils.doQuery((Connection)this.openConnection(), (String)String.format("select count(*) from pg_namespace where nspname='%s';", MotionEtlGlobalCtx.getInstance().currentTargetSchema()), resultSet -> {
                try {
                    resultSet.next();
                    return resultSet.getString(1);
                }
                catch (SQLException e) {
                    EtlGlobalCtx.INSTANCE.handleException((Throwable)e);
                    return "0";
                }
            });
            if (schema.equals("0")) {
                String sql = String.format("CREATE SCHEMA %s;set search_path to %s;", MotionEtlGlobalCtx.getInstance().currentTargetSchema(), MotionEtlGlobalCtx.getInstance().currentTargetSchema() + "," + searchPath);
                JdbcUtils.executeSql((Connection)this.openConnection(), (String)sql);
                continue;
            }
            log.info("schema {} \u5df2\u7ecf\u5b58\u5728", (Object)MotionEtlGlobalCtx.getInstance().currentTargetSchema());
        }
        MotionEtlGlobalCtx.getInstance().resetSchemaIndex();
    }

    public Map<String, TableInfo> tableInfo() {
        Object sql = "";
        sql = String.format("select table_name,column_name,case udt_name\n                            when 'character varying' then 'varchar'\n                            when 'character' then 'char'\n                            else udt_name\n                            end,character_maximum_length,numeric_precision,numeric_scale\n                        from information_schema.columns\n                        where table_schema = lower('%s') and is_identity = 'NO' \n                        and table_name not like 'BIN$%%$0'\n                        and (table_schema,table_name) in \n(\nSELECT  \nn.nspname,\nc.relname as tablename\nFROM pg_catalog.pg_class c \nLEFT JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace \nWHERE c.relkind IN ('r','p')\nAND n.nspname  = lower('%s') \nAND c.relname not like 'BIN$%%$0'\n)", MotionEtlGlobalCtx.getInstance().currentTargetSchema(), MotionEtlGlobalCtx.getInstance().currentTargetSchema()) + MotionEtlGlobalCtx.getInstance().filterGaussdb500Table();
        return this.getTableInfo((String)sql);
    }

    public String createColumnDdl() {
        return String.format("select table_name,column_name,udt_name,\n                        numeric_precision, numeric_scale,character_maximum_length,datetime_precision\n                        from information_schema.columns\n                        where table_schema = lower('%s') and is_identity = 'NO' \n", MotionEtlGlobalCtx.getInstance().currentTargetSchema()) + MotionEtlGlobalCtx.getInstance().filterGaussdb500Table();
    }

    public Map<String, HashMap<String, String>> countType() {
        HashMap<String, HashMap<String, String>> result = new HashMap<String, HashMap<String, String>>(8);
        String tableCountSql = String.format("SELECT  \nc.relname as table_name,\n'0' as invalid_data_filling\n FROM pg_catalog.pg_class c \nLEFT JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace \nWHERE c.relkind IN ('r','p')\nAND n.nspname  = '%s' \n", MotionEtlGlobalCtx.getInstance().currentTargetSchema().toLowerCase(), MotionEtlGlobalCtx.getInstance().filterGaussdb500Table());
        result.put(CompareTypeEnum.TABLE.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)tableCountSql));
        String indexCountSql = String.format("select \n       tablename as table_name,\n       string_agg(indexname, ',') AS index_list \nfrom pg_indexes i  where i.schemaname = '%s'\nand (schemaname,indexname) in \n(\nSELECT n.nspname, \n  c.relname as \"index_name\"\n  FROM pg_catalog.pg_class c\n     LEFT JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace\nWHERE c.relkind IN ('i')\n      AND n.nspname = '%s'\n)\n %s \nGROUP BY \n    tablename\nORDER BY \n    tablename\n", MotionEtlGlobalCtx.getInstance().currentTargetSchema().toLowerCase(), MotionEtlGlobalCtx.getInstance().currentTargetSchema().toLowerCase(), MotionEtlGlobalCtx.getInstance().filterGaussdb500Table());
        result.put(CompareTypeEnum.INDEX.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)indexCountSql));
        String viewCountSql = String.format("select relname,'0' as invalid_data_filling from pg_class where relkind = 'v' and relnamespace = (select oid from pg_namespace where nspname='%s')", MotionEtlGlobalCtx.getInstance().currentTargetSchema().toLowerCase());
        result.put(CompareTypeEnum.VIEW.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)viewCountSql));
        return result;
    }

    public String createTableDataColumnInfo() {
        return String.format("select c.nspname,d.relname as table_name,b.attname,e.typname, \n   max(case when a.indisunique and b.attnum = ANY(a.indkey) then 1 else 0 end)  is_unique \n   from pg_attribute b\n   join pg_class d on d.oid=b.attrelid\n   join pg_namespace c on c.oid=d.relnamespace\n   join pg_type e on b.atttypid=e.oid\n   left join (select indkey,indrelid,indisunique from pg_index where indisunique) a on a.indrelid=b.attrelid\n   where c.nspname='%s' and b.attnum>0 and d.relkind='r' %s\n   group by c.nspname,d.relname,b.attname,e.typname        \n   order by d.relname,b.attname;", MotionEtlGlobalCtx.getInstance().currentTargetSchema(), MotionEtlGlobalCtx.getInstance().filterGaussdb500Table());
    }
}

