/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.target.goldenmysql;

import com.hundsun.lightdb.TableInfo;
import com.hundsun.lightdb.core.EtlConfig;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.target.AbstractTargetJdbcMeta;
import com.hundsun.lightdb.motion.enums.CompareTypeEnum;
import com.hundsun.lightdb.utils.CommonUtils;
import com.hundsun.lightdb.utils.JdbcUtils;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"etl.global.targetDatabase"}, havingValue="golden-mysql")
public class GoldenMysqlTargetJdbcMeta
extends AbstractTargetJdbcMeta {
    private static final Logger log = LoggerFactory.getLogger(GoldenMysqlTargetJdbcMeta.class);

    @Autowired
    public GoldenMysqlTargetJdbcMeta(@Qualifier(value="target") EtlConfig.DbConfig dbConfig) {
        super(dbConfig);
    }

    public Map<String, TableInfo> tableInfo() {
        String sql = String.format("select TABLE_NAME,COLUMN_NAME,DATA_TYPE,CHARACTER_MAXIMUM_LENGTH,NUMERIC_PRECISION,NUMERIC_SCALE from INFORMATION_SCHEMA.COLUMNS a\n where TABLE_SCHEMA = '%s' and not exists(  \n select 1 from information_schema.views b where a.table_schema=b.table_schema and a.table_name=b.table_name)", MotionEtlGlobalCtx.getInstance().currentTargetSchema()) + MotionEtlGlobalCtx.getInstance().filterGoldenDBTable("a.table_name");
        return this.getTableInfo(sql);
    }

    public void createScehma() {
    }

    public HashMap<String, HashMap<String, String>> countType() {
        HashMap<String, HashMap<String, String>> result = new HashMap<String, HashMap<String, String>>(8);
        String countTableSql = String.format("select TABLE_NAME,                            '0' as invalid_data_filling\n                        from information_schema.tables \n                        where TABLE_SCHEMA = '%s'\n                               and TABLE_TYPE = 'BASE TABLE'\n                              %s\n", MotionEtlGlobalCtx.getInstance().currentTargetSchema(), MotionEtlGlobalCtx.getInstance().filterGoldenDBTable("TABLE_NAME"));
        result.put(CompareTypeEnum.TABLE.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)countTableSql));
        String indexCountSql = String.format("SELECT \n    TABLE_NAME,\n    GROUP_CONCAT(index_name ORDER BY index_name SEPARATOR ',') AS index_list\nFROM \n    INFORMATION_SCHEMA.STATISTICS\nwhere table_schema = '%s' and index_name != 'PRIMARY'\n      %s\nGROUP BY \n    TABLE_NAME\nORDER BY \n    TABLE_NAME", MotionEtlGlobalCtx.getInstance().currentTargetSchema(), MotionEtlGlobalCtx.getInstance().filterGoldenDBTable("TABLE_NAME"));
        result.put(CompareTypeEnum.INDEX.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)indexCountSql));
        String viewCountSql = String.format("select TABLE_NAME,\n     '0' as invalid_data_filling \n      from information_schema.views where TABLE_SCHEMA = '%s'", MotionEtlGlobalCtx.getInstance().currentTargetSchema());
        result.put(CompareTypeEnum.VIEW.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)viewCountSql));
        return result;
    }

    public String createTableDataColumnInfo() {
        return String.format("select a.table_schema,a.table_name,a.COLUMN_NAME, a.DATA_TYPE,        \n   ifnull(b.is_unique,0) is_unique                                         \n   from                                                                    \n   (select c.table_schema,c.table_name,c.COLUMN_NAME,c.DATA_TYPE                   \n     from information_schema.columns c      JOIN  information_schema.TABLES t          ON c.table_schema = t.table_schema \n     AND c.table_name = t.table_name                                 \n     where c.table_schema='%s' AND t.TABLE_TYPE = 'BASE TABLE' %s) a                                   \n   left join                                                               \n   (select distinct table_schema,table_name,COLUMN_NAME,1 is_unique         \n     from information_schema.statistics b                                  \n    where table_schema='%s' and non_unique=0 and sub_part is null %s) b    \n   on                                                                      \n   a.table_schema=b.table_schema and                                       \n   a.table_name=b.table_name and                                           \n   a.column_name=b.column_name                                             \n   order by a.table_name,a.COLUMN_NAME", MotionEtlGlobalCtx.getInstance().currentTargetSchema(), MotionEtlGlobalCtx.getInstance().filterGoldenDBTable("c.TABLE_NAME"), MotionEtlGlobalCtx.getInstance().currentTargetSchema(), MotionEtlGlobalCtx.getInstance().filterGoldenDBTable("b.TABLE_NAME"));
    }

    public Connection getConnection(EtlConfig.DbConfig dbConfig) {
        String driverClassName = "com.goldendb.jdbc.Driver";
        String regex = "^gdb_mysql-connector-java.*\\.jar$";
        return CommonUtils.getConnectionByDbConfig((EtlConfig.DbConfig)dbConfig, (String)driverClassName, (String)regex, this.getClass());
    }

    public String createColumnDdl() {
        return String.format("select\n    TABLE_NAME,\n    lower(COLUMN_NAME),\n    DATA_TYPE,\n    NUMERIC_PRECISION ,\n    NUMERIC_SCALE ,\n    character_maximum_length,\n    datetime_precision\nfrom\n    INFORMATION_SCHEMA.COLUMNS\nwhere \n    TABLE_SCHEMA = '%s' and \n    table_name not in(select table_name from information_schema.views where table_schema='%s') \n %s", MotionEtlGlobalCtx.getInstance().currentTargetSchema(), MotionEtlGlobalCtx.getInstance().currentTargetSchema(), MotionEtlGlobalCtx.getInstance().filterGoldenDBTable("table_name"));
    }
}

