/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.target.lightdb;

import com.alibaba.druid.support.json.JSONUtils;
import com.google.common.base.Joiner;
import com.hundsun.lightdb.TableInfo;
import com.hundsun.lightdb.core.EtlGlobalCtx;
import com.hundsun.lightdb.core.KeyValuePair;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.RowValue;
import com.hundsun.lightdb.core.source.SourceFetcher;
import com.hundsun.lightdb.core.source.SourceJdbcMeta;
import com.hundsun.lightdb.core.target.AbstractTargetImporter;
import com.hundsun.lightdb.core.target.TargetJdbcMeta;
import com.hundsun.lightdb.utils.JdbcUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@ConditionalOnProperty(value={"etl.global.targetDatabase"}, havingValue="lightdb")
public class LightdbTargetImporter
extends AbstractTargetImporter {
    private static final Logger log = LoggerFactory.getLogger(LightdbTargetImporter.class);
    public static final int PAIR_COUNT = 2;

    @Autowired
    public LightdbTargetImporter(TargetJdbcMeta targetJdbcMeta, SourceJdbcMeta sourceJdbcMeta) {
        super(targetJdbcMeta, sourceJdbcMeta);
    }

    public void init() {
        super.init();
        this.targetJdbcMeta.createScehma();
    }

    public void saveError() {
        if (StringUtils.isNotBlank((CharSequence)MotionEtlGlobalCtx.getInstance().getGlobalConfig().getErrorSaveLightdbSchema()) && StringUtils.isNotBlank((CharSequence)MotionEtlGlobalCtx.getInstance().getGlobalConfig().getErrorSaveLightdbTable())) {
            this.targetJdbcMeta.saveMessage();
        }
    }

    public HashMap<String, HashMap<String, String>> columnInfo() {
        String ddl = this.targetJdbcMeta.createColumnDdl();
        return JdbcUtils.fetchColumnInfo((Connection)this.targetJdbcMeta.openConnection(), (String)ddl);
    }

    public String compareData(HashMap<KeyValuePair, String> source, HashMap<String, KeyValuePair> tables) {
        StringBuffer result = new StringBuffer();
        result.append("\u6570\u636e\u5bf9\u6bd4\u5f00\u59cb\n");
        StringBuffer falseInfo = new StringBuffer();
        StringBuffer trueInfo = new StringBuffer();
        if (source == null || source.size() == 0) {
            falseInfo.append("\u6e90\uff1a\u65e0\u8868\n");
        } else {
            HashMap tableNames = (HashMap)this.targetJdbcMeta.tableNames();
            for (Map.Entry<KeyValuePair, String> entry : source.entrySet()) {
                KeyValuePair key = entry.getKey();
                String schemaTable = key.getKey();
                String tableName = schemaTable.substring(schemaTable.indexOf(46) + 1);
                String targetSchemaTable = MotionEtlGlobalCtx.getInstance().currentTargetSchema() + "." + tableName;
                String sql = "";
                sql = "lightdb-pg".equals(this.targetJdbcMeta.getDbConfig().getMode()) ? String.format(" select * from (select %s from %s  order by %s )limit 20", entry.getKey().getValue(), targetSchemaTable, entry.getKey().getValue()) : String.format(" select * from (select %s from %s  order by %s )WHERE ROWNUM <=20", entry.getKey().getValue(), targetSchemaTable, entry.getKey().getValue());
                int number = entry.getKey().getValue().split(",").length;
                if (!tableNames.containsKey(tableName.toLowerCase())) {
                    falseInfo.append(tableName + "\u7ed3\u679c\u4e0d\u4e00\u81f4\uff0c\u76ee\u6807\u65e0\u8be5\u8868\n");
                    continue;
                }
                try {
                    String targetInfo = this.targetJdbcMeta.targetDataInfo(sql, number, tables.get(tableName).getKey().split(","));
                    if (StringUtils.isBlank((CharSequence)targetInfo) || StringUtils.isBlank((CharSequence)entry.getValue())) {
                        if (StringUtils.isBlank((CharSequence)targetInfo) && StringUtils.isBlank((CharSequence)entry.getValue())) {
                            trueInfo.append(tableName + "\u5bf9\u6bd4\u4e00\u81f4\uff0c\u65e0\u6570\u636e\u3002");
                            continue;
                        }
                        if (targetInfo == null || targetInfo.length() == 0) {
                            falseInfo.append(tableName + "\u7ed3\u679c\u4e0d\u4e00\u81f4 \n \t\u76ee\u6807\uff1a\u65e0\u6570\u636e\n");
                            continue;
                        }
                        if (entry.getValue() != null && entry.getValue().length() != 0) continue;
                        falseInfo.append(tableName + "\u7ed3\u679c\u4e0d\u4e00\u81f4  \n \t\u76ee\u6807\uff1a\u6570\u636e\u591a\u4f59\n");
                        continue;
                    }
                    if (!targetInfo.equals(entry.getValue())) {
                        falseInfo.append(tableName + "\u7ed3\u679c\u4e0d\u4e00\u81f4 \n");
                        falseInfo.append("\t \u6e90\u6570\u636e\u4e3a:" + entry.getValue() + "\n");
                        falseInfo.append("\t \u76ee\u6807\u6570\u636e:" + targetInfo + "\n");
                        continue;
                    }
                    result.append(tableName + "\u5bf9\u6bd4\u4e00\u81f4\u3002");
                }
                catch (Exception e) {
                    EtlGlobalCtx.INSTANCE.handleException("\u4efb\u52a1\u6267\u884c\u4e2d\u65ad", (Throwable)e);
                }
            }
        }
        result.append(trueInfo.toString() + "\n");
        result.append(falseInfo.toString());
        return result.toString();
    }

    public Map<String, HashMap<String, String>> countType() {
        return this.targetJdbcMeta.countType();
    }

    public void getEtlMessage() {
        this.targetJdbcMeta.getEtlMessage();
    }

    public TargetJdbcMeta targetJdbcMeta() {
        return this.targetJdbcMeta;
    }

    private void compareTableData(SourceFetcher sourceFetcher, TableInfo tableInfo) {
        try {
            this.compareTableData(tableInfo, sourceFetcher);
        }
        catch (Exception e) {
            EtlGlobalCtx.INSTANCE.handleException(tableInfo.formatTableName(), (Throwable)e);
        }
    }

    private void compareTableData(TableInfo tableInfo, SourceFetcher sourceFetcher) throws SQLException {
        List sourceRows = sourceFetcher.fetchCompareData(tableInfo);
        if (CollectionUtils.isEmpty((Collection)sourceRows)) {
            if (log.isWarnEnabled()) {
                log.warn("\u53d1\u73b0\u4e00\u4e2a\u7a7a\u8868 {}", (Object)tableInfo.formatTableName());
            }
            return;
        }
        String join = Joiner.on((char)',').join((Iterable)tableInfo.getColumnNames());
        String sql = String.format("select * from %s order by " + join + " limit 10000", tableInfo.formatTableName());
        List targetRows = JdbcUtils.fetchData((Connection)this.targetJdbcMeta.openConnection(), (TableInfo)tableInfo, (String)sql);
        if (CollectionUtils.isEmpty((Collection)targetRows)) {
            EtlGlobalCtx.INSTANCE.handleException((Throwable)new RuntimeException("\u76ee\u6807\u8868\u4e3a\u7a7a" + tableInfo.formatTableName()));
            return;
        }
        if (sourceRows.size() != targetRows.size()) {
            EtlGlobalCtx.INSTANCE.handleException(String.format("\u8868\u6570\u636e\u884c\u6570\u4e0d\u5339\u914d \u8868\uff1a%s source\uff1a%d target\uff1a%d", tableInfo.formatTableName(), sourceRows.size(), targetRows.size()), (Throwable)new RuntimeException());
        }
        for (RowValue sourceRow : sourceRows) {
            sourceRow.setSource(true);
            sourceRow.removeLastCol();
        }
        sourceRows.addAll(targetRows);
        sourceRows.sort(Comparator.comparing(RowValue::getUniqueKey));
        int beginIndex = 0;
        while (beginIndex + 1 < sourceRows.size()) {
            RowValue first = (RowValue)sourceRows.get(beginIndex);
            RowValue second = (RowValue)sourceRows.get(beginIndex + 1);
            if (first.isSource() == second.isSource() || !LightdbTargetImporter.compareRow((List)first.getValues(), (List)second.getValues(), (TableInfo)tableInfo)) {
                EtlGlobalCtx.INSTANCE.handleException(String.format("%s \u8bb0\u5f55\u4e0d\u5339\u914d first:%s second:%s", tableInfo.formatTableName(), JSONUtils.toJSONString((Object)first.getValues()), JSONUtils.toJSONString((Object)second.getValues())), (Throwable)new RuntimeException());
                ++beginIndex;
                continue;
            }
            beginIndex += 2;
        }
    }

    private static boolean compareRow(List<Object> sourceRow, List<Object> targetRow, TableInfo tableInfo) {
        try {
            if (sourceRow.size() != targetRow.size()) {
                if (log.isErrorEnabled()) {
                    log.error("\u5217\u4e2a\u6570\u4e0d\u5339\u914d {} {} {}", new Object[]{tableInfo.formatTableName(), sourceRow.size(), targetRow.size()});
                }
                return false;
            }
            for (int i = 0; i < targetRow.size(); ++i) {
                if (LightdbTargetImporter.compareColumnValue((Object)sourceRow.get(i), (Object)targetRow.get(i), (String)tableInfo.formatTableName())) continue;
                if (log.isErrorEnabled()) {
                    log.error("\u5217\u503c\u4e0d\u5339\u914d {} {} {}", new Object[]{tableInfo.formatTableName(), JSONUtils.toJSONString((Object)sourceRow.get(i)), JSONUtils.toJSONString((Object)targetRow.get(i))});
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            EtlGlobalCtx.INSTANCE.handleException(tableInfo.formatTableName(), (Throwable)e);
            return false;
        }
    }

    private static boolean compareColumnValue(Object o1, Object o2, String table) {
        if (Objects.isNull(o1) || Objects.isNull(o2)) {
            if (Objects.nonNull(o1) || Objects.nonNull(o2)) {
                if (log.isInfoEnabled()) {
                    log.info("\u6709\u4e2a\u503c\u4e3a null\uff1a{} {} {}", new Object[]{table, o1, o2});
                }
                return false;
            }
            return true;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            Number n1 = (Number)o1;
            Number n2 = (Number)o2;
            return n1.doubleValue() - n2.doubleValue() == 0.0;
        }
        if (o1.getClass() == o2.getClass()) {
            return o1.equals(o2);
        }
        String s1 = o1.toString();
        String s2 = o2.toString();
        return s1.length() > s2.length() ? s1.startsWith(s2) : s2.startsWith(s1);
    }

    public HashMap<String, TableInfo> tableDataColumnInfo() {
        String ddl = this.targetJdbcMeta.createTableDataColumnInfo();
        return JdbcUtils.fetchTableColumnInfo((Connection)this.targetJdbcMeta.openConnection(), (String)ddl);
    }
}

