/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.target.lightdbmysql;

import com.hundsun.lightdb.TableInfo;
import com.hundsun.lightdb.core.source.SourceJdbcMeta;
import com.hundsun.lightdb.core.target.AbstractTargetImporter;
import com.hundsun.lightdb.core.target.TargetJdbcMeta;
import com.hundsun.lightdb.utils.JdbcUtils;
import java.sql.Connection;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"etl.global.targetDatabase"}, havingValue="lightdb_mysql")
public class LightdbMysqlTargetImporter
extends AbstractTargetImporter {
    private static final Logger log = LoggerFactory.getLogger(LightdbMysqlTargetImporter.class);

    @Autowired
    public LightdbMysqlTargetImporter(TargetJdbcMeta targetJdbcMeta, SourceJdbcMeta sourceJdbcMeta) {
        super(targetJdbcMeta, sourceJdbcMeta);
    }

    public void init() {
        super.init();
        this.targetJdbcMeta.createScehma();
    }

    public HashMap<String, HashMap<String, String>> columnInfo() {
        String ddl = this.targetJdbcMeta.createColumnDdl();
        return JdbcUtils.fetchColumnInfo((Connection)this.targetJdbcMeta.openConnection(), (String)ddl);
    }

    public HashMap<String, TableInfo> tableDataColumnInfo() {
        String ddl = this.targetJdbcMeta.createTableDataColumnInfo();
        return JdbcUtils.fetchTableColumnInfo((Connection)this.targetJdbcMeta.openConnection(), (String)ddl);
    }
}

